/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.serialization.ComponentElement;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentSerializationController;
import org.netbeans.modules.vmd.api.io.serialization.PropertyElement;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ControllersCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.PointsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ResourcesCategoryCD;
import org.netbeans.modules.vmd.midp.components.general.RootCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.netbeans.modules.vmd.midp.palette.wizard.ComponentInstaller;

public class MidpDocumentSerializationController
extends DocumentSerializationController {
    public static final String VERSION_1 = "1";
    private Collection<String> unresolved = new HashSet<String>();

    public void approveComponents(DataObjectContext context, DesignDocument loadingDocument, String documentVersion, final Collection<ComponentElement> componentElements, DocumentErrorHandler errorHandler) {
        final DescriptorRegistry registry = loadingDocument.getDescriptorRegistry();
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                for (ComponentElement element : componentElements) {
                    String string = element.getTypeID().getString();
                    if (!MidpTypes.isValidFQNClassName(string) || registry.getComponentDescriptor(new TypeID(TypeID.Kind.COMPONENT, string)) != null) continue;
                    MidpDocumentSerializationController.this.unresolved.add(string);
                }
            }
        });
        if (!this.unresolved.isEmpty()) {
            Map<String, ComponentInstaller.Item> found = ComponentInstaller.search(ProjectUtils.getProject((DataObjectContext)context));
            ArrayList<ComponentInstaller.Item> install = new ArrayList<ComponentInstaller.Item>();
            for (String s : this.unresolved) {
                ComponentInstaller.Item item = found.get(s);
                if (item == null) continue;
                install.add(item);
            }
            ComponentInstaller.install(found, install);
        }
    }

    public void approveProperties(DataObjectContext context, DesignDocument loadingDocument, String documentVersion, DesignComponent component, Collection<PropertyElement> propertyElements, DocumentErrorHandler errorHandler) {
        if (!"vmd-midp".equals(context.getProjectType()) || !VERSION_1.equals(documentVersion)) {
            return;
        }
        if (loadingDocument.getDescriptorRegistry().isInHierarchy(ItemCD.TYPEID, component.getType())) {
            ArrayList<PropertyElement> elementsToRemove = new ArrayList<PropertyElement>();
            ArrayList<PropertyElement> elementsToAdd = new ArrayList<PropertyElement>();
            for (PropertyElement propertyElement : propertyElements) {
                if (!"itemCommandlistener".equals(propertyElement.getPropertyName())) continue;
                elementsToRemove.add(propertyElement);
                elementsToAdd.add(PropertyElement.create((String)"itemCommandListener", (TypeID)propertyElement.getTypeID(), (String)propertyElement.getSerialized()));
                break;
            }
            propertyElements.removeAll(elementsToRemove);
            propertyElements.addAll(elementsToAdd);
            for (PropertyElement pe : propertyElements) {
                pe.getSerialized();
            }
        }
    }

    public void postValidateDocument(DataObjectContext context, DesignDocument loadingDocument, String documentVersion, DocumentErrorHandler errorHandler) {
        if (!"vmd-midp".equals(context.getProjectType()) || !VERSION_1.equals(documentVersion)) {
            return;
        }
        DesignComponent rootComponent = loadingDocument.getRootComponent();
        if (rootComponent == null) {
            rootComponent = loadingDocument.createComponent(RootCD.TYPEID);
            loadingDocument.setRootComponent(rootComponent);
        }
        MidpDocumentSupport.getCategoryComponent(loadingDocument, CommandsCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(loadingDocument, ControllersCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(loadingDocument, DisplayablesCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(loadingDocument, PointsCategoryCD.TYPEID);
        MidpDocumentSupport.getCategoryComponent(loadingDocument, ResourcesCategoryCD.TYPEID);
    }
}

