/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ide;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.glassfish.eecommon.api.HttpMonitorHelper;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.ResourceRegistrationHelper;
import org.netbeans.modules.glassfish.javaee.ide.Hk2Target;
import org.netbeans.modules.glassfish.javaee.ide.Hk2TargetModuleID;
import org.netbeans.modules.glassfish.javaee.ide.MonitorProgressObject;
import org.netbeans.modules.glassfish.javaee.ide.UpdateContextRoot;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule2;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DeploymentContext;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class FastDeploy
extends IncrementalDeployment
implements IncrementalDeployment2 {
    private static final String GFDEPLOY = "gfdeploy";
    private Hk2DeploymentManager dm;
    private static Pattern badName = Pattern.compile(".*\\s.*_[jwrc]ar");
    private static Pattern badPath = Pattern.compile(".*[\\\\/].*\\s.*_[jwrc]ar[\\\\/].*");

    public FastDeploy(Hk2DeploymentManager dm) {
        this.dm = dm;
    }

    public ProgressObject initialDeploy(Target target, J2eeModule module, ModuleConfiguration configuration, File dir) {
        return this.initialDeploy(target, module, dir, new File[0]);
    }

    public ProgressObject initialDeploy(Target target, DeploymentContext context) {
        return this.initialDeploy(target, context.getModule(), context.getModuleFile(), context.getRequiredLibraries());
    }

    private ProgressObject initialDeploy(Target target, J2eeModule module, final File dir, final File[] requiredLibraries) {
        String contextRoot;
        final String moduleName = Utils.sanitizeName((String)org.netbeans.modules.glassfish.eecommon.api.Utils.computeModuleID((J2eeModule)module, (File)dir, (String)Integer.toString(((Object)((Object)this)).hashCode())));
        Hk2TargetModuleID moduleId = Hk2TargetModuleID.get((Hk2Target)target, moduleName, contextRoot = null, dir.getAbsolutePath());
        ProgressObject po = this.checkAgainstGF15690(dir, moduleId);
        if (null != po) {
            return po;
        }
        final MonitorProgressObject deployProgress = new MonitorProgressObject(this.dm, moduleId);
        MonitorProgressObject updateCRProgress = new MonitorProgressObject(this.dm, moduleId);
        deployProgress.addProgressListener(new UpdateContextRoot(updateCRProgress, moduleId, this.dm.getServerInstance(), J2eeModule.Type.WAR.equals(module.getType())));
        MonitorProgressObject restartProgress = new MonitorProgressObject(this.dm, moduleId);
        final GlassfishModule commonSupport = this.dm.getCommonServerSupport();
        final GlassfishModule2 commonSupport2 = commonSupport instanceof GlassfishModule2 ? (GlassfishModule2)commonSupport : null;
        boolean restart = false;
        try {
            restart = HttpMonitorHelper.synchronizeMonitor((String)((String)commonSupport.getInstanceProperties().get("domainsfolder")), (String)((String)commonSupport.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)commonSupport.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        catch (SAXException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        ResourceRegistrationHelper.deployResources(dir, this.dm);
        if (restart) {
            restartProgress.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    if (event.getDeploymentStatus().isCompleted()) {
                        if (commonSupport2 != null && requiredLibraries.length > 0) {
                            commonSupport2.deploy((OperationStateListener)deployProgress, dir, moduleName, null, Collections.emptyMap(), requiredLibraries);
                        } else {
                            commonSupport.deploy((OperationStateListener)deployProgress, dir, moduleName);
                        }
                    } else {
                        deployProgress.fireHandleProgressEvent(event.getDeploymentStatus());
                    }
                }
            });
            commonSupport.restartServer((OperationStateListener)restartProgress);
            return updateCRProgress;
        }
        if (commonSupport2 != null && requiredLibraries.length > 0) {
            commonSupport2.deploy((OperationStateListener)deployProgress, dir, moduleName, null, Collections.emptyMap(), requiredLibraries);
        } else {
            commonSupport.deploy((OperationStateListener)deployProgress, dir, moduleName);
        }
        return updateCRProgress;
    }

    private ProgressObject checkAgainstGF15690(File dir, Hk2TargetModuleID moduleId) {
        File parent = dir.getParentFile();
        MonitorProgressObject po = null;
        if (null != parent && GFDEPLOY.equals(parent.getName())) {
            File[] modules;
            for (File f : modules = dir.listFiles()) {
                String fname;
                if (!f.isDirectory() || !badName.matcher(fname = f.getName()).matches()) continue;
                po = new MonitorProgressObject(this.dm, moduleId);
                po.operationStateChanged(GlassfishModule.OperationState.FAILED, NbBundle.getMessage(FastDeploy.class, (String)"ERR_SPACE_IN_JAR_NAMES", (Object)fname));
                return po;
            }
        }
        return null;
    }

    public ProgressObject incrementalDeploy(TargetModuleID targetModuleID, AppChangeDescriptor appChangeDescriptor) {
        return this.incrementalDeploy(targetModuleID, appChangeDescriptor, new File[0]);
    }

    public ProgressObject incrementalDeploy(TargetModuleID targetModuleID, DeploymentContext context) {
        return this.incrementalDeploy(targetModuleID, context.getChanges(), context.getRequiredLibraries());
    }

    private ProgressObject incrementalDeploy(final TargetModuleID targetModuleID, AppChangeDescriptor appChangeDescriptor, final File[] requiredLibraries) {
        File dir;
        DeploymentChangeDescriptor dcd;
        boolean hasChanges;
        final MonitorProgressObject progressObject = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        for (File f : appChangeDescriptor.getChangedFiles()) {
            String fname = f.getAbsolutePath();
            if (!badPath.matcher(fname).matches()) continue;
            progressObject.operationStateChanged(GlassfishModule.OperationState.FAILED, NbBundle.getMessage(FastDeploy.class, (String)"ERR_SPACE_IN_JAR_NAMES", (Object)fname));
            return progressObject;
        }
        MonitorProgressObject restartObject = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        MonitorProgressObject updateCRObject = new MonitorProgressObject(this.dm, (Hk2TargetModuleID)targetModuleID, CommandType.REDEPLOY);
        progressObject.addProgressListener(new UpdateContextRoot(updateCRObject, (Hk2TargetModuleID)targetModuleID, this.dm.getServerInstance(), null != targetModuleID.getWebURL()));
        final GlassfishModule commonSupport = this.dm.getCommonServerSupport();
        final GlassfishModule2 commonSupport2 = commonSupport instanceof GlassfishModule2 ? (GlassfishModule2)commonSupport : null;
        boolean restart = false;
        try {
            restart = HttpMonitorHelper.synchronizeMonitor((String)((String)commonSupport.getInstanceProperties().get("domainsfolder")), (String)((String)commonSupport.getInstanceProperties().get("domainname")), (boolean)Boolean.parseBoolean((String)commonSupport.getInstanceProperties().get("httpMonitorOn")), (String[])new String[]{"modules/org-netbeans-modules-schema2beans.jar"});
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        catch (SAXException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.WARNING, "http monitor state", ex);
        }
        final boolean resourcesChanged = this.containsFileWithName("glassfish-resources.xml", appChangeDescriptor.getChangedFiles());
        boolean bl = hasChanges = appChangeDescriptor.classesChanged() || appChangeDescriptor.descriptorChanged() || appChangeDescriptor.ejbsChanged() || appChangeDescriptor.manifestChanged() || appChangeDescriptor.serverDescriptorChanged() || resourcesChanged;
        if (appChangeDescriptor instanceof DeploymentChangeDescriptor && (dcd = (DeploymentChangeDescriptor)appChangeDescriptor).serverResourcesChanged() && null != (dir = this.getDirectoryForModule(targetModuleID))) {
            ResourceRegistrationHelper.deployResources(dir, this.dm);
        }
        if (restart) {
            restartObject.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent event) {
                    if (event.getDeploymentStatus().isCompleted()) {
                        if (hasChanges) {
                            if (commonSupport2 != null && requiredLibraries.length > 0) {
                                commonSupport2.redeploy((OperationStateListener)progressObject, targetModuleID.getModuleID(), null, requiredLibraries, resourcesChanged);
                            } else {
                                commonSupport.redeploy((OperationStateListener)progressObject, targetModuleID.getModuleID(), resourcesChanged);
                            }
                        } else {
                            progressObject.fireHandleProgressEvent(event.getDeploymentStatus());
                        }
                    } else {
                        progressObject.fireHandleProgressEvent(event.getDeploymentStatus());
                    }
                }
            });
            commonSupport.restartServer((OperationStateListener)restartObject);
            return updateCRObject;
        }
        if (hasChanges) {
            if (commonSupport2 != null && requiredLibraries.length > 0) {
                commonSupport2.redeploy((OperationStateListener)progressObject, targetModuleID.getModuleID(), null, requiredLibraries, resourcesChanged);
            } else {
                commonSupport.redeploy((OperationStateListener)progressObject, targetModuleID.getModuleID(), resourcesChanged);
            }
        } else {
            progressObject.operationStateChanged(GlassfishModule.OperationState.COMPLETED, NbBundle.getMessage(FastDeploy.class, (String)"MSG_RedeployUnneeded"));
        }
        return updateCRObject;
    }

    public boolean canFileDeploy(Target target, J2eeModule deployable) {
        if (null == deployable) {
            return false;
        }
        return deployable.getType() != J2eeModule.Type.CAR;
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule app, ModuleConfiguration configuration) {
        File dest = null;
        if (app.getType() == J2eeModule.Type.EAR) {
            File tmp = this.getProjectDir(app);
            if (null == tmp) {
                return dest;
            }
            dest = new File(tmp, "target");
            if (!dest.exists()) {
                dest = new File(tmp, "dist");
            }
            if (dest.isFile() || dest.isDirectory() && !dest.canWrite()) {
                throw new IllegalStateException();
            }
            String moduleName = Utils.sanitizeName((String)org.netbeans.modules.glassfish.eecommon.api.Utils.computeModuleID((J2eeModule)app, null, null));
            String dirName = GFDEPLOY;
            if (null != moduleName) {
                dirName = dirName + "/" + moduleName;
            }
            dest = new File(dest, dirName);
            boolean retval = true;
            if (!dest.exists()) {
                retval = dest.mkdirs();
            }
            if (!retval || !dest.isDirectory()) {
                dest = null;
            }
        }
        return dest;
    }

    public File getDirectoryForNewModule(File file, String string, J2eeModule app, ModuleConfiguration configuration) {
        return new File(file, FastDeploy.transform(this.removeLeadSlash(string)));
    }

    private String removeLeadSlash(String s) {
        if (null == s) {
            return s;
        }
        if (s.length() < 1) {
            return s;
        }
        if (!s.startsWith("/")) {
            return s;
        }
        return s.substring(1);
    }

    static String transform(String s) {
        StringBuilder sb;
        char tmp;
        int len = s.length();
        if (len > 4 && (tmp = (sb = new StringBuilder(s)).charAt(len - 4)) == '.') {
            sb.setCharAt(len - 4, '_');
            return sb.toString();
        }
        return s;
    }

    public File getDirectoryForModule(TargetModuleID targetModuleID) {
        return new File(((Hk2TargetModuleID)targetModuleID).getLocation());
    }

    public ProgressObject deployOnSave(TargetModuleID module, DeploymentChangeDescriptor desc) {
        return this.incrementalDeploy(module, (AppChangeDescriptor)desc);
    }

    public boolean isDeployOnSaveSupported() {
        return !"false".equals(System.getProperty("glassfish.javaee.deployonsave"));
    }

    private File getProjectDir(J2eeModule app) {
        try {
            FileObject fo = app.getContentDirectory();
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (null != p) {
                fo = p.getProjectDirectory();
                return FileUtil.toFile((FileObject)fo);
            }
        }
        catch (IOException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.FINER, null, ex);
        }
        File tmp = app.getResourceDirectory();
        if (tmp != null) {
            return tmp.getParentFile();
        }
        return null;
    }

    public String getModuleUrl(TargetModuleID module) {
        assert (null != module);
        if (null == module) {
            return "/bogusModule";
        }
        Hk2TargetModuleID self = (Hk2TargetModuleID)module;
        String retVal = self.getModuleID();
        return retVal.startsWith("/") ? retVal : "/" + retVal;
    }

    private boolean containsFileWithName(String name, File[] changedFiles) {
        if (null == changedFiles || null == name) {
            return false;
        }
        for (File f : changedFiles) {
            String fp;
            String string = fp = null != f ? f.getAbsolutePath() : null;
            if (null == fp || !fp.contains(name)) continue;
            return true;
        }
        return false;
    }
}

