/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.NoopTask;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule2;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class CommonServerSupport
implements GlassfishModule2,
RefreshModulesCookie {
    private final transient Lookup lookup;
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap(37));
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.STOPPED;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private transient boolean isRemote = false;
    private GlassfishInstanceProvider instanceProvider;
    private boolean stopDisabled = false;
    private static final RequestProcessor RP = new RequestProcessor("CommonServerSupport - start/stop/refresh", 5);
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);

    CommonServerSupport(Lookup lookup, Map<String, String> ip, GlassfishInstanceProvider instanceProvider) {
        this.lookup = lookup;
        this.instanceProvider = instanceProvider;
        this.isRemote = ip.get("domainsfolder") == null;
        String hostName = CommonServerSupport.updateString(ip, "host", "localhost");
        String glassfishRoot = CommonServerSupport.updateString(ip, "homefolder", "");
        int httpPort = CommonServerSupport.updateInt(ip, "httpportnumber", 8080);
        CommonServerSupport.updateString(ip, "displayName", "Bogus display name");
        int adminPort = CommonServerSupport.updateInt(ip, "adminPort", 4848);
        CommonServerSupport.updateString(ip, "preserveSessionsOn", "true");
        CommonServerSupport.updateString(ip, "derbyStartOn", this.isRemote ? "false" : "true");
        CommonServerSupport.updateString(ip, "useIDEProxyOn", "true");
        CommonServerSupport.updateString(ip, "driverDeployOn", "true");
        String deployerUri = ip.get("url");
        ip.put("jvmMode", this.isRemote && !deployerUri.contains("deployer:gfv3ee6wc") ? "debugMode" : "normalMode");
        this.properties.putAll(ip);
        this.properties.put("username", "admin");
        this.properties.put("password", "adminadmin");
        this.instanceFO = this.getInstanceFileObject();
        this.refresh();
    }

    private static String updateString(Map<String, String> map, String key, String defaultValue) {
        String result = map.get(key);
        if (result == null) {
            map.put(key, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    private static int updateInt(Map<String, String> map, String key, int defaultValue) {
        int result;
        String value = map.get(key);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            map.put(key, Integer.toString(defaultValue));
            result = defaultValue;
        }
        return result;
    }

    private FileObject getInstanceFileObject() {
        String instanceFN;
        FileObject dir = FileUtil.getConfigFile((String)this.instanceProvider.getInstancesDirName());
        if (dir != null && (instanceFN = this.properties.get("InstanceFOPath")) != null) {
            return dir.getFileObject(instanceFN);
        }
        return null;
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getGlassfishRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    @Override
    public String getPassword() {
        String retVal = this.properties.get("password");
        String key = this.properties.get("url");
        char[] retChars = Keyring.read((String)key);
        if (null == retChars || retChars.length < 1 || !"this really long string is used to identify a password that has been stored in the Keyring".equals(retVal)) {
            retChars = retVal.toCharArray();
            if (null != key) {
                Keyring.save((String)key, (char[])retChars, (String)"a Glassfish/SJSAS passord");
                this.properties.put("password", "this really long string is used to identify a password that has been stored in the Keyring");
            }
        } else {
            retVal = String.copyValueOf(retChars);
        }
        return retVal;
    }

    public String getAdminPort() {
        return this.properties.get("adminPort");
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public int getHttpPortNumber() {
        int httpPort = -1;
        try {
            httpPort = Integer.parseInt(this.properties.get("httpportnumber"));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        return httpPort;
    }

    public int getAdminPortNumber() {
        int adminPort = -1;
        try {
            adminPort = Integer.parseInt(this.properties.get("adminPort"));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        return adminPort;
    }

    public String getHostName() {
        return this.properties.get("host");
    }

    public synchronized String getDomainsRoot() {
        String retVal = this.properties.get("domainsfolder");
        if (null == retVal) {
            return null;
        }
        File candidate = new File(retVal);
        if (candidate.exists() && !Utils.canWrite(candidate)) {
            String foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)"GF3");
            FileObject destdir = null;
            try {
                destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (null != destdir) {
                candidate = new File(candidate, this.properties.get("domainname"));
                FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)candidate));
                try {
                    Utils.doCopy(source, destdir);
                    retVal = FileUtil.toFile((FileObject)destdir).getAbsolutePath();
                    this.properties.put("domainsfolder", retVal);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return retVal;
    }

    public String getDomainName() {
        String retVal = this.properties.get("domainname");
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState newState) {
        boolean fireChange = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != newState) {
                this.serverState = newState;
                fireChange = true;
            }
        }
        if (fireChange) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        this.getDomainsRoot();
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"{0}\"", Thread.currentThread().getName());
        StartOperationStateListener startServerListener = new StartOperationStateListener(GlassfishModule.ServerState.RUNNING);
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), startServerListener, stateListener));
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener stateListener, FileObject jdkRoot, String[] jvmArgs) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"{0}\"", Thread.currentThread().getName());
        StartOperationStateListener startServerListener = new StartOperationStateListener(GlassfishModule.ServerState.STOPPED_JVM_PROFILER);
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, this.getRecognizers(), jdkRoot, jvmArgs, startServerListener, stateListener));
        RP.post(task);
        return task;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> recognizers;
        Collection cookies = this.lookup.lookupAll(RecognizerCookie.class);
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie cookie : cookies) {
                recognizers.addAll(cookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    @Override
    public Future<GlassfishModule.OperationState> stopServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.stopServer called on thread \"{0}\"", Thread.currentThread().getName());
        OperationStateListener stopServerListener = new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (newState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (newState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> task = null;
        task = !this.isRemote() ? new FutureTask<GlassfishModule.OperationState>(new StopTask(this, stopServerListener, stateListener)) : new FutureTask<GlassfishModule.OperationState>(new NoopTask(this, stopServerListener, stateListener));
        if (this.stopDisabled) {
            stopServerListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            if (null != stateListener) {
                stateListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            }
            return task;
        }
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> restartServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.restartServer called on thread \"{0}\"", Thread.currentThread().getName());
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new RestartTask(this, stateListener));
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name) {
        return this.deploy(stateListener, application, name, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot) {
        return this.deploy(stateListener, application, name, contextRoot, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties) {
        return this.deploy(stateListener, application, name, contextRoot, null, new File[0]);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties, File[] libraries) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.deploy(application, name, contextRoot, properties, libraries);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, null, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, contextRoot, new File[0], resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, File[] libraries, boolean resourcesChanged) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.redeploy(name, contextRoot, libraries, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> undeploy(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.undeploy(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> enable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.enable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> disable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.disable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> execute(ServerCommand command) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command, OperationStateListener ... osl) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.getInstanceProperties(), osl);
        return mgr.execute(command);
    }

    @Override
    public AppDesc[] getModuleList(String container) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        int total = 0;
        Map<String, List<AppDesc>> appMap = mgr.getApplications(container);
        Collection<List<AppDesc>> appLists = appMap.values();
        for (List<AppDesc> appList : appLists) {
            total += appList.size();
        }
        AppDesc[] result = new AppDesc[total];
        int index = 0;
        for (List<AppDesc> appList : appLists) {
            for (AppDesc app : appList) {
                result[index++] = app;
            }
        }
        return result;
    }

    @Override
    public Map<String, ResourceDesc> getResourcesMap(String type) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        HashMap<String, ResourceDesc> resourcesMap = new HashMap<String, ResourceDesc>();
        List<ResourceDesc> resourcesList = mgr.getResources(type);
        for (ResourceDesc resource : resourcesList) {
            resourcesMap.put(resource.getName(), resource);
        }
        return resourcesMap;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String name, String value, boolean overwrite) {
        String result = null;
        Map<String, String> map = this.properties;
        synchronized (map) {
            result = this.properties.get(name);
            if (result == null || overwrite) {
                this.properties.put(name, value);
                this.setInstanceAttr(name, value);
                result = value;
            }
        }
        return result;
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    void getProperty(String key) {
        this.properties.get(key);
    }

    boolean setInstanceAttr(String name, String value) {
        boolean retVal = false;
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null && this.instanceFO.canWrite()) {
            try {
                this.instanceFO.setAttribute(name, (Object)value);
                retVal = true;
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + name + " in " + this.instanceFO.getPath() + " for " + this.getDeployerUri(), ex);
            }
        } else if (null == this.instanceFO) {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), false, "null"});
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), this.instanceFO.canWrite(), this.instanceFO.getPath()});
        }
        return retVal;
    }

    void setFileObject(FileObject fo) {
        this.instanceFO = fo;
    }

    public static boolean isRunning(String host, int port) {
        if (null == host) {
            return false;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            Socket socket = new Socket();
            socket.connect(isa, 100);
            socket.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean isReallyRunning() {
        return CommonServerSupport.isRunning(this.getHostName(), this.getAdminPortNumber()) && this.isReady(false, 30, TimeUnit.SECONDS);
    }

    public boolean isReady(boolean retry, int timeout, TimeUnit units) {
        boolean isReady = false;
        int maxtries = retry ? 3 : 1;
        int tries = 0;
        while (!isReady && tries++ < maxtries) {
            if (tries > 1) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, ex);
                }
            }
            long start = System.nanoTime();
            Commands.LocationCommand command = new Commands.LocationCommand();
            try {
                long end;
                Future<GlassfishModule.OperationState> result = null;
                result = this.isRemote ? this.execute(true, command, new OperationStateListener(){

                    @Override
                    public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                        if (GlassfishModule.OperationState.FAILED == newState) {
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
                            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                            Logger.getLogger("glassfish").log(Level.INFO, message);
                        }
                    }
                }) : this.execute(true, command);
                if (result.get(timeout, units) == GlassfishModule.OperationState.COMPLETED) {
                    end = System.nanoTime();
                    Logger.getLogger("glassfish").log(Level.FINE, "{0} responded in {1}ms", new Object[]{command.getCommand(), (end - start) / 1000000L});
                    String domainRoot = this.getDomainsRoot() + File.separator + this.getDomainName();
                    String targetDomainRoot = command.getDomainRoot();
                    if (this.getDomainsRoot() != null && targetDomainRoot != null) {
                        File installDir = FileUtil.normalizeFile((File)new File(domainRoot));
                        File targetInstallDir = FileUtil.normalizeFile((File)new File(targetDomainRoot));
                        isReady = installDir.equals(targetInstallDir);
                    } else {
                        boolean bl = isReady = null != targetDomainRoot;
                    }
                    if (!isReady) break;
                    this.updateHttpPort();
                    break;
                }
                if (!command.retry()) {
                    result = this.execute(true, new Commands.VersionCommand());
                    isReady = result.get(timeout, units) == GlassfishModule.OperationState.COMPLETED;
                    break;
                }
                end = System.nanoTime();
                Logger.getLogger("glassfish").log(Level.FINE, "{0} timed out inside server after {1}ms", new Object[]{command.getCommand(), (end - start) / 1000000L});
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.INFO, command.getCommand() + " timed out.", ex);
                isReady = false;
                break;
            }
        }
        return isReady;
    }

    @Override
    public void refresh() {
        this.refresh(null, null);
    }

    @Override
    public void refresh(String expected, String unexpected) {
        if (this.refreshRunning.compareAndSet(false, true)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    boolean isRunning = CommonServerSupport.this.isReallyRunning();
                    GlassfishModule.ServerState currentState = CommonServerSupport.this.getServerState();
                    if (currentState == GlassfishModule.ServerState.STOPPED && isRunning) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    } else if (currentState == GlassfishModule.ServerState.RUNNING && !isRunning) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                    } else if (currentState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER && isRunning) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    }
                    CommonServerSupport.this.refreshRunning.set(false);
                }
            });
        }
    }

    void disableStop() {
        this.stopDisabled = true;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.instanceProvider.getCommandFactory();
    }

    @Override
    public String getResourcesXmlName() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc") ? "glassfish-resources" : "sun-resources";
    }

    @Override
    public boolean supportsRestartInDebug() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isRestfulLogAccessSupported() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isWritable() {
        return null == this.instanceFO ? false : this.instanceFO.canWrite();
    }

    private void updateHttpPort() {
        ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("*.server-config.*.http-listener-1.port");
        Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
        try {
            if (result2.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                Map<String, String> retVal = gpc.getData();
                for (Map.Entry<String, String> entry : retVal.entrySet()) {
                    String val = entry.getValue();
                    try {
                        if (null == val || val.trim().length() <= 0) continue;
                        Integer.parseInt(val);
                        this.setEnvironmentProperty("httpportnumber", val, true);
                    }
                    catch (NumberFormatException nfe) {}
                }
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
    }

    class StartOperationStateListener
    implements OperationStateListener {
        private GlassfishModule.ServerState endState;

        StartOperationStateListener(GlassfishModule.ServerState endState) {
            this.endState = endState;
        }

        @Override
        public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            if (newState == GlassfishModule.OperationState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
            } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                CommonServerSupport.this.startedByIde = CommonServerSupport.this.isRemote ? false : CommonServerSupport.this.isReady(false, 300, TimeUnit.MILLISECONDS);
                CommonServerSupport.this.setServerState(this.endState);
            } else if (newState == GlassfishModule.OperationState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }
    }
}

