/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class EntityWizardPanel
extends JPanel {
    private Project project;
    private ChangeListener listener;
    static final String IS_VALID = "EntityWizardPanel_isValid";
    private boolean createPU;
    private ButtonGroup accessTypeGroup;
    private JCheckBox createPUCheckbox;
    private JLabel createPUWarningLabel;
    private JLabel jLabel1;
    private ButtonGroup persistenceGroup;
    private JTextField primaryKeyTextField;
    private JButton searchButton;

    public EntityWizardPanel(ChangeListener changeListener) {
        this.setProject(this.project);
        this.listener = changeListener;
        this.initComponents();
        this.createPUCheckbox.setSelected(true);
        this.primaryKeyTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EntityWizardPanel.this.listener.stateChanged(null);
            }
        });
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyTextField.getText();
    }

    void setPersistenceUnitButtonVisibility(boolean visible) {
        this.createPUCheckbox.setVisible(visible);
        this.updateWarning();
    }

    private void updateWarning() {
        String warning = null;
        try {
            if (this.createPUCheckbox.isVisible() && !this.createPU && !ProviderUtil.persistenceExists(this.project) && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
                warning = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_NoPersistenceUnit");
            }
        }
        catch (InvalidPersistenceXmlException ex) {
            warning = NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)ex.getPath());
        }
        ImageIcon icon = null;
        if (warning != null) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/persistence/ui/resources/warning.gif", (boolean)false);
        } else {
            warning = " ";
        }
        this.createPUWarningLabel.setIcon(icon);
        this.createPUWarningLabel.setText(warning);
        this.createPUWarningLabel.setToolTipText(warning);
    }

    void setProject(Project project) {
        this.project = project;
    }

    public boolean isCreatePU() {
        return this.createPUCheckbox.isVisible() && this.createPU;
    }

    private void initComponents() {
        this.persistenceGroup = new ButtonGroup();
        this.accessTypeGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.primaryKeyTextField = new JTextField();
        this.searchButton = new JButton();
        this.createPUWarningLabel = new ShyLabel();
        this.createPUCheckbox = new JCheckBox();
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/entity/Bundle").getString("MN_PrimaryKeyType").charAt(0));
        this.jLabel1.setLabelFor(this.primaryKeyTextField);
        this.jLabel1.setText(NbBundle.getBundle(EntityWizardPanel.class).getString("LBL_PrimaryKeyClass"));
        this.primaryKeyTextField.setText("Long");
        this.searchButton.setText("...");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntityWizardPanel.this.searchButtonActionPerformed(evt);
            }
        });
        this.createPUWarningLabel.setText(" ");
        Mnemonics.setLocalizedText((AbstractButton)this.createPUCheckbox, (String)NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.createPUCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EntityWizardPanel.this.createPUCheckboxItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.primaryKeyTextField, -1, 241, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.searchButton)).add((Component)this.createPUWarningLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createPUCheckbox).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.searchButton).add((Component)this.primaryKeyTextField, -2, -1, -2)).addPreferredGap(0, 39, Short.MAX_VALUE).add((Component)this.createPUWarningLabel).addPreferredGap(0).add((Component)this.createPUCheckbox)));
        this.primaryKeyTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EntityWizardPanel.class, (String)"LBL_PrimaryKeyClass"));
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    EntityWizardPanel.this.primaryKeyTextField.setText(handle.getQualifiedName());
                }
            }
        });
    }

    private void createPUCheckboxItemStateChanged(ItemEvent evt) {
        this.createPU = this.createPUCheckbox.isVisible() && this.createPUCheckbox.isSelected();
        this.updateWarning();
        this.listener.stateChanged(null);
    }

    private static final class ShyLabel
    extends JLabel {
        private ShyLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width = 0;
            return size;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.width = 0;
            return size;
        }
    }
}

