/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorFilesModel;
import org.netbeans.modules.cnd.highlight.error.includes.ErrorIncludesModel;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ErrorIncludeDialog
extends JPanel
implements CsmModelListener {
    private static final boolean TRACE_ERROR_STATISTIC = Boolean.getBoolean("cnd.highlight.trace.statistic");
    private static final RequestProcessor RP = new RequestProcessor(ErrorIncludeDialog.class.getName(), 1);
    private CsmProject baseProject;
    private Dialog parent;
    private ErrorIncludesModel model;
    private JList leftList;
    private JList rightList;
    private JEditorPane guessList;
    private Map<String, List<String>> searchBase;
    private RequestProcessor.Task guessTask = null;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private static final String CYG_DRIVE_WIN = "\\cygdrive\\";

    public ErrorIncludeDialog(Set<CsmFile> files) {
        ArrayList<CsmInclude> includes = new ArrayList<CsmInclude>();
        ArrayList<CsmErrorDirective> errors = new ArrayList<CsmErrorDirective>();
        CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
        for (CsmFile file : files) {
            Collection fileErrors = file.getErrors();
            boolean hasFailed = !fileErrors.isEmpty();
            errors.addAll(fileErrors);
            for (CsmInclude incl : fiq.getBrokenIncludes(file)) {
                if (incl.getIncludeFile() != null) continue;
                includes.add(incl);
                hasFailed = true;
            }
            if (this.baseProject == null) {
                this.baseProject = file.getProject();
            }
            if (hasFailed || !TRACE_ERROR_STATISTIC) continue;
            System.out.println("File marked as failed does not contain failed directives:");
            System.out.println("  " + file.getAbsolutePath());
        }
        if (this.baseProject != null && TRACE_ERROR_STATISTIC) {
            this.checkHighlightModel(files);
        }
        this.createComponents(includes, errors);
        this.setPreferredSize(new Dimension(NbPreferences.forModule(ErrorIncludeDialog.class).getInt("dialogSizeW", 500), NbPreferences.forModule(ErrorIncludeDialog.class).getInt("dialogSizeH", 240)));
        this.setMinimumSize(new Dimension(320, 240));
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChangeFlags() == 4L && !e.getChanged().isVisible()) {
                    ErrorIncludeDialog.this.leftList.setModel(new DefaultListModel());
                    ErrorIncludeDialog.this.rightList.setModel(new DefaultListModel());
                    ErrorIncludeDialog.this.model = null;
                    ErrorIncludeDialog.this.baseProject = null;
                    ErrorIncludeDialog.this.parent = null;
                    if (ErrorIncludeDialog.this.searchBase != null) {
                        ErrorIncludeDialog.this.searchBase.clear();
                    }
                    CsmListeners.getDefault().removeModelListener((CsmModelListener)ErrorIncludeDialog.this);
                    NbPreferences.forModule(ErrorIncludeDialog.class).putInt("dialogSizeW", ErrorIncludeDialog.this.getSize().width);
                    NbPreferences.forModule(ErrorIncludeDialog.class).putInt("dialogSizeH", ErrorIncludeDialog.this.getSize().height);
                }
            }
        });
    }

    public void projectOpened(CsmProject project) {
    }

    public void projectClosed(CsmProject project) {
        if (project == this.baseProject && this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    public void modelChanged(CsmChangeEvent e) {
    }

    public static void showErrorIncludeDialog(Set<CsmFile> files) {
        ErrorIncludeDialog errors = new ErrorIncludeDialog(files);
        DialogDescriptor descriptor = new DialogDescriptor((Object)errors, ErrorIncludeDialog.i18n("ErrorIncludeDialog_Title"), false, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.setVisible(true);
        errors.parent = dlg;
        CsmListeners.getDefault().addModelListener((CsmModelListener)errors);
    }

    private void createComponents(List<CsmInclude> includes, List<CsmErrorDirective> errors) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.createIncludesPane(), c);
        this.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleName"));
        this.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescription"));
        this.model = new ErrorIncludesModel(includes, errors);
        this.leftList.setModel(this.model);
        this.addListeners();
        if (TRACE_ERROR_STATISTIC) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ErrorIncludeDialog.this.printStatistic();
                }
            });
        }
    }

    private void checkHighlightModel(Set<CsmFile> files) {
        boolean failed;
        CsmFile file;
        CsmFileInfoQuery fiq = CsmFileInfoQuery.getDefault();
        for (CsmFile f : this.baseProject.getSourceFiles()) {
            file = f;
            failed = fiq.hasBrokenIncludes(file);
            if (failed) {
                if (files.contains(file)) continue;
                System.out.println("Project source file is failed and not found in highlight");
                System.out.println("  " + file.getAbsolutePath());
                continue;
            }
            if (!files.contains(file)) continue;
            System.out.println("Project source file is not failed and found in highlight");
            System.out.println("  " + file.getAbsolutePath());
        }
        for (CsmFile f : this.baseProject.getHeaderFiles()) {
            file = f;
            failed = fiq.hasBrokenIncludes(file);
            if (failed) {
                if (files.contains(file)) continue;
                System.out.println("Project header file is failed and not found in highlight");
                System.out.println("  " + file.getAbsolutePath());
                continue;
            }
            if (!files.contains(file)) continue;
            System.out.println("Project header file is not failed and found in highlight");
            System.out.println("  " + file.getAbsolutePath());
        }
    }

    private void printStatistic() {
        if (this.baseProject != null) {
            Object o;
            boolean failed;
            CsmFile file;
            CsmFile f;
            int files = 0;
            int directives = 0;
            int failedDirectives = 0;
            int failedFiles = 0;
            Iterator i$ = this.baseProject.getSourceFiles().iterator();
            while (i$.hasNext()) {
                file = f = (CsmFile)i$.next();
                ++files;
                failed = false;
                for (CsmInclude directive : file.getIncludes()) {
                    if (directive.getIncludeFile() == null) {
                        ++failedDirectives;
                        failed = true;
                    }
                    ++directives;
                }
                if (!failed) continue;
                ++failedFiles;
            }
            i$ = this.baseProject.getHeaderFiles().iterator();
            while (i$.hasNext()) {
                file = f = (CsmFile)i$.next();
                ++files;
                failed = false;
                for (CsmInclude directive : file.getIncludes()) {
                    if (directive.getIncludeFile() == null) {
                        ++failedDirectives;
                        failed = true;
                    }
                    ++directives;
                }
                if (!failed) continue;
                ++failedFiles;
            }
            System.out.println("*Model #includes statistic*");
            System.out.println("  Amount of #includes:" + directives);
            System.out.println("  Failed    #includes:" + failedDirectives);
            System.out.println("  Amount     of files:" + files);
            System.out.println("  Failed        files:" + failedFiles);
            if (directives > 0) {
                double metric = 100.0 * (double)(directives - failedDirectives) / (double)directives;
                System.out.println("  Resolve #include Accuracy:" + metric + "%");
                metric = 100.0 * (double)(files - failedFiles) / (double)files;
                System.out.println("  File-based       Accuracy:" + metric + "%");
            }
            if ((o = this.baseProject.getPlatformProject()) instanceof NativeProject) {
                files = 0;
                NativeProject nativeProject = (NativeProject)o;
                for (NativeFileItem item : nativeProject.getAllFiles()) {
                    if (item.isExcluded()) continue;
                    switch (item.getLanguage()) {
                        case C: 
                        case CPP: 
                        case C_HEADER: {
                            ++files;
                            break;
                        }
                    }
                }
                System.out.println("*Details for project statistic*");
                System.out.println("  Amount of native project files:" + files);
                System.out.println("  Failed   highlight   #includes:" + this.model.getFailedIncludesSize());
                System.out.println("  Failed   highlight      files:" + this.model.getFailedFilesSize());
            }
        }
    }

    private JComponent createIncludesPane() {
        this.leftList = new JList();
        this.leftList.setBorder(BorderFactory.createEmptyBorder());
        this.leftList.setSelectionMode(0);
        this.rightList = new JList();
        this.rightList.setBorder(BorderFactory.createEmptyBorder());
        this.rightList.setSelectionMode(0);
        this.guessList = new JEditorPane();
        this.guessList.setContentType("text/html");
        this.guessList.setEditable(false);
        JSplitPane pane = new JSplitPane();
        pane.setResizeWeight(0.5);
        pane.setOneTouchExpandable(true);
        JScrollPane leftScroller = new JScrollPane(this.leftList);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        JLabel l = new JLabel();
        l.setLabelFor(this.leftList);
        Mnemonics.setLocalizedText((JLabel)l, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleInclides"));
        l.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameInclides"));
        l.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameInclides"));
        l.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionInclides"));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 16;
        c.insets = new Insets(5, 6, 5, 5);
        p.add((Component)l, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 6, 5, 5);
        p.add((Component)leftScroller, c);
        pane.setLeftComponent(p);
        JSplitPane vertical = new JSplitPane(0);
        vertical.setResizeWeight(0.5);
        vertical.setOneTouchExpandable(true);
        JScrollPane rightTopScroller = new JScrollPane(this.rightList);
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        l = new JLabel();
        l.setLabelFor(this.rightList);
        Mnemonics.setLocalizedText((JLabel)l, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleFiles"));
        l.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameFiles"));
        l.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameFiles"));
        l.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionFiles"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 16;
        c.insets = new Insets(5, 6, 5, 5);
        p.add((Component)l, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 6, 5, 5);
        p.add((Component)rightTopScroller, c);
        vertical.setTopComponent(p);
        JScrollPane rightBottomScroller = new JScrollPane(this.guessList);
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        l = new JLabel();
        l.setLabelFor(this.guessList);
        Mnemonics.setLocalizedText((JLabel)l, (String)ErrorIncludeDialog.i18n("ErrorIncludeDialog_TitleGuess"));
        l.setToolTipText(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameGuess"));
        l.getAccessibleContext().setAccessibleName(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleNameGuess"));
        l.getAccessibleContext().setAccessibleDescription(ErrorIncludeDialog.i18n("ErrorIncludeDialog_AccessibleDescriptionGuess"));
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 16;
        c.insets = new Insets(5, 6, 5, 5);
        p.add((Component)l, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 6, 5, 5);
        p.add((Component)rightBottomScroller, c);
        vertical.setBottomComponent(p);
        pane.setRightComponent(vertical);
        vertical.addHierarchyListener(new HierarchyListener(){
            private boolean show;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((4L & e.getChangeFlags()) == 4L) {
                    JSplitPane p = (JSplitPane)e.getSource();
                    if (this.show) {
                        int l1 = p.getTopComponent().getHeight();
                        int l2 = p.getBottomComponent().getHeight();
                        if (l1 > 0 && l2 > 0) {
                            NbPreferences.forModule(ErrorIncludeDialog.class).putDouble("verticalDivider", (double)l1 / (double)(l1 + l2));
                        }
                    } else {
                        p.setDividerLocation(NbPreferences.forModule(ErrorIncludeDialog.class).getDouble("verticalDivider", 0.65));
                        this.show = true;
                    }
                }
            }
        });
        pane.addHierarchyListener(new HierarchyListener(){
            private boolean show;

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((4L & e.getChangeFlags()) == 4L) {
                    JSplitPane p = (JSplitPane)e.getSource();
                    if (this.show) {
                        int l1 = p.getLeftComponent().getWidth();
                        int l2 = p.getRightComponent().getWidth();
                        if (l1 > 0 && l2 > 0) {
                            NbPreferences.forModule(ErrorIncludeDialog.class).putDouble("horisontalDivider", (double)l1 / (double)(l1 + l2));
                        }
                    } else {
                        p.setDividerLocation(NbPreferences.forModule(ErrorIncludeDialog.class).getDouble("horisontalDivider", 0.35));
                        this.show = true;
                    }
                }
            }
        });
        return pane;
    }

    private void addListeners() {
        this.leftList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selected;
                if (!e.getValueIsAdjusting() && (selected = ErrorIncludeDialog.this.leftList.getSelectedIndex()) >= 0) {
                    List<CsmOffsetable> errors = ErrorIncludeDialog.this.baseProject != null && ErrorIncludeDialog.this.baseProject.isValid() ? ErrorIncludeDialog.this.model.getElementList(selected) : Collections.emptyList();
                    ErrorFilesModel m = new ErrorFilesModel(errors);
                    ErrorIncludeDialog.this.rightList.setModel(m);
                    if (errors.size() > 0) {
                        ErrorIncludeDialog.this.rightList.setSelectedIndex(0);
                        ErrorIncludeDialog.this.rightList.invalidate();
                        ErrorIncludeDialog.this.rightList.repaint();
                        CsmOffsetable error = m.getFailedDirective(0);
                        ErrorIncludeDialog.this.guessList.setText(NbBundle.getMessage(ErrorIncludeDialog.class, (String)"MSG_Loading"));
                        ErrorIncludeDialog.this.guess(error, (String)ErrorIncludeDialog.this.model.getElementAt(selected));
                    } else {
                        ErrorIncludeDialog.this.guessList.setText("");
                    }
                }
            }
        });
        this.leftList.setSelectedIndex(0);
        this.rightList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selected = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                    if (selected >= 0 && ErrorIncludeDialog.this.baseProject != null && ErrorIncludeDialog.this.baseProject.isValid()) {
                        ErrorFilesModel m = (ErrorFilesModel)ErrorIncludeDialog.this.rightList.getModel();
                        CsmOffsetable error = m.getFailedDirective(selected);
                        ErrorIncludeDialog.this.guessList.setText(NbBundle.getMessage(ErrorIncludeDialog.class, (String)"MSG_Loading"));
                        ErrorIncludeDialog.this.guess(error, (String)ErrorIncludeDialog.this.model.getElementAt(ErrorIncludeDialog.this.leftList.getSelectedIndex()));
                    } else {
                        ErrorIncludeDialog.this.guessList.setText("");
                    }
                }
            }
        });
        this.leftList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selected = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (e.getClickCount() == 2 && selected >= 0) {
                    ErrorIncludeDialog.this.openElement(selected);
                }
            }
        });
        this.leftList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int selected = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (e.getModifiers() == 0 && e.getKeyCode() == 32 && selected >= 0) {
                    ErrorIncludeDialog.this.openElement(selected);
                }
            }
        });
        this.rightList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selected = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (e.getClickCount() == 2 && selected >= 0) {
                    ErrorIncludeDialog.this.openElement(selected);
                }
            }
        });
        this.rightList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int selected = ErrorIncludeDialog.this.rightList.getSelectedIndex();
                if (e.getModifiers() == 0 && e.getKeyCode() == 32 && selected >= 0) {
                    ErrorIncludeDialog.this.openElement(selected);
                }
            }
        });
    }

    private void openElement(int selected) {
        if (this.baseProject != null && this.baseProject.isValid()) {
            ErrorFilesModel m = (ErrorFilesModel)this.rightList.getModel();
            CsmOffsetable error = m.getFailedDirective(selected);
            CsmUtilities.openSource((CsmObject)error);
        }
    }

    private void guess(final CsmOffsetable error, final String item) {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                List list;
                final StringBuilder buf = new StringBuilder();
                String found = item;
                boolean handleIncludeError = CsmKindUtilities.isInclude((CsmObject)error);
                if (handleIncludeError) {
                    List result;
                    if (ErrorIncludeDialog.this.searchBase == null) {
                        ErrorIncludeDialog.this.searchBase = ErrorIncludeDialog.this.search(error);
                    }
                    found = found.replace("<", "");
                    found = found.replace(">", "");
                    found = found.replace("\"", "");
                    if ((found = found.replace("\\", "/")).indexOf(47) >= 0) {
                        found = found.substring(found.lastIndexOf(47) + 1);
                    }
                    if ((result = (List)ErrorIncludeDialog.this.searchBase.get(found)) != null) {
                        for (String elem : result) {
                            buf.append(elem).append("\n<br>");
                        }
                    }
                } else {
                    buf.append(error.getText()).append("\n<br>");
                }
                CsmFile file = error.getContainingFile();
                if (handleIncludeError) {
                    ErrorIncludeDialog.this.getObjectFile(found, ((Object)file.getAbsolutePath()).toString(), buf);
                }
                if (file.isHeaderFile()) {
                    list = CsmFileInfoQuery.getDefault().getIncludeStack(file);
                    if (list.size() > 0) {
                        buf.append(ErrorIncludeDialog.i18n("PathToHeader"));
                        file = ((CsmInclude)list.get(0)).getContainingFile();
                        for (CsmInclude inc : list) {
                            buf.append("\n<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                            buf.append(inc.getContainingFile().getAbsolutePath());
                            buf.append(ErrorIncludeDialog.i18n("PathToHeaderLine", inc.getStartPosition().getLine()));
                        }
                        buf.append("\n<br>");
                    } else {
                        file = null;
                    }
                }
                if (file != null) {
                    FileObject fo;
                    list = CsmFileInfoQuery.getDefault().getUserIncludePaths(file);
                    if (list.size() > 0) {
                        buf.append(ErrorIncludeDialog.i18n("SourceUserPaths"));
                        for (FSPath fsPath : list) {
                            buf.append("\n<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                            fo = fsPath.getFileObject();
                            if (fo != null && fo.isValid() && fo.isFolder()) {
                                buf.append(fsPath.getPath());
                                continue;
                            }
                            buf.append("<font color='red'>");
                            buf.append(fsPath.getPath());
                            buf.append("</font>");
                        }
                        buf.append("\n<br>");
                    }
                    if ((list = CsmFileInfoQuery.getDefault().getSystemIncludePaths(file)).size() > 0) {
                        buf.append(ErrorIncludeDialog.i18n("SourceSystemPaths"));
                        for (FSPath fsPath : list) {
                            buf.append("\n<br>&nbsp;&nbsp;&nbsp;&nbsp;");
                            fo = fsPath.getFileObject();
                            if (fo != null && fo.isValid() && fo.isFolder()) {
                                buf.append(fsPath.getPath());
                                continue;
                            }
                            buf.append("<font color='red'>");
                            buf.append(fsPath.getPath());
                            buf.append("</font>");
                        }
                        buf.append("\n<br>");
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ErrorIncludeDialog.this.guessList.setText("<html><head></head><body>" + buf.toString() + "</body></html>");
                    }
                });
            }
        };
        if (this.guessTask != null) {
            this.guessTask.cancel();
            this.guessTask = null;
        }
        this.guessTask = RP.post(worker);
    }

    private void getObjectFile(String searchFor, String in, StringBuilder buf) {
        List<String> result;
        String source = in.replace("<", "");
        source = source.replace(">", "");
        source = source.replace("\"", "");
        if ((source = source.replace("\\", "/")).indexOf(47) >= 0) {
            source = source.substring(source.lastIndexOf(47) + 1);
        }
        if (source.lastIndexOf(46) > 0 && (result = this.searchBase.get(source = source.substring(0, source.lastIndexOf(46)) + ".o")) != null) {
            for (String elem : result) {
                buf.append(elem).append("\n<br>");
                String path = this.trace(searchFor, elem, in);
                if (path == null) continue;
                buf.append(path).append("\n<br>");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String trace(String found, String objFileName, String unit) {
        Dwarf dump = null;
        try {
            List includes;
            CompilationUnit cu;
            String fullName;
            dump = new Dwarf(objFileName);
            Iterator units = dump.iteratorCompilationUnits();
            if (units.hasNext() && unit.equals(fullName = this.getRightName((cu = (CompilationUnit)units.next()).getSourceFileAbsolutePath())) && (includes = cu.getStatementList().getPathsForFile(found)).size() > 0) {
                String path = this.getRightName(cu.getCompilationDir());
                String message = ErrorIncludeDialog.i18n("HeaderFromBinary");
                String string = MessageFormat.format(message, path, fullName, includes.get(0));
                return string;
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (WrongFileFormatException ex) {
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
        return null;
    }

    private String fixFileName(String fileName) {
        if (fileName != null && Utilities.isWindows()) {
            if (fileName.startsWith(CYG_DRIVE_UNIX)) {
                fileName = fileName.substring(CYG_DRIVE_UNIX.length());
                fileName = "" + Character.toUpperCase(fileName.charAt(0)) + ':' + fileName.substring(1);
            } else {
                int i = fileName.indexOf(CYG_DRIVE_WIN);
                if (i > 0) {
                    fileName = fileName.substring(i + CYG_DRIVE_UNIX.length());
                    fileName = "" + Character.toUpperCase(fileName.charAt(0)) + ':' + fileName.substring(1);
                }
            }
            fileName = fileName.replace('/', '\\');
        }
        return fileName;
    }

    private String getRightName(String fullName) {
        fullName = CndFileUtils.normalizeAbsolutePath((String)fullName);
        fullName = this.fixFileName(fullName);
        return fullName;
    }

    private Map<String, List<String>> search(CsmOffsetable ppDirective) {
        File f;
        CsmProject prj = ppDirective.getContainingFile().getProject();
        HashSet<String> set = new HashSet<String>();
        for (CsmFile file : prj.getSourceFiles()) {
            f = new File(((Object)file.getAbsolutePath()).toString());
            set.add(f.getParentFile().getAbsolutePath());
        }
        for (CsmFile file : prj.getHeaderFiles()) {
            f = new File(((Object)file.getAbsolutePath()).toString());
            set.add(f.getParentFile().getAbsolutePath());
        }
        ArrayList list = new ArrayList(set);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            f = new File((String)it.next());
            this.gatherSubFolders(f, set);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Iterator it2 = set.iterator();
        while (it2.hasNext()) {
            File[] ff;
            File d = new File((String)it2.next());
            if (!d.exists() || !d.isDirectory() || !d.canRead() || (ff = d.listFiles()) == null) continue;
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].isFile()) continue;
                List<String> l = map.get(ff[i].getName());
                if (l == null) {
                    l = new ArrayList<String>();
                    map.put(ff[i].getName(), l);
                }
                l.add(ff[i].getAbsolutePath());
            }
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherSubFolders(File d, HashSet<String> set) {
        if (!d.exists() || !d.isDirectory() || !d.canRead()) return;
        if (CndPathUtilitities.isIgnoredFolder((File)d)) {
            return;
        }
        String path = d.getAbsolutePath();
        if (set.contains(path)) return;
        set.add(d.getAbsolutePath());
        File[] ff = d.listFiles();
        if (ff == null) return;
        for (int i = 0; i < ff.length; ++i) {
            try {
                String canPath = ff[i].getCanonicalPath();
                String absPath = ff[i].getAbsolutePath();
                if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                    continue;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.gatherSubFolders(ff[i], set);
        }
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(ErrorIncludeDialog.class, (String)id);
    }

    private static String i18n(String id, int line) {
        return NbBundle.getMessage(ErrorIncludeDialog.class, (String)id, (Object)("" + line));
    }
}

