/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class FixActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private SourcePathProvider sp;
    private Listener listener;
    private boolean isFixCommandSupported;

    public FixActionProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.sp = (SourcePathProvider)lookupProvider.lookupFirst(null, SourcePathProvider.class);
        this.listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(this.listener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.listener);
        ClassesToReload.getInstance().addPropertyChangeListener(this.listener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-java", (PropertyChangeListener)this.listener);
        this.setEnabled(ActionsManager.ACTION_FIX, this.shouldBeEnabled());
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.listener);
        ClassesToReload.getInstance().removePropertyChangeListener(this.listener);
        MainProjectManager.getDefault().removePropertyChangeListener(this.listener);
        EditorContextDispatcher.getDefault().removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_FIX);
    }

    public void doAction(Object action) {
        if (!this.isFixCommandSupported) {
            Set<FileObject> sourceRootsFO = this.getSourceRootsFO(this.sp);
            Map<String, FileObject> classes = ClassesToReload.getInstance().popClassesToReload(this.debugger, sourceRootsFO);
            FixActionProvider.reloadClasses(this.debugger, classes);
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FixActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException iex) {
            }
            catch (InvocationTargetException itex) {
                ErrorManager.getDefault().notify((Throwable)itex);
            }
        } else {
            this.invokeAction();
        }
    }

    private Set<FileObject> getSourceRootsFO(SourcePathProvider sp) {
        if (sp instanceof SourcePathProviderImpl) {
            return ((SourcePathProviderImpl)sp).getSourceRootsFO();
        }
        String[] sourceRoots = sp.getSourceRoots();
        HashSet<FileObject> fos = new HashSet<FileObject>();
        for (String root : sourceRoots) {
            FileObject fo;
            int jarIndex = root.indexOf("!/");
            if (jarIndex > 0) {
                fo = FileUtil.toFileObject((File)new File(root.substring(0, jarIndex)));
                fo = fo.getFileObject(root.substring(jarIndex + 2));
            } else {
                fo = FileUtil.toFileObject((File)new File(root));
            }
            if (fo == null) continue;
            fos.add(fo);
        }
        return fos;
    }

    private void invokeAction() {
        ((ActionProvider)this.getCurrentProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.fix", this.getLookup());
    }

    private Project getCurrentProject() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return MainProjectManager.getDefault().getMainProject();
        }
        DataObject dao = (DataObject)nodes[0].getCookie(DataObject.class);
        if (dao == null || !dao.isValid()) {
            return MainProjectManager.getDefault().getMainProject();
        }
        return FileOwnerQuery.getOwner((FileObject)dao.getPrimaryFile());
    }

    private boolean shouldBeEnabled() {
        ActionProvider actionProvider;
        if (!this.debugger.canFixClasses()) {
            return false;
        }
        this.isFixCommandSupported = false;
        Project p = this.getCurrentProject();
        if (p != null && (actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null) {
            int i;
            String[] sa = actionProvider.getSupportedActions();
            int k = sa.length;
            for (i = 0; i < k && !"debug.fix".equals(sa[i]); ++i) {
            }
            boolean bl = this.isFixCommandSupported = i < k && actionProvider.isActionEnabled("debug.fix", this.getLookup());
        }
        if (!this.isFixCommandSupported) {
            return ClassesToReload.getInstance().hasClassesToReload(this.debugger, this.getSourceRootsFO(this.sp));
        }
        return true;
    }

    private Lookup getLookup() {
        FileObject fo;
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        int k = nodes.length;
        ArrayList<DataObject> l = new ArrayList<DataObject>();
        for (int i = 0; i < k; ++i) {
            DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
            if (dobj == null || !dobj.isValid()) continue;
            l.add(dobj);
        }
        if (l.isEmpty() && (fo = EditorContextDispatcher.getDefault().getMostRecentFile()) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                l.add(dobj);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        return Lookups.fixed((Object[])l.toArray(new DataObject[l.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadClasses(final JPDADebugger debugger, Map<String, FileObject> classes) {
        RequestProcessor rp;
        final HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (String className : classes.keySet()) {
            FileObject fo = classes.get(className);
            InputStream is = null;
            try {
                is = fo.getInputStream();
                long fileSize = fo.getSize();
                byte[] bytecode = new byte[(int)fileSize];
                is.read(bytecode);
                map.put(className, bytecode);
                System.out.println(" " + className);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (map.size() == 0) {
            return;
        }
        try {
            Session s = (Session)debugger.getClass().getMethod("getSession", new Class[0]).invoke((Object)debugger, new Object[0]);
            rp = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                String error = null;
                try {
                    debugger.fixClasses(map);
                }
                catch (UnsupportedOperationException uoex) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixUnsupported", (Object)uoex.getLocalizedMessage());
                }
                catch (NoClassDefFoundError ncdfex) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixMismatch", (Object)ncdfex.getLocalizedMessage());
                }
                catch (VerifyError ver) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixVerifierProblems", (Object)ver.getLocalizedMessage());
                }
                catch (UnsupportedClassVersionError ucver) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixUnsupportedVersion", (Object)ucver.getLocalizedMessage());
                }
                catch (ClassFormatError cfer) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixNotValid", (Object)cfer.getLocalizedMessage());
                }
                catch (ClassCircularityError ccer) {
                    error = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixCircularity", (Object)ccer.getLocalizedMessage());
                }
                catch (RuntimeException vmdisc) {
                    if ("com.sun.jdi.VMDisconnectedException".equals(vmdisc.getClass().getName())) {
                        return;
                    }
                    throw vmdisc;
                }
                if (error != null) {
                    FixActionProvider.notifyError(error);
                } else {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixSuccess"));
                }
            }
        });
    }

    static void notifyError(String error) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)error, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        StatusDisplayer.getDefault().setStatusText(error);
    }

    public static class ClassesToReload {
        private static ClassesToReload instance;
        private Map<JPDADebugger, Map<FileObject, Map<String, FileObject>>> classesByDebugger = new WeakHashMap<JPDADebugger, Map<FileObject, Map<String, FileObject>>>();
        private PropertyChangeSupport pch = new PropertyChangeSupport(this);

        private ClassesToReload() {
        }

        public static synchronized ClassesToReload getInstance() {
            if (instance == null) {
                instance = new ClassesToReload();
            }
            return instance;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pch.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pch.removePropertyChangeListener(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClassToReload(JPDADebugger debugger, FileObject src, String className, FileObject fo) {
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<String, FileObject> classes;
                Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
                if (srcRoots == null) {
                    srcRoots = new HashMap<FileObject, Map<String, FileObject>>();
                    this.classesByDebugger.put(debugger, srcRoots);
                }
                if ((classes = srcRoots.get(src)) == null) {
                    classes = new HashMap<String, FileObject>();
                    srcRoots.put(src, classes);
                }
                classes.put(className, fo);
            }
            this.pch.firePropertyChange("classesToReload", null, className);
        }

        public synchronized boolean hasClassesToReload(JPDADebugger debugger, Set<FileObject> enabledSourceRoots) {
            Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
            if (srcRoots != null) {
                for (FileObject src : srcRoots.keySet()) {
                    if (!enabledSourceRoots.contains(src)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, FileObject> popClassesToReload(JPDADebugger debugger, Set<FileObject> enabledSourceRoots) {
            HashMap<String, FileObject> classes = new HashMap<String, FileObject>();
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<FileObject, Map<String, FileObject>> srcRoots = this.classesByDebugger.get(debugger);
                if (srcRoots != null) {
                    HashSet<FileObject> sourceRoots = new HashSet<FileObject>(srcRoots.keySet());
                    for (FileObject src : sourceRoots) {
                        if (!enabledSourceRoots.contains(src)) continue;
                        classes.putAll(srcRoots.remove(src));
                    }
                }
            }
            if (classes.size() > 0) {
                this.pch.firePropertyChange("classesToReload", null, null);
            }
            return classes;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean en = FixActionProvider.this.shouldBeEnabled();
            FixActionProvider.this.setEnabled(ActionsManager.ACTION_FIX, en);
            if (FixActionProvider.this.debugger.getState() == 4) {
                FixActionProvider.this.destroy();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
        }

        public void engineRemoved(DebuggerEngine engine) {
        }
    }
}

