/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchImpl;
import org.netbeans.modules.debugger.jpda.models.Local;
import org.netbeans.modules.debugger.jpda.models.ObjectLocalVariable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class JPDAObjectWatchImpl
extends AbstractObjectVariable
implements JPDAWatch,
ObjectVariable {
    private JPDADebuggerImpl debugger;
    private Watch watch;
    private String exceptionDescription;

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, Value v) {
        super(debugger, v, "" + watch + (v instanceof ObjectReference ? "^" : ""));
        this.debugger = debugger;
        this.watch = watch;
    }

    JPDAObjectWatchImpl(JPDADebuggerImpl debugger, Watch watch, String exceptionDescription) {
        super(debugger, null, "" + watch);
        this.debugger = debugger;
        this.watch = watch;
        this.exceptionDescription = exceptionDescription;
    }

    public Watch getWatch() {
        return this.watch;
    }

    public String getExpression() {
        return this.watch.getExpression();
    }

    public void setExpression(String expression) {
        this.watch.setExpression(expression);
    }

    public void remove() {
        this.watch.remove();
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        block26: {
            CallStackFrameImpl frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (frame == null) {
                throw new InvalidExpressionException("No curent frame.");
            }
            try {
                try {
                    LocalVariable local = frame.getLocalVariable(this.getExpression());
                    if (local != null) {
                        if (local instanceof Local) {
                            ((Local)local).setValue(value);
                        } else {
                            ((ObjectLocalVariable)local).setValue(value);
                        }
                        return;
                    }
                }
                catch (AbsentInformationException ex) {
                    // empty catch block
                }
                ReferenceType clazz = LocationWrapper.declaringType(StackFrameWrapper.location(frame.getStackFrame()));
                Field field = ReferenceTypeWrapper.fieldByName(clazz, this.getExpression());
                if (field == null) {
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                if (TypeComponentWrapper.isStatic(field)) {
                    if (clazz instanceof ClassType) {
                        try {
                            ClassTypeWrapper.setValue((ClassType)clazz, field, value);
                            break block26;
                        }
                        catch (InvalidTypeException ex) {
                            throw new InvalidExpressionException((Throwable)ex);
                        }
                        catch (ClassNotLoadedException ex) {
                            throw new InvalidExpressionException((Throwable)ex);
                        }
                        catch (IllegalArgumentException iaex) {
                            throw new InvalidExpressionException((Throwable)iaex);
                        }
                    }
                    throw new InvalidExpressionException(NbBundle.getMessage(JPDAWatchImpl.class, (String)"MSG_CanNotSetValue", (Object)this.getExpression()));
                }
                ObjectReference thisObject = StackFrameWrapper.thisObject(frame.getStackFrame());
                if (thisObject == null) {
                    throw new InvalidExpressionException("no instance context.");
                }
                try {
                    ObjectReferenceWrapper.setValue(thisObject, field, value);
                }
                catch (IllegalArgumentExceptionWrapper ex) {
                    throw new InvalidExpressionException((Throwable)ex.getCause());
                }
                catch (InvalidTypeException ex) {
                    throw new InvalidExpressionException((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    throw new InvalidExpressionException((Throwable)ex);
                }
                catch (IllegalArgumentException iaex) {
                    throw new InvalidExpressionException((Throwable)iaex);
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    throw new InvalidExpressionException((Throwable)ocex);
                }
            }
            catch (InternalExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (VMDisconnectedExceptionWrapper ex) {
            }
            catch (ClassNotPreparedExceptionWrapper ex) {
                throw new InvalidExpressionException((Throwable)ex);
            }
            catch (InvalidStackFrameExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
                throw new InvalidExpressionException((Throwable)ex);
            }
        }
    }

    @Override
    protected void setInnerValue(Value v) {
        super.setInnerValue(v);
        this.exceptionDescription = null;
    }

    void setException(String exceptionDescription) {
        super.setInnerValue(null);
        this.exceptionDescription = exceptionDescription;
    }

    boolean isPrimitive() {
        return !(this.getInnerValue() instanceof ObjectReference);
    }

    @Override
    public JPDAObjectWatchImpl clone() {
        JPDAObjectWatchImpl clon = this.exceptionDescription == null ? new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.getJDIValue()) : new JPDAObjectWatchImpl(this.getDebugger(), this.watch, this.exceptionDescription);
        return clon;
    }
}

