/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadDeathEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ThreadStartEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.openide.util.Exceptions;

public class ThreadBreakpointImpl
extends BreakpointImpl
implements Executor {
    private ThreadBreakpoint breakpoint;

    public ThreadBreakpointImpl(ThreadBreakpoint presenter, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)presenter, null, debugger, session);
        this.breakpoint = presenter;
        this.set();
    }

    @Override
    protected void setRequests() {
        try {
            VirtualMachine vm;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                ThreadStartRequest tsr = EventRequestManagerWrapper.createThreadStartRequest(this.getEventRequestManager());
                this.addEventRequest(tsr);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0 && (vm = this.getVirtualMachine()) != null) {
                ThreadDeathRequest tdr = EventRequestManagerWrapper.createThreadDeathRequest(VirtualMachineWrapper.eventRequestManager(vm));
                this.addEventRequest(tdr);
            }
        }
        catch (InternalExceptionWrapper e) {
        }
        catch (ObjectCollectedExceptionWrapper e) {
        }
        catch (VMDisconnectedExceptionWrapper e) {
        }
        catch (InvalidRequestStateExceptionWrapper irse) {
            Exceptions.printStackTrace((Throwable)irse);
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (oldRequest instanceof ThreadStartRequest) {
            return EventRequestManagerWrapper.createThreadStartRequest(this.getEventRequestManager());
        }
        if (oldRequest instanceof ThreadDeathRequest) {
            return EventRequestManagerWrapper.createThreadDeathRequest(this.getEventRequestManager());
        }
        return null;
    }

    @Override
    public boolean processCondition(Event event) {
        return true;
    }

    @Override
    public boolean exec(Event event) {
        ThreadReference thread = null;
        try {
            if (event instanceof ThreadStartEvent) {
                thread = ThreadStartEventWrapper.thread((ThreadStartEvent)event);
            } else if (event instanceof ThreadDeathEvent) {
                thread = ThreadDeathEventWrapper.thread((ThreadDeathEvent)event);
            }
        }
        catch (InternalExceptionWrapper ex) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            return true;
        }
        return this.perform(event, thread, null, event instanceof ThreadDeathEvent ? null : thread);
    }

    @Override
    public void removed(EventRequest eventRequest) {
    }
}

