/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private int lineNumber;
    private int breakpointLineNumber;
    private int lineNumberForUpdate = -1;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint breakpoint, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session, SourcePath sourcePath) {
        super((JPDABreakpoint)breakpoint, reader, debugger, session);
        this.reader = reader;
        this.updateLineNumber();
        this.setSourceRoot(sourcePath.getSourceRoot(breakpoint.getURL()));
        this.set();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLineNumber() {
        LineBreakpoint lb = this.getBreakpoint();
        int theLineNumber = EditorContextBridge.getContext().getLineNumber((Object)lb, (Object)this.getDebugger());
        LineBreakpointImpl lineBreakpointImpl = this;
        synchronized (lineBreakpointImpl) {
            this.breakpointLineNumber = lb.getLineNumber();
            this.lineNumber = theLineNumber;
        }
    }

    protected LineBreakpoint getBreakpoint() {
        return (LineBreakpoint)super.getBreakpoint();
    }

    @Override
    void fixed() {
        logger.fine("LineBreakpoint fixed: " + this);
        this.updateLineNumber();
        super.fixed();
    }

    @Override
    protected boolean isApplicable() {
        LineBreakpoint breakpoint = this.getBreakpoint();
        String[] preferredSourceRoot = new String[]{null};
        String sourcePath = this.getDebugger().getEngineContext().getRelativePath(breakpoint.getURL(), '/', true);
        if (sourcePath == null) {
            return false;
        }
        boolean isInSources = false;
        String srcRoot = this.getSourceRoot();
        if (srcRoot != null) {
            String[] sourceRoots = this.getDebugger().getEngineContext().getSourceRoots();
            for (int i = 0; i < sourceRoots.length; ++i) {
                if (!srcRoot.equals(sourceRoots[i])) continue;
                isInSources = true;
            }
        }
        if (!isInSources) {
            return false;
        }
        return !isInSources || this.isEnabled(sourcePath, preferredSourceRoot);
    }

    @Override
    protected void setRequests() {
        LineBreakpoint breakpoint = this.getBreakpoint();
        this.updateLineNumber();
        String[] preferredSourceRoot = new String[]{null};
        String sourcePath = this.getDebugger().getEngineContext().getRelativePath(breakpoint.getURL(), '/', true);
        if (sourcePath == null) {
            String reason = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoSourceRoot", (Object)breakpoint.getURL());
            this.setInvalid(reason);
            return;
        }
        String className = breakpoint.getPreferredClassName();
        if (className == null && (className = this.reader.findCachedClassName((JPDABreakpoint)breakpoint)) == null && (className = EditorContextBridge.getContext().getClassName(breakpoint.getURL(), this.lineNumber)) != null && className.length() > 0) {
            this.reader.storeCachedClassName((JPDABreakpoint)breakpoint, className);
        }
        if (className == null || className.length() == 0) {
            logger.warning("Class name not defined for breakpoint " + breakpoint);
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoBPClass"));
            return;
        }
        boolean isInSources = false;
        String srcRoot = this.getSourceRoot();
        if (srcRoot != null) {
            String[] sourceRoots = this.getDebugger().getEngineContext().getSourceRoots();
            for (int i = 0; i < sourceRoots.length; ++i) {
                if (!srcRoot.equals(sourceRoots[i])) continue;
                isInSources = true;
            }
        }
        if (!isInSources && LineBreakpointImpl.classExistsInSources(className, this.getDebugger().getEngineContext().getProjectSourceRoots())) {
            logger.fine("LineBreakpoint " + breakpoint + " NOT submitted, URL " + breakpoint.getURL() + " not in sources, but class " + className + " exist in sources.");
            return;
        }
        if (isInSources && !this.isEnabled(sourcePath, preferredSourceRoot)) {
            String reason = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_DifferentPrefferedSourceRoot", (Object)preferredSourceRoot[0]);
            this.setInvalid(reason);
            logger.fine("LineBreakpoint " + breakpoint + " NOT submitted, because of '" + reason + "'.");
            return;
        }
        logger.fine("LineBreakpoint " + breakpoint + " - setting request for " + className);
        this.setClassRequests(new String[]{className}, new String[0], 1);
        this.checkLoadedClasses(className, null);
    }

    private void setInvalid(String reason) {
        ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + this.getBreakpoint().getURL() + " at line " + this.lineNumber + ", reason: " + reason);
        this.setValidity(Breakpoint.VALIDITY.INVALID, reason);
    }

    private static boolean classExistsInSources(final String className, String[] projectSourceRoots) {
        ArrayList<FileObject> sourcePaths = new ArrayList<FileObject>(projectSourceRoots.length);
        for (String sr : projectSourceRoots) {
            FileObject fo = LineBreakpointImpl.getFileObject(sr);
            if (fo == null) continue;
            sourcePaths.add(fo);
        }
        ClassPath cp = ClassPathSupport.createClassPath((FileObject[])sourcePaths.toArray(new FileObject[0]));
        ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[0]), (ClassPath)cp);
        JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        final boolean[] found = new boolean[]{false};
        try {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    TypeElement te = cc.getElements().getTypeElement(className);
                    if (te != null) {
                        found[0] = true;
                    }
                }
            }, false);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return found[0];
    }

    private static FileObject getFileObject(String file) {
        File f = new File(file);
        FileObject fo = FileUtil.toFileObject((File)f);
        String path = null;
        if (fo == null && file.contains("!/")) {
            int index = file.indexOf("!/");
            f = new File(file.substring(0, index));
            fo = FileUtil.toFileObject((File)f);
            path = file.substring(index + "!/".length());
        }
        if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
            fo = FileUtil.getArchiveRoot((FileObject)fo);
            if (path != null) {
                fo = fo.getFileObject(path);
            }
        }
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classLoaded(List<ReferenceType> referenceTypes) {
        int newBreakpointLineNumber;
        int origBreakpointLineNumber;
        int lineNumberToSet;
        LineBreakpoint breakpoint = this.getBreakpoint();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Classes " + referenceTypes + " loaded for breakpoint " + breakpoint);
        }
        boolean submitted = false;
        String failReason = null;
        ReferenceType noLocRefType = null;
        LineBreakpointImpl lineBreakpointImpl = this;
        synchronized (lineBreakpointImpl) {
            lineNumberToSet = this.lineNumber;
            newBreakpointLineNumber = origBreakpointLineNumber = this.breakpointLineNumber;
        }
        String currFailReason = null;
        for (int counter = 0; counter < 2; ++counter) {
            for (ReferenceType referenceType : referenceTypes) {
                String[] reason = new String[]{null};
                boolean[] isNoLocReason = new boolean[1];
                List locations = LineBreakpointImpl.getLocations(referenceType, breakpoint.getStratum(), breakpoint.getSourceName(), breakpoint.getSourcePath(), lineNumberToSet, reason, isNoLocReason);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Locations in " + referenceType + " are: " + locations + ", reason = '" + reason[0]);
                }
                if (locations.isEmpty()) {
                    failReason = reason[0];
                    if (!isNoLocReason[0]) continue;
                    noLocRefType = referenceType;
                    continue;
                }
                for (Location location : locations) {
                    try {
                        BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
                        this.setFilters(br);
                        this.addEventRequest(br);
                        submitted = true;
                    }
                    catch (VMDisconnectedExceptionWrapper e) {
                    }
                    catch (InternalExceptionWrapper e) {
                    }
                    catch (ObjectCollectedExceptionWrapper e) {
                    }
                    catch (InvalidRequestStateExceptionWrapper irse) {
                        Exceptions.printStackTrace((Throwable)irse);
                    }
                }
            }
            if (counter == 0) {
                int newLineNumber;
                if (submitted || noLocRefType == null || (newLineNumber = this.findBreakableLine(breakpoint.getURL(), origBreakpointLineNumber)) == origBreakpointLineNumber || newLineNumber < 0 || LineBreakpointImpl.findBreakpoint(breakpoint.getURL(), newLineNumber) != null) break;
                newBreakpointLineNumber = newLineNumber;
                lineNumberToSet += newLineNumber - origBreakpointLineNumber;
                currFailReason = failReason;
                failReason = null;
                continue;
            }
            if (submitted) continue;
            failReason = currFailReason;
        }
        if (submitted) {
            LineBreakpointImpl lineBreakpointImpl2 = this;
            synchronized (lineBreakpointImpl2) {
                if (origBreakpointLineNumber != newBreakpointLineNumber) {
                    this.lineNumberForUpdate = newBreakpointLineNumber;
                    breakpoint.setLineNumber(newBreakpointLineNumber);
                }
            }
            this.setValidity(Breakpoint.VALIDITY.VALID, failReason);
        } else {
            ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + referenceTypes.get(0).name() + " at line " + this.lineNumber + ", reason: " + failReason);
            this.setValidity(Breakpoint.VALIDITY.INVALID, failReason);
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        Location location = BreakpointRequestWrapper.location((BreakpointRequest)oldRequest);
        BreakpointRequest br = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), location);
        this.setFilters(br);
        return br;
    }

    private void setFilters(BreakpointRequest br) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        ObjectVariable[] varFilters;
        JPDAThread[] threadFilters = this.getBreakpoint().getThreadFilters((JPDADebugger)this.getDebugger());
        if (threadFilters != null && threadFilters.length > 0) {
            for (JPDAThread t : threadFilters) {
                BreakpointRequestWrapper.addThreadFilter(br, ((JPDAThreadImpl)t).getThreadReference());
            }
        }
        if ((varFilters = this.getBreakpoint().getInstanceFilters((JPDADebugger)this.getDebugger())) != null && varFilters.length > 0) {
            for (ObjectVariable v : varFilters) {
                BreakpointRequestWrapper.addInstanceFilter(br, (ObjectReference)((JDIVariable)v).getJDIValue());
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.processCondition(event, this.getBreakpoint().getCondition(), LocatableEventWrapper.thread((BreakpointEvent)event), null);
            }
            catch (InternalExceptionWrapper ex) {
                return true;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            try {
                return this.perform(event, LocatableEventWrapper.thread((BreakpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), null);
            }
            catch (InternalExceptionWrapper ex) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return false;
            }
        }
        return super.exec(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("lineNumber".equals(evt.getPropertyName())) {
            LineBreakpointImpl lineBreakpointImpl = this;
            synchronized (lineBreakpointImpl) {
                if (this.lineNumberForUpdate != -1) {
                    this.lineNumber = this.lineNumberForUpdate;
                    this.lineNumberForUpdate = -1;
                    return;
                }
            }
            int old = this.lineNumber;
            this.updateLineNumber();
            if (this.lineNumber == old) {
                return;
            }
        }
        super.propertyChange(evt);
    }

    private static List getLocations(ReferenceType referenceType, String stratum, String sourceName, String bpSourcePath, int lineNumber, String[] reason, boolean[] noLocationReason) {
        try {
            reason[0] = null;
            noLocationReason[0] = false;
            List<Location> locations = LineBreakpointImpl.locationsOfLineInClass(referenceType, stratum, sourceName, bpSourcePath, lineNumber, reason);
            if (locations.isEmpty() && reason[0] == null) {
                reason[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLocation", (Object)Integer.toString(lineNumber), (Object)referenceType.name());
                noLocationReason[0] = true;
            }
            return locations;
        }
        catch (AbsentInformationException ex) {
            reason[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLineInfo", (Object)referenceType.name());
        }
        catch (ObjectCollectedException ex) {
            reason[0] = ex.getLocalizedMessage();
        }
        catch (ClassNotPreparedException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
        }
        catch (InternalException iex) {
            ErrorManager.getDefault().annotate((Throwable)iex, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            ErrorManager.getDefault().notify((Throwable)iex);
            reason[0] = iex.getLocalizedMessage();
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Location> locationsOfLineInClass(ReferenceType referenceType, String stratum, String sourceName, String bpSourcePath, int lineNumber, String[] reason) throws AbsentInformationException, ObjectCollectedException, ClassNotPreparedException, InternalException {
        List<Location> list;
        try {
            list = ReferenceTypeWrapper.locationsOfLine0(referenceType, stratum, sourceName, lineNumber);
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            throw ex.getCause();
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("LineBreakpoint: locations for ReferenceType=" + referenceType + ", stratum=" + stratum + ", source name=" + sourceName + ", bpSourcePath=" + bpSourcePath + ", lineNumber=" + lineNumber + " are: {" + list + "}");
        }
        if (!list.isEmpty()) {
            if (bpSourcePath == null) {
                return list;
            }
            bpSourcePath = bpSourcePath.replace(File.separatorChar, '/');
            ArrayList<Location> locations = new ArrayList<Location>(list.size());
            for (Location l : list) {
                String lSourcePath;
                try {
                    lSourcePath = LocationWrapper.sourcePath(l).replace(File.separatorChar, '/');
                }
                catch (InternalExceptionWrapper ex) {
                    return Collections.emptyList();
                }
                catch (VMDisconnectedExceptionWrapper ex) {
                    return Collections.emptyList();
                }
                lSourcePath = LineBreakpointImpl.normalize(lSourcePath);
                if (lSourcePath.equals(bpSourcePath)) {
                    locations.add(l);
                    continue;
                }
                reason[0] = "Breakpoint source path '" + bpSourcePath + "' is different from the location source path '" + lSourcePath + "'.";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("LineBreakpoint: relevant location(s) for path '" + bpSourcePath + "': " + locations);
            }
            if (!locations.isEmpty()) {
                return locations;
            }
        }
        return Collections.emptyList();
    }

    private static String normalize(String path) {
        Pattern thisDirectoryPattern = Pattern.compile("(/|\\A)\\./");
        Pattern parentDirectoryPattern = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher m = thisDirectoryPattern.matcher(path);
        while (m.find()) {
            path = m.replaceAll("$1");
            m = thisDirectoryPattern.matcher(path);
        }
        m = parentDirectoryPattern.matcher(path);
        while (m.find()) {
            if (m.group(2).equals("..")) continue;
            path = path.substring(0, m.start()) + m.group(1) + path.substring(m.end());
            m = parentDirectoryPattern.matcher(path);
        }
        return path;
    }

    private int findBreakableLine(String url, final int lineNumber) {
        int[] result;
        block17: {
            BaseDocument doc;
            FileObject fileObj = null;
            try {
                fileObj = URLMapper.findFileObject((URL)new URL(url));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (fileObj == null) {
                return lineNumber;
            }
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            if (dobj == null) {
                return lineNumber;
            }
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            if (ec == null) {
                return lineNumber;
            }
            try {
                doc = (BaseDocument)ec.openDocument();
            }
            catch (UserQuestionException uqex) {
                return lineNumber;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return lineNumber;
            }
            final int rowStartOffset = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(lineNumber - 1));
            JavaSource js = JavaSource.forFileObject((FileObject)fileObj);
            if (js == null) {
                return lineNumber;
            }
            result = new int[]{lineNumber};
            try {
                Future scanFinished = js.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        TreeUtilities treeUtils;
                        TreePath path;
                        Tree tree;
                        CompilationUnitTree compUnit;
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        int startOffs = (int)positions.getStartPosition(compUnit = ci.getCompilationUnit(), tree = (path = (treeUtils = ci.getTreeUtilities()).pathFor(rowStartOffset)).getLeaf());
                        int outerLineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)startOffs) + 1;
                        if (outerLineNumber == lineNumber) {
                            return;
                        }
                        Tree.Kind kind = tree.getKind();
                        if (kind == Tree.Kind.COMPILATION_UNIT || TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind)) {
                            return;
                        }
                        if (kind == Tree.Kind.BLOCK) {
                            BlockTree blockTree = (BlockTree)tree;
                            Tree previousTree = null;
                            int previousTreeEndOffset = -1;
                            for (StatementTree statementTree : blockTree.getStatements()) {
                                int end = (int)positions.getStartPosition(compUnit, statementTree);
                                if (end <= rowStartOffset && end > previousTreeEndOffset) {
                                    previousTree = statementTree;
                                    previousTreeEndOffset = end;
                                    continue;
                                }
                                if (end <= rowStartOffset) continue;
                                break;
                            }
                            if (previousTree == null) {
                                tree = path.getParentPath().getLeaf();
                                kind = tree.getKind();
                                if (kind != Tree.Kind.COMPILATION_UNIT && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind)) {
                                    previousTree = tree;
                                } else {
                                    return;
                                }
                            }
                            startOffs = (int)positions.getStartPosition(compUnit, previousTree);
                            outerLineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)startOffs) + 1;
                        }
                        result[0] = outerLineNumber;
                    }
                }, true);
                if (scanFinished.isDone()) break block17;
                if (EventQueue.isDispatchThread()) {
                    return lineNumber;
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return lineNumber;
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                    return lineNumber;
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return lineNumber;
            }
        }
        return result[0];
    }

    private static LineBreakpoint findBreakpoint(String url, int lineNumber) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            LineBreakpoint lb;
            if (!(breakpoints[i] instanceof LineBreakpoint) || !(lb = (LineBreakpoint)breakpoints[i]).getURL().equals(url) || lb.getLineNumber() != lineNumber) continue;
            return lb;
        }
        return null;
    }
}

