/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.Repository;
import org.netbeans.modules.mercurial.ui.repository.UserCredentialsSupport;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.IndexingBridge;
import org.netbeans.modules.versioning.util.KeyringSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NetworkSettings;
import org.openide.util.Utilities;

public class HgCommand {
    public static final String HG_COMMAND = "hg";
    public static final String HG_WINDOWS_EXE = ".exe";
    public static final String HG_WINDOWS_BAT = ".bat";
    public static final String HG_WINDOWS_CMD = ".cmd";
    public static final String[] HG_WINDOWS_EXECUTABLES = new String[]{"hg.exe", "hg.bat", "hg.cmd"};
    public static final String HG_COMMAND_PLACEHOLDER = "hg";
    public static final String HGK_COMMAND = "hgk";
    private static final String HG_STATUS_CMD = "status";
    private static final String HG_OPT_REPOSITORY = "--repository";
    private static final String HG_OPT_BUNDLE = "--bundle";
    private static final String HG_OPT_CWD_CMD = "--cwd";
    private static final String HG_OPT_USERNAME = "--user";
    private static final String HG_OPT_FOLLOW = "--follow";
    private static final String HG_FLAG_REV_CMD = "--rev";
    private static final String HG_STATUS_FLAG_TIP_CMD = "tip";
    private static final String HG_STATUS_FLAG_REM_DEL_CMD = "-rd";
    private static final String HG_STATUS_FLAG_INTERESTING_CMD = "-marduC";
    private static final String HG_HEAD_STR = "HEAD";
    private static final String HG_FLAG_DATE_CMD = "--date";
    private static final String HG_COMMIT_CMD = "commit";
    private static final String HG_COMMIT_OPT_LOGFILE_CMD = "--logfile";
    private static final String HG_COMMIT_TEMPNAME = "hgcommit";
    private static final String HG_COMMIT_TEMPNAME_SUFFIX = ".hgm";
    private static final String HG_COMMIT_DEFAULT_MESSAGE = "[no commit message]";
    private static final String HG_REVERT_CMD = "revert";
    private static final String HG_REVERT_NOBACKUP_CMD = "--no-backup";
    private static final String HG_ADD_CMD = "add";
    private static final String HG_BRANCH_CMD = "branch";
    private static final String HG_BRANCH_REV_CMD = "tip";
    private static final String HG_BRANCH_REV_TEMPLATE_CMD = "--template={rev}\\n";
    private static final String HG_BRANCH_SHORT_CS_TEMPLATE_CMD = "--template={node|short}\\n";
    private static final String HG_BRANCH_INFO_TEMPLATE_CMD = "--template={branches}:{rev}:{node|short}\\n";
    private static final String HG_CREATE_CMD = "init";
    private static final String HG_CLONE_CMD = "clone";
    private static final String HG_UPDATE_ALL_CMD = "update";
    private static final String HG_UPDATE_FORCE_ALL_CMD = "-C";
    private static final String HG_REMOVE_CMD = "remove";
    private static final String HG_REMOVE_FLAG_FORCE_CMD = "--force";
    private static final String HG_LOG_CMD = "log";
    private static final String HG_TIP_CMD = "tip";
    private static final String HG_ID_CMD = "identify";
    private static final String HG_OUT_CMD = "out";
    private static final String HG_LOG_LIMIT_ONE_CMD = "-l 1";
    private static final String HG_LOG_LIMIT_CMD = "-l";
    private static final String HG_PARENT_CMD = "parents";
    private static final String HG_LOG_NO_MERGES_CMD = "-M";
    private static final String HG_LOG_DEBUG_CMD = "--debug";
    private static final String HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD = "--template=rev:{rev}\\nauth:{author}\\nuser:{author|user}\\ndesc:{desc}\\ndate:{date|hgdate}\\nid:{node|short}\\n\\nendCS:\\n";
    private static final String HG_LOG_REV_TIP_RANGE = "tip:0";
    private static final String HG_LOG_REVISION_OUT = "rev:";
    private static final String HG_LOG_AUTHOR_OUT = "auth:";
    private static final String HG_LOG_USER_OUT = "user:";
    private static final String HG_LOG_DESCRIPTION_OUT = "desc:";
    private static final String HG_LOG_DATE_OUT = "date:";
    private static final String HG_LOG_ID_OUT = "id:";
    private static final String HG_LOG_PARENTS_OUT = "parents:";
    private static final String HG_LOG_FILEMODS_OUT = "file_mods:";
    private static final String HG_LOG_FILEADDS_OUT = "file_adds:";
    private static final String HG_LOG_FILEDELS_OUT = "file_dels:";
    private static final String HG_LOG_FILECOPIESS_OUT = "file_copies:";
    private static final String HG_LOG_ENDCS_OUT = "endCS:";
    private static final String HG_LOG_PATCH_CMD = "-p";
    private static final String HG_LOG_TEMPLATE_EXPORT_FILE_CMD = "--template=# Mercurial Export File Diff\\n# changeset: \\t{rev}:{node|short}\\n# user:\\t\\t{author}\\n# date:\\t\\t{date|isodate}\\n# summary:\\t{desc}\\n\\n";
    private static final String HG_CSET_TEMPLATE_CMD = "--template={rev}:{node|short}\\n";
    private static final String HG_REV_TEMPLATE_CMD = "--template={rev}\\n";
    private static final String HG_CSET_TARGET_TEMPLATE_CMD = "--template={rev} ({node|short})\\n";
    private static final String HG_CAT_CMD = "cat";
    private static final String HG_FLAG_OUTPUT_CMD = "--output";
    private static final String HG_COMMONANCESTOR_CMD = "debugancestor";
    private static final String HG_ANNOTATE_CMD = "annotate";
    private static final String HG_ANNOTATE_FLAGN_CMD = "--number";
    private static final String HG_ANNOTATE_FLAGU_CMD = "--user";
    private static final String HG_EXPORT_CMD = "export";
    private static final String HG_IMPORT_CMD = "import";
    private static final String HG_RENAME_CMD = "rename";
    private static final String HG_RENAME_AFTER_CMD = "-A";
    private static final String HG_COPY_CMD = "copy";
    private static final String HG_COPY_AFTER_CMD = "-A";
    private static final String HG_NEWEST_FIRST = "--newest-first";
    private static final String HG_RESOLVE_CMD = "resolve";
    private static final String HG_RESOLVE_MARK_RESOLVED = "--mark";
    private static final String HG_MERGE_CMD = "merge";
    private static final String HG_MERGE_FORCE_CMD = "-f";
    private static final String HG_MERGE_ENV = "EDITOR=success || $TEST -s";
    private static final String HG_MERGE_SIMPLE_TOOL = "ui.merge=internal:merge";
    public static final String HG_HGK_PATH_SOLARIS10 = "/usr/demo/mercurial";
    private static final String HG_HGK_PATH_SOLARIS10_ENV = "PATH=/usr/bin/:/usr/sbin:/bin:/usr/demo/mercurial";
    private static final String HG_PULL_CMD = "pull";
    private static final String HG_UPDATE_CMD = "-u";
    private static final String HG_PUSH_CMD = "push";
    private static final String HG_BUNDLE_CMD = "bundle";
    private static final String HG_UNBUNDLE_CMD = "unbundle";
    private static final String HG_ROLLBACK_CMD = "rollback";
    private static final String HG_BACKOUT_CMD = "backout";
    private static final String HG_BACKOUT_MERGE_CMD = "--merge";
    private static final String HG_BACKOUT_COMMIT_MSG_CMD = "-m";
    private static final String HG_REV_CMD = "-r";
    private static final String HG_BASE_CMD = "--base";
    private static final String HG_OPTION_GIT = "--git";
    private static final String HG_STRIP_CMD = "strip";
    private static final String HG_STRIP_EXT_CMD = "extensions.mq=";
    private static final String HG_STRIP_NOBACKUP_CMD = "-n";
    private static final String HG_STRIP_FORCE_MULTIHEAD_CMD = "-f";
    private static final String HG_VERIFY_CMD = "verify";
    private static final String HG_VERSION_CMD = "version";
    private static final String HG_INCOMING_CMD = "incoming";
    private static final String HG_OUTGOING_CMD = "outgoing";
    private static final String HG_VIEW_CMD = "view";
    private static final String HG_VERBOSE_CMD = "-v";
    private static final String HG_CONFIG_OPTION_CMD = "--config";
    private static final String HG_FETCH_EXT_CMD = "extensions.fetch=";
    private static final String HG_FETCH_CMD = "fetch";
    public static final String HG_PROXY_ENV = "http_proxy=";
    private static final String HG_MERGE_NEEDED_ERR = "(run 'hg heads' to see heads, 'hg merge' to merge)";
    public static final String HG_MERGE_CONFLICT_ERR = "conflicts detected in ";
    public static final String HG_MERGE_FAILED1_ERR = "merging";
    public static final String HG_MERGE_FAILED2_ERR = "failed!";
    private static final String HG_MERGE_MULTIPLE_HEADS_ERR = "abort: repo has ";
    private static final String HG_MERGE_UNCOMMITTED_ERR = "abort: outstanding uncommitted merges";
    private static final String HG_MERGE_UNAVAILABLE_ERR = "is not recognized as an internal or external command";
    private static final String HG_NO_CHANGES_ERR = "no changes found";
    private static final String HG_CREATE_NEW_BRANCH_ERR = "abort: push creates new remote ";
    private static final String HG_HEADS_CREATED_ERR = "(+1 heads)";
    private static final String HG_NO_HG_CMD_FOUND_ERR = "hg: not found";
    private static final String HG_ARG_LIST_TOO_LONG_ERR = "Arg list too long";
    private static final String HG_ARGUMENT_LIST_TOO_LONG_ERR = "Argument list too long";
    private static final String HG_HEADS_CMD = "heads";
    private static final String HG_NO_REPOSITORY_ERR = "There is no Mercurial repository here";
    private static final String HG_NO_RESPONSE_ERR = "no suitable response from remote hg!";
    private static final String HG_NOT_REPOSITORY_ERR = "does not appear to be an hg repository";
    private static final String HG_REPOSITORY = "repository";
    private static final String HG_NOT_FOUND_ERR = "not found!";
    private static final String HG_UPDATE_SPAN_BRANCHES_ERR = "abort: update spans branches";
    private static final String HG_ALREADY_TRACKED_ERR = " already tracked!";
    private static final String HG_NOT_TRACKED_ERR = " no tracked!";
    private static final String HG_CANNOT_READ_COMMIT_MESSAGE_ERR = "abort: can't read commit message";
    private static final String HG_CANNOT_RUN_ERR = "Cannot run program";
    private static final String HG_ABORT_ERR = "abort: ";
    private static final String HG_ABORT_PUSH_ERR = "abort: push creates new remote ";
    private static final String HG_ABORT_NO_FILES_TO_COPY_ERR = "abort: no files to copy";
    private static final String HG_ABORT_NO_DEFAULT_PUSH_ERR = "abort: repository default-push not found!";
    private static final String HG_ABORT_NO_DEFAULT_ERR = "abort: repository default not found!";
    private static final String HG_ABORT_POSSIBLE_PROXY_ERR = "abort: error: node name or service name not known";
    private static final String HG_ABORT_UNCOMMITTED_CHANGES_ERR = "abort: outstanding uncommitted changes";
    private static final String HG_BACKOUT_MERGE_NEEDED_ERR = "(use \"backout --merge\" if you want to auto-merge)";
    private static final String HG_ABORT_BACKOUT_MERGE_CSET_ERR = "abort: cannot back out a merge changeset without --parent";
    private static final String HG_COMMIT_AFTER_MERGE_ERR = "abort: cannot partially commit a merge (do not specify files or patterns)";
    private static final String HG_ADDING = "adding";
    private static final String HG_WARNING_PERFORMANCE_FILES_OVER = ": files over";
    private static final String HG_WARNING_PERFORMANCE_CAUSE_PROBLEMS = "cause memory and performance problems";
    private static final String HG_NO_CHANGE_NEEDED_ERR = "no change needed";
    private static final String HG_NO_ROLLBACK_ERR = "no rollback information available";
    private static final String HG_NO_UPDATES_ERR = "0 files updated, 0 files merged, 0 files removed, 0 files unresolved";
    private static final String HG_NO_VIEW_ERR = "hg: unknown command 'view'";
    private static final String HG_HGK_NOT_FOUND_ERR = "sh: hgk: not found";
    private static final String HG_NO_SUCH_FILE_ERR = "No such file";
    private static final String HG_NO_REV_STRIP_ERR = "abort: unknown revision";
    private static final String HG_LOCAL_CHANGES_STRIP_ERR = "abort: local changes found";
    private static final String HG_MULTIPLE_HEADS_STRIP_ERR = "no rollback information available";
    private static final char HG_STATUS_CODE_MODIFIED = 'm';
    private static final char HG_STATUS_CODE_ADDED = 'a';
    private static final char HG_STATUS_CODE_REMOVED = 'r';
    private static final char HG_STATUS_CODE_CLEAN = 'c';
    private static final char HG_STATUS_CODE_DELETED = 'A';
    private static final char HG_STATUS_CODE_NOTTRACKED = '_';
    private static final char HG_STATUS_CODE_IGNORED = 'i';
    private static final char HG_STATUS_CODE_CONFLICT = 'u';
    private static final char HG_STATUS_CODE_ABORT = '\u00c3';
    public static final String HG_STR_CONFLICT_EXT = ".conflict~";
    private static final String HG_EPOCH_PLUS_ONE_YEAR = "1971-01-01";
    private static final String HG_AUTHORIZATION_REQUIRED_ERR = "authorization required";
    private static final String HG_AUTHORIZATION_FAILED_ERR = "authorization failed";
    public static final String COMMIT_AFTER_MERGE = "commitAfterMerge";
    private static final String ENV_HGPLAIN = "HGPLAIN";
    private static final String ENV_HGENCODING = "HGENCODING";
    public static final String ENCODING = HgCommand.getEncoding();
    private static final String HG_LOG_FULL_CHANGESET_NAME = "log-full-changeset.tmpl";
    private static final String HG_LOG_ONLY_FILES_CHANGESET_NAME = "log-only-files-changeset.tmpl";
    private static final String HG_LOG_CHANGESET_GENERAL_NAME = "changeset.tmpl";
    private static final String HG_LOG_STYLE_NAME = "log.style";
    private static final String HG_ARGUMENT_STYLE = "--style=";
    private static final int WINDOWS_MAX_COMMANDLINE_SIZE = 8000;
    private static final int MAC_MAX_COMMANDLINE_SIZE = 64000;
    private static final int UNIX_MAX_COMMANDLINE_SIZE = 128000;
    private static final int MAX_COMMANDLINE_SIZE;
    private static final HashSet<String> GUARDED_COMMANDS;
    private static final HashSet<String> REPOSITORY_NOMODIFICATION_COMMANDS;
    private static final String HG_FLAG_TOPO = "--topo";
    private static Boolean topoAvailable;

    public static List<String> doMerge(File repository, String revStr) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_MERGE_CMD);
        command.add("-f");
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (HgModuleConfig.getDefault().isInternalMergeToolEnabled()) {
            command.add(HG_CONFIG_OPTION_CMD);
            command.add(HG_MERGE_SIMPLE_TOOL);
        }
        if (revStr != null) {
            command.add(revStr);
        }
        env.add(HG_MERGE_ENV);
        List<String> list = HgCommand.execEnv(command, env);
        return list;
    }

    public static List<String> doUpdateAll(File repository, boolean bForce, String revision, boolean bThrowException) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_UPDATE_ALL_CMD);
        command.add(HG_VERBOSE_CMD);
        if (bForce) {
            command.add(HG_UPDATE_FORCE_ALL_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(revision);
        }
        List<String> list = HgCommand.exec(command);
        if (bThrowException && !list.isEmpty()) {
            if (HgCommand.isErrorUpdateSpansBranches(list.get(0))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_UPDATE_MERGE_TEXT"));
            }
            if (HgCommand.isMergeAbortUncommittedMsg(list.get(0))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_UPDATE_COMMIT_TEXT"));
            }
        }
        return list;
    }

    public static List<String> doUpdateAll(File repository, boolean bForce, String revision) throws HgException {
        return HgCommand.doUpdateAll(repository, bForce, revision, true);
    }

    public static List<String> doRollback(File repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ROLLBACK_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ROLLBACK_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doBackout(File repository, String revision, boolean doMerge, String commitMsg, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> env = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BACKOUT_CMD);
        if (doMerge) {
            command.add(HG_BACKOUT_MERGE_CMD);
            env.add(HG_MERGE_ENV);
        }
        if (commitMsg != null && !commitMsg.equals("")) {
            command.add(HG_BACKOUT_COMMIT_MSG_CMD);
            command.add(commitMsg);
        } else {
            command.add(HG_BACKOUT_COMMIT_MSG_CMD);
            command.add(NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_MERGE_COMMIT_MSG", (Object)revision));
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(HG_REV_CMD);
            command.add(revision);
        }
        if ((list = doMerge ? HgCommand.execEnv(command, env) : HgCommand.exec(command)).isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_BACKOUT_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doStrip(File repository, String revision, boolean doForceMultiHead, boolean doBackup, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CONFIG_OPTION_CMD);
        command.add(HG_STRIP_EXT_CMD);
        command.add(HG_STRIP_CMD);
        if (doForceMultiHead) {
            command.add("-f");
        }
        if (!doBackup) {
            command.add(HG_STRIP_NOBACKUP_CMD);
        }
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(revision);
        }
        if ((list = HgCommand.exec(command)).isEmpty() && doBackup) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_STRIP_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doVerify(File repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERIFY_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_VERIFY_FAILED"), logger);
        }
        return list;
    }

    public static String getHgVersion() {
        List<String> list;
        try {
            list = HgCommand.execForVersionCheck();
        }
        catch (HgException ex) {
            return null;
        }
        if (!list.isEmpty()) {
            int start = list.get(0).indexOf(40);
            int end = list.get(0).indexOf(41);
            if (start != -1 && end != -1) {
                return list.get(0).substring(start + 9, end);
            }
        }
        return null;
    }

    public static List<String> doPull(File repository, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_PULL_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_UPDATE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        String defaultPull = new HgConfigFiles(repository).getDefaultPull(false);
        String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull, true, logger);
        if (proxy != null) {
            ArrayList<String> env = new ArrayList<String>();
            env.add(HG_PROXY_ENV + proxy);
            list = HgCommand.execEnv(command, env);
        } else {
            list = HgCommand.exec(command);
        }
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return list;
    }

    public static List<String> doPull(File repository, HgURL from, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || from == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_PULL_CMD;
        command.logger = logger;
        command.remoteUrl = from;
        command.repository = repository;
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.additionalOptions.add(HG_UPDATE_CMD);
        command.urlPathProperties = new String[]{"default", "default-pull"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<String> doUnbundle(File repository, File bundle, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERBOSE_CMD);
        command.add(HG_UNBUNDLE_CMD);
        command.add(HG_UPDATE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (bundle != null) {
            command.add(bundle.getAbsolutePath());
        }
        if (!(list = HgCommand.exec(command)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return list;
    }

    public static List<String> doIncoming(File repository, OutputLogger logger) throws HgException {
        List<String> cmdOutput;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_INCOMING_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        String defaultPull = new HgConfigFiles(repository).getDefaultPull(false);
        String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull, false, null);
        if (proxy != null) {
            ArrayList<String> env = new ArrayList<String>();
            env.add(HG_PROXY_ENV + proxy);
            cmdOutput = HgCommand.execEnv(command, env);
        } else {
            cmdOutput = HgCommand.exec(command);
        }
        if (!cmdOutput.isEmpty() && HgCommand.isErrorAbort(cmdOutput.get(cmdOutput.size() - 1))) {
            HgCommand.handleError(command, cmdOutput, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
        }
        return cmdOutput;
    }

    public static List<String> doIncoming(File repository, HgURL from, File bundle, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || from == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_INCOMING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = from;
        command.repository = repository;
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.showSaveOption = showSaveCredentialsOption;
        if (bundle != null) {
            command.additionalOptions.add(HG_OPT_BUNDLE);
            command.additionalOptions.add(bundle.getAbsolutePath());
        }
        command.urlPathProperties = new String[]{"default", "default-pull"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<String> doOutgoing(File repository, HgURL toUrl, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || toUrl == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPush(false);
        command.hgCommandType = HG_OUTGOING_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = toUrl;
        command.repository = repository;
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.additionalOptions.add(HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
        command.showSaveOption = showSaveCredentialsOption;
        command.urlPathProperties = new String[]{"default-push"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<String> doPush(File repository, HgURL toUrl, OutputLogger logger, boolean showSaveCredentialsOption) throws HgException {
        if (repository == null || toUrl == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.acquireCredentialsFirst = true;
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPush(false);
        command.hgCommandType = HG_PUSH_CMD;
        command.logger = logger;
        command.remoteUrl = toUrl;
        command.repository = repository;
        command.urlPathProperties = new String[]{"default-push"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<String> doView(File repository, OutputLogger logger) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        ArrayList<String> env = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VIEW_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (HgUtils.isSolaris()) {
            env.add(HG_HGK_PATH_SOLARIS10_ENV);
            list = HgCommand.execEnv(command, env);
        } else {
            list = HgCommand.exec(command);
        }
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoView(list.get(list.size() - 1))) {
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_NO_VIEW_TEXT"));
            }
            if (HgCommand.isErrorHgkNotFound(list.get(0)) || HgCommand.isErrorNoSuchFile(list.get(0))) {
                OutputLogger.getLogger(repository.getAbsolutePath()).outputInRed(list.toString());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_WARN_HGK_NOT_FOUND_TEXT"));
            }
            if (HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        return list;
    }

    private static String getGlobalProxyIfNeeded(String defaultPath, boolean bOutputDetails, OutputLogger logger) {
        String proxy = null;
        if (defaultPath != null && (defaultPath.startsWith("http:") || defaultPath.startsWith("https:"))) {
            URI uri = null;
            try {
                uri = new URI(defaultPath);
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            String proxyHost = NetworkSettings.getProxyHost((URI)uri);
            if (proxyHost != null && proxyHost.length() > 0) {
                proxy = proxyHost;
                String proxyPort = NetworkSettings.getProxyPort((URI)uri);
                assert (proxyPort != null);
                proxy = proxy + (!proxyPort.equals("") ? ":" + proxyPort : "");
            }
        }
        if (proxy != null && bOutputDetails) {
            logger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_USING_PROXY_INFO", proxy));
        }
        return proxy;
    }

    public static List<String> doFetch(File repository, HgURL from, OutputLogger logger) throws HgException {
        if (repository == null || from == null) {
            return null;
        }
        InterRepositoryCommand command = new InterRepositoryCommand();
        command.defaultUrl = new HgConfigFiles(repository).getDefaultPull(false);
        command.hgCommandType = HG_FETCH_CMD;
        command.logger = logger;
        command.outputDetails = false;
        command.remoteUrl = from;
        command.repository = repository;
        command.additionalOptions.add(HG_VERBOSE_CMD);
        command.additionalOptions.add(HG_CONFIG_OPTION_CMD);
        command.additionalOptions.add(HG_FETCH_EXT_CMD);
        if (HgModuleConfig.getDefault().isInternalMergeToolEnabled()) {
            command.additionalOptions.add(HG_CONFIG_OPTION_CMD);
            command.additionalOptions.add(HG_MERGE_SIMPLE_TOOL);
        }
        command.showSaveOption = true;
        command.urlPathProperties = new String[]{"default", "default-pull"};
        List<String> retval = command.invoke();
        return retval;
    }

    public static List<HgLogMessage> processLogMessages(File root, List<File> files, List<String> list, List<HgLogMessage> messages) {
        return HgCommand.processLogMessages(root, files, list, messages, false);
    }

    public static List<HgLogMessage> processLogMessages(File root, List<File> files, List<String> list, List<HgLogMessage> messages, boolean revertOrder) {
        ArrayList<String> filesShortPaths = new ArrayList<String>();
        String rootPath = root.getAbsolutePath();
        if (list != null && !list.isEmpty()) {
            if (files != null) {
                for (File f : files) {
                    String shortPath = f.getAbsolutePath();
                    if (!shortPath.startsWith(rootPath) || shortPath.length() <= rootPath.length()) continue;
                    if (Utilities.isWindows()) {
                        filesShortPaths.add(shortPath.substring(rootPath.length() + 1).replace(File.separatorChar, '/'));
                        continue;
                    }
                    filesShortPaths.add(shortPath.substring(rootPath.length() + 1));
                }
            }
            String fc = null;
            String fd = null;
            String fa = null;
            String fm = null;
            String parents = null;
            String id = null;
            String date = null;
            String desc = null;
            String username = null;
            String author = null;
            String rev = null;
            boolean bEnd = false;
            boolean stillInMessage = false;
            for (String s : list) {
                if (s.indexOf(HG_LOG_REVISION_OUT) == 0) {
                    rev = s.substring(HG_LOG_REVISION_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_AUTHOR_OUT) == 0) {
                    author = s.substring(HG_LOG_AUTHOR_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_USER_OUT) == 0) {
                    username = s.substring(HG_LOG_USER_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_DESCRIPTION_OUT) == 0) {
                    desc = s.substring(HG_LOG_DESCRIPTION_OUT.length()).trim();
                    stillInMessage = true;
                } else if (s.indexOf(HG_LOG_DATE_OUT) == 0) {
                    date = s.substring(HG_LOG_DATE_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_ID_OUT) == 0) {
                    id = s.substring(HG_LOG_ID_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_PARENTS_OUT) == 0) {
                    parents = s.substring(HG_LOG_PARENTS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEMODS_OUT) == 0) {
                    fm = s.substring(HG_LOG_FILEMODS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEADDS_OUT) == 0) {
                    fa = s.substring(HG_LOG_FILEADDS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILEDELS_OUT) == 0) {
                    fd = s.substring(HG_LOG_FILEDELS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_FILECOPIESS_OUT) == 0) {
                    fc = s.substring(HG_LOG_FILECOPIESS_OUT.length()).trim();
                    stillInMessage = false;
                } else if (s.indexOf(HG_LOG_ENDCS_OUT) == 0) {
                    stillInMessage = false;
                    bEnd = true;
                } else if (stillInMessage) {
                    desc = desc + "\n" + s;
                }
                if (!(rev != null & bEnd)) continue;
                HgLogMessage hgMsg = new HgLogMessage(rootPath, filesShortPaths, rev, author, username, desc, date, id, parents, fm, fa, fd, fc);
                if (revertOrder) {
                    messages.add(0, hgMsg);
                } else {
                    messages.add(hgMsg);
                }
                fc = null;
                fd = null;
                fa = null;
                fm = null;
                parents = null;
                id = null;
                date = null;
                desc = null;
                author = null;
                rev = null;
                bEnd = false;
            }
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getIncomingMessages(File root, String toRevision, boolean bShowMerges, OutputLogger logger) {
        ArrayList<HgLogMessage> messages = new ArrayList<HgLogMessage>(0);
        try {
            List<String> list = HgCommand.doIncomingForSearch(root, toRevision, bShowMerges, logger);
            HgCommand.processLogMessages(root, null, list, messages, true);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.closeLog();
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getOutMessages(File root, String toRevision, boolean bShowMerges, OutputLogger logger) {
        ArrayList<HgLogMessage> messages = new ArrayList<HgLogMessage>(0);
        try {
            List<String> list = HgCommand.doOutForSearch(root, toRevision, bShowMerges, logger);
            HgCommand.processLogMessages(root, null, list, messages, true);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.closeLog();
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(File root, Set<File> files, String fromRevision, String toRevision, boolean bShowMerges, int limitRevisions, OutputLogger logger) {
        return HgCommand.getLogMessages(root, files, fromRevision, toRevision, bShowMerges, false, limitRevisions, logger, true);
    }

    public static HgLogMessage[] getLogMessagesNoFileInfo(File root, Set<File> files, int limit, OutputLogger logger) {
        return HgCommand.getLogMessages(root, files, "0", "tip", true, false, limit, logger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HgLogMessage[] getLogMessages(File root, Set<File> files, String fromRevision, String toRevision, boolean bShowMerges, boolean bGetFileInfo, int limit, OutputLogger logger, boolean ascOrder) {
        ArrayList<HgLogMessage> messages = new ArrayList<HgLogMessage>(0);
        try {
            String headRev = HgCommand.getLastRevision(root, null);
            if (headRev == null) {
                HgLogMessage[] hgLogMessageArray = messages.toArray(new HgLogMessage[0]);
                return hgLogMessageArray;
            }
            LinkedList<String> list = new LinkedList();
            ArrayList<File> filesList = files != null ? new ArrayList<File>(files) : null;
            list = HgCommand.doLog(root, filesList, fromRevision, toRevision, headRev, bShowMerges, bGetFileInfo, limit, logger);
            HgCommand.processLogMessages(root, filesList, list, messages, ascOrder);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            logger.closeLog();
        }
        return messages.toArray(new HgLogMessage[0]);
    }

    public static Boolean hasHistory(File repository) {
        if (repository == null) {
            return false;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_LOG_LIMIT_ONE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        try {
            List<String> list = HgCommand.exec(command);
            if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(0))) {
                return false;
            }
            return !list.isEmpty();
        }
        catch (HgException e) {
            return false;
        }
    }

    private static File getPreviousName(File repository, File file, String revision) throws HgException {
        if (repository == null) {
            return null;
        }
        if (revision == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_OPT_FOLLOW);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_FLAG_REV_CMD);
        command.add(revision);
        List<String> list = null;
        File tempFolder = Utils.getTempFolder((boolean)false);
        try {
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_ONLY_FILES_CHANGESET_NAME));
            command.add(file.getAbsolutePath());
            list = HgCommand.exec(command);
            if (list.isEmpty() || HgCommand.isErrorAbort(list.get(0))) {
                File file2 = null;
                return file2;
            }
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", HgUtils.replaceHttpPassword(command));
            Mercurial.LOG.log(e instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, e);
            throw new HgException(e.getMessage());
        }
        finally {
            Utils.deleteRecursively((File)tempFolder);
        }
        String[] fileNames = list.get(0).split("\t");
        for (int j = fileNames.length - 1; j > 0; --j) {
            File name = new File(repository, fileNames[j]);
            if (!name.equals(file)) continue;
            return new File(repository, fileNames[j - 1]);
        }
        return null;
    }

    private static List<String> doLog(File repository, List<File> files, String from, String to, String headRev, boolean bShowMerges, boolean bGetFileInfo, int limit, OutputLogger logger) throws HgException {
        String dateStr;
        if (repository == null) {
            return null;
        }
        if (files != null && files.isEmpty()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_VERBOSE_CMD);
        if (limit >= 0) {
            command.add(HG_LOG_LIMIT_CMD);
            command.add(Integer.toString(limit));
        }
        boolean doFollow = false;
        if (files != null) {
            doFollow = true;
            for (File f : files) {
                if (!f.isDirectory()) continue;
                doFollow = false;
                break;
            }
        }
        if (doFollow) {
            command.add(HG_OPT_FOLLOW);
        }
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (bGetFileInfo) {
            command.add(HG_LOG_DEBUG_CMD);
        }
        if ((dateStr = HgCommand.handleRevDates(from, to)) != null) {
            command.add(HG_FLAG_DATE_CMD);
            command.add(dateStr);
        }
        String revStr = HgCommand.handleRevNumbers(from, to, headRev);
        if (dateStr == null && revStr != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revStr);
        }
        if (revStr == null) {
            return Collections.emptyList();
        }
        File tempFolder = Utils.getTempFolder((boolean)false);
        try {
            List<String> list;
            if (bGetFileInfo) {
                command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_FULL_CHANGESET_NAME));
            } else {
                command.add(HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
            }
            if (files != null) {
                for (File f : files) {
                    command.add(f.getAbsolutePath());
                }
            }
            if (!(list = HgCommand.exec(command)).isEmpty()) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            Utils.deleteRecursively((File)tempFolder);
        }
    }

    public static HgLogMessage doTip(File repository, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add("tip");
        command.add(HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        List<HgLogMessage> messages = new ArrayList<HgLogMessage>(1);
        messages = HgCommand.processLogMessages(repository, null, list, messages, false);
        return messages.get(0);
    }

    public static List<String> doOutForSearch(File repository, String to, boolean bShowMerges, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_OUT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        command.add(HG_LOG_DEBUG_CMD);
        String revStr = HgCommand.handleIncomingRevNumber(to);
        if (revStr != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revStr);
        }
        File tempFolder = Utils.getTempFolder((boolean)false);
        try {
            List<String> list;
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_FULL_CHANGESET_NAME));
            String defaultPush = new HgConfigFiles(repository).getDefaultPush(false);
            String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPush, false, null);
            if (proxy != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.add(HG_PROXY_ENV + proxy);
                list = HgCommand.execEnv(command, env);
            } else {
                list = HgCommand.exec(command);
            }
            if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPush(list.get(0))) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            Utils.deleteRecursively((File)tempFolder);
        }
    }

    public static List<String> doIncomingForSearch(File repository, String to, boolean bShowMerges, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_INCOMING_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_NEWEST_FIRST);
        if (!bShowMerges) {
            command.add(HG_LOG_NO_MERGES_CMD);
        }
        command.add(HG_LOG_DEBUG_CMD);
        String revStr = HgCommand.handleIncomingRevNumber(to);
        if (revStr != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revStr);
        }
        File tempFolder = Utils.getTempFolder((boolean)false);
        try {
            List<String> list;
            command.add(HgCommand.prepareLogTemplate(tempFolder, HG_LOG_FULL_CHANGESET_NAME));
            String defaultPull = new HgConfigFiles(repository).getDefaultPull(false);
            String proxy = HgCommand.getGlobalProxyIfNeeded(defaultPull, false, null);
            if (proxy != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.add(HG_PROXY_ENV + proxy);
                list = HgCommand.execEnv(command, env);
            } else {
                list = HgCommand.exec(command);
            }
            if (!list.isEmpty() && !HgCommand.isErrorNoDefaultPath(list.get(0))) {
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                } else if (HgCommand.isErrorAbort(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                }
            }
            List<String> list2 = list;
            return list2;
        }
        catch (IOException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
            throw new HgException(ex.getMessage());
        }
        finally {
            Utils.deleteRecursively((File)tempFolder);
        }
    }

    private static String handleRevDates(String from, String to) {
        Date fromDate = null;
        Date toDate = null;
        Date currentDate = new Date();
        Date epochPlusOneDate = null;
        try {
            epochPlusOneDate = new SimpleDateFormat("yyyy-MM-dd").parse(HG_EPOCH_PLUS_ONE_YEAR);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            if (from != null) {
                fromDate = new SimpleDateFormat("yyyy-MM-dd").parse(from);
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        try {
            if (to != null) {
                toDate = new SimpleDateFormat("yyyy-MM-dd").parse(to);
            }
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (fromDate != null && toDate == null && to == null) {
            toDate = currentDate;
            to = new SimpleDateFormat("yyyy-MM-dd").format(toDate);
        }
        if (fromDate == null && from == null && toDate != null) {
            fromDate = epochPlusOneDate;
            from = HG_EPOCH_PLUS_ONE_YEAR;
        }
        if (fromDate != null && toDate == null && to != null || fromDate == null && from != null && toDate != null) {
            HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_BOTHDATES_NEEDED_TEXT");
            return null;
        }
        if (fromDate != null && toDate != null) {
            if (epochPlusOneDate != null && fromDate.before(epochPlusOneDate)) {
                fromDate = epochPlusOneDate;
                from = HG_EPOCH_PLUS_ONE_YEAR;
            }
            if (currentDate != null && toDate.after(currentDate)) {
                toDate = currentDate;
                to = new SimpleDateFormat("yyyy-MM-dd").format(toDate);
            }
            if (fromDate.after(toDate)) {
                HgUtils.warningDialog(HgCommand.class, "MSG_SEARCH_HISTORY_TITLE", "MSG_SEARCH_HISTORY_WARN_FROM_BEFORE_TODATE_NEEDED_TEXT");
                return null;
            }
            return from + " to " + to;
        }
        return null;
    }

    private static String handleIncomingRevNumber(String to) {
        int toInt = -1;
        if (to != null && (to.equalsIgnoreCase("tip") || to.equalsIgnoreCase(HG_HEAD_STR))) {
            to = "tip";
        }
        try {
            toInt = Integer.parseInt(to);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toInt > -1 ? to : "tip";
    }

    private static String handleRevNumbers(String from, String to, String headRev) {
        int fromInt = -1;
        int toInt = -1;
        int headRevInt = -1;
        if (from != null && (from.equalsIgnoreCase("tip") || from.equalsIgnoreCase(HG_HEAD_STR))) {
            from = headRev;
        }
        if (to != null && (to.equalsIgnoreCase("tip") || to.equalsIgnoreCase(HG_HEAD_STR))) {
            to = headRev;
        }
        try {
            fromInt = Integer.parseInt(from);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            toInt = Integer.parseInt(to);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            headRevInt = Integer.parseInt(headRev);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (headRevInt > -1 && toInt > headRevInt) {
            to = headRev;
            toInt = headRevInt;
        }
        if (headRevInt > -1 && fromInt > headRevInt) {
            return null;
        }
        String revStr = null;
        if (fromInt > -1 && toInt > -1) {
            revStr = to + ":" + from;
        } else if (fromInt > -1) {
            revStr = (headRevInt != -1 ? headRevInt + ":" : "tip:") + from;
        } else if (toInt > -1) {
            revStr = to + ":0";
        }
        if (revStr == null) {
            if (to == null) {
                to = "tip";
            }
            if (from == null) {
                from = "0";
            }
            revStr = to + ":" + from;
        }
        return revStr;
    }

    public static void doCat(File repository, File file, File outFile, OutputLogger logger) throws HgException {
        HgCommand.doCat(repository, file, outFile, null, false, logger);
    }

    public static void doCat(File repository, File file, File outFile, String revision, OutputLogger logger) throws HgException {
        HgCommand.doCat(repository, file, outFile, revision, true, logger);
    }

    public static void doCat(File repository, File file, File outFile, String revision, boolean retry, OutputLogger logger) throws HgException {
        String newRevision;
        File prevFile;
        if (repository == null) {
            return;
        }
        if (file == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CAT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_FLAG_OUTPUT_CMD);
        command.add(outFile.getAbsolutePath());
        if (revision != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revision);
        }
        try {
            command.add(file.getCanonicalPath());
        }
        catch (IOException e) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", HgUtils.replaceHttpPassword(command));
            Mercurial.LOG.log(Level.INFO, null, e);
            throw new HgException(e.getMessage());
        }
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        if (outFile.length() == 0L && retry && (prevFile = HgCommand.getPreviousName(repository, file, newRevision = Integer.toString(Integer.parseInt(revision) + 1))) != null) {
            HgCommand.doCat(repository, prevFile, outFile, revision, false, logger);
        }
    }

    public static HgLogMessage.HgRevision getCommonAncestor(String rootURL, String rev1, String rev2, OutputLogger logger) throws HgException {
        HgLogMessage.HgRevision res = HgCommand.getCommonAncestor(rootURL, rev1, rev2, false, logger);
        if (res == null) {
            res = HgCommand.getCommonAncestor(rootURL, rev1, rev2, true, logger);
        }
        return res;
    }

    private static HgLogMessage.HgRevision getCommonAncestor(String rootURL, String rev1, String rev2, boolean bUseIndex, OutputLogger logger) throws HgException {
        if (rootURL == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COMMONANCESTOR_CMD);
        if (bUseIndex) {
            command.add(".hg/store/00changelog.i");
        }
        command.add(rev1);
        command.add(rev2);
        command.add(HG_OPT_REPOSITORY);
        command.add(rootURL);
        command.add(HG_OPT_CWD_CMD);
        command.add(rootURL);
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            String[] splits = list.get(0).split(":");
            String tmp = splits != null && splits.length >= 1 ? splits[0] : null;
            String tmpId = splits != null && splits.length >= 2 ? splits[1] : null;
            int tmpRev = -1;
            try {
                tmpRev = Integer.parseInt(tmp);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            return tmpRev > -1 ? new HgLogMessage.HgRevision(tmpId, tmp) : null;
        }
        return null;
    }

    public static void doCreate(File root, OutputLogger logger) throws HgException {
        if (root == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CREATE_CMD);
        command.add(root.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_CREATE_FAILED"), logger);
        }
    }

    public static List<String> doClone(File repository, File target, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        return HgCommand.doClone(new HgURL(repository), target, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> doClone(HgURL repository, File target, OutputLogger logger) throws HgException {
        if (repository == null || target == null) {
            return null;
        }
        File parentTarget = target.getParentFile();
        try {
            if (!parentTarget.mkdirs() && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getAbsolutePath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        List<String> list = null;
        boolean retry = true;
        PasswordAuthentication credentials = null;
        HgKenaiAccessor supp = HgKenaiAccessor.getInstance();
        String rawUrl = repository.toUrlStringWithoutUserInfo();
        if (supp.isKenai(rawUrl) && supp.isLoggedIntoKenai(rawUrl)) {
            credentials = supp.getPasswordAuthentication(rawUrl, false);
        }
        HgURL url = repository;
        while (retry) {
            block18: {
                retry = false;
                try {
                    if (credentials == null) break block18;
                    url = new HgURL(repository.toHgCommandUrlString(), credentials.getUserName(), credentials.getPassword());
                }
                catch (URISyntaxException ex) {
                    Mercurial.LOG.log(Level.SEVERE, null, ex);
                    break;
                }
            }
            ArrayList<Object> command = new ArrayList<Object>();
            command.add(HgCommand.getHgCommand());
            command.add(HG_CLONE_CMD);
            command.add(HG_VERBOSE_CMD);
            command.add(url);
            command.add(target);
            list = HgCommand.exec(command);
            try {
                if (list.isEmpty()) continue;
                if (HgCommand.isErrorNoRepository(list.get(0))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                    continue;
                }
                if (HgCommand.isErrorNoResponse(list.get(list.size() - 1))) {
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_RESPONSE_ERR"), logger);
                    continue;
                }
                if (HgCommand.isErrorAbort(list.get(list.size() - 1))) {
                    if ((credentials = HgCommand.handleAuthenticationError(list, target, rawUrl, credentials == null ? "" : credentials.getUserName(), new UserCredentialsSupport(), HG_CLONE_CMD)) != null) {
                        retry = true;
                        continue;
                    }
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
                    continue;
                }
                if (url.getPassword() == null || supp.isKenai(rawUrl)) continue;
                try {
                    HgModuleConfig.getDefault().setProperty(target, "default-pull", new HgURL(url.toUrlStringWithoutUserInfo(), url.getUsername(), null).toCompleteUrlString());
                }
                catch (URISyntaxException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
                catch (IOException ex) {
                    Mercurial.LOG.log(Level.INFO, null, ex);
                }
                KeyringSupport.save((String)HgUtils.PREFIX_VERSIONING_MERCURIAL_URL, (String)url.toHgCommandStringWithNoPassword(), (char[])((char[])url.getPassword().clone()), null);
            }
            finally {
                if (url == repository) continue;
                url.clearPassword();
            }
        }
        return list;
    }

    public static void doCommit(File repository, List<File> commitFiles, String commitMessage, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COMMIT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        String projectUserName = new HgConfigFiles(repository).getUserName(false);
        String globalUsername = HgModuleConfig.getDefault().getSysUserName();
        String username = null;
        if (projectUserName != null && projectUserName.length() > 0) {
            username = projectUserName;
        } else if (globalUsername != null && globalUsername.length() > 0) {
            username = globalUsername;
        }
        if (username != null) {
            command.add("--user");
            command.add(username);
        }
        File tempfile = null;
        try {
            List<String> list;
            if (commitMessage == null || commitMessage.length() == 0) {
                commitMessage = HG_COMMIT_DEFAULT_MESSAGE;
            }
            tempfile = File.createTempFile(HG_COMMIT_TEMPNAME, HG_COMMIT_TEMPNAME_SUFFIX);
            BufferedWriter out = new BufferedWriter(ENCODING == null ? new OutputStreamWriter(new FileOutputStream(tempfile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(tempfile), ENCODING));
            out.write(commitMessage);
            out.close();
            command.add(HG_COMMIT_OPT_LOGFILE_CMD);
            command.add(tempfile.getAbsolutePath());
            for (File f : commitFiles) {
                if (f.getAbsolutePath().length() <= repository.getAbsolutePath().length()) {
                    command.add(f.getAbsolutePath());
                    continue;
                }
                command.add(f.getAbsolutePath().substring(repository.getAbsolutePath().length() + 1));
            }
            if (Utilities.isWindows()) {
                int size = 0;
                for (String line : command) {
                    size += line.length();
                }
                if (HgCommand.isTooLongCommand(size)) {
                    throw new HgException.HgTooLongArgListException(NbBundle.getMessage(HgCommand.class, (String)"MSG_ARG_LIST_TOO_LONG_ERR", command.get(1), (Object)(command.size() - 2)));
                }
            }
            if (!(list = HgCommand.exec(command)).isEmpty() && HgCommand.isCommitAfterMerge(list.get(list.size() - 1))) {
                throw new HgException(COMMIT_AFTER_MERGE);
            }
            if (!list.isEmpty() && (HgCommand.isErrorNotTracked(list.get(0)) || HgCommand.isErrorCannotReadCommitMsg(list.get(0)) || HgCommand.isErrorAbort(list.get(list.size() - 1)) || HgCommand.isErrorAbort(list.get(0)))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMIT_FAILED"), logger);
            }
        }
        catch (IOException ex) {
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_FAILED_TO_READ_COMMIT_MESSAGE"));
        }
        finally {
            if (commitMessage != null && tempfile != null) {
                tempfile.delete();
            }
        }
    }

    public static void doRename(File repository, File sourceFile, File destFile, OutputLogger logger) throws HgException {
        HgCommand.doRename(repository, sourceFile, destFile, false, logger);
    }

    private static void doRename(File repository, File sourceFile, File destFile, boolean bAfter, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RENAME_CMD);
        if (bAfter) {
            command.add("-A");
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        command.add(sourceFile.getAbsolutePath().substring(repository.getAbsolutePath().length() + 1));
        command.add(destFile.getAbsolutePath().substring(repository.getAbsolutePath().length() + 1));
        List<String> list = HgCommand.exec(command);
        if (!(list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || bAfter && HgCommand.isErrorAbortNoFilesToCopy(list.get(list.size() - 1)))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_RENAME_FAILED"), logger);
        }
    }

    public static void doRenameAfter(File repository, File sourceFile, File destFile, OutputLogger logger) throws HgException {
        HgCommand.doRename(repository, sourceFile, destFile, true, logger);
    }

    public static void doCopy(File repository, File sourceFile, File destFile, boolean bAfter, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_COPY_CMD);
        if (bAfter) {
            command.add("-A");
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        command.add(sourceFile.getAbsolutePath().substring(repository.getAbsolutePath().length() + 1));
        command.add(destFile.getAbsolutePath().substring(repository.getAbsolutePath().length() + 1));
        List<String> list = HgCommand.exec(command);
        if (!(list.isEmpty() || !HgCommand.isErrorAbort(list.get(list.size() - 1)) || bAfter && HgCommand.isErrorAbortNoFilesToCopy(list.get(list.size() - 1)))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COPY_FAILED"), logger);
        }
    }

    public static void doAdd(File repository, List<File> addFiles, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (addFiles.isEmpty()) {
            return;
        }
        ArrayList<String> basicCommand = new ArrayList<String>();
        basicCommand.add(HgCommand.getHgCommand());
        basicCommand.add(HG_ADD_CMD);
        basicCommand.add(HG_OPT_REPOSITORY);
        basicCommand.add(repository.getAbsolutePath());
        List<List<String>> attributeGroups = HgCommand.splitAttributes(basicCommand, addFiles, false);
        for (List<String> attributes : attributeGroups) {
            LinkedList<String> command = new LinkedList<String>(basicCommand);
            command.addAll(attributes);
            List<String> list = HgCommand.exec(command);
            if (list.isEmpty() || HgCommand.isErrorAlreadyTracked(list.get(0)) || HgCommand.isAddingLine(list.get(0)) || !HgCommand.getFilesWithPerformanceWarning(list).isEmpty()) continue;
            HgCommand.handleError(command, list, list.get(0), logger);
        }
    }

    public static void doRevert(File repository, List<File> revertFiles, String revision, boolean doBackup, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (revertFiles.isEmpty()) {
            return;
        }
        final ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_REVERT_CMD);
        if (!doBackup) {
            command.add(HG_REVERT_NOBACKUP_CMD);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revision);
        }
        for (File f : revertFiles) {
            command.add(f.getAbsolutePath());
        }
        Callable<List<String>> callable = new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return HgCommand.exec(command);
            }
        };
        List<String> list = HgCommand.runWithoutIndexing(callable, revertFiles, HG_REVERT_CMD);
        if (!list.isEmpty() && HgCommand.isErrorNoChangeNeeded(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_REVERT_FAILED"), logger);
        }
    }

    public static void doAdd(File repository, File file, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ADD_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), logger);
        }
    }

    public static List<String> doAnnotate(File repository, File file, String revision, OutputLogger logger) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ANNOTATE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revision);
        }
        command.add(HG_ANNOTATE_FLAGN_CMD);
        command.add("--user");
        command.add(HG_OPT_FOLLOW);
        command.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorNoSuchFile(list.get(0))) {
                String rev;
                list = revision == null ? ((rev = HgCommand.getLastRevision(repository, file)) != null ? HgCommand.doAnnotate(repository, file, rev, logger) : null) : null;
            }
        }
        return list;
    }

    public static List<String> doAnnotate(File repository, File file, OutputLogger logger) throws HgException {
        return HgCommand.doAnnotate(repository, file, null, logger);
    }

    public static String getBranchInfo(File repository) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add("tip");
        command.add(HG_BRANCH_INFO_TEMPLATE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<String> getHeadRevisions(File repository) throws HgException {
        return HgCommand.getHeadInfo(repository, "--template={rev}\\n");
    }

    public static List<String> getHeadRevisions(String repository) throws HgException {
        return HgCommand.getHeadInfo(repository, "--template={rev}\\n");
    }

    public static HgLogMessage[] getHeadRevisionsInfo(File repository, OutputLogger logger) throws HgException {
        List<String> list = HgCommand.getHeadInfo(repository, HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(null, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
        List<HgLogMessage> messages = new ArrayList<HgLogMessage>(5);
        messages = HgCommand.processLogMessages(repository, null, list, messages, false);
        return messages.toArray(new HgLogMessage[messages.size()]);
    }

    public static String getCurrentHeadChangeset(File repository, OutputLogger logger) {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_ID_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add("-i");
        try {
            list = HgCommand.exec(command);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(ex instanceof HgException.HgCommandCanceledException ? Level.FINE : Level.INFO, null, ex);
            list = Collections.emptyList();
        }
        String id = "-1";
        if (!list.isEmpty() && (id = list.get(0).trim()).endsWith("+")) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    private static List<String> getHeadInfo(String repository, String template) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_HEADS_CMD);
        topoAvailable = Boolean.TRUE.equals(topoAvailable) || topoAvailable == null && HgUtils.hasTopoOption(Mercurial.getInstance().getVersion());
        if (topoAvailable.booleanValue()) {
            command.add(HG_FLAG_TOPO);
        }
        command.add(HG_OPT_REPOSITORY);
        command.add(repository);
        command.add(template);
        List<String> output = HgCommand.exec(command);
        if (topoAvailable.booleanValue() && output.contains("hg heads: option --topo not recognized")) {
            topoAvailable = false;
            return HgCommand.getHeadInfo(repository, template);
        }
        return output;
    }

    private static List<String> getHeadInfo(File repository, String template) throws HgException {
        if (repository == null) {
            return null;
        }
        return HgCommand.getHeadInfo(repository.getAbsolutePath(), template);
    }

    public static String getLastRevision(File repository, File file) throws HgException {
        return HgCommand.getLastChange(repository, file, "--template={rev}\\n");
    }

    private static String getLastChange(File repository, File file, String template) throws HgException {
        List<String> list;
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_LOG_LIMIT_ONE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(template);
        if (file != null) {
            command.add(file.getAbsolutePath());
        }
        if (!(list = HgCommand.exec(command)).isEmpty()) {
            return new StringBuffer(list.get(0)).toString();
        }
        return null;
    }

    public static HgLogMessage.HgRevision getParent(File repository, File file, String revision) throws HgException {
        if (repository == null) {
            return null;
        }
        HgLogMessage.HgRevision parentRevision = HgLogMessage.HgRevision.EMPTY;
        List<HgLogMessage> revisions = HgCommand.getParents(repository, file, revision);
        if (revisions.size() > 1) {
            String rev1 = revisions.get(0).getRevisionNumber();
            String rev2 = revisions.get(1).getRevisionNumber();
            parentRevision = HgCommand.getCommonAncestor(repository.getAbsolutePath(), rev1, rev2, OutputLogger.getLogger(null));
        } else if (revisions.size() == 1) {
            parentRevision = revisions.get(0).getHgRevision();
        }
        return parentRevision;
    }

    public static List<HgLogMessage> getParents(File repository, File file, String revision) throws HgException {
        if (repository == null) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_PARENT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        if (revision != null) {
            command.add(HG_FLAG_REV_CMD);
            command.add(revision);
        }
        command.add(HG_LOG_TEMPLATE_HISTORY_NO_FILEINFO_CMD);
        List<String> list = null;
        if (file != null) {
            command.add(file.getAbsolutePath());
        }
        if (!(list = HgCommand.exec(command)).isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), OutputLogger.getLogger(null));
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), OutputLogger.getLogger(null));
            }
        }
        return HgCommand.processLogMessages(repository, file == null ? Collections.emptyList() : Collections.singletonList(file), list, new LinkedList<HgLogMessage>());
    }

    public static Map<File, FileInformation> getStatus(File repository, List<File> files) throws HgException {
        return HgCommand.getStatusWithFlags(repository, files, HG_STATUS_FLAG_INTERESTING_CMD, true);
    }

    public static void doRemove(File repository, List<File> removeFiles, OutputLogger logger) throws HgException {
        if (repository == null) {
            return;
        }
        if (removeFiles.isEmpty()) {
            return;
        }
        ArrayList<String> basicCommand = new ArrayList<String>();
        basicCommand.add(HgCommand.getHgCommand());
        basicCommand.add(HG_REMOVE_CMD);
        basicCommand.add(HG_OPT_REPOSITORY);
        basicCommand.add(repository.getAbsolutePath());
        basicCommand.add(HG_REMOVE_FLAG_FORCE_CMD);
        List<List<String>> attributeGroups = HgCommand.splitAttributes(basicCommand, removeFiles, false);
        for (List<String> attributes : attributeGroups) {
            LinkedList<String> command = new LinkedList<String>(basicCommand);
            command.addAll(attributes);
            List<String> list = HgCommand.exec(command);
            if (list.isEmpty()) continue;
            HgCommand.handleError(command, list, list.get(0), logger);
        }
    }

    public static void doRemove(File repository, File f, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_REMOVE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_REMOVE_FLAG_FORCE_CMD);
        try {
            command.add(f.getCanonicalPath());
        }
        catch (IOException ioe) {
            Mercurial.LOG.log(Level.WARNING, null, ioe);
            command.add(f.getAbsolutePath());
        }
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty() && HgCommand.isErrorAlreadyTracked(list.get(0))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_ALREADY_TRACKED"), logger);
        }
    }

    public static List<String> doExport(File repository, String revStr, String outputFileName, OutputLogger logger) throws HgException {
        List<String> list;
        File fileTarget = new File(outputFileName);
        File parentTarget = fileTarget.getParentFile();
        try {
            if (!parentTarget.mkdir() && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getAbsolutePath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_EXPORT_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPTION_GIT);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_FLAG_OUTPUT_CMD);
        command.add(outputFileName);
        if (revStr != null) {
            command.add(revStr);
        }
        if (!(list = HgCommand.exec(command)).isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doBundle(File repository, String revBase, String revTo, File outputFile, OutputLogger logger) throws HgException {
        File parentTarget = outputFile.getParentFile();
        try {
            if (!parentTarget.mkdirs() && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdirs() failed for : {0}", parentTarget.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getAbsolutePath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_BUNDLE_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_BASE_CMD);
        command.add(revBase);
        if (revTo != null) {
            command.add(HG_REV_CMD);
            command.add(revTo);
        }
        command.add(outputFile.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_BUNDLE_FAILED"), logger);
        }
        return list;
    }

    public static List<String> doExportFileDiff(File repository, File file, String revStr, String outputFileName, OutputLogger logger) throws HgException {
        File fileTarget = new File(outputFileName);
        File parentTarget = fileTarget.getParentFile();
        try {
            if (!parentTarget.mkdir() && !parentTarget.isDirectory()) {
                Mercurial.LOG.log(Level.WARNING, "File.mkdir() failed for : {0}", parentTarget.getAbsolutePath());
                throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
            }
        }
        catch (SecurityException e) {
            Mercurial.LOG.log(Level.WARNING, "File.mkdir() for : {0} threw SecurityException {1}", new Object[]{parentTarget.getAbsolutePath(), e.getMessage()});
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_TO_CREATE_PARENT_DIR"));
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_LOG_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_REV_CMD);
        command.add(revStr);
        command.add(HG_LOG_TEMPLATE_EXPORT_FILE_CMD);
        command.add(HG_LOG_PATCH_CMD);
        command.add(HG_OPTION_GIT);
        command.add(file.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_EXPORT_FAILED"), logger);
        } else {
            HgCommand.writeOutputFileDiff(list, outputFileName);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputFileDiff(List<String> list, String outputFileName) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(outputFileName));
            for (String s : list) {
                pw.println(s);
                pw.flush();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static List<String> doImport(File repository, File patchFile, OutputLogger logger) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_IMPORT_CMD);
        command.add(HG_VERBOSE_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        command.add(patchFile.getAbsolutePath());
        List<String> list = HgCommand.exec(command);
        if (!list.isEmpty() && HgCommand.isErrorAbort(list.get(list.size() - 1))) {
            logger.output(list);
            HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_IMPORT_FAILED"), logger);
        }
        return list;
    }

    private static Map<File, FileInformation> getStatusWithFlags(File repository, List<File> dirs, String statusFlags, boolean bIgnoreUnversioned) throws HgException {
        if (repository == null) {
            return null;
        }
        long startTime = 0L;
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINER)) {
            Mercurial.STATUS_LOG.log(Level.FINER, "getStatusWithFlags: starting for {0}", dirs);
            startTime = System.currentTimeMillis();
        }
        FileInformation prev_info = null;
        List<String> list = HgCommand.doRepositoryDirStatusCmd(repository, dirs, statusFlags);
        HashMap<File, FileInformation> repositoryFiles = new HashMap<File, FileInformation>(list.size());
        File file = null;
        for (String statusLine : list) {
            FileInformation info = HgCommand.getFileInformationFromStatusLine(statusLine);
            Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): status line {0}  info {1}", new Object[]{statusLine, info});
            if (statusLine.length() > 0) {
                if (statusLine.charAt(0) == ' ') {
                    if (file != null && (prev_info.getStatus() & 0x1000) != 0) {
                        prev_info = new FileInformation(4096, new FileStatus(file, true), false);
                        Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): prev_info {0}  filePath {1}", new Object[]{prev_info, file});
                        continue;
                    }
                    if (file != null) continue;
                    Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status line {2} filepath == nullfor prev_info ", new Object[]{repository.getAbsolutePath(), statusFlags, statusLine});
                    continue;
                }
                if (file != null) {
                    repositoryFiles.put(file, prev_info);
                }
            }
            if (bIgnoreUnversioned ? info.getStatus() == 1 || info.getStatus() == 0 : info.getStatus() == 0) continue;
            StringBuilder sb = new StringBuilder(statusLine);
            sb.delete(0, 2);
            file = Utilities.isWindows() && sb.toString().startsWith(repository.getAbsolutePath()) ? new File(sb.toString()) : new File(repository, sb.toString());
            file = FileUtil.normalizeFile((File)file);
            if (HgCommand.existsConflictFile(file.getAbsolutePath())) {
                info = new FileInformation(64, null, false);
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): CONFLICT repository path: {0} status flags: {1} status line {2} CONFLICT {3}", new Object[]{repository.getAbsolutePath(), statusFlags, statusLine, file + HG_STR_CONFLICT_EXT});
            }
            prev_info = info;
        }
        if (prev_info != null) {
            repositoryFiles.put(file, prev_info);
        }
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            if (list.size() < 10) {
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list {2}", new Object[]{repository.getAbsolutePath(), statusFlags, list});
            } else {
                Mercurial.LOG.log(Level.FINE, "getStatusWithFlags(): repository path: {0} status flags: {1} status list has {2} elements", new Object[]{repository.getAbsolutePath(), statusFlags, list.size()});
            }
        }
        if (Mercurial.STATUS_LOG.isLoggable(Level.FINER)) {
            Mercurial.STATUS_LOG.log(Level.FINER, "getStatusWithFlags for {0} lasted {1}", new Object[]{dirs, System.currentTimeMillis() - startTime});
        }
        return repositoryFiles;
    }

    private static FileInformation getFileInformationFromStatusLine(String status) {
        FileInformation info = null;
        if (status == null || status.length() == 0) {
            return new FileInformation(8, null, false);
        }
        char c0 = status.charAt(0);
        char c1 = status.charAt(1);
        switch (c0 + c1) {
            case 109: {
                info = new FileInformation(16, null, false);
                break;
            }
            case 97: {
                info = new FileInformation(4096, null, false);
                break;
            }
            case 114: {
                info = new FileInformation(256, null, false);
                break;
            }
            case 99: {
                info = new FileInformation(8, null, false);
                break;
            }
            case 65: {
                info = new FileInformation(2048, null, false);
                break;
            }
            case 105: {
                info = new FileInformation(2, null, false);
                break;
            }
            case 95: {
                info = new FileInformation(4, null, false);
                break;
            }
            case 117: {
                info = new FileInformation(64, null, false);
                break;
            }
            case 195: {
                info = new FileInformation(1, null, false);
                break;
            }
            default: {
                info = new FileInformation(0, null, false);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> doRepositoryDirStatusCmd(File repository, List<File> dirs, String statusFlags) throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_STATUS_CMD);
        command.add(statusFlags);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        List<List<String>> attributeGroups = HgCommand.splitAttributes(command, dirs, true);
        LinkedList<String> commandOutput = new LinkedList<String>();
        for (List<String> attributes : attributeGroups) {
            LinkedList<String> finalCommand = new LinkedList<String>(command);
            finalCommand.addAll(attributes);
            List<String> list = HgCommand.exec(finalCommand);
            if (!list.isEmpty() && HgCommand.isErrorNoRepository(list.get(0))) {
                OutputLogger logger = OutputLogger.getLogger(repository.getAbsolutePath());
                try {
                    HgCommand.handleError(finalCommand, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
                }
                finally {
                    logger.closeLog();
                }
            }
            if (HgUtils.hasResolveCommand(Mercurial.getInstance().getVersion())) {
                try {
                    List<String> unresolved = HgCommand.getUnresolvedFiles(repository, attributes);
                    list.addAll(unresolved);
                }
                catch (HgException ex) {
                    // empty catch block
                }
            }
            commandOutput.addAll(list);
        }
        return commandOutput;
    }

    private static List<String> getUnresolvedFiles(File repository, List<String> attributes) throws HgException {
        assert (attributes != null);
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RESOLVE_CMD);
        command.add(HG_LOG_LIMIT_CMD);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(HG_OPT_CWD_CMD);
        command.add(repository.getAbsolutePath());
        command.addAll(attributes);
        List<String> list = HgCommand.exec(command);
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String line = it.next();
            if (line.length() >= 2 && line.charAt(0) + line.charAt(1) == 117) continue;
            it.remove();
        }
        return list;
    }

    private static List<String> execEnv(List<? extends Object> command, List<String> env) throws HgException {
        return HgCommand.execEnv(command, env, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> execEnv(final List<? extends Object> command, List<String> env, boolean logUsage) throws HgException {
        if (EventQueue.isDispatchThread()) {
            Mercurial.LOG.log(Level.FINE, "WARNING execEnv():  calling Hg command in AWT Thread - could stall UI");
        }
        assert (command != null && command.size() > 0);
        if (logUsage) {
            Utils.logVCSClientEvent((String)"HG", (String)"CLI");
        }
        HgCommand.logCommand(command);
        File outputStyleFile = null;
        File repository = null;
        String hgCommand = HgCommand.getHgCommandName(command);
        try {
            List<String> list;
            try {
                outputStyleFile = HgCommand.createOutputStyleFile(command);
            }
            catch (IOException ex) {
                Mercurial.LOG.log(Level.WARNING, "Failed to create temporary file defining Hg output style.");
            }
            List<String> commandLine = HgCommand.toCommandList(command, outputStyleFile);
            final ProcessBuilder pb = new ProcessBuilder(commandLine);
            Map<String, String> envOrig = pb.environment();
            HgCommand.setGlobalEnvVariables(envOrig);
            if (env != null && env.size() > 0) {
                for (String s : env) {
                    envOrig.put(s.substring(0, s.indexOf(61)), s.substring(s.indexOf(61) + 1));
                }
            }
            if (HgCommand.isGuardedCommand(hgCommand) && (repository = HgCommand.getRepositoryFromCommand(command, hgCommand)) != null) {
                list = HgCommand.runWithoutIndexing(new Callable<List<String>>(){

                    @Override
                    public List<String> call() throws Exception {
                        return HgCommand.exec(command, pb);
                    }
                }, Collections.singletonList(repository), hgCommand);
                return list;
            }
            list = HgCommand.exec(commandLine, pb);
            return list;
        }
        finally {
            if (outputStyleFile != null) {
                outputStyleFile.delete();
            }
            if (HgCommand.modifiesRepository(hgCommand)) {
                if (repository == null) {
                    repository = HgCommand.getRepositoryFromCommand(command, hgCommand);
                }
                if (repository != null) {
                    Mercurial.getInstance().refreshWorkingCopyTimestamp(repository);
                }
            }
        }
    }

    private static void setGlobalEnvVariables(Map<String, String> environment) {
        environment.put(ENV_HGPLAIN, "true");
        if (ENCODING != null) {
            environment.put(ENV_HGENCODING, ENCODING);
        }
    }

    private static void logCommand(List<? extends Object> command) {
        if (Mercurial.LOG.isLoggable(Level.FINE)) {
            if (command.size() > 10) {
                ArrayList<String> smallCommand = new ArrayList<String>();
                int count = 0;
                Iterator<? extends Object> i = command.iterator();
                while (i.hasNext()) {
                    smallCommand.add((String)i.next());
                    if (count++ <= 10) continue;
                }
                Mercurial.LOG.log(Level.FINE, "execEnv(): {0}", smallCommand);
            } else {
                Mercurial.LOG.log(Level.FINE, "execEnv(): {0}", command);
            }
        }
    }

    private static List<String> exec(List<? extends Object> command, ProcessBuilder pb) throws HgException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader input = null;
        BufferedReader error = null;
        Process proc = null;
        try {
            proc = pb.start();
            input = new BufferedReader(ENCODING == null ? new InputStreamReader(proc.getInputStream()) : new InputStreamReader(proc.getInputStream(), ENCODING));
            final BufferedReader errorReader = error = new BufferedReader(ENCODING == null ? new InputStreamReader(proc.getErrorStream()) : new InputStreamReader(proc.getErrorStream(), ENCODING));
            final LinkedList errorOutput = new LinkedList();
            final BufferedReader inputReader = input;
            final LinkedList inputOutput = new LinkedList();
            Thread errorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = errorReader.readLine()) != null) {
                            errorOutput.add(line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            errorThread.start();
            Thread inputThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String line;
                        while ((line = inputReader.readLine()) != null) {
                            inputOutput.add(line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            inputThread.start();
            try {
                inputThread.join();
                errorThread.join();
            }
            catch (InterruptedException ex) {
                Mercurial.LOG.log(Level.FINE, "execEnv():  process interrupted {0}", ex);
                if (proc != null) {
                    proc.destroy();
                }
                throw new HgException.HgCommandCanceledException(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_CANCELLED"));
            }
            list.addAll(inputOutput);
            input.close();
            input = null;
            list.addAll(errorOutput);
            error.close();
            error = null;
            try {
                proc.waitFor();
                if (proc.exitValue() == 255) {
                    Mercurial.LOG.log(Level.FINE, "execEnv():  process returned 255");
                    if (list.isEmpty()) {
                        Mercurial.LOG.log(Level.SEVERE, "command: {0}", command);
                        throw new HgException.HgTooLongArgListException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
                    }
                }
            }
            catch (InterruptedException e) {
                Mercurial.LOG.log(Level.FINE, "execEnv():  process interrupted {0}", e);
            }
        }
        catch (InterruptedIOException e) {
            Mercurial.LOG.log(Level.FINE, "execEnv():  execEnv(): InterruptedIOException {0}", e);
            if (proc != null) {
                proc.destroy();
            }
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_CANCELLED"));
        }
        catch (IOException e) {
            Mercurial.LOG.log(HG_VERSION_CMD.equals(command.get(1)) ? Level.FINE : Level.INFO, "execEnv():  execEnv(): IOException", e);
            if (HgCommand.isErrorArgsTooLong(e.getMessage())) {
                assert (command.size() > 2);
                throw new HgException.HgTooLongArgListException(NbBundle.getMessage(HgCommand.class, (String)"MSG_ARG_LIST_TOO_LONG_ERR", (Object)HgCommand.getHgCommandName(command), (Object)(command.size() - 2)));
            }
            if (HgCommand.isErrorNoHg(e.getMessage()) || HgCommand.isErrorCannotRun(e.getMessage())) {
                throw new HgException(NbBundle.getMessage(Mercurial.class, (String)"MSG_VERSION_NONE_MSG"));
            }
            throw new HgException(NbBundle.getMessage(HgCommand.class, (String)"MSG_UNABLE_EXECUTE_COMMAND"));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioex) {}
                input = null;
            }
            if (error != null) {
                try {
                    error.close();
                }
                catch (IOException ioex) {}
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createOutputStyleFile(List<? extends Object> cmdLine) throws IOException {
        File result = null;
        for (Object object : cmdLine) {
            String str;
            if (object == null) {
                assert (false);
                continue;
            }
            if (object.getClass() != String.class || !(str = (String)object).startsWith("--template=")) continue;
            if (result != null) {
                assert (false) : "implementation not ready for multiple templates on one command line";
                continue;
            }
            String template = str.substring("--template=".length());
            File tempFile = File.createTempFile("hg-output-style", null);
            OutputStreamWriter writer = ENCODING == null ? new OutputStreamWriter(new FileOutputStream(tempFile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), ENCODING);
            try {
                ((Writer)writer).append("changeset = ").append('\"').append(template).append('\"');
            }
            finally {
                if (writer != null) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException ex) {}
                }
            }
            result = tempFile;
        }
        return result;
    }

    private static List<String> toCommandList(List<? extends Object> cmdLine, File styleFile) {
        if (cmdLine.isEmpty()) {
            return cmdLine;
        }
        ArrayList<String> result = new ArrayList<String>(cmdLine.size() + 2);
        boolean first = true;
        for (Object object : cmdLine) {
            if (object == null) {
                assert (false);
                continue;
            }
            if (object == "hg") {
                result.addAll(HgCommand.makeHgLauncherCommandLine());
            } else if (object.getClass() == String.class) {
                String str = (String)object;
                if (str.startsWith("--template=") && styleFile != null) {
                    result.add("--style");
                    result.add(styleFile.getAbsolutePath());
                } else {
                    result.add(str);
                }
            } else if (object instanceof HgURL) {
                if (first) {
                    assert (false);
                    result.add(object.toString());
                } else {
                    result.add(((HgURL)object).toHgCommandUrlString());
                }
            } else if (object instanceof File) {
                result.add(((File)object).getPath());
            } else {
                assert (false);
                result.add(object.toString());
            }
            first = false;
        }
        assert (!result.isEmpty());
        return result;
    }

    private static List<String> exec(List<? extends Object> command) throws HgException {
        if (!Mercurial.getInstance().isAvailable()) {
            return new ArrayList<String>();
        }
        return HgCommand.execEnv(command, null);
    }

    private static List<String> execForVersionCheck() throws HgException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_VERSION_CMD);
        return HgCommand.execEnv(command, null, false);
    }

    private static String getHgCommand() {
        return "hg";
    }

    private static List<String> makeHgLauncherCommandLine() {
        File launcherFile;
        String defaultPath = HgModuleConfig.getDefault().getExecutableBinaryPath();
        if (defaultPath == null || defaultPath.length() == 0) {
            return Collections.singletonList("hg");
        }
        File f = new File(defaultPath);
        if (f.isFile()) {
            launcherFile = f;
        } else if (Utilities.isWindows()) {
            launcherFile = null;
            for (String hgExecutable : HG_WINDOWS_EXECUTABLES) {
                File executableFile = new File(f, hgExecutable);
                if (!executableFile.isFile()) continue;
                launcherFile = executableFile;
                break;
            }
            if (launcherFile == null) {
                launcherFile = new File(f, "hg.exe");
            }
        } else {
            launcherFile = new File(f, "hg");
        }
        String launcherPath = launcherFile.getAbsolutePath();
        if (Utilities.isWindows() && !launcherPath.endsWith(HG_WINDOWS_EXE)) {
            ArrayList<String> result = new ArrayList<String>(3);
            result.add("cmd.exe");
            result.add("/C");
            result.add(launcherPath);
            return result;
        }
        List<String> result = Collections.singletonList(launcherPath);
        return result;
    }

    private static void handleError(List<? extends Object> command, List<String> cmdOutput, String message, OutputLogger logger) throws HgException {
        if (command != null && cmdOutput != null && logger != null) {
            Mercurial.LOG.log(Level.WARNING, "command: {0}", command);
            Mercurial.LOG.log(Level.WARNING, "output: {0}", HgUtils.replaceHttpPassword(cmdOutput));
            logger.outputInRed(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ERR"));
            logger.output(NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_INFO_ERR", command, HgUtils.replaceHttpPassword(cmdOutput)));
        }
        if (cmdOutput != null && !cmdOutput.isEmpty() && (HgCommand.isErrorPossibleProxyIssue(cmdOutput.get(0)) || HgCommand.isErrorPossibleProxyIssue(cmdOutput.get(cmdOutput.size() - 1)))) {
            boolean bConfirmSetProxy = HgUtils.confirmDialog(HgCommand.class, "MSG_POSSIBLE_PROXY_ISSUE_TITLE", "MSG_POSSIBLE_PROXY_ISSUE_QUERY");
            if (bConfirmSetProxy) {
                OptionsDisplayer.getDefault().open("General");
            }
        } else {
            throw new HgException(message);
        }
    }

    private static PasswordAuthentication handleAuthenticationError(List<String> cmdOutput, File repository, String url, String userName, UserCredentialsSupport credentialsSupport, String hgCommand) throws HgException {
        return HgCommand.handleAuthenticationError(cmdOutput, repository, url, userName, credentialsSupport, hgCommand, true);
    }

    private static PasswordAuthentication handleAuthenticationError(List<String> cmdOutput, File repository, String url, String userName, UserCredentialsSupport credentialsSupport, String hgCommand, boolean showKenaiLoginDialog) throws HgException {
        PasswordAuthentication credentials = null;
        String msg = cmdOutput.get(cmdOutput.size() - 1).toLowerCase();
        if (HgCommand.isAuthMsg(msg)) {
            HgKenaiAccessor support = HgKenaiAccessor.getInstance();
            if (support.isKenai(url) && showKenaiLoginDialog) {
                HgCommand.checkKenaiPermissions(hgCommand, url, support);
                credentials = HgCommand.handleKenaiAuthorisation(support, url);
            } else {
                credentials = credentialsSupport.getUsernamePasswordCredentials(repository, url, userName);
            }
        }
        return credentials;
    }

    private static PasswordAuthentication handleKenaiAuthorisation(HgKenaiAccessor support, String url) {
        PasswordAuthentication pa = support.getPasswordAuthentication(url, true);
        return pa;
    }

    public static boolean isAuthMsg(String msg) {
        return msg.contains(HG_AUTHORIZATION_REQUIRED_ERR) || msg.contains(HG_AUTHORIZATION_FAILED_ERR);
    }

    public static boolean isMergeNeededMsg(String msg) {
        return msg.indexOf(HG_MERGE_NEEDED_ERR) > -1;
    }

    public static boolean isBackoutMergeNeededMsg(String msg) {
        return msg.indexOf(HG_BACKOUT_MERGE_NEEDED_ERR) > -1;
    }

    public static boolean isMergeFailedMsg(String msg) {
        return msg.indexOf(HG_MERGE_FAILED1_ERR) > -1 && msg.indexOf(HG_MERGE_FAILED2_ERR) > -1;
    }

    public static boolean isConflictDetectedInMsg(String msg) {
        return msg.indexOf(HG_MERGE_CONFLICT_ERR) > -1;
    }

    public static boolean isMergeUnavailableMsg(String msg) {
        return msg.indexOf(HG_MERGE_UNAVAILABLE_ERR) > -1;
    }

    public static boolean isMergeAbortMultipleHeadsMsg(String msg) {
        return msg.indexOf(HG_MERGE_MULTIPLE_HEADS_ERR) > -1;
    }

    public static boolean isMergeAbortUncommittedMsg(String msg) {
        return msg.indexOf(HG_MERGE_UNCOMMITTED_ERR) > -1;
    }

    public static boolean isNoChanges(String msg) {
        return msg.indexOf(HG_NO_CHANGES_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPush(String msg) {
        return msg.indexOf(HG_ABORT_NO_DEFAULT_PUSH_ERR) > -1;
    }

    private static boolean isErrorNoDefaultPath(String msg) {
        return msg.indexOf(HG_ABORT_NO_DEFAULT_ERR) > -1;
    }

    private static boolean isErrorPossibleProxyIssue(String msg) {
        return msg.indexOf(HG_ABORT_POSSIBLE_PROXY_ERR) > -1;
    }

    private static boolean isErrorNoRepository(String msg) {
        return msg.indexOf(HG_NO_REPOSITORY_ERR) > -1 || msg.indexOf(HG_NOT_REPOSITORY_ERR) > -1 || msg.indexOf(HG_REPOSITORY) > -1 && msg.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoHg(String msg) {
        return msg.indexOf(HG_NO_HG_CMD_FOUND_ERR) > -1;
    }

    private static boolean isErrorArgsTooLong(String msg) {
        return msg.indexOf(HG_ARG_LIST_TOO_LONG_ERR) > -1 || msg.contains(HG_ARGUMENT_LIST_TOO_LONG_ERR);
    }

    private static boolean isErrorCannotRun(String msg) {
        return msg.indexOf(HG_CANNOT_RUN_ERR) > -1;
    }

    private static boolean isErrorUpdateSpansBranches(String msg) {
        return msg.indexOf(HG_UPDATE_SPAN_BRANCHES_ERR) > -1;
    }

    private static boolean isErrorAlreadyTracked(String msg) {
        return msg.indexOf(HG_ALREADY_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotTracked(String msg) {
        return msg.indexOf(HG_NOT_TRACKED_ERR) > -1;
    }

    private static boolean isErrorNotFound(String msg) {
        return msg.indexOf(HG_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorCannotReadCommitMsg(String msg) {
        return msg.indexOf(HG_CANNOT_READ_COMMIT_MESSAGE_ERR) > -1;
    }

    private static boolean isErrorAbort(String msg) {
        return msg.indexOf(HG_ABORT_ERR) > -1;
    }

    public static boolean isErrorAbortPush(String msg) {
        return msg.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isErrorAbortNoFilesToCopy(String msg) {
        return msg.indexOf(HG_ABORT_NO_FILES_TO_COPY_ERR) > -1;
    }

    public static boolean isCommitAfterMerge(String msg) {
        return msg.indexOf(HG_COMMIT_AFTER_MERGE_ERR) > -1;
    }

    private static boolean isErrorNoChangeNeeded(String msg) {
        return msg.indexOf(HG_NO_CHANGE_NEEDED_ERR) > -1;
    }

    public static boolean isCreateNewBranch(String msg) {
        return msg.indexOf("abort: push creates new remote ") > -1;
    }

    public static boolean isHeadsCreated(String msg) {
        return msg.indexOf(HG_HEADS_CREATED_ERR) > -1;
    }

    public static boolean isNoRollbackPossible(String msg) {
        return msg.indexOf("no rollback information available") > -1;
    }

    public static boolean isNoRevStrip(String msg) {
        return msg.indexOf(HG_NO_REV_STRIP_ERR) > -1;
    }

    public static boolean isLocalChangesStrip(String msg) {
        return msg.indexOf(HG_LOCAL_CHANGES_STRIP_ERR) > -1;
    }

    public static boolean isMultipleHeadsStrip(String msg) {
        return msg.indexOf("no rollback information available") > -1;
    }

    public static boolean isUncommittedChangesBackout(String msg) {
        return msg.indexOf(HG_ABORT_UNCOMMITTED_CHANGES_ERR) > -1;
    }

    public static boolean isMergeChangesetBackout(String msg) {
        return msg.indexOf(HG_ABORT_BACKOUT_MERGE_CSET_ERR) > -1;
    }

    public static boolean isNoUpdates(String msg) {
        return msg.indexOf(HG_NO_UPDATES_ERR) > -1;
    }

    private static boolean isErrorNoView(String msg) {
        return msg.indexOf(HG_NO_VIEW_ERR) > -1;
    }

    private static boolean isErrorHgkNotFound(String msg) {
        return msg.indexOf(HG_HGK_NOT_FOUND_ERR) > -1;
    }

    private static boolean isErrorNoSuchFile(String msg) {
        return msg.indexOf(HG_NO_SUCH_FILE_ERR) > -1;
    }

    private static boolean isErrorNoResponse(String msg) {
        return msg.indexOf(HG_NO_RESPONSE_ERR) > -1;
    }

    private static boolean isAddingLine(String msg) {
        return msg.toLowerCase().indexOf(HG_ADDING) > -1;
    }

    private static List<String> getFilesWithPerformanceWarning(List<String> list) {
        LinkedList<String> fileList = new LinkedList<String>();
        for (String line : list) {
            int pos = line.indexOf(HG_WARNING_PERFORMANCE_FILES_OVER);
            if (pos <= 0 || !line.contains(HG_WARNING_PERFORMANCE_CAUSE_PROBLEMS)) continue;
            fileList.add(line.substring(0, pos));
        }
        return fileList;
    }

    public static void createConflictFile(String path) {
        try {
            File file = new File(path + HG_STR_CONFLICT_EXT);
            boolean success = file.createNewFile();
            Mercurial.LOG.log(Level.FINE, "createConflictFile(): File: {0} {1}", new Object[]{path + HG_STR_CONFLICT_EXT, success ? "Created" : "Not Created"});
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsResolved(File repository, File file, OutputLogger logger) throws HgException {
        List<String> list;
        if (file == null) {
            return;
        }
        if (!HgUtils.hasResolveCommand(Mercurial.getInstance().getVersion())) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_RESOLVE_CMD);
        command.add(HG_RESOLVE_MARK_RESOLVED);
        command.add(HG_OPT_REPOSITORY);
        command.add(repository.getAbsolutePath());
        command.add(FileUtil.normalizeFile((File)file).getAbsolutePath());
        try {
            list = HgCommand.exec(command);
        }
        finally {
            Mercurial.getInstance().refreshWorkingCopyTimestamp(repository);
        }
        if (!list.isEmpty()) {
            if (HgCommand.isErrorNoRepository(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_NO_REPOSITORY_ERR"), logger);
            } else if (HgCommand.isErrorAbort(list.get(0))) {
                HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), logger);
            }
        }
    }

    public static void deleteConflictFile(String path) {
        boolean success = new File(path + HG_STR_CONFLICT_EXT).delete();
        Mercurial.LOG.log(Level.FINE, "deleteConflictFile(): File: {0} {1}", new Object[]{path + HG_STR_CONFLICT_EXT, success ? "Deleted" : "Not Deleted"});
    }

    public static boolean existsConflictFile(String path) {
        File file = new File(path + HG_STR_CONFLICT_EXT);
        boolean bExists = file.canWrite();
        if (bExists) {
            Mercurial.LOG.log(Level.FINE, "existsConflictFile(): File: {0} {1}", new Object[]{path + HG_STR_CONFLICT_EXT, "Exists"});
        }
        return bExists;
    }

    public static boolean checkRemoteRepository(String repository) {
        boolean retval = false;
        if (repository == null || "".equals(repository)) {
            return retval;
        }
        File tmpFolder = Utils.getTempFolder((boolean)false);
        File tmpTarget = new File(tmpFolder, "rep");
        ArrayList<String> command = new ArrayList<String>();
        command.add(HgCommand.getHgCommand());
        command.add(HG_CLONE_CMD);
        command.add(repository);
        command.add(tmpTarget.getAbsolutePath());
        retval = HgCommand.execCheckClone(command);
        Utils.deleteRecursively((File)tmpFolder);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean execCheckClone(List<String> command) {
        boolean[] isRepository;
        block22: {
            isRepository = new boolean[]{false};
            if (!Mercurial.getInstance().isAvailable(true, false)) {
                Mercurial.LOG.info("Unsupported hg version");
                return isRepository[0];
            }
            Process proc = null;
            try {
                Mercurial.LOG.log(Level.FINE, "execCheckClone(): {0}", command);
                ProcessBuilder b = new ProcessBuilder(command);
                b.redirectErrorStream(true);
                final Process procf = proc = b.start();
                Thread t1 = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        BufferedReader in = new BufferedReader(new InputStreamReader(procf.getInputStream()));
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                if (!(line = line.toLowerCase()).contains("requesting all changes") && !line.contains("adding changesets") && !line.contains(HgCommand.HG_NO_CHANGES_ERR) && !line.contains("updating working directory")) continue;
                                isRepository[0] = true;
                                break;
                            }
                        }
                        catch (IOException ex) {
                            Mercurial.LOG.log(Level.FINE, null, ex);
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException ex) {
                                Mercurial.LOG.log(Level.FINE, null, ex);
                            }
                        }
                    }
                });
                t1.start();
                int rounds = HgUtils.getNumberOfRoundsForRepositoryValidityCheck();
                while (t1.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (--rounds != 0) continue;
                    proc.destroy();
                    isRepository[0] = true;
                }
            }
            catch (InterruptedIOException e) {
                Mercurial.LOG.log(Level.FINE, "execCheckClone():  InterruptedIOException {0}", e);
                if (proc == null) break block22;
                try {
                    proc.getInputStream().close();
                    proc.getOutputStream().close();
                    proc.getErrorStream().close();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
                proc.destroy();
            }
            catch (IOException e) {
                Mercurial.LOG.log(Level.INFO, null, e);
            }
            finally {
                if (proc != null) {
                    try {
                        proc.getInputStream().close();
                        proc.getErrorStream().close();
                        proc.getOutputStream().close();
                    }
                    catch (IOException ex) {
                        Mercurial.LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        }
        return isRepository[0];
    }

    private static boolean isTooLongCommand(int commandSize) {
        return (Utilities.isWindows() || Utilities.isMac()) && commandSize > MAX_COMMANDLINE_SIZE;
    }

    private static String getHgCommandName(List<? extends Object> commandList) {
        String commandName = null;
        if (commandList.size() > 1 && "hg".equals(commandList.get(0))) {
            commandName = commandList.get(1).toString();
        }
        return commandName;
    }

    private static boolean isGuardedCommand(String hgCommand) {
        return GUARDED_COMMANDS.contains(hgCommand);
    }

    private static boolean modifiesRepository(String hgCommand) {
        return !REPOSITORY_NOMODIFICATION_COMMANDS.contains(hgCommand);
    }

    private static File getRepositoryFromCommand(List<? extends Object> commandList, String hgCommand) {
        File repositoryFile = null;
        boolean isRepositoryArgument = false;
        ListIterator<? extends Object> it = commandList.listIterator();
        while (it.hasNext()) {
            Object argument = it.next();
            if (isRepositoryArgument || HG_CLONE_CMD.equals(hgCommand) && !it.hasNext()) {
                repositoryFile = new File(argument.toString());
                break;
            }
            if (!HG_OPT_REPOSITORY.equals(argument)) continue;
            isRepositoryArgument = true;
        }
        return repositoryFile;
    }

    private static List<String> runWithoutIndexing(Callable<List<String>> callable, List<File> files, String hgCommand) throws HgException {
        try {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINER, "Running command with disabled indexing: [hg {0}] on {1}", new Object[]{hgCommand, files});
            }
            return (List)IndexingBridge.getInstance().runWithoutIndexing(callable, files.toArray(new File[files.size()]));
        }
        catch (HgException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Mercurial.LOG.log(Level.INFO, "Cannot run command hg " + hgCommand + " without indexing", ex);
            throw new HgException("Cannot run command hg " + hgCommand + " due to: " + ex.getMessage());
        }
    }

    private HgCommand() {
    }

    private static String getEncoding() {
        String enc = null;
        String prop = System.getProperty("mercurial.encoding", "");
        if (!prop.isEmpty()) {
            try {
                if (Charset.isSupported(prop)) {
                    enc = prop;
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (enc == null) {
                Mercurial.LOG.log(Level.WARNING, "Unsupported encoding {0}, using default", prop);
            }
        }
        return enc;
    }

    private static void checkKenaiPermissions(String hgCommand, String repositoryUrl, HgKenaiAccessor ka) throws HgException {
        if (HG_PUSH_CMD.equals(hgCommand)) {
            if (!ka.canWrite(repositoryUrl)) {
                throw new HgException(NbBundle.getMessage(Repository.class, (String)"MSG_Repository.kenai.insufficientRights.write"));
            }
        } else if (!ka.canRead(repositoryUrl)) {
            throw new HgException(NbBundle.getMessage(Repository.class, (String)"MSG_Repository.kenai.insufficientRights.read"));
        }
    }

    private static String prepareLogTemplate(File temporaryFolder, String changesetFileName) throws IOException {
        InputStream isChangeset = HgCommand.class.getResourceAsStream(changesetFileName);
        InputStream isStyle = HgCommand.class.getResourceAsStream(HG_LOG_STYLE_NAME);
        File styleFile = new File(temporaryFolder, HG_LOG_STYLE_NAME);
        File changesetFile = new File(temporaryFolder, HG_LOG_CHANGESET_GENERAL_NAME);
        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(changesetFile), (InputStream)isChangeset);
        Utils.copyStreamsCloseAll((OutputStream)new FileOutputStream(styleFile), (InputStream)isStyle);
        return HG_ARGUMENT_STYLE + styleFile.getAbsolutePath();
    }

    private static List<List<String>> splitAttributes(List<String> basicCommand, List<File> files, boolean includeFolders) {
        LinkedList<List<String>> attributes = new LinkedList<List<String>>();
        int basicCommandSize = 0;
        for (String s : basicCommand) {
            basicCommandSize += s.length() + 1;
        }
        ListIterator<File> iterator = files.listIterator();
        while (iterator.hasNext()) {
            LinkedList<String> commandAttributes = new LinkedList<String>();
            int commandSize = basicCommandSize;
            boolean fileAdded = false;
            while (iterator.hasNext()) {
                File f = iterator.next();
                if (!includeFolders && f.isDirectory()) continue;
                if (fileAdded && HgCommand.isTooLongCommand(commandSize += f.getAbsolutePath().length() + 1)) {
                    Mercurial.LOG.fine("splitAttributes: files in loop");
                    iterator.previous();
                    break;
                }
                commandAttributes.add(f.getAbsolutePath());
                fileAdded = true;
            }
            attributes.add(commandAttributes);
        }
        return attributes;
    }

    static /* synthetic */ String access$200() {
        return HgCommand.getHgCommand();
    }

    static {
        String maxCmdSizeProp = System.getProperty("mercurial.maxCommandlineSize");
        if (maxCmdSizeProp == null) {
            maxCmdSizeProp = "";
        }
        int maxCmdSize = 0;
        try {
            maxCmdSize = Integer.parseInt(maxCmdSizeProp);
        }
        catch (NumberFormatException e) {
            maxCmdSize = 0;
        }
        if (maxCmdSize < 1024) {
            maxCmdSize = Utilities.isWindows() ? 8000 : (Utilities.isMac() ? 64000 : 128000);
        }
        MAX_COMMANDLINE_SIZE = maxCmdSize;
        GUARDED_COMMANDS = new HashSet(8);
        GUARDED_COMMANDS.add(HG_BACKOUT_CMD);
        GUARDED_COMMANDS.add(HG_CLONE_CMD);
        GUARDED_COMMANDS.add(HG_IMPORT_CMD);
        GUARDED_COMMANDS.add(HG_FETCH_CMD);
        GUARDED_COMMANDS.add(HG_PULL_CMD);
        GUARDED_COMMANDS.add(HG_MERGE_CMD);
        GUARDED_COMMANDS.add(HG_UNBUNDLE_CMD);
        GUARDED_COMMANDS.add(HG_UPDATE_ALL_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS = new HashSet(16);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_ANNOTATE_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_CAT_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_EXPORT_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_BUNDLE_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_ID_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_INCOMING_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_LOG_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_OUTGOING_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_OUT_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_PUSH_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_RESOLVE_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_STATUS_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add("tip");
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_VERIFY_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_VERSION_CMD);
        REPOSITORY_NOMODIFICATION_COMMANDS.add(HG_VIEW_CMD);
    }

    private static class InterRepositoryCommand {
        protected File repository;
        protected HgURL remoteUrl;
        protected OutputLogger logger;
        protected String hgCommand = HgCommand.access$200();
        protected String hgCommandType;
        protected String defaultUrl;
        protected boolean acquireCredentialsFirst;
        protected boolean outputDetails = true;
        protected List<String> additionalOptions = new LinkedList<String>();
        protected UserCredentialsSupport credentialsSupport;
        protected boolean showSaveOption;
        protected String[] urlPathProperties = new String[0];
        private PasswordAuthentication credentials;

        private void saveCredentials(String propertyName) {
            try {
                HgModuleConfig.getDefault().setProperty(this.repository, propertyName, new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), null).toCompleteUrlString());
            }
            catch (URISyntaxException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            catch (IOException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<String> invoke() throws HgException {
            String rawUrl;
            HgKenaiAccessor supp;
            boolean showLoginWindow;
            boolean retry;
            List list;
            block19: {
                char[] password;
                block18: {
                    list = null;
                    retry = true;
                    showLoginWindow = true;
                    this.credentials = null;
                    supp = HgKenaiAccessor.getInstance();
                    rawUrl = this.remoteUrl.toUrlStringWithoutUserInfo();
                    this.acquireCredentialsFirst |= supp.isLoggedIntoKenai(rawUrl);
                    if (!supp.isKenai(rawUrl)) break block18;
                    if (this.acquireCredentialsFirst) {
                        this.credentials = supp.getPasswordAuthentication(rawUrl, false);
                        if (this.credentials == null) {
                            showLoginWindow = false;
                        }
                    }
                    break block19;
                }
                if (this.remoteUrl.getUsername() != null && this.remoteUrl.getPassword() == null && (password = KeyringSupport.read((String)HgUtils.PREFIX_VERSIONING_MERCURIAL_URL, (String)this.remoteUrl.toHgCommandStringWithNoPassword())) != null) {
                    this.credentials = new PasswordAuthentication(this.remoteUrl.getUsername(), password);
                }
            }
            HgURL url = this.remoteUrl;
            this.credentialsSupport = new UserCredentialsSupport();
            this.credentialsSupport.setShowSaveOption(this.showSaveOption);
            try {
                while (retry) {
                    retry = false;
                    try {
                        if (this.credentials != null) {
                            url = new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), this.credentials.getPassword());
                        }
                    }
                    catch (URISyntaxException ex) {
                        Mercurial.LOG.log(Level.SEVERE, null, ex);
                        return list;
                    }
                    ArrayList<Object> command = new ArrayList<Object>();
                    command.add(this.hgCommand);
                    command.add(this.hgCommandType);
                    for (String s : this.additionalOptions) {
                        command.add(s);
                    }
                    command.add(HgCommand.HG_OPT_REPOSITORY);
                    command.add(this.repository.getAbsolutePath());
                    command.add(url);
                    String proxy = HgCommand.getGlobalProxyIfNeeded(this.defaultUrl, this.outputDetails, this.logger);
                    if (proxy != null) {
                        ArrayList<String> env = new ArrayList<String>();
                        env.add(HgCommand.HG_PROXY_ENV + proxy);
                        list = HgCommand.execEnv(command, env);
                    } else {
                        list = HgCommand.exec(command);
                    }
                    if (url != this.remoteUrl) {
                        url.clearPassword();
                    }
                    if (list.isEmpty() || !HgCommand.isErrorAbort((String)list.get(list.size() - 1)) || HgCommand.HG_PUSH_CMD.equals(this.hgCommandType) && HgCommand.isErrorAbortPush((String)list.get(list.size() - 1))) continue;
                    this.credentials = HgCommand.handleAuthenticationError(list, this.repository, rawUrl, this.credentials == null ? "" : this.credentials.getUserName(), this.credentialsSupport, this.hgCommandType, showLoginWindow);
                    if (this.credentials != null) {
                        retry = true;
                        if (supp.isKenai(rawUrl) || this.credentials == null) continue;
                        try {
                            KeyringSupport.save((String)HgUtils.PREFIX_VERSIONING_MERCURIAL_URL, (String)new HgURL(this.remoteUrl.toHgCommandUrlString(), this.credentials.getUserName(), null).toHgCommandStringWithNoPassword(), (char[])((char[])this.credentials.getPassword().clone()), null);
                            continue;
                        }
                        catch (URISyntaxException ex) {
                            Mercurial.LOG.log(Level.SEVERE, null, ex);
                            continue;
                        }
                    }
                    HgCommand.handleError(command, list, NbBundle.getMessage(HgCommand.class, (String)"MSG_COMMAND_ABORTED"), this.logger);
                }
                return list;
            }
            finally {
                if (!supp.isKenai(rawUrl) && this.credentials != null) {
                    this.savePathProperties();
                    Arrays.fill(this.credentials.getPassword(), '\u0000');
                }
            }
        }

        private void savePathProperties() {
            if (this.credentialsSupport != null && this.credentialsSupport.shallSaveValues()) {
                for (String pathProp : this.urlPathProperties) {
                    this.saveCredentials(pathProp);
                }
            }
        }
    }
}

