/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConflictResolvedAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        return cache.containsFileOfStatus(context, 64, false);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_MarkResolved";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ConflictResolvedAction.resolved(context);
    }

    public static void resolved(VCSContext ctx) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        File[] files = cache.listFiles(ctx, 64);
        File root = HgUtils.getRootFile(ctx);
        if (root == null || files == null || files.length == 0) {
            return;
        }
        ConflictResolvedAction.conflictResolved(root, files);
    }

    public static void conflictResolved(File repository, final File[] files) {
        if (repository == null || files == null || files.length == 0) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                for (int i = 0; i < files.length; ++i) {
                    if (this.isCanceled()) {
                        return;
                    }
                    File file = files[i];
                    File repository = Mercurial.getInstance().getRepositoryRoot(file);
                    ConflictResolvedAction.perform(file, repository, logger);
                }
            }
        };
        support.start(rp, repository, NbBundle.getMessage(ConflictResolvedAction.class, (String)"MSG_ConflictResolved_Progress"));
    }

    private static void perform(File file, File repository, OutputLogger logger) {
        if (file == null) {
            return;
        }
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        file = FileUtil.normalizeFile((File)file);
        try {
            HgCommand.markAsResolved(repository, file, logger);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.INFO, null, ex);
        }
        HgCommand.deleteConflictFile(file.getAbsolutePath());
        Mercurial.LOG.log(Level.FINE, "ConflictResolvedAction.perform(): DELETE CONFLICT File: {0}", new Object[]{file.getAbsolutePath() + ".conflict~"});
        cache.refresh(file);
    }

    public static void resolved(final File file) {
        if (file == null) {
            return;
        }
        final File repository = Mercurial.getInstance().getRepositoryRoot(file);
        if (repository == null) {
            return;
        }
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                ConflictResolvedAction.perform(file, repository, this.getLogger());
            }
        };
        support.start(rp, repository, NbBundle.getMessage(ConflictResolvedAction.class, (String)"MSG_ConflictResolved_Progress"));
    }
}

