/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.RepositorySystem;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.openide.util.Exceptions;

class NBRepositoryModelResolver
implements ModelResolver {
    private final MavenEmbedder embedder;
    private List<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();

    NBRepositoryModelResolver(MavenEmbedder embedder) {
        this.embedder = embedder;
    }

    private NBRepositoryModelResolver(NBRepositoryModelResolver original) {
        this(original.embedder);
        this.remoteRepositories = new ArrayList<ArtifactRepository>(original.remoteRepositories);
    }

    public ModelResolver newCopy() {
        return new NBRepositoryModelResolver(this);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        RepositorySystem repositorySystem = this.embedder.lookupComponent(RepositorySystem.class);
        try {
            ArtifactRepository repo = repositorySystem.buildArtifactRepository(repository);
            this.remoteRepositories.add(repo);
            this.remoteRepositories = repositorySystem.getEffectiveRepositories(this.remoteRepositories);
        }
        catch (org.apache.maven.artifact.InvalidRepositoryException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        this.embedder.setUpLegacySupport();
        Artifact artifactParent = this.embedder.lookupComponent(RepositorySystem.class).createProjectArtifact(groupId, artifactId, version);
        try {
            this.embedder.resolve(artifactParent, this.remoteRepositories, this.embedder.getLocalRepository());
        }
        catch (ArtifactResolutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new UnresolvableModelException(ex.getMessage(), groupId, artifactId, version);
        }
        catch (ArtifactNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new UnresolvableModelException(ex.getMessage(), groupId, artifactId, version);
        }
        return new FileModelSource(artifactParent.getFile());
    }
}

