/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.ui.setup.CreateHostWizardIterator;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostData;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostWizardPanel1;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostWizardPanel2;
import org.netbeans.modules.cnd.remote.ui.wizard.CreateHostWizardPanel3;
import org.netbeans.modules.cnd.remote.ui.wizard.SelectHostVisualPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectHostWizardPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor>,
ChangeListener {
    private final ChangeListener changeListener;
    private final boolean allowLocal;
    private SelectHostVisualPanel component;
    private final CreateHostData createHostData;
    private final ToolsCacheManager cacheManager;
    private final CreateHostWizardPanel1 delegate;
    private final AtomicBoolean setupNewHost;
    private WizardDescriptor wizardDescriptor;
    private volatile boolean needsValidation;
    private final boolean allowToCreateNewHostDirectly;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public SelectHostWizardPanel(boolean allowLocal, boolean allowToCreateNewHostDirectly, ChangeListener changeListener) {
        this.allowLocal = allowLocal;
        this.changeListener = changeListener;
        this.cacheManager = ToolsCacheManager.createInstance((boolean)true);
        this.allowToCreateNewHostDirectly = allowToCreateNewHostDirectly;
        this.createHostData = new CreateHostData(this.cacheManager, allowToCreateNewHostDirectly);
        this.delegate = new CreateHostWizardPanel1(this.createHostData);
        this.delegate.addChangeListener(this);
        this.setupNewHost = new AtomicBoolean();
        if (allowLocal) {
            this.setupNewHost.set(ServerList.getRecords().isEmpty());
        } else {
            this.setupNewHost.set(ServerList.getRecords().size() <= 1);
        }
        this.needsValidation = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectHostVisualPanel getComponent() {
        SelectHostWizardPanel selectHostWizardPanel = this;
        synchronized (selectHostWizardPanel) {
            if (this.component == null) {
                this.component = new SelectHostVisualPanel(this, this.allowLocal, this.delegate.getComponent(), this.setupNewHost, this.allowToCreateNewHostDirectly);
            }
        }
        return this.component;
    }

    public List<WizardDescriptor.Panel<WizardDescriptor>> getAdditionalPanels() {
        ArrayList<WizardDescriptor.Panel<WizardDescriptor>> list = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>(2);
        list.add(new CreateHostWizardPanel2(this.createHostData));
        list.add(new CreateHostWizardPanel3(this.createHostData));
        return list;
    }

    public boolean isNewHost() {
        return this.setupNewHost.get();
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void prepareValidation() {
        if (this.needsValidation) {
            this.getComponent().enableControls(false);
        }
    }

    public void validate() throws WizardValidationException {
        if (this.needsValidation) {
            ExecutionEnvironment execEnv = this.getComponent().getSelectedHost();
            try {
                if (execEnv != null) {
                    ConnectionManager.getInstance().connectTo(execEnv);
                    RemoteUtil.checkSetupAfterConnection(execEnv);
                }
            }
            catch (IOException ex) {
                String message = NbBundle.getMessage(this.getClass(), (String)"CannotConnectMessage");
                throw new WizardValidationException((JComponent)this.getComponent(), message, message);
            }
            catch (CancellationException ex) {
                String message = NbBundle.getMessage(this.getClass(), (String)"ConnectCancelledMessage");
                throw new WizardValidationException((JComponent)this.getComponent(), message, message);
            }
            finally {
                this.getComponent().enableControls(true);
            }
        }
    }

    public boolean isValid() {
        if (this.setupNewHost.get()) {
            return this.delegate.isValid();
        }
        return this.getComponent().getSelectedHost() != null;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    public void readSettings(WizardDescriptor settings) {
        this.delegate.readSettings(settings);
        this.wizardDescriptor = settings;
        this.getComponent().onReadSettings();
        this.needsValidation = false;
    }

    public void storeSettings(WizardDescriptor settings) {
        this.delegate.storeSettings(settings);
        ExecutionEnvironment env = this.getComponent().getSelectedHost();
        settings.putProperty("hostUID", (Object)(env == null ? null : ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env)));
        settings.putProperty("ToolsCacheManager", (Object)this.createHostData.getCacheManager());
        this.getComponent().onStoreSettings();
        this.needsValidation = true;
    }

    ExecutionEnvironment getSelectedHost() {
        return this.getComponent().getSelectedHost();
    }

    void apply() {
        if (this.isNewHost()) {
            CreateHostWizardIterator.applyHostSetup(this.cacheManager, this.createHostData);
        }
    }
}

