/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartRunnable;
import org.netbeans.modules.j2ee.jboss4.ide.JBStopRunnable;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBStartServer
extends StartServer
implements ProgressObject {
    private static final int AVERAGE_SERVER_INSTANCES = 2;
    private MODE mode;
    private final JBDeploymentManager dm;
    private static Set<String> isDebugModeUri = Collections.synchronizedSet(new HashSet(2));
    private Vector listeners = new Vector();
    private DeploymentStatus deploymentStatus;

    public JBStartServer(DeploymentManager dm) {
        if (!(dm instanceof JBDeploymentManager)) {
            throw new IllegalArgumentException("Not an instance of JBDeploymentManager");
        }
        this.dm = (JBDeploymentManager)dm;
    }

    private void addDebugModeUri() {
        isDebugModeUri.add(this.dm.getUrl());
    }

    private void removeDebugModeUri() {
        isDebugModeUri.remove(this.dm.getUrl());
    }

    private boolean existsDebugModeUri() {
        return isDebugModeUri.contains(this.dm.getUrl());
    }

    public ProgressObject startDebugging(Target target) {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(JBStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.DEBUG;
        RequestProcessor.getDefault().post((Runnable)new JBStartRunnable(null, this.dm, this), 0, 5);
        this.addDebugModeUri();
        return this;
    }

    public boolean isDebuggable(Target target) {
        if (!this.existsDebugModeUri()) {
            return false;
        }
        return this.isRunning();
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo("localhost", this.dm.getDebuggingPort());
    }

    public ProgressObject startProfiling(Target target, ProfilerServerSettings settings) {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(JBStartServer.class, (String)"MSG_START_PROFILED_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.PROFILE;
        RequestProcessor.getDefault().post((Runnable)new JBStartRunnable(settings, this.dm, this), 0, 5);
        this.removeDebugModeUri();
        return this;
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public ProgressObject stopDeploymentManager() {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
        RequestProcessor.getDefault().post((Runnable)new JBStopRunnable(this.dm, this), 0, 5);
        this.removeDebugModeUri();
        return this;
    }

    public ProgressObject startDeploymentManager() {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(JBStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.RUN;
        RequestProcessor.getDefault().post((Runnable)new JBStartRunnable(null, this.dm, this), 0, 5);
        this.removeDebugModeUri();
        return this;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    private boolean isReallyRunning() {
        final InstanceProperties ip = this.dm.getInstanceProperties();
        if (ip == null) {
            return false;
        }
        SafeTrueTest test = new SafeTrueTest(){

            @Override
            public void run() {
                boolean isJBoss6;
                String checkingConfigName = ip.getProperty("server");
                String checkingServerDir = null;
                try {
                    String serverDir = ip.getProperty("server-dir");
                    String rootDir = ip.getProperty("root-dir");
                    if (serverDir == null || rootDir == null) {
                        this.result = false;
                        return;
                    }
                    checkingServerDir = new File(serverDir).getCanonicalPath();
                }
                catch (IllegalStateException ex) {
                    Logger.getLogger("global").log(Level.INFO, null, ex);
                    this.result = false;
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.INFO, null, ex);
                    this.result = false;
                }
                Object serverName = Util.getMBeanParameter(JBStartServer.this.dm, "ServerName", "jboss.system:type=ServerConfig");
                Object serverHome = Util.getMBeanParameter(JBStartServer.this.dm, "ServerHomeLocation", "jboss.system:type=ServerConfig");
                boolean bl = isJBoss6 = serverHome != null;
                if (!isJBoss6) {
                    serverHome = Util.getMBeanParameter(JBStartServer.this.dm, "ServerHomeDir", "jboss.system:type=ServerConfig");
                }
                try {
                    if (serverHome != null) {
                        serverHome = isJBoss6 ? new File(((URL)serverHome).toURI()).getAbsolutePath() : ((File)serverHome).getAbsolutePath();
                    }
                }
                catch (URISyntaxException use) {
                    Logger.getLogger(JBStartServer.class.getName()).log(Level.WARNING, "error getting file from URI: " + serverHome, use);
                }
                if (serverName == null || serverHome == null) {
                    this.result = false;
                    return;
                }
                if (checkingConfigName.equals(serverName) && checkingServerDir.equals(serverHome)) {
                    this.result = true;
                }
            }
        };
        return this.safeTrueTest(test, 10000);
    }

    private boolean safeTrueTest(SafeTrueTest test, int timeout) {
        try {
            new RequestProcessor().post((Runnable)test).waitFinished((long)timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return test.result();
    }

    public boolean isRunning() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        if (ip == null) {
            return false;
        }
        if (!this.isReallyRunning()) {
            JBDeploymentManager.setRunningLastCheck(ip, Boolean.FALSE);
            return false;
        }
        JBDeploymentManager.setRunningLastCheck(ip, Boolean.TRUE);
        return true;
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Vector targets = null;
        JBStartServer jBStartServer = this;
        synchronized (jBStartServer) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                ProgressListener target = (ProgressListener)targets.elementAt(i);
                target.handleProgressEvent(evt);
            }
        }
    }

    MODE getMode() {
        return this.mode;
    }

    private static abstract class SafeTrueTest
    implements Runnable {
        protected boolean result = false;

        private SafeTrueTest() {
        }

        @Override
        public abstract void run();

        public final boolean result() {
            return this.result;
        }
    }

    static enum ACTION_STATUS {
        SUCCESS,
        FAILURE,
        UNKNOWN;

    }

    static enum MODE {
        RUN,
        DEBUG,
        PROFILE;

    }
}

