/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.screen.ScreenAccessController;

public class ScreenViewController
implements DesignDocumentAwareness {
    public static final String SCREEN_ID = "screen";
    private DesignDocument designDocument;
    private JPanel visual;
    private JToolBar toolbar;
    private JComponent loadingPanel = IOUtils.createLoadingPanel();

    public ScreenViewController(DataObjectContext context) {
        this.visual = new JPanel();
        this.visual.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        context.addDesignDocumentAwareness((DesignDocumentAwareness)this);
    }

    public JComponent getVisualRepresentation() {
        return this.visual;
    }

    public JComponent getToolbarRepresentation() {
        return this.toolbar;
    }

    public void setDesignDocument(final DesignDocument newDesignDocument) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenAccessController accessController;
                if (ScreenViewController.this.designDocument != null && (accessController = (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class)) != null) {
                    accessController.hideNotify();
                }
                ScreenViewController.this.toolbar.removeAll();
                ScreenViewController.this.visual.removeAll();
                ScreenViewController.this.designDocument = newDesignDocument;
                ScreenAccessController screenAccessController = accessController = ScreenViewController.this.designDocument != null ? (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class) : null;
                if (accessController != null) {
                    accessController.showNotify();
                    final DataObjectContext context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)ScreenViewController.this.designDocument);
                    if (context != null) {
                        ScreenViewController.this.designDocument.getTransactionManager().readAccess(new Runnable(){

                            @Override
                            public void run() {
                                accessController.setScreenSize(MidpProjectPropertiesSupport.getDeviceScreenSizeFromProject((DataObjectContext)context));
                            }
                        });
                    }
                    ScreenViewController.this.visual.add((Component)new JScrollPane(accessController.getMainPanel()), "Center");
                    JToolBar.Separator separator = new JToolBar.Separator();
                    separator.setOrientation(1);
                    ScreenViewController.this.toolbar.add(separator);
                    ScreenViewController.this.toolbar.add(accessController.getToolBar());
                } else {
                    ScreenViewController.this.visual.add((Component)ScreenViewController.this.loadingPanel, "Center");
                }
                ScreenViewController.this.toolbar.validate();
                ScreenViewController.this.visual.validate();
            }
        });
    }

    public void setScreenSize(final Dimension deviceScreenSize) {
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ScreenViewController.this.designDocument != null) {
                    ScreenViewController.this.designDocument.getTransactionManager().readAccess(new Runnable(){

                        @Override
                        public void run() {
                            ScreenAccessController accessController = (ScreenAccessController)ScreenViewController.this.designDocument.getListenerManager().getAccessController(ScreenAccessController.class);
                            if (accessController != null) {
                                accessController.setScreenSize(deviceScreenSize);
                            }
                        }
                    });
                }
            }
        });
    }
}

