/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.netbeans.modules.dlight.util.Computable;

public final class TasksCachedProcessor<P, R>
implements Computable<P, R> {
    private final ConcurrentMap<P, Future<R>> cache = new ConcurrentHashMap<P, Future<R>>();
    private final Computable<P, R> computable;
    private final boolean removeOnCompletion;

    public TasksCachedProcessor(Computable<P, R> c, boolean removeOnCompletion) {
        this.computable = c;
        this.removeOnCompletion = removeOnCompletion;
    }

    public boolean isResultAvailable(P arg) {
        Future res = (Future)this.cache.get(arg);
        if (res == null) {
            return false;
        }
        return res.isDone() && !res.isCancelled();
    }

    @Override
    public R compute(final P arg) throws InterruptedException {
        Object evaluation;
        FutureTask ft;
        FutureTask f = (FutureTask)this.cache.get(arg);
        if (f == null && (f = (Future)this.cache.putIfAbsent(arg, ft = new FutureTask(evaluation = new Callable<R>(){

            @Override
            public R call() throws InterruptedException {
                return TasksCachedProcessor.this.computable.compute(arg);
            }
        }))) == null) {
            f = ft;
            ft.run();
        }
        try {
            evaluation = f.get();
            return (R)evaluation;
        }
        catch (Throwable th) {
            this.cache.remove(arg, f);
            throw new CancellationException(th.getMessage());
        }
        finally {
            if (this.removeOnCompletion) {
                this.cache.remove(arg, f);
            }
        }
    }

    public void remove(P param) {
        Future f = (Future)this.cache.get(param);
        if (f != null && !f.isDone()) {
            f.cancel(true);
        }
        this.cache.remove(param);
    }

    public void resetCache() {
        this.cache.clear();
    }
}

