/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.netbeans.modules.javadoc.search.URLUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ReferencesPanel
extends JPanel
implements Runnable,
ListSelectionListener {
    private static final String PLEASE_WAIT = NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.wait.text");
    private static final Object LOCK = new Object();
    private static final String EMPTY_LOCATION = "";
    private static final RequestProcessor RP = new RequestProcessor(ReferencesPanel.class.getName(), 1, false, false);
    private int state = 0;
    private ListModel model;
    private ItemDesc[] items;
    private final AbstractButton openBtn;
    private JScrollPane jScrollPane1;
    private JLabel listLabel;
    private JTextField locationField;
    private JLabel locationLabel;
    private JList refList;

    public ReferencesPanel(AbstractButton openBtn) {
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.text"));
        this.openBtn = openBtn;
    }

    public static URL showInWindow() {
        JButton openBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)openBtn, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.ok.text"));
        openBtn.getAccessibleContext().setAccessibleDescription(openBtn.getText());
        openBtn.setEnabled(false);
        Object[] buttons = new Object[]{openBtn, DialogDescriptor.CANCEL_OPTION};
        ReferencesPanel panel = new ReferencesPanel(openBtn);
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.title"), true, buttons, (Object)openBtn, 0, HelpCtx.DEFAULT_HELP, null);
        desc.setClosingOptions(buttons);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"AN_ReferencesDialog"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"AD_ReferencesDialog"));
        RP.post((Runnable)panel);
        dialog.setVisible(true);
        dialog.dispose();
        return desc.getValue() == openBtn ? panel.getSelectedItem() : null;
    }

    @Override
    public void run() {
        switch (this.state) {
            case 0: {
                this.runGetIndiciesTask();
                break;
            }
            case 1: {
                this.runListUpdateTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGetIndiciesTask() {
        List<IndexBuilder.Index> data = IndexBuilder.getDefault().getIndices(true);
        Object object = LOCK;
        synchronized (object) {
            ItemDesc[] modelItems;
            if (data.isEmpty()) {
                modelItems = new ItemDesc[]{ItemDesc.noItem()};
            } else {
                modelItems = new ItemDesc[data.size()];
                this.items = modelItems;
                int i = 0;
                for (IndexBuilder.Index index : data) {
                    modelItems[i] = new ItemDesc(index.display, index.fo);
                    ++i;
                }
            }
            this.model = new FixListModel(modelItems);
        }
        this.state = 1;
        EventQueue.invokeLater(this);
    }

    private void runListUpdateTask() {
        this.refList.setModel(this.model);
        this.refList.addListSelectionListener(this);
        this.refList.setSelectedIndex(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        URL item = this.getSelectedItem();
        String s = item == null ? EMPTY_LOCATION : URLUtils.getDisplayName(item);
        this.locationField.setText(s);
        this.openBtn.setEnabled(item != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL getSelectedItem() {
        int index = this.refList.getSelectedIndex();
        Object object = LOCK;
        synchronized (object) {
            return index < 0 || this.items == null || this.items.length == 0 ? null : this.items[index].location;
        }
    }

    private void initComponents() {
        this.listLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.refList = new JList<String>(new String[]{PLEASE_WAIT});
        this.locationField = new JTextField();
        this.locationLabel = new JLabel();
        this.listLabel.setLabelFor(this.refList);
        this.listLabel.setText(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.text"));
        this.refList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.refList);
        this.refList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.refList.AccessibleContext.accessibleName"));
        this.refList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.refList.AccessibleContext.accessibleDescription"));
        this.locationField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationField);
        this.locationLabel.setText(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE).add(1, (Component)this.listLabel).add(1, (Component)this.locationField, -1, 376, Short.MAX_VALUE).add(1, (Component)this.locationLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.listLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationField, -2, -1, -2).addContainerGap()));
        this.listLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.AccessibleContext.accessibleName"));
        this.listLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.AccessibleContext.accessibleDescription"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.AccessibleContext.accessibleName"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.AccessibleContext.accessibleDescription"));
    }

    private static final class FixListModel
    implements ListModel {
        private ItemDesc[] items;

        public FixListModel(ItemDesc[] items) {
            this.items = items;
        }

        @Override
        public int getSize() {
            return this.items.length;
        }

        public Object getElementAt(int index) {
            return this.items[index].name;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static final class ItemDesc {
        private static ItemDesc NO_ITEM;
        String name;
        String locationName;
        URL location;

        public ItemDesc(String name, URL location) {
            this.name = name;
            this.location = location;
        }

        String getLocationName() {
            if (this.locationName == null) {
                this.locationName = URLUtils.getDisplayName(this.location);
            }
            return this.locationName;
        }

        static ItemDesc noItem() {
            if (NO_ITEM == null) {
                NO_ITEM = new ItemDesc(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.noJavadoc"), null);
            }
            return NO_ITEM;
        }
    }
}

