/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.archetype.ArchetypeProvider;
import org.openide.util.NbCollections;

public abstract class CatalogRepoProvider
implements ArchetypeProvider {
    private static final String EL_ARCHETYPES = "archetypes";
    private static final String EL_ARCHETYPE = "archetype";
    private static final String EL_ARTIFACTID = "artifactId";
    private static final String EL_DESCRIPTION = "description";
    private static final String EL_GROUPID = "groupId";
    private static final String EL_REPOSITORY = "repository";
    private static final String EL_VERSION = "version";
    private static final Logger LOG = Logger.getLogger(CatalogRepoProvider.class.getName());

    protected CatalogRepoProvider() {
    }

    protected abstract URL file() throws IOException;

    protected String repository() {
        return null;
    }

    @Override
    public List<Archetype> getArchetypes() {
        ArrayList<Archetype> toRet = new ArrayList<Archetype>();
        try {
            Namespace ns;
            URL file = this.file();
            if (file == null) {
                return toRet;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            Element list = root.getChild(EL_ARCHETYPES, ns = root.getNamespace());
            if (list != null) {
                for (Element el : NbCollections.checkedListByCopy((List)list.getChildren(EL_ARCHETYPE, ns), Element.class, (boolean)true)) {
                    String grId = el.getChildText(EL_GROUPID, ns);
                    String artId = el.getChildText(EL_ARTIFACTID, ns);
                    String ver = el.getChildText(EL_VERSION, ns);
                    String repo = el.getChildText(EL_REPOSITORY, ns);
                    String desc = el.getChildText(EL_DESCRIPTION, ns);
                    Archetype archetype = new Archetype(false);
                    if (grId == null || artId == null || ver == null) continue;
                    archetype.setArtifactId(artId);
                    archetype.setGroupId(grId);
                    archetype.setVersion(ver);
                    if (repo != null) {
                        archetype.setRepository(repo);
                    } else {
                        archetype.setRepository(this.repository());
                    }
                    if (desc != null) {
                        archetype.setName(desc);
                    }
                    toRet.add(archetype);
                }
            }
        }
        catch (IOException exc) {
            LOG.log(Level.INFO, null, exc);
        }
        catch (JDOMException exc) {
            LOG.log(Level.INFO, null, exc);
        }
        return toRet;
    }
}

