/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public class DefaultReplaceTokenProvider
implements ReplaceTokenProvider,
ActionConvertor {
    private static final String ARTIFACTID = "artifactId";
    private static final String CLASSPATHSCOPE = "classPathScope";
    private static final String GROUPID = "groupId";
    private final Project project;
    private static final String CLASSNAME = "className";
    private static final String CLASSNAME_EXT = "classNameWithExtension";
    private static final String PACK_CLASSNAME = "packageClassName";
    public static final String METHOD_NAME = "nb.single.run.methodName";
    private static final String VARIABLE_PREFIX = "var.";

    public DefaultReplaceTokenProvider(Project prj) {
        this.project = prj;
    }

    protected static FileObject[] extractFileObjectsfromLookup(Lookup lookup) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (DataObject d : lookup.lookup(new Lookup.Template(DataObject.class)).allInstances()) {
            FileObject f = d.getPrimaryFile();
            files.add(f);
        }
        Collection methods = lookup.lookupAll(SingleMethod.class);
        if (methods.size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            files.add(method.getFile());
        }
        return files.toArray(new FileObject[files.size()]);
    }

    @Override
    public Map<String, String> createReplacements(String actionName, Lookup lookup) {
        String withExt;
        Collection methods;
        FileObject[] fos = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup);
        Tuple tuple = new Tuple(null, null);
        FileObject fo = null;
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        Map<String, String> vars = DefaultReplaceTokenProvider.readVariables();
        replaceMap.putAll(vars);
        NbMavenProject prj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        replaceMap.put(GROUPID, prj.getMavenProject().getGroupId());
        replaceMap.put(ARTIFACTID, prj.getMavenProject().getArtifactId());
        if (fos.length > 0) {
            fo = fos[0];
            Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
            if ("text/x-java".equals(fo.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(srcs.getSourceGroups("java"), replaceMap, fo);
            }
            if ("text/x-groovy".equals(fo.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(srcs.getSourceGroups("groovy"), replaceMap, fo);
            }
            if ("text/x-scala".equals(fo.getMIMEType())) {
                tuple = DefaultReplaceTokenProvider.checkSG(srcs.getSourceGroups("scala"), replaceMap, fo);
            }
            if (tuple.relPath == null) {
                replaceMap.put(CLASSNAME_EXT, "");
                replaceMap.put(CLASSNAME, "");
                replaceMap.put(PACK_CLASSNAME, "");
            }
        }
        if ((methods = lookup.lookupAll(SingleMethod.class)).size() == 1) {
            SingleMethod method = (SingleMethod)methods.iterator().next();
            replaceMap.put(METHOD_NAME, method.getMethodName());
        }
        if (tuple.group != null && ("2TestSourceRoot".equals(tuple.group.getName()) || "82GroovyTestSourceRoot".equals(tuple.group.getName()) || "92ScalaTestSourceRoot".equals(tuple.group.getName()))) {
            replaceMap.put(CLASSPATHSCOPE, "test");
        } else {
            replaceMap.put(CLASSPATHSCOPE, "runtime");
        }
        if (tuple.group != null && "1SourceRoot".equals(tuple.group.getName()) && ("test.single".equals(actionName) || "debug.test.single".equals(actionName)) && (withExt = replaceMap.get(CLASSNAME_EXT)) != null && withExt.endsWith(".java")) {
            replaceMap.put(CLASSNAME_EXT, withExt.replace(".java", "Test.java"));
            replaceMap.put(CLASSNAME, replaceMap.get(CLASSNAME) + "Test");
            replaceMap.put(PACK_CLASSNAME, replaceMap.get(PACK_CLASSNAME) + "Test");
        }
        return replaceMap;
    }

    private static Tuple checkSG(SourceGroup[] grp, HashMap<String, String> replaceMap, FileObject fo) {
        String relPath = null;
        SourceGroup group = null;
        for (int i = 0; i < grp.length; ++i) {
            relPath = FileUtil.getRelativePath((FileObject)grp[i].getRootFolder(), (FileObject)fo);
            if (relPath == null) continue;
            group = grp[i];
            replaceMap.put(CLASSNAME_EXT, fo.getNameExt());
            replaceMap.put(CLASSNAME, fo.getName());
            String pack = FileUtil.getRelativePath((FileObject)grp[i].getRootFolder(), (FileObject)fo.getParent());
            if (pack != null) {
                replaceMap.put(PACK_CLASSNAME, (pack + (pack.length() > 0 ? "." : "") + fo.getName()).replace('/', '.'));
                break;
            }
            replaceMap.put(PACK_CLASSNAME, fo.getName());
            break;
        }
        return new Tuple(relPath, group);
    }

    public static Map<String, String> readVariables() {
        HashMap<String, String> vs = new HashMap<String, String>();
        EditableProperties ep = PropertyUtils.getGlobalProperties();
        for (Map.Entry entry : ep.entrySet()) {
            if (!((String)entry.getKey()).startsWith(VARIABLE_PREFIX)) continue;
            vs.put(((String)entry.getKey()).substring(VARIABLE_PREFIX.length()), FileUtil.normalizeFile((File)new File((String)entry.getValue())).getAbsolutePath());
        }
        return vs;
    }

    @Override
    public String convert(String action, Lookup lookup) {
        FileObject[] fos;
        if ("debug.single.method".equals(action)) {
            return "debug.test.single";
        }
        if ("run.single.method".equals(action)) {
            return "test.single";
        }
        if (("run.single".equals(action) || "debug.single".equals(action)) && (fos = DefaultReplaceTokenProvider.extractFileObjectsfromLookup(lookup)).length > 0) {
            FileObject fo = fos[0];
            if ("text/x-java".equals(fo.getMIMEType())) {
                Sources srcs = (Sources)this.project.getLookup().lookup(Sources.class);
                SourceGroup[] grp = srcs.getSourceGroups("java");
                for (int i = 0; i < grp.length; ++i) {
                    String relPath = FileUtil.getRelativePath((FileObject)grp[i].getRootFolder(), (FileObject)fo);
                    if (relPath == null || SourceUtils.isScanInProgress() || !SourceUtils.isMainClass((String)relPath.replaceFirst("[.]java$", "").replace('/', '.'), (ClasspathInfo)ClasspathInfo.create((FileObject)fo), (boolean)true)) continue;
                    return action + ".main";
                }
            }
            if ("text/x-groovy".equals(fo.getMIMEType())) {
                return action + ".main";
            }
            if ("text/x-scala".equals(fo.getMIMEType())) {
                return action + ".main";
            }
        }
        return null;
    }

    private static class Tuple {
        final String relPath;
        final SourceGroup group;

        public Tuple(String path, SourceGroup sg) {
            this.relPath = path;
            this.group = sg;
        }
    }
}

