/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.MavenCommandLineExecutor;
import org.netbeans.modules.maven.execute.MavenExecutor;
import org.netbeans.modules.maven.execute.OutputTabMaintainer;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.spi.lifecycle.MavenBuildPlanSupport;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public abstract class AbstractMavenExecutor
extends OutputTabMaintainer
implements MavenExecutor,
Cancellable {
    protected RunConfig config;
    protected ReRunAction rerun;
    protected ReRunAction rerunDebug;
    protected StopAction stop;
    protected BuildPlanAction buildPlan;
    private List<String> messages = new ArrayList<String>();
    private List<OutputListener> listeners = new ArrayList<OutputListener>();
    protected ExecutorTask task;
    private static final Set<String> forbidden = new HashSet<String>();
    protected MavenItem item;
    protected final Object SEMAPHORE = new Object();

    protected AbstractMavenExecutor(RunConfig conf) {
        super(conf.getExecutionName());
        this.config = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTask(ExecutorTask task) {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            this.task = task;
            this.item = new MavenItem();
            this.SEMAPHORE.notifyAll();
        }
    }

    @Override
    public final void addInitialMessage(String line, OutputListener listener) {
        this.messages.add(line);
        this.listeners.add(listener);
    }

    protected final void processInitialMessage() {
        Iterator<String> it1 = this.messages.iterator();
        Iterator<OutputListener> it2 = this.listeners.iterator();
        InputOutput ioput = this.getInputOutput();
        try {
            while (it1.hasNext()) {
                OutputListener ol = it2.next();
                if (ol != null) {
                    ioput.getErr().println(it1.next(), ol, true);
                    continue;
                }
                ioput.getErr().println(it1.next());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected final void actionStatesAtStart() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractMavenExecutor.this.rerun.setEnabled(false);
                AbstractMavenExecutor.this.rerunDebug.setEnabled(false);
                if (AbstractMavenExecutor.this instanceof MavenCommandLineExecutor) {
                    AbstractMavenExecutor.this.buildPlan.setEnabled(false);
                } else {
                    AbstractMavenExecutor.this.buildPlan.setEnabled(true);
                }
                AbstractMavenExecutor.this.stop.setEnabled(true);
            }
        });
    }

    protected final void actionStatesAtFinish() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractMavenExecutor.this.rerun.setEnabled(true);
                AbstractMavenExecutor.this.rerunDebug.setEnabled(true);
                AbstractMavenExecutor.this.stop.setEnabled(false);
            }
        });
    }

    @Override
    protected void reassignAdditionalContext(Iterator vals) {
        this.rerun = (ReRunAction)vals.next();
        this.rerunDebug = (ReRunAction)vals.next();
        this.stop = (StopAction)vals.next();
        this.buildPlan = (BuildPlanAction)vals.next();
        this.rerun.setConfig(this.config);
        this.rerunDebug.setConfig(this.config);
        this.buildPlan.setConfig(this.config);
        this.stop.setExecutor(this);
    }

    public static final Properties excludeNetBeansProperties(Properties props) {
        Properties toRet = new Properties();
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (forbidden.contains(key)) continue;
            toRet.put(key, props.getProperty(key));
        }
        return toRet;
    }

    protected final Collection createContext() {
        Collection<String> col = super.createContext();
        col.add((String)((Object)this.rerun));
        col.add((String)((Object)this.rerunDebug));
        col.add((String)((Object)this.stop));
        col.add((String)((Object)this.buildPlan));
        return col;
    }

    @Override
    protected Action[] createNewTabActions() {
        this.rerun = new ReRunAction(false);
        this.rerunDebug = new ReRunAction(true);
        this.stop = new StopAction();
        this.buildPlan = new BuildPlanAction();
        this.rerun.setConfig(this.config);
        this.rerunDebug.setConfig(this.config);
        this.buildPlan.setConfig(this.config);
        this.stop.setExecutor(this);
        Action[] actions = !this.isEmbedded() ? new Action[]{this.rerun, this.rerunDebug, this.stop} : new Action[]{this.rerun, this.rerunDebug, this.buildPlan, this.stop};
        return actions;
    }

    protected boolean isEmbedded() {
        return false;
    }

    static {
        forbidden.add("netbeans.logger.console");
        forbidden.add("java.util.logging.config.class");
        forbidden.add("netbeans.autoupdate.language");
        forbidden.add("netbeans.dirs");
        forbidden.add("netbeans.home");
        forbidden.add("sun.awt.exception.handler");
        forbidden.add("org.openide.TopManager.GUI");
        forbidden.add("org.openide.major.version");
        forbidden.add("netbeans.autoupdate.variant");
        forbidden.add("netbeans.dynamic.classpath");
        forbidden.add("netbeans.autoupdate.country");
        forbidden.add("netbeans.hash.code");
        forbidden.add("org.openide.TopManager");
        forbidden.add("org.openide.version");
        forbidden.add("netbeans.buildnumber");
        forbidden.add("javax.xml.parsers.DocumentBuilderFactory");
        forbidden.add("javax.xml.parsers.SAXParserFactory");
        forbidden.add("rave.build");
        forbidden.add("netbeans.accept_license_class");
        forbidden.add("rave.version");
        forbidden.add("netbeans.autoupdate.version");
        forbidden.add("netbeans.importclass");
        forbidden.add("netbeans.user");
    }

    private class MavenItem
    implements BuildExecutionSupport.Item {
        private MavenItem() {
        }

        public String getDisplayName() {
            return AbstractMavenExecutor.this.config.getTaskDisplayName();
        }

        public void repeatExecution() {
            RunUtils.executeMaven(AbstractMavenExecutor.this.config);
        }

        public boolean isRunning() {
            return !AbstractMavenExecutor.this.task.isFinished();
        }

        public void stopRunning() {
            AbstractMavenExecutor.this.cancel();
        }
    }

    static class BuildPlanAction
    extends AbstractAction {
        private MavenEmbedder embedder;
        private RunConfig config;
        private MavenBuildPlanSupport mbps;

        BuildPlanAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/buildplangoals.png", (boolean)false));
            this.putValue("Name", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Build_Plan"));
            this.putValue("ShortDescription", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Build_Plan_tip"));
            this.mbps = (MavenBuildPlanSupport)Lookup.getDefault().lookup(MavenBuildPlanSupport.class);
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            return this.mbps != null && this.config != null && this.config.getProject() != null && super.isEnabled();
        }

        public void setConfig(RunConfig config) {
            this.config = config;
        }

        public void setEmbedder(MavenEmbedder embedder) {
            this.embedder = embedder;
            this.setEnabled(embedder != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.embedder != null && this.config != null && this.config.getProject() != null) {
                NbMavenProject prj = (NbMavenProject)this.config.getProject().getLookup().lookup(NbMavenProject.class);
                this.mbps.openBuildPlanView(this.embedder, prj.getMavenProject(), this.config.getGoals().toArray(new String[0]));
            }
        }
    }

    static class StopAction
    extends AbstractAction {
        private AbstractMavenExecutor exec;

        StopAction() {
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/stop.png", (boolean)false));
            this.putValue("Name", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Stop_execution"));
            this.putValue("ShortDescription", NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Stop_Execution"));
            this.setEnabled(false);
        }

        void setExecutor(AbstractMavenExecutor ex) {
            this.exec = ex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    StopAction.this.exec.cancel();
                }
            });
        }
    }

    static class ReRunAction
    extends AbstractAction {
        private RunConfig config;
        private boolean debug;

        public ReRunAction(boolean debug) {
            this.debug = debug;
            this.putValue("SmallIcon", debug ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refreshdebug.png", (boolean)false) : ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/refresh.png", (boolean)false));
            this.putValue("Name", debug ? NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Rerun_extra") : NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TXT_Rerun"));
            this.putValue("ShortDescription", debug ? NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Rerun_Extra") : NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIP_Rerun"));
            this.setEnabled(false);
        }

        void setConfig(RunConfig config) {
            this.config = config;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.debug) {
                RunGoalsPanel pnl = new RunGoalsPanel();
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(AbstractMavenExecutor.class, (String)"TIT_Run_maven"));
                pnl.readConfig(this.config);
                Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (retValue == DialogDescriptor.OK_OPTION) {
                    BeanRunConfig newConfig = new BeanRunConfig(this.config);
                    pnl.applyValues(newConfig);
                    RunUtils.executeMaven(newConfig);
                }
            } else {
                BeanRunConfig newConfig = new BeanRunConfig(this.config);
                RunUtils.executeMaven(newConfig);
            }
        }
    }
}

