/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.dlight.db.derby.DerbyDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorageFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Exceptions;

public final class DerbyDataStorageFactory
extends SQLDataStorageFactory<DerbyDataStorage> {
    static final String DERBY_DATA_STORAGE_TYPE = "db:sql:derby";
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();

    public DerbyDataStorageFactory() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType(DERBY_DATA_STORAGE_TYPE));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    public DerbyDataStorage createStorage() {
        try {
            DerbyDataStorage result = new DerbyDataStorage();
            result.connect();
            return result;
        }
        catch (SQLException ex) {
            DLightLogger.getLogger(DerbyDataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public DerbyDataStorage openStorage(String uniqueKey) {
        try {
            DerbyDataStorage result = new DerbyDataStorage(uniqueKey);
            result.connect();
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public DerbyDataStorage createStorage(String uniqueKey) {
        try {
            DerbyDataStorage result = new DerbyDataStorage(uniqueKey);
            result.connect();
            return result;
        }
        catch (SQLException ex) {
            DLightLogger.getLogger(DerbyDataStorageFactory.class).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getUniqueKey(DerbyDataStorage storage) {
        return storage.getURL();
    }

    public DerbyDataStorage openStorage(String uniqueKey, PersistentDataStorageFactory.Mode mode) {
        try {
            DerbyDataStorage result = new DerbyDataStorage(uniqueKey);
            result.connect();
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

