/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.derby;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.ForeignKeyConstraint;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

public class DerbyDataStorage
extends SQLDataStorage {
    private static final Logger logger = DLightLogger.getLogger(DerbyDataStorage.class);
    private static final String SQL_QUERY_DELIMETER = "";
    private static final File tmpDir;
    private static final AtomicInteger dbIndex;
    private final List<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    private String dbURL;

    public DerbyDataStorage() throws SQLException {
        this("jdbc:derby:DerbyDlight" + dbIndex.incrementAndGet() + ";create=true;user=dbuser;password=dbuserpswd");
    }

    private void initStorageTypes() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql:derby"));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    DerbyDataStorage(String url) throws SQLException {
        super(url);
        this.dbURL = url;
        this.initStorageTypes();
    }

    public String createForeignKeyConstraint(ForeignKeyConstraint fKey) {
        return " FOREIGN KEY (" + fKey.getColumn().getColumnName() + ") REFERENCES " + fKey.getReferenceTable().getName() + "(" + fKey.getReferenceColumn().getColumnName() + ") ";
    }

    String getURL() {
        return this.dbURL;
    }

    public boolean shutdown() {
        boolean result = super.shutdown();
        String dbName = this.dbURL.substring(this.dbURL.lastIndexOf(58) + 1, this.dbURL.indexOf(59));
        result = Util.deleteLocalDirectory((File)new File(tmpDir, dbName)) && result;
        return result;
    }

    protected String classToType(Class<?> clazz) {
        if (clazz == Integer.class) {
            return "integer";
        }
        return super.classToType(clazz);
    }

    protected final Connection doConnect() throws SQLException {
        Connection connection = DriverManager.getConnection(this.getDbURL());
        connection.setHoldability(1);
        return connection;
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        for (DataTableMetadata tdmd : tableMetadatas) {
            this.tables.put(tdmd.getName(), tdmd);
            this.createTable(tdmd);
        }
    }

    public String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public String getAutoIncrementExpresion() {
        return "GENERATED ALWAYS AS IDENTITY";
    }

    public String getPrimaryKeyExpression() {
        return "PRIMARY KEY";
    }

    public boolean hasData(DataTableMetadata data) {
        ArrayList toCheck = new ArrayList(this.tables.values());
        return data.isProvidedBy(toCheck);
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void loadSchema() {
    }

    static {
        dbIndex = new AtomicInteger();
        File tempDir = null;
        try {
            HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            tempDir = hi.getTempDirFile();
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (tempDir == null) {
            tempDir = new File(System.getProperty("java.io.tmpdir"));
        }
        tmpDir = new File(tempDir, "/derby_dlight");
        try {
            System.setProperty("derby.system.home", tmpDir.getAbsolutePath());
            Class<?> driver = Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
            logger.log(Level.INFO, "Driver for Derby(JavaDB) ({0}) Loaded ", driver.getName());
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (tmpDir.exists()) {
            final File[] files = tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.startsWith("DerbyDlight");
                }
            });
            int generalNameLength = "DerbyDlight".length();
            int newValue = 0;
            for (int i = 0; i < files.length; ++i) {
                String suffix = files[i].getName().substring(generalNameLength);
                try {
                    newValue = Math.max(newValue, Integer.valueOf(suffix));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            dbIndex.getAndSet(newValue);
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (File file : files) {
                        Util.deleteLocalDirectory((File)file);
                    }
                }
            }, (String)"DerbyDataStorage removing old data bases");
        }
    }
}

