/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.core.spi.multiview.SourceViewMarker;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;

public class FormEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie {
    private static final String MV_FORM_ID = "form";
    private static final String MV_JAVA_ID = "java";
    private static final int JAVA_ELEMENT_INDEX = 0;
    private static final int FORM_ELEMENT_INDEX = 1;
    private int elementToOpen;
    private static final String SECTION_INIT_COMPONENTS = "initComponents";
    private static final String SECTION_VARIABLES = "variables";
    private static final String iconURL = "org/netbeans/modules/form/resources/form.gif";
    private FormDataObject formDataObject;
    private CloneableTopComponent multiviewTC;
    private static PropertyChangeListener topcompsListener;
    private UndoRedo.Manager editorUndoManager;
    private FormEditor formEditor;
    private static final Set<FormEditorSupport> opened;
    private static Map<FileSystem, FileStatusListener> fsToStatusListener;
    private boolean saving;
    private static Boolean groupVisible;
    private FormGEditor guardedEditor;
    private GuardedSectionsProvider guardedProvider;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            if (FormEditorSupport.this.formEditor == null) {
                this.doSave(false);
            } else if (EventQueue.isDispatchThread()) {
                this.doSave(true);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            this.doSave(true);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
                }
            }
        }

        private void doSave(boolean bothJavaAndForm) {
            try {
                if (bothJavaAndForm) {
                    FormEditorSupport.this.saveDocument();
                } else {
                    FormEditorSupport.this.saveSourceOnly();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", ex);
            }
        }
    };
    private final CookieSet cookies;

    public FormEditorSupport(MultiDataObject.Entry javaEntry, FormDataObject formDataObject, CookieSet cookies) {
        super((DataObject)formDataObject, (CloneableEditorSupport.Env)new Environment((DataObject)formDataObject));
        this.setMIMEType("text/x-java");
        this.formDataObject = formDataObject;
        this.cookies = cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFormEditor(boolean forceFormElement) {
        boolean switchToForm;
        boolean alreadyOpened = opened.contains((Object)this);
        boolean bl = switchToForm = forceFormElement || !alreadyOpened;
        if (switchToForm) {
            this.elementToOpen = 1;
        }
        long ms = System.currentTimeMillis();
        try {
            this.showOpeningStatus("FMT_PreparingForm");
            this.multiviewTC = this.openCloneableTopComponent();
            this.multiviewTC.requestActive();
            if (switchToForm) {
                MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
                handler.requestActive(handler.getPerspectives()[1]);
            }
        }
        finally {
            this.hideOpeningStatus();
        }
        Logger.getLogger(FormEditor.class.getName()).log(Level.FINER, "Opening form time 1: {0}ms", System.currentTimeMillis() - ms);
    }

    void showOpeningStatus(String fmtMessage) {
        JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
        mainWin.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        mainWin.getGlassPane().setVisible(true);
        StatusDisplayer.getDefault().setStatusText(FormUtils.getFormattedBundleString(fmtMessage, new Object[]{this.formDataObject.getFormFile().getName()}));
        RepaintManager.currentManager(mainWin).paintDirtyRegions();
    }

    void hideOpeningStatus() {
        JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
        mainWin.getGlassPane().setVisible(false);
        mainWin.getGlassPane().setCursor(null);
        StatusDisplayer.getDefault().setStatusText("");
    }

    private void addStatusListener(FileSystem fs) {
        FileStatusListener fsl = fsToStatusListener.get(fs);
        if (fsl == null) {
            fsl = new FileStatusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void annotationChanged(FileStatusEvent ev) {
                    Set set = opened;
                    synchronized (set) {
                        for (FormEditorSupport fes : opened) {
                            if (!ev.hasChanged(fes.getFormDataObject().getPrimaryFile()) && !ev.hasChanged(fes.getFormDataObject().getFormFile())) continue;
                            fes.updateMVTCDisplayName();
                        }
                    }
                }
            };
            fs.addFileStatusListener(fsl);
            fsToStatusListener.put(fs, fsl);
        }
    }

    private static void detachStatusListeners() {
        for (Map.Entry<FileSystem, FileStatusListener> entry : fsToStatusListener.entrySet()) {
            FileSystem fs = entry.getKey();
            FileStatusListener fsl = entry.getValue();
            fs.removeFileStatusListener(fsl);
        }
        fsToStatusListener.clear();
    }

    void selectJavaEditor() {
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (handler != null) {
            handler.requestActive(handler.getPerspectives()[0]);
        }
    }

    protected boolean asynchronousOpen() {
        return false;
    }

    public void open() {
        if (EventQueue.isDispatchThread()) {
            this.openInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormEditorSupport.this.openInAWT();
                }
            });
        }
    }

    private void openInAWT() {
        if (!this.formDataObject.isValid()) {
            return;
        }
        if (Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("nonEditableTemplate"))) {
            String pattern = FormUtils.getBundleString("MSG_NonEditableTemplate");
            String message = MessageFormat.format(pattern, this.formDataObject.getNodeDelegate().getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            return;
        }
        this.elementToOpen = 0;
        super.open();
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (handler != null) {
            handler.requestActive(handler.getPerspectives()[0]);
        }
    }

    public void openAt(PositionRef pos) {
        this.elementToOpen = 0;
        this.openCloneableTopComponent();
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        handler.requestActive(handler.getPerspectives()[0]);
        this.openAt(pos, -1).getComponent().requestActive();
    }

    public void openAt(Position pos) {
        this.openAt(this.createPositionRef(pos.getOffset(), Position.Bias.Forward));
    }

    public boolean loadForm() {
        this.getFormEditor(true);
        return this.formEditor.loadForm();
    }

    public boolean isOpened() {
        return this.formEditor != null && this.formEditor.isFormLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        IOException ioEx = null;
        try {
            if (this.formEditor != null) {
                this.formEditor.saveFormData();
            }
            this.saving = true;
            super.saveDocument();
        }
        catch (PersistenceException ex) {
            Throwable t = ex.getOriginalException();
            if (t instanceof IOException) {
                ioEx = (IOException)t;
            } else {
                ioEx = new IOException("Cannot save the form");
                ErrorManager.getDefault().annotate((Throwable)ioEx, t != null ? t : ex);
            }
        }
        finally {
            this.saving = false;
        }
        if (this.formEditor != null) {
            this.formEditor.reportErrors(2);
        }
        if (ioEx != null) {
            throw ioEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveSourceOnly() throws IOException {
        try {
            this.saving = true;
            super.saveDocument();
        }
        finally {
            this.saving = false;
        }
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        return FormEditor.getFormDataObject(formModel);
    }

    public FormModel getFormModel() {
        FormEditor fe = this.getFormEditor();
        return fe == null ? null : fe.getFormModel();
    }

    public FormEditor getFormEditor() {
        return this.getFormEditor(false);
    }

    FormEditor getFormEditor(boolean initialize) {
        if (this.formEditor == null && initialize) {
            this.formEditor = new FormEditor(this.formDataObject);
        }
        return this.formEditor;
    }

    void markFormModified() {
        if (this.formEditor != null && this.formEditor.isFormLoaded() && !this.formDataObject.isModified()) {
            this.notifyModified();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.editorUndoManager = super.createUndoRedoManager();
        return this.editorUndoManager;
    }

    void discardEditorUndoableEdits() {
        if (this.editorUndoManager != null) {
            this.editorUndoManager.discardAllEdits();
        }
    }

    JEditorPane getEditorPane() {
        return this.multiviewTC != null ? ((CloneableEditorSupport.Pane)this.multiviewTC).getEditorPane() : null;
    }

    public void reloadForm() {
        if (this.canClose()) {
            this.reloadDocument();
        }
    }

    protected Task reloadDocument() {
        if (this.multiviewTC == null) {
            return super.reloadDocument();
        }
        Task docLoadTask = super.reloadDocument();
        if (this.saving) {
            return docLoadTask;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FormDesigner formDesigner = FormEditorSupport.this.getFormEditor(true).getFormDesigner();
                if (formDesigner == null) {
                    if (FormEditorSupport.this.multiviewTC == null) {
                        return;
                    }
                    formDesigner = (FormDesigner)((Object)FormEditorSupport.this.multiviewTC.getClientProperty((Object)"formDesigner"));
                }
                if (formDesigner == null) {
                    return;
                }
                FormEditorSupport.this.getFormEditor().closeForm();
                FormEditorSupport.this.formEditor = null;
                formDesigner.reset(FormEditorSupport.this.getFormEditor(true));
                FormEditorSupport.this.getFormEditor().setFormDesigner(formDesigner);
                if (formDesigner.isShowing()) {
                    FormEditorSupport.this.loadForm();
                    FormEditor formEditor = FormEditorSupport.this.getFormEditor();
                    formEditor.reportErrors(1);
                    if (!formEditor.isFormLoaded()) {
                        formDesigner.removeAll();
                    } else {
                        formDesigner.initialize();
                    }
                    ComponentInspector.getInstance().focusForm(formEditor);
                    formDesigner.revalidate();
                    formDesigner.repaint();
                }
            }
        });
        return docLoadTask;
    }

    public FormEditor reloadFormEditor() {
        if (this.formEditor == null || !this.formEditor.isFormLoaded()) {
            return null;
        }
        FormDesigner formDesigner = this.formEditor.getFormDesigner();
        if (formDesigner == null) {
            formDesigner = (FormDesigner)((Object)this.multiviewTC.getClientProperty((Object)"formDesigner"));
        }
        this.formEditor.closeForm();
        this.formEditor = null;
        this.formEditor = this.getFormEditor(true);
        if (formDesigner != null) {
            formDesigner.reset(this.formEditor);
            this.formEditor.setFormDesigner(formDesigner);
        }
        this.loadForm();
        this.formEditor.reportErrors(1);
        if (this.formEditor.isFormLoaded() && formDesigner != null && formDesigner.isShowing()) {
            formDesigner.initialize();
        }
        return this.formEditor;
    }

    public void closeFormEditor() {
        if (this.isOpened()) {
            final FormDesigner formDesigner = this.formEditor.getFormDesigner();
            this.formEditor.closeForm();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (formDesigner != null) {
                        formDesigner.reset(FormEditorSupport.this.formEditor);
                    }
                    FormEditorSupport.this.selectJavaEditor();
                }
            };
            if (EventQueue.isDispatchThread()) {
                run.run();
            } else {
                try {
                    EventQueue.invokeAndWait(run);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    protected void notifyClosed() {
        opened.remove((Object)this);
        if (opened.isEmpty()) {
            FormEditorSupport.detachTopComponentsListener();
            FormEditorSupport.detachStatusListeners();
        }
        super.notifyClosed();
        if (this.formEditor != null) {
            this.formEditor.closeForm();
            this.formEditor = null;
        }
        this.multiviewTC = null;
        this.guardedProvider = null;
        this.guardedEditor = null;
        this.elementToOpen = 0;
    }

    private void multiViewClosed(CloneableTopComponent mvtc) {
        boolean isLast;
        Enumeration en = mvtc.getReference().getComponents();
        boolean bl = isLast = !en.hasMoreElements();
        if (this.multiviewTC == mvtc) {
            this.multiviewTC = null;
            FormDesigner formDesigner = null;
            while (en.hasMoreElements()) {
                this.multiviewTC = (CloneableTopComponent)en.nextElement();
                FormDesigner designer = (FormDesigner)((Object)this.multiviewTC.getClientProperty((Object)"formDesigner"));
                if (designer == null) continue;
                formDesigner = designer;
                break;
            }
            if (!isLast && formDesigner == null && this.formEditor != null) {
                this.formEditor.closeForm();
                this.formEditor = null;
            }
        }
        if (isLast) {
            this.notifyClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean alreadyModified = this.isModified();
        boolean retVal = super.notifyModified();
        if (retVal) {
            this.addSaveCookie();
        }
        if (!alreadyModified) {
            FileObject formFile = this.formDataObject.getFormFile();
            if (!formFile.canWrite()) {
                FileLock lock = null;
                try {
                    lock = formFile.lock();
                }
                catch (UserQuestionException uqex) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)uqex.getLocalizedMessage(), FormUtils.getBundleString("TITLE_UserQuestion"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (NotifyDescriptor.YES_OPTION.equals(nd.getValue())) {
                        try {
                            uqex.confirmed();
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    FormEditorSupport.this.reloadForm();
                                }
                            });
                        }
                        catch (IOException ioex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioex);
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            this.updateMVTCDisplayName();
        }
        return retVal;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
        this.updateMVTCDisplayName();
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if ("activated".equals(ev.getPropertyName())) {
                    FormEditorSupport fes;
                    TopComponent active = TopComponent.getRegistry().getActivated();
                    if (FormEditorSupport.getSelectedElementType(active) != -1 && (fes = FormEditorSupport.getFormEditor(active)) != null) {
                        fes.multiviewTC = (CloneableTopComponent)active;
                        FormDesigner designer = (FormDesigner)((Object)active.getClientProperty((Object)"formDesigner"));
                        if (designer != null) {
                            fes.getFormEditor().setFormDesigner(designer);
                        }
                    }
                    FormEditorSupport.checkFormGroupVisibility();
                } else if ("opened".equals(ev.getPropertyName())) {
                    FormEditorSupport fes;
                    TopComponent active;
                    Set oldSet = (Set)ev.getOldValue();
                    Set newSet = (Set)ev.getNewValue();
                    if (newSet.size() < oldSet.size()) {
                        for (Object o : oldSet) {
                            FormEditorSupport fes2;
                            CloneableTopComponent closedTC;
                            if (newSet.contains(o) || !(o instanceof CloneableTopComponent) || FormEditorSupport.getSelectedElementType((TopComponent)(closedTC = (CloneableTopComponent)o)) == -1 || (fes2 = FormEditorSupport.getFormEditor((TopComponent)closedTC)) == null) continue;
                            fes2.multiViewClosed(closedTC);
                        }
                    }
                    if ((active = TopComponent.getRegistry().getActivated()) != null && FormEditorSupport.getSelectedElementType(active) != -1 && (fes = FormEditorSupport.getFormEditor(active)) != null) {
                        fes.updateMVTCDisplayName();
                    }
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
            TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup(MV_FORM_ID);
            if (group != null) {
                group.close();
            }
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        if (!this.formDataObject.isValid()) {
            return super.createPane();
        }
        MultiViewDescription[] descs = new MultiViewDescription[]{new JavaDesc((DataObject)this.formDataObject), new FormDesc((DataObject)this.formDataObject)};
        CloneableTopComponent mvtc = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])descs, (MultiViewDescription)descs[this.elementToOpen], (CloseOperationHandler)new CloseHandler((DataObject)this.formDataObject));
        Mode editorMode = WindowManager.getDefault().findMode("editor");
        if (editorMode != null) {
            editorMode.dockInto((TopComponent)mvtc);
        }
        return (CloneableEditorSupport.Pane)mvtc;
    }

    private static boolean readOnly(FormDataObject formDataObject) {
        FormModel fm;
        FormEditorSupport fes;
        if (!formDataObject.getPrimaryFile().canWrite()) {
            return true;
        }
        TopComponent active = TopComponent.getRegistry().getActivated();
        if (active != null && FormEditorSupport.getSelectedElementType(active) == 1 && (fes = formDataObject.getFormEditor()) != null && (fm = fes.getFormModel()) != null) {
            return fm.isReadOnly();
        }
        return false;
    }

    private static String getMVTCToolTipText(FormDataObject formDataObject) {
        return DataEditorSupport.toolTip((FileObject)formDataObject.getPrimaryFile(), (boolean)formDataObject.isModified(), (boolean)FormEditorSupport.readOnly(formDataObject));
    }

    private static String[] getMVTCDisplayName(FormDataObject formDataObject) {
        FormDesigner fd;
        FormModel fm;
        FormEditorSupport fes;
        Node node = formDataObject.getNodeDelegate();
        String title = node.getDisplayName();
        String htmlTitle = node.getHtmlDisplayName();
        if (htmlTitle == null) {
            try {
                htmlTitle = XMLUtil.toElementContent((String)title);
            }
            catch (CharConversionException x) {
                htmlTitle = "???";
            }
        }
        if ((fes = formDataObject.getFormEditor()) != null && (fm = fes.getFormModel()) != null && (fd = FormEditor.getFormDesigner(formDataObject.getFormEditor().getFormModel())) != null && fd.getFormModel() != null && fd.isShowing() && !fd.isTopRADComponent() && fd.getTopDesignComponent() != null) {
            title = FormUtils.getFormattedBundleString("FMT_FormTitleWithContainerName", new Object[]{title, fd.getTopDesignComponent().getName()});
            htmlTitle = FormUtils.getFormattedBundleString("FMT_FormTitleWithContainerName", new Object[]{htmlTitle, fd.getTopDesignComponent().getName()});
        }
        boolean modified = formDataObject.isModified();
        boolean readOnly = FormEditorSupport.readOnly(formDataObject);
        return new String[]{DataEditorSupport.annotateName((String)title, (boolean)false, (boolean)modified, (boolean)readOnly), DataEditorSupport.annotateName((String)htmlTitle, (boolean)true, (boolean)modified, (boolean)readOnly)};
    }

    void updateMVTCDisplayName() {
        if (EventQueue.isDispatchThread()) {
            this.updateMVTCDisplayNameInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormEditorSupport.this.updateMVTCDisplayNameInAWT();
                }
            });
        }
    }

    private void updateMVTCDisplayNameInAWT() {
        if (this.multiviewTC == null || !this.formDataObject.isValid()) {
            return;
        }
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        Enumeration en = this.multiviewTC.getReference().getComponents();
        while (en.hasMoreElements()) {
            TopComponent tc = (TopComponent)en.nextElement();
            tc.setDisplayName(titles[0]);
            tc.setHtmlDisplayName(titles[1]);
        }
    }

    void updateMVTCToolTipText() {
        if (EventQueue.isDispatchThread()) {
            if (this.multiviewTC == null) {
                return;
            }
            String tooltip = FormEditorSupport.getMVTCToolTipText(this.formDataObject);
            Enumeration en = this.multiviewTC.getReference().getComponents();
            while (en.hasMoreElements()) {
                TopComponent tc = (TopComponent)en.nextElement();
                tc.setToolTipText(tooltip);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FormEditorSupport.this.multiviewTC == null) {
                        return;
                    }
                    String tooltip = FormEditorSupport.getMVTCToolTipText(FormEditorSupport.this.formDataObject);
                    Enumeration en = FormEditorSupport.this.multiviewTC.getReference().getComponents();
                    while (en.hasMoreElements()) {
                        TopComponent tc = (TopComponent)en.nextElement();
                        tc.setToolTipText(tooltip);
                    }
                }
            });
        }
    }

    static boolean isLastView(TopComponent tc) {
        if (!(tc instanceof CloneableTopComponent)) {
            return false;
        }
        boolean oneOrLess = true;
        Enumeration en = ((CloneableTopComponent)tc).getReference().getComponents();
        if (en.hasMoreElements()) {
            en.nextElement();
            if (en.hasMoreElements()) {
                oneOrLess = false;
            }
        }
        return oneOrLess;
    }

    void setTopComponent(TopComponent topComp) {
        this.multiviewTC = (CloneableTopComponent)topComp;
        String[] titles = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        this.multiviewTC.setDisplayName(titles[0]);
        this.multiviewTC.setHtmlDisplayName(titles[1]);
        this.multiviewTC.setToolTipText(FormEditorSupport.getMVTCToolTipText(this.formDataObject));
        opened.add(this);
        FormEditorSupport.attachTopComponentsListener();
        try {
            this.addStatusListener(this.formDataObject.getPrimaryFile().getFileSystem());
        }
        catch (FileStateInvalidException fsiex) {
            fsiex.printStackTrace();
        }
    }

    public static FormEditorSupport getFormEditor(TopComponent tc) {
        Object dobj = tc.getLookup().lookup(DataObject.class);
        return dobj instanceof FormDataObject ? ((FormDataObject)((Object)dobj)).getFormEditorSupport() : null;
    }

    static void checkFormGroupVisibility() {
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup(MV_FORM_ID);
        if (group == null) {
            return;
        }
        boolean designerSelected = false;
        for (Mode mode : wm.getModes()) {
            TopComponent selected = mode.getSelectedTopComponent();
            if (FormEditorSupport.getSelectedElementType(selected) != 1) continue;
            designerSelected = true;
            break;
        }
        if (designerSelected && !Boolean.TRUE.equals(groupVisible)) {
            ComponentInspector inspector;
            groupVisible = Boolean.FALSE;
            group.open();
            groupVisible = Boolean.TRUE;
            TopComponentGroup paletteGroup = wm.findTopComponentGroup("commonpalette");
            if (null != paletteGroup) {
                paletteGroup.open();
            }
            if (!Boolean.TRUE.equals((inspector = ComponentInspector.getInstance()).getClientProperty("isSliding"))) {
                inspector.requestVisible();
            }
        } else if (!designerSelected && !Boolean.FALSE.equals(groupVisible)) {
            group.close();
            groupVisible = Boolean.FALSE;
        }
    }

    static int getSelectedElementType(TopComponent tc) {
        MultiViewHandler handler;
        if (tc != null && (handler = MultiViews.findMultiViewHandler((TopComponent)tc)) != null) {
            String prefId = handler.getSelectedPerspective().preferredID();
            if (MV_JAVA_ID.equals(prefId)) {
                return 0;
            }
            if (MV_FORM_ID.equals(prefId)) {
                return 1;
            }
        }
        return -1;
    }

    public SimpleSection getVariablesSection() {
        return this.getGuardedSectionManager().findSimpleSection(SECTION_VARIABLES);
    }

    public SimpleSection getInitComponentSection() {
        return this.getGuardedSectionManager().findSimpleSection(SECTION_INIT_COMPONENTS);
    }

    public GuardedSectionManager getGuardedSectionManager() {
        try {
            StyledDocument doc;
            block4: {
                doc = null;
                try {
                    doc = this.openDocument();
                }
                catch (UserQuestionException uqex) {
                    Object retVal = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)uqex.getLocalizedMessage(), 0));
                    if (NotifyDescriptor.YES_OPTION != retVal) break block4;
                    uqex.confirmed();
                    doc = this.openDocument();
                }
            }
            return doc == null ? null : GuardedSectionManager.getInstance((StyledDocument)doc);
        }
        catch (IOException ex) {
            throw (IllegalStateException)new IllegalStateException("cannot open document").initCause(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        if (this.guardedEditor == null) {
            this.guardedEditor = new FormGEditor();
            GuardedSectionsFactory gFactory = GuardedSectionsFactory.find((String)((DataEditorSupport.Env)this.env).getMimeType());
            if (gFactory != null) {
                this.guardedProvider = gFactory.create((GuardedEditorSupport)this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            this.guardedEditor.doc = doc;
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Reader reader = this.guardedProvider.createGuardedReader(stream, c);
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKit(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = this.guardedProvider.createGuardedWriter(stream, c);
            try {
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    public void addSaveCookie() {
        DataObject javaData = this.getDataObject();
        if (javaData.getCookie(SaveCookie.class) == null) {
            this.cookies.add((Node.Cookie)this.saveCookie);
            javaData.setModified(true);
        }
    }

    public void removeSaveCookie() {
        DataObject javaData = this.getDataObject();
        if (javaData.getCookie(SaveCookie.class) != null) {
            this.cookies.remove((Node.Cookie)this.saveCookie);
            javaData.setModified(false);
        }
    }

    static {
        opened = Collections.synchronizedSet(new HashSet());
        fsToStatusListener = new HashMap<FileSystem, FileStatusListener>();
        groupVisible = null;
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;

        public Environment(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((FormDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(FormEditorSupport.class);
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744315424172415L;
        private DataObject dataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject formDO) {
            this.dataObject = formDO;
        }

        private FormEditorSupport getFormEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public boolean resolveCloseOperation(CloseOperationState[] elements) {
            FormEditorSupport formEditor = this.getFormEditor();
            return formEditor != null ? formEditor.canClose() : true;
        }
    }

    private static class JavaEditorTopComponent
    extends CloneableEditor
    implements MultiViewElement {
        private static final long serialVersionUID = -3126744316624172415L;
        private transient JComponent toolbar;
        private transient MultiViewElementCallback multiViewObserver;

        JavaEditorTopComponent() {
        }

        JavaEditorTopComponent(DataEditorSupport s) {
            super((CloneableEditorSupport)s);
        }

        public JComponent getToolbarRepresentation() {
            if (this.toolbar == null) {
                Document doc;
                JEditorPane pane = this.getEditorPane();
                if (pane != null && (doc = pane.getDocument()) instanceof NbDocument.CustomToolbar) {
                    this.toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(pane);
                }
                if (this.toolbar == null) {
                    this.toolbar = new JPanel();
                }
            }
            return this.toolbar;
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void setMultiViewCallback(MultiViewElementCallback callback) {
            this.multiViewObserver = callback;
            if (((DataEditorSupport)this.cloneableEditorSupport()).getDataObject() instanceof FormDataObject) {
                ((FormDataObject)((DataEditorSupport)this.cloneableEditorSupport()).getDataObject()).getFormEditorSupport().setTopComponent(callback.getTopComponent());
            }
        }

        public void requestVisible() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestVisible();
            } else {
                super.requestVisible();
            }
        }

        public void requestActive() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestActive();
            } else {
                super.requestActive();
            }
        }

        public void componentClosed() {
            super.canClose(null, true);
            super.componentClosed();
        }

        public void componentShowing() {
            JavaCodeGenerator codeGen;
            FormEditorSupport fe;
            super.componentShowing();
            DataObject dob = ((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
            FormDataObject formDO = (FormDataObject)dob;
            FormModel model = null;
            if (formDO != null && (fe = formDO.getFormEditor()) != null && (model = fe.getFormModel()) != null && (codeGen = (JavaCodeGenerator)FormEditor.getCodeGenerator(model)) != null) {
                codeGen.regenerateCode();
            }
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentOpened() {
            super.componentOpened();
            DataObject dob = ((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
            if (this.multiViewObserver != null && !(dob instanceof FormDataObject)) {
                this.multiViewObserver.getTopComponent().close();
                EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
                ec.open();
            }
        }

        public void updateName() {
            super.updateName();
            if (this.multiViewObserver != null) {
                FormDataObject formDataObject = (FormDataObject)((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
                String[] titles = FormEditorSupport.getMVTCDisplayName(formDataObject);
                this.setDisplayName(titles[0]);
                this.setHtmlDisplayName(titles[1]);
            }
        }

        protected boolean closeLast() {
            return true;
        }

        public CloseOperationState canCloseElement() {
            if (!FormEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
                return CloseOperationState.STATE_OK;
            }
            return MultiViewFactory.createUnsafeCloseState((String)"ID_JAVA_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
        }

        protected boolean isActiveTC() {
            TopComponent selected = JavaEditorTopComponent.getRegistry().getActivated();
            if (selected == null) {
                return false;
            }
            if (selected == this) {
                return true;
            }
            MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)selected);
            return handler != null && FormEditorSupport.MV_JAVA_ID.equals(handler.getSelectedPerspective().preferredID());
        }
    }

    private static class JavaDesc
    implements MultiViewDescription,
    SourceViewMarker,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private DataObject dataObject;

        private JavaDesc() {
        }

        public JavaDesc(DataObject formDO) {
            this.dataObject = formDO;
        }

        private FormEditorSupport getJavaEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public MultiViewElement createElement() {
            FormEditorSupport javaEditor = this.getJavaEditor();
            if (javaEditor != null) {
                javaEditor.prepareDocument();
                JavaEditorTopComponent editor = new JavaEditorTopComponent((DataEditorSupport)this.dataObject.getCookie(FormEditorSupport.class));
                Node[] nodes = editor.getActivatedNodes();
                if (nodes == null || nodes.length == 0) {
                    editor.setActivatedNodes(new Node[]{this.dataObject.getNodeDelegate()});
                }
                return editor;
            }
            return MultiViewFactory.BLANK_ELEMENT;
        }

        public String getDisplayName() {
            return FormUtils.getBundleString("CTL_SourceTabCaption");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)FormEditorSupport.iconURL);
        }

        public int getPersistenceType() {
            return 1;
        }

        public String preferredID() {
            return FormEditorSupport.MV_JAVA_ID;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.dataObject);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Object firstObject = in.readObject();
            if (firstObject instanceof FormDataObject) {
                this.dataObject = (DataObject)firstObject;
            }
        }
    }

    private static class FormDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private DataObject dataObject;

        private FormDesc() {
        }

        public FormDesc(DataObject formDO) {
            this.dataObject = formDO;
        }

        private FormEditorSupport getFormEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public MultiViewElement createElement() {
            FormEditorSupport formEditor = this.getFormEditor();
            return new FormDesigner(formEditor == null ? null : formEditor.getFormEditor(true));
        }

        public String getDisplayName() {
            return FormUtils.getBundleString("CTL_DesignTabCaption");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)FormEditorSupport.iconURL);
        }

        public int getPersistenceType() {
            return 2;
        }

        public String preferredID() {
            return FormEditorSupport.MV_FORM_ID;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.dataObject);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Object firstObject = in.readObject();
            if (firstObject instanceof FormDataObject) {
                this.dataObject = (DataObject)firstObject;
            }
        }
    }

    private final class FormGEditor
    implements GuardedEditorSupport {
        StyledDocument doc = null;

        private FormGEditor() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }
}

