/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.validation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import nu.validator.htmlparser.sax.HtmlSerializer;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.ResultHandler;
import nu.validator.messages.TextMessageTextHandler;
import nu.validator.messages.types.MessageType;
import nu.validator.source.SourceHandler;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.modules.html.validation.LinesMapper;
import org.netbeans.modules.html.validation.ProblemsHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NbMessageEmitter
extends MessageEmitter {
    private static final char[] COLON_SPACE = new char[]{':', ' '};
    private static final char[] PERIOD = new char[]{'.'};
    private static final char[] ON_LINE = "On line ".toCharArray();
    private static final char[] AT_LINE = "At line ".toCharArray();
    private static final char[] FROM_LINE = "From line ".toCharArray();
    private static final char[] TO_LINE = "; to line ".toCharArray();
    private static final char[] COLUMN = ", column ".toCharArray();
    private static final char[] IN_RESOURCE = " in resource ".toCharArray();
    private TextMessageTextHandler messageTextHandler;
    private String systemId;
    private int oneBasedFirstLine;
    private int oneBasedFirstColumn;
    private int oneBasedLastLine;
    private int oneBasedLastColumn;
    private boolean textEmitted;
    private HtmlSerializer contentHandler;
    private ProblemsHandler problemsHandler;
    private int problemType;
    private LinesMapper linesMapper;
    private Writer writer;
    private boolean asciiQuotes;
    private ContentHandler elaborationContentHandler;

    public NbMessageEmitter(ProblemsHandler problemsHandler, LinesMapper linesMapper, boolean asciiQuotes) {
        this.problemsHandler = problemsHandler;
        this.linesMapper = linesMapper;
        this.asciiQuotes = asciiQuotes;
    }

    private void emitErrorLevel(char[] level) throws IOException {
        this.writer.write(level, 0, level.length);
    }

    private void maybeEmitLocation() throws IOException {
        if (this.oneBasedLastLine == -1 && this.systemId == null) {
            return;
        }
        if (this.oneBasedLastLine == -1) {
            this.emitSystemId();
        } else if (this.oneBasedLastColumn == -1) {
            this.emitLineLocation();
        } else if (this.oneBasedFirstLine == -1 || this.oneBasedFirstLine == this.oneBasedLastLine && this.oneBasedFirstColumn == this.oneBasedLastColumn) {
            this.emitSingleLocation();
        } else {
            this.emitRangeLocation();
        }
        this.writer.write(10);
    }

    private void maybeEmitInResource() throws IOException {
        if (this.systemId != null) {
            this.writer.write(IN_RESOURCE);
            this.emitSystemId();
        }
    }

    private void emitSystemId() throws IOException {
        this.writer.write(this.systemId);
    }

    private void emitRangeLocation() throws IOException {
        this.writer.write(FROM_LINE);
        this.writer.write(Integer.toString(this.oneBasedFirstLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedFirstColumn));
        this.writer.write(TO_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedLastColumn));
        this.maybeEmitInResource();
    }

    private void emitSingleLocation() throws IOException {
        this.writer.write(AT_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.writer.write(COLUMN);
        this.writer.write(Integer.toString(this.oneBasedLastColumn));
        this.maybeEmitInResource();
    }

    private void emitLineLocation() throws IOException {
        this.writer.write(ON_LINE);
        this.writer.write(Integer.toString(this.oneBasedLastLine));
        this.maybeEmitInResource();
    }

    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        this.writer = new StringWriter();
        this.elaborationContentHandler = new SimplifiedMessagesContentHandler(this.writer);
        this.messageTextHandler = new TextMessageTextHandler(this.writer, this.asciiQuotes);
        this.contentHandler = new HtmlSerializer(this.writer);
        this.systemId = systemId;
        this.oneBasedFirstLine = oneBasedFirstLine;
        this.oneBasedFirstColumn = oneBasedFirstColumn;
        this.oneBasedLastLine = oneBasedLastLine;
        this.oneBasedLastColumn = oneBasedLastColumn;
        try {
            this.emitErrorLevel(type.getPresentationName());
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.textEmitted = false;
        this.problemType = NbMessageEmitter.messageTypeToProblemType(type);
    }

    private static int messageTypeToProblemType(MessageType type) {
        if (type == MessageType.INFO) {
            return 0;
        }
        if (type == MessageType.WARNING) {
            return 1;
        }
        if (type == MessageType.FATAL) {
            return 3;
        }
        if (type == MessageType.INTERNAL) {
            return 4;
        }
        return 2;
    }

    public void startMessages(String documentUri, boolean willShowSource) throws SAXException {
        this.problemsHandler.startProblems();
    }

    public void endMessages() throws SAXException {
        this.problemsHandler.endProblems();
    }

    public void endText() throws SAXException {
        try {
            this.writer.write(10);
            this.textEmitted = true;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public MessageTextHandler startText() throws SAXException {
        try {
            this.writer.write(COLON_SPACE);
            return this.messageTextHandler;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endMessage() throws SAXException {
        int to;
        int from;
        try {
            if (!this.textEmitted) {
                this.writer.write(PERIOD);
                this.writer.write(10);
            }
            this.maybeEmitLocation();
            this.writer.write(10);
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
        if (this.oneBasedFirstLine == -1) {
            from = 0;
            to = this.linesMapper.getLinesCount() > 0 ? this.linesMapper.getLine(0).getEnd() : 0;
        } else {
            int linefrom = -1;
            int lineto = -1;
            int columnfrom = -1;
            int columnto = -1;
            if (this.oneBasedFirstLine != -1) {
                linefrom = this.oneBasedFirstLine;
                int n = columnfrom = this.oneBasedFirstColumn == -1 ? 0 : this.oneBasedFirstColumn;
            }
            if (this.oneBasedLastLine != -1) {
                lineto = this.oneBasedLastLine;
                columnto = this.oneBasedLastColumn == -1 ? 0 : this.oneBasedLastColumn;
            } else {
                lineto = linefrom;
                columnto = 1;
            }
            from = this.linesMapper.getSourceOffsetForLocation(linefrom - 1, columnfrom - 1);
            to = this.linesMapper.getSourceOffsetForLocation(lineto - 1, columnto);
        }
        this.problemsHandler.addProblem(ProblemDescription.create((String)"nu.validator.issue", (String)this.writer.toString(), (int)this.problemType, (int)from, (int)to));
    }

    public ResultHandler startResult() throws SAXException {
        return null;
    }

    public ContentHandler startElaboration() throws SAXException {
        return this.elaborationContentHandler;
    }

    public SourceHandler startFullSource(int lineOffset) throws SAXException {
        return super.startFullSource(lineOffset);
    }

    public SourceHandler startSource() throws SAXException {
        return super.startSource();
    }

    private static class SimplifiedMessagesContentHandler
    implements ContentHandler {
        private static boolean inDD;
        private static boolean inDL;
        private static boolean inDT;
        private static boolean inCODE;
        private Writer out;
        private static final String DL = "dl";
        private static final String DT = "dt";
        private static final String DD = "dd";
        private static final String CODE = "code";

        public SimplifiedMessagesContentHandler(Writer out) {
            this.out = out;
        }

        private void write(String s) throws SAXException {
            try {
                this.out.write(s);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            inDD = false;
            inDT = false;
            inDL = false;
            inCODE = false;
            this.write("\n");
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (DL.equals(localName)) {
                inDL = true;
            } else if (DT.equals(localName)) {
                inDT = true;
            } else if (DD.equals(localName)) {
                inDD = true;
            } else if (CODE.equals(localName)) {
                inCODE = true;
                this.write("'");
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (DL.equals(localName)) {
                inDL = false;
            } else if (DT.equals(localName)) {
                inDT = false;
                this.write("\n");
            } else if (DD.equals(localName)) {
                inDD = false;
                this.write("\n");
            } else if (CODE.equals(localName)) {
                inCODE = false;
                this.write("'");
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (inDL && (inDD || inDT || inCODE)) {
                this.write(new String(ch, start, length));
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

