/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexRow;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class IndexChanger {
    private IndexRowGenerator irg;
    private long indexCID;
    private DynamicCompiledOpenConglomInfo indexDCOCI;
    private StaticCompiledOpenConglomInfo indexSCOCI;
    private String indexName;
    private ConglomerateController baseCC;
    private TransactionController tc;
    private int lockMode;
    private FormatableBitSet baseRowReadMap;
    private ConglomerateController indexCC = null;
    private ScanController indexSC = null;
    private LanguageConnectionContext lcc;
    private ExecIndexRow ourIndexRow = null;
    private ExecIndexRow ourUpdatedIndexRow = null;
    private TemporaryRowHolderImpl rowHolder = null;
    private boolean rowHolderPassedIn;
    private int isolationLevel;
    private Activation activation;
    private boolean ownIndexSC = true;

    public IndexChanger(IndexRowGenerator indexRowGenerator, long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo, String string, ConglomerateController conglomerateController, TransactionController transactionController, int n, FormatableBitSet formatableBitSet, int n2, Activation activation) throws StandardException {
        this.irg = indexRowGenerator;
        this.indexCID = l;
        this.indexSCOCI = staticCompiledOpenConglomInfo;
        this.indexDCOCI = dynamicCompiledOpenConglomInfo;
        this.baseCC = conglomerateController;
        this.tc = transactionController;
        this.lockMode = n;
        this.baseRowReadMap = formatableBitSet;
        this.rowHolderPassedIn = false;
        this.isolationLevel = n2;
        this.activation = activation;
        this.indexName = string;
        if (activation != null && activation.getIndexConglomerateNumber() == l) {
            this.ownIndexSC = false;
        }
    }

    public void setRowHolder(TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.rowHolder = temporaryRowHolderImpl;
        this.rowHolderPassedIn = temporaryRowHolderImpl != null;
    }

    public void setBaseCC(ConglomerateController conglomerateController) {
        this.baseCC = conglomerateController;
    }

    private void setOurIndexRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.ourIndexRow == null) {
            this.ourIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(execRow, rowLocation, this.ourIndexRow, this.baseRowReadMap);
    }

    private void setOurUpdatedIndexRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.ourUpdatedIndexRow == null) {
            this.ourUpdatedIndexRow = this.irg.getIndexRowTemplate();
        }
        this.irg.getIndexRow(execRow, rowLocation, this.ourUpdatedIndexRow, this.baseRowReadMap);
    }

    private boolean indexRowChanged() throws StandardException {
        int n = this.ourIndexRow.nColumns();
        for (int i = 1; i <= n; ++i) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = this.ourIndexRow.getColumn(i);
            if (dataValueDescriptor2.compare(2, dataValueDescriptor = this.ourUpdatedIndexRow.getColumn(i), true, true)) continue;
            return true;
        }
        return false;
    }

    private ExecIndexRow getDeferredIndexRowTemplate(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        ExecIndexRow execIndexRow = this.irg.getIndexRowTemplate();
        this.irg.getIndexRow(execRow, rowLocation, execIndexRow, this.baseRowReadMap);
        return execIndexRow;
    }

    private void setScan() throws StandardException {
        if (!this.ownIndexSC) {
            this.indexSC = this.activation.getIndexScanController();
        } else if (this.indexSC == null) {
            RowLocation rowLocation = this.baseCC.newRowLocationTemplate();
            this.indexSC = this.indexSCOCI == null ? this.tc.openScan(this.indexCID, false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1) : this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1, this.indexSCOCI, this.indexDCOCI);
        } else {
            this.indexSC.reopenScan(this.ourIndexRow.getRowArray(), 1, null, this.ourIndexRow.getRowArray(), -1);
        }
    }

    private void closeIndexCC() throws StandardException {
        if (this.indexCC != null) {
            this.indexCC.close();
        }
        this.indexCC = null;
    }

    private void closeIndexSC() throws StandardException {
        if (this.ownIndexSC && this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
    }

    private void doDelete() throws StandardException {
        if (this.ownIndexSC && !this.indexSC.next()) {
            Object[] objectArray = new Object[]{this.ourIndexRow.getRowArray()[this.ourIndexRow.getRowArray().length - 1], new Long(this.indexCID)};
            Monitor.getStream().println(MessageService.getCompleteMessage("X0Y83.S", objectArray));
            return;
        }
        this.indexSC.delete();
    }

    private void doInsert() throws StandardException {
        this.insertAndCheckDups(this.ourIndexRow);
    }

    private void doDeferredInsert() throws StandardException {
        if (this.rowHolder == null) {
            Properties properties = new Properties();
            this.openIndexCC().getInternalTablePropertySet(properties);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, null);
        }
        if (!this.rowHolderPassedIn) {
            this.rowHolder.insert(this.ourIndexRow);
        }
    }

    private void insertAndCheckDups(ExecIndexRow execIndexRow) throws StandardException {
        this.openIndexCC();
        int n = this.indexCC.insert(execIndexRow.getRowArray());
        if (n == 1) {
            Object object;
            String string = this.indexName;
            LanguageConnectionContext languageConnectionContext = this.activation.getLanguageConnectionContext();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexCID);
            UUID uUID = conglomerateDescriptor.getTableID();
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(uUID);
            String string2 = tableDescriptor.getName();
            if (string == null) {
                object = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                string = ((ConstraintDescriptor)object).getConstraintName();
            }
            object = StandardException.newException("23505", (Object)string, (Object)string2);
            throw object;
        }
    }

    private ConglomerateController openIndexCC() throws StandardException {
        if (this.indexCC == null) {
            this.indexCC = this.indexSCOCI == null ? this.tc.openConglomerate(this.indexCID, false, 16388, this.lockMode, this.isolationLevel) : this.tc.openCompiledConglomerate(false, 16388, this.lockMode, this.isolationLevel, this.indexSCOCI, this.indexDCOCI);
        }
        return this.indexCC;
    }

    public void open() throws StandardException {
    }

    public void delete(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.setScan();
        this.doDelete();
    }

    public void update(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.setOurUpdatedIndexRow(execRow2, rowLocation);
        if (this.indexRowChanged()) {
            this.setScan();
            this.doDelete();
            this.insertForUpdate(execRow2, rowLocation);
        }
    }

    public void insert(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        this.doInsert();
    }

    void insertForUpdate(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.setOurIndexRow(execRow, rowLocation);
        if (this.irg.isUnique()) {
            this.doDeferredInsert();
        } else {
            this.doInsert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws StandardException {
        IndexRow indexRow = new IndexRow();
        if (this.rowHolder != null) {
            CursorResultSet cursorResultSet = this.rowHolder.getResultSet();
            try {
                ExecRow execRow;
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.insertAndCheckDups((ExecIndexRow)execRow);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                cursorResultSet.close();
                if (!this.rowHolderPassedIn) {
                    this.rowHolder.close();
                }
                throw throwable;
            }
            cursorResultSet.close();
            if (!this.rowHolderPassedIn) {
                this.rowHolder.close();
            }
        }
    }

    public void close() throws StandardException {
        this.closeIndexCC();
        this.closeIndexSC();
        if (this.rowHolder != null && !this.rowHolderPassedIn) {
            this.rowHolder.close();
        }
        this.baseCC = null;
    }
}

