/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;

public abstract class XMLDecoder {
    private Map<String, XMLDecoder> tagMap = new HashMap<String, XMLDecoder>();
    private XMLDecoder currentDecoder;
    private String currentElement;

    protected abstract String tag();

    protected abstract void start(Attributes var1) throws VersionException;

    protected abstract void end();

    protected abstract void startElement(String var1, Attributes var2);

    protected abstract void endElement(String var1, String var2);

    protected void registerXMLDecoder(XMLDecoder decoder) {
        this.tagMap.put(decoder.tag(), decoder);
    }

    protected void deregisterXMLDecoder(XMLDecoder decoder) {
        this.tagMap.remove(decoder.tag());
    }

    void _startElement(String name, Attributes atts) throws VersionException {
        if (this.checkStartRecursion(name, atts)) {
            return;
        }
        this.startElement(name, atts);
    }

    void _endElement(String name, String currentText) {
        if (this.checkEndRecursion(name, currentText)) {
            return;
        }
        this.endElement(name, currentText);
    }

    private boolean checkStartRecursion(String name, Attributes atts) throws VersionException {
        if (this.currentDecoder != null) {
            this.currentDecoder._startElement(name, atts);
            return true;
        }
        XMLDecoder tentativeDecoder = this.tagMap.get(name);
        if (tentativeDecoder != null) {
            tentativeDecoder.start(atts);
            this.currentDecoder = tentativeDecoder;
            this.currentElement = name;
            return true;
        }
        return false;
    }

    private boolean checkEndRecursion(String name, String currentText) {
        if (this.currentDecoder != null) {
            if (this.currentDecoder.checkEndRecursion(name, currentText)) {
                return true;
            }
            if (name.equals(this.currentElement)) {
                this.currentDecoder.end();
                this.currentDecoder = null;
                this.currentElement = null;
                return true;
            }
            this.currentDecoder.endElement(name, currentText);
            return true;
        }
        return false;
    }

    protected int getVersion(Attributes atts) {
        int version = 0;
        String versionString = atts.getValue("version");
        if (versionString != null) {
            version = new Integer(versionString);
        }
        return version;
    }

    protected void checkVersion(Attributes atts, String what, int maxVersion) throws VersionException {
        int version = this.getVersion(atts);
        if (version > maxVersion) {
            String title = NbBundle.getMessage(XMLDecoder.class, (String)"MSG_version_ignore_title");
            String message = NbBundle.getMessage(XMLDecoder.class, (String)"MSG_version_ignore");
            NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, 0, 3, null, NotifyDescriptor.YES_OPTION);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            if (ret == NotifyDescriptor.YES_OPTION) {
                return;
            }
            throw new VersionException(what, false, maxVersion, version);
        }
    }
}

