/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public abstract class AbstractExecutorRunAction
extends NodeAction {
    private static final boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.actions.AbstractExecutorRunAction");

    protected boolean enable(Node[] activatedNodes) {
        DataObject dataObject;
        boolean enabled = false;
        enabled = activatedNodes == null || activatedNodes.length == 0 || activatedNodes.length > 1 ? false : this.accept(dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class));
        return enabled;
    }

    protected abstract boolean accept(DataObject var1);

    protected static Project getProject(Node node) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    protected static ExecutionEnvironment getExecutionEnvironment(FileObject fileObject, Project project) {
        ExecutionEnvironment dh;
        RemoteProject info;
        if (project == null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        ExecutionEnvironment developmentHost = null;
        if (project != null && (info = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (dh = info.getDevelopmentHost()) != null) {
            developmentHost = dh;
        }
        if (developmentHost == null && ((developmentHost = FileSystemProvider.getExecutionEnvironment((FileObject)fileObject)) == null || developmentHost.isLocal())) {
            developmentHost = ServerList.getDefaultRecord().getExecutionEnvironment();
        }
        return developmentHost;
    }

    private static Project findProject(Node node) {
        Node parent = node;
        while (true) {
            Project project;
            if ((project = (Project)parent.getLookup().lookup(Project.class)) != null) {
                return project;
            }
            Node p = parent.getParentNode();
            if (p == null || p == parent) break;
            parent = p;
        }
        return null;
    }

    protected static boolean isSunStudio(Node node, Project project) {
        CompilerSet set = AbstractExecutorRunAction.getCompilerSet(node, project);
        if (set == null) {
            return false;
        }
        return set.getCompilerFlavor().isSunStudioCompiler();
    }

    protected static CompilerSet getCompilerSet(Node node, Project project) {
        ToolchainProject toolchain;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (project == null) {
            project = AbstractExecutorRunAction.findProject(node);
        }
        if (project == null) {
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        CompilerSet set = null;
        if (project != null && (toolchain = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            set = toolchain.getCompilerSet();
        }
        if (set == null) {
            ExecutionEnvironment executionEnvironment = FileSystemProvider.getExecutionEnvironment((FileObject)fileObject);
            if (!executionEnvironment.isLocal()) {
                set = CompilerSetManager.get((ExecutionEnvironment)executionEnvironment).getDefaultCompilerSet();
            }
            if (set == null) {
                set = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getDefaultCompilerSet();
            }
        }
        return set;
    }

    protected static String getCommand(Node node, Project project, PredefinedToolKind tool, String defaultName) {
        Tool aTool;
        CompilerSet set = AbstractExecutorRunAction.getCompilerSet(node, project);
        String command = null;
        if (set != null && (aTool = set.findTool((ToolKind)tool)) != null) {
            command = aTool.getPath();
        }
        if (command == null || command.length() == 0) {
            ExecutionSupport mes;
            if (tool == PredefinedToolKind.MakeTool) {
                mes = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
                if (mes != null) {
                    command = ((MakeExecSupport)mes).getMakeCommand();
                }
            } else if (tool == PredefinedToolKind.QMakeTool) {
                mes = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
                if (mes != null) {
                    command = ((QMakeExecSupport)mes).getQMakeCommand();
                }
            } else if (tool == PredefinedToolKind.CMakeTool && (mes = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
                command = ((CMakeExecSupport)mes).getCMakeCommand();
            }
        }
        if (command == null || command.length() == 0) {
            command = AbstractExecutorRunAction.findTools(defaultName);
        }
        return command;
    }

    protected static FileObject getBuildDirectory(Node node, PredefinedToolKind tool) {
        CMakeExecSupport mes;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject makeFileDir = dataObject.getPrimaryFile().getParent();
        String bdir = null;
        if (tool == PredefinedToolKind.MakeTool) {
            MakeExecSupport mes2 = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
            if (mes2 != null) {
                bdir = mes2.getBuildDirectory();
            }
        } else if (tool == PredefinedToolKind.QMakeTool) {
            QMakeExecSupport mes3 = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
            if (mes3 != null) {
                bdir = mes3.getRunDirectory();
            }
        } else if (tool == PredefinedToolKind.CMakeTool && (mes = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
            bdir = mes.getRunDirectory();
        }
        if (bdir == null) {
            return makeFileDir;
        }
        return AbstractExecutorRunAction.getAbsolutePath(bdir, makeFileDir);
    }

    protected static String[] getArguments(Node node, PredefinedToolKind tool) {
        CMakeExecSupport mes;
        String[] args = null;
        if (tool == PredefinedToolKind.QMakeTool) {
            QMakeExecSupport mes2 = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
            if (mes2 != null) {
                args = mes2.getArguments();
            }
        } else if (tool == PredefinedToolKind.CMakeTool && (mes = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
            args = mes.getArguments();
        }
        if (args == null) {
            args = new String[]{};
        }
        return args;
    }

    public static String findTools(String toolName) {
        for (String path : Path.getPath()) {
            String task = path + File.separatorChar + toolName;
            File tool = new File(task);
            if (tool.exists() && tool.isFile()) {
                return tool.getAbsolutePath();
            }
            if (!Utilities.isWindows() || !(tool = new File(task = task + ".exe")).exists() || !tool.isFile()) continue;
            return tool.getAbsolutePath();
        }
        return toolName;
    }

    private static Map<String, String> parseEnvironmentVariables(Collection<String> vars) {
        if (vars.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        for (String s : vars) {
            int i = s.indexOf(61);
            if (i <= 0) continue;
            String key = s.substring(0, i);
            String value = s.substring(i + 1).trim();
            if (value.length() > 1 && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                value = value.substring(1, value.length() - 1);
            }
            envMap.put(key, value);
        }
        return envMap;
    }

    private static Map<String, String> getDefaultEnvironment(ExecutionEnvironment execEnv, Node node, Project project) {
        PlatformInfo pi = PlatformInfo.getDefault(execEnv);
        String defaultPath = pi.getPathAsString();
        CompilerSet cs = AbstractExecutorRunAction.getCompilerSet(node, project);
        if (cs != null) {
            defaultPath = cs.getDirectory() + pi.pathSeparator() + defaultPath;
            String cmdDir = cs.getCompilerFlavor().getCommandFolder(pi.getPlatform());
            if (cmdDir != null && 0 < cmdDir.length()) {
                defaultPath = cmdDir + pi.pathSeparator() + defaultPath;
            }
        }
        return Collections.singletonMap(pi.getPathName(), defaultPath);
    }

    private static Map<String, String> getExecCookieEnvironment(Node node) {
        ExecutionSupport execSupport = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        if (execSupport == null) {
            return Collections.emptyMap();
        }
        return AbstractExecutorRunAction.parseEnvironmentVariables(Arrays.asList(execSupport.getEnvironmentVariables()));
    }

    protected static Map<String, String> getEnv(ExecutionEnvironment execEnv, Node node, Project project, List<String> additionalEnvironment) {
        HashMap<String, String> envMap = new HashMap<String, String>(AbstractExecutorRunAction.getDefaultEnvironment(execEnv, node, project));
        envMap.putAll(AbstractExecutorRunAction.getExecCookieEnvironment(node));
        if (additionalEnvironment != null) {
            envMap.putAll(AbstractExecutorRunAction.parseEnvironmentVariables(additionalEnvironment));
        }
        return envMap;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected static String getString(String key) {
        return NbBundle.getBundle(AbstractExecutorRunAction.class).getString(key);
    }

    protected static String getString(String key, String ... a1) {
        return NbBundle.getMessage(AbstractExecutorRunAction.class, (String)key, (Object[])a1);
    }

    protected static String quoteExecutable(String orig) {
        StringBuilder sb = new StringBuilder();
        String escapeChars = Utilities.isWindows() ? " \"'()" : " \"'()!";
        for (char c : orig.toCharArray()) {
            if (escapeChars.indexOf(c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected boolean asynchronous() {
        return false;
    }

    private static FileObject getAbsolutePath(String bdir, FileObject relativeDirFO) {
        if (bdir.length() == 0 || bdir.equals(".")) {
            return relativeDirFO;
        }
        if (CndPathUtilitities.isPathAbsolute((CharSequence)bdir)) {
            try {
                return relativeDirFO.getFileSystem().findResource(bdir);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            FileObject buildDirFO = relativeDirFO.getFileObject(bdir);
            if (buildDirFO == null) {
                return null;
            }
            return buildDirFO;
        }
        return null;
    }

    protected static void saveNode(Node node) {
        SaveCookie save = (SaveCookie)node.getLookup().lookup(SaveCookie.class);
        if (save != null) {
            try {
                save.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void traceExecutable(String executable, String buildDir, StringBuilder argsFlat, String host, Map<String, String> envMap) {
        if (TRACE) {
            StringBuilder buf = new StringBuilder("Run " + executable);
            buf.append("\n\tin folder   ").append(buildDir);
            buf.append("\n\targuments   ").append((CharSequence)argsFlat);
            buf.append("\n\thost        ").append(host);
            buf.append("\n\tenvironment ");
            for (Map.Entry<String, String> v : envMap.entrySet()) {
                buf.append("\n\t\t").append(v.getKey()).append("=").append(v.getValue());
            }
            buf.append("\n");
            logger.log(Level.INFO, buf.toString());
        }
    }

    protected static void traceExecutable(String executable, String buildDir, String[] args, String host, Map<String, String> envMap) {
        if (TRACE) {
            StringBuilder argsFlat = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                argsFlat.append(" ");
                argsFlat.append(args[i]);
            }
            AbstractExecutorRunAction.traceExecutable(executable, buildDir, argsFlat, host, envMap);
        }
    }

    protected static void trace(String message) {
        if (TRACE) {
            logger.log(Level.INFO, message);
        }
    }

    protected static String convertToRemoteIfNeeded(ExecutionEnvironment execEnv, String localDir, Project project) {
        if (!AbstractExecutorRunAction.checkConnection(execEnv)) {
            return null;
        }
        if (execEnv.isRemote()) {
            return RemoteSyncSupport.getPathMap((ExecutionEnvironment)execEnv, (Project)project).getRemotePath(localDir, false);
        }
        return localDir;
    }

    protected static String convertToRemoveSeparatorsIfNeeded(ExecutionEnvironment execEnv, String localPath) {
        if (execEnv.isRemote()) {
            return localPath.replace("\\", "/");
        }
        return localPath;
    }

    protected static boolean checkConnection(ExecutionEnvironment execEnv) {
        if (execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (CancellationException ex) {
                return false;
            }
        }
        return true;
    }

    static {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
    }

    protected static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private final AtomicReference<NativeProcess> processRef = new AtomicReference();
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;
        private final RemoteSyncWorker syncWorker;

        public ProcessChangeListener(ExecutionListener listener, Writer outputListener, LineConvertor lineConvertor, RemoteSyncWorker syncWorker) {
            this.listener = listener;
            this.outputListener = outputListener;
            this.lineConvertor = lineConvertor;
            this.syncWorker = syncWorker;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            if (NativeProcess.State.RUNNING == event.state && this.listener != null) {
                this.listener.executionStarted(event.pid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.closeOutputListener();
            NativeProcess process = this.processRef.get();
            try {
                if (process != null && this.listener != null) {
                    this.listener.executionFinished(process.exitValue());
                }
            }
            finally {
                if (this.syncWorker != null) {
                    this.syncWorker.shutdown();
                }
            }
        }

        public LineConvertor newLineConvertor() {
            return new LineConvertor(){

                public List<ConvertedLine> convert(String line) {
                    return ProcessChangeListener.this.convert(line);
                }
            };
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.outputListener = null;
            }
        }

        private synchronized List<ConvertedLine> convert(String line) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(line);
                    this.outputListener.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(line);
            }
            return null;
        }
    }
}

