/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;

public class InstantRenamerImpl
implements InstantRenamer {
    private static final boolean IS_RENAME_REFACTORING_ENABLED = true;
    private List<Occurence> allOccurences = Collections.emptyList();

    public boolean isRenameAllowed(ParserResult info, int caretOffset, String[] explanationRetValue) {
        Occurence.Accuracy accuracy;
        this.allOccurences.clear();
        PHPParseResult result = (PHPParseResult)info;
        Model model = result.getModel();
        OccurencesSupport occurencesSupport = model.getOccurencesSupport(caretOffset);
        Occurence caretOccurence = occurencesSupport.getOccurence();
        if (caretOccurence != null && ((accuracy = caretOccurence.degreeOfAccuracy()).equals((Object)Occurence.Accuracy.EXACT) || accuracy.equals((Object)Occurence.Accuracy.UNIQUE))) {
            FieldElement fld;
            MethodElement meth;
            PhpModifiers phpModifiers;
            VariableName varName;
            Collection<? extends PhpElement> allDeclarations = caretOccurence.getAllDeclarations();
            if (allDeclarations.size() != 1) {
                return false;
            }
            PhpElement decl = allDeclarations.iterator().next();
            if (decl instanceof VariableName ? !(varName = (VariableName)decl).isGloballyVisible() && !varName.representsThis() : (decl instanceof MethodElement ? (phpModifiers = (meth = (MethodElement)decl).getPhpModifiers()).isPrivate() : decl instanceof FieldElement && (phpModifiers = (fld = (FieldElement)decl).getPhpModifiers()).isPrivate())) {
                return this.checkAll(caretOccurence);
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(ParserResult info, int caretOffset) {
        HashSet<OffsetRange> retval = new HashSet<OffsetRange>();
        for (Occurence occurence : this.allOccurences) {
            retval.add(occurence.getOccurenceRange());
        }
        this.allOccurences.clear();
        return retval != null ? retval : Collections.emptySet();
    }

    private boolean checkAll(Occurence caretOccurence) {
        ArrayList<Occurence> collected = new ArrayList<Occurence>();
        Collection<Occurence> all = caretOccurence.getAllOccurences();
        for (Occurence occurence : all) {
            if (occurence.getAllDeclarations().size() == 1) {
                collected.add(occurence);
                continue;
            }
            this.allOccurences.clear();
            return false;
        }
        this.allOccurences = collected;
        return true;
    }
}

