/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.util.NbBundle;

public class VCSCommitTableModel<F extends VCSFileNode>
extends AbstractTableModel {
    public static final String COLUMN_NAME_COMMIT = "commit";
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    public static String[] COMMIT_COLUMNS = new String[]{"commit", "name", "status", "action", "path"};
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private F[] nodes;
    private String[] columns;

    private VCSCommitOptions[] createDefaultCommitOptions() {
        VCSCommitOptions[] co = new VCSCommitOptions[this.getNodes().length];
        for (int i = 0; i < this.getNodes().length; ++i) {
            co[i] = VCSCommitOptions.COMMIT;
            co[i] = ((VCSFileNode)this.getNode(i)).getDefaultCommitOption(true);
        }
        return co;
    }

    public VCSCommitTableModel() {
        ResourceBundle loc = NbBundle.getBundle(VCSCommitTableModel.class);
        columnLabels.put(COLUMN_NAME_COMMIT, new String[]{loc.getString("CTL_CommitTable_Column_Commit"), loc.getString("CTL_CommitTable_Column_Description")});
        columnLabels.put(COLUMN_NAME_NAME, new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(COMMIT_COLUMNS);
        List l = Collections.emptyList();
    }

    protected void setNodes(F[] nodes) {
        this.nodes = nodes;
        this.fireTableDataChanged();
    }

    protected void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public List<F> getCommitFiles() {
        List<Object> ret = new LinkedList();
        if (this.nodes == null) {
            ret = Collections.emptyList();
            return Collections.unmodifiableList(ret);
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            ret.add(this.nodes[i]);
        }
        return Collections.unmodifiableList(ret);
    }

    @Override
    public String getColumnName(int column) {
        return columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes == null ? 0 : this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return Boolean.class;
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return VCSCommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals(COLUMN_NAME_COMMIT);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_COMMIT)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getCommitOptions() != VCSCommitOptions.EXCLUDE;
        }
        if (col.equals(COLUMN_NAME_NAME)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getName();
        }
        if (col.equals(COLUMN_NAME_STATUS)) {
            F node = this.nodes[rowIndex];
            Object finfo = ((VCSFileNode)node).getInformation();
            return ((VCSFileInformation)finfo).getStatusText();
        }
        if (col.equals(COLUMN_NAME_ACTION)) {
            return ((VCSFileNode)this.nodes[rowIndex]).getCommitOptions();
        }
        if (col.equals(COLUMN_NAME_PATH)) {
            String shortPath = null;
            if (this.rootFile != null) {
                String relativePath = ((VCSFileNode)this.nodes[rowIndex]).getFile().getAbsolutePath().substring(this.rootFile.rootLocalPath.length());
                shortPath = this.rootFile.repositoryPath + relativePath.replace(File.separatorChar, '/');
            } else {
                shortPath = ((VCSFileNode)this.nodes[rowIndex]).getRelativePath();
                if (shortPath == null) {
                    shortPath = NbBundle.getMessage(VCSCommitTableModel.class, (String)"LBL_Location_NotInRepository");
                }
            }
            return shortPath;
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals(COLUMN_NAME_ACTION)) {
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions((VCSCommitOptions)aValue);
        } else if (col.equals(COLUMN_NAME_COMMIT)) {
            F node = this.nodes[rowIndex];
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions((Boolean)aValue != false ? ((VCSFileNode)node).getDefaultCommitOption(false) : VCSCommitOptions.EXCLUDE);
        } else {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    protected F[] getNodes() {
        return this.nodes;
    }

    public F getNode(int row) {
        return this.nodes[row];
    }

    public VCSCommitOptions getOption(int row) {
        return ((VCSFileNode)this.nodes[row]).getCommitOptions();
    }

    protected void setRootFile(String repositoryPath, String rootLocalPath) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = repositoryPath;
        this.rootFile.rootLocalPath = rootLocalPath;
    }

    protected void setIncluded(int[] rows, boolean include) {
        for (int rowIndex : rows) {
            F node = this.nodes[rowIndex];
            VCSCommitOptions options = ((VCSFileNode)node).getDefaultCommitOption(false);
            ((VCSFileNode)this.nodes[rowIndex]).setCommitOptions(include ? options : VCSCommitOptions.EXCLUDE);
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    private class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

