/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTBaseMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTFileMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroMapSnapshot;
import org.netbeans.modules.cnd.apt.impl.support.APTPreprocHandlerImpl;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public class APTSerializeUtils {
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_APT = 3;
    private static int fileIndex = 0;
    private static final boolean TRACE = true;
    private static final int NULL_POINTER = -1;
    private static final int MACRO_MAP_STATE_IMPL = 1;
    private static final int MACRO_MAP_FILE_STATE_IMPL = 2;
    private static final int PREPROC_STATE_STATE_IMPL = 3;
    private static final int MACRO_MAP_SNAPSHOT = 4;
    private static final int UNDEFINED_MACRO = 5;
    private static final int MACRO_IMPL = 6;

    private APTSerializeUtils() {
    }

    public static void writeAPT(ObjectOutputStream out, APT apt) throws IOException {
        out.writeObject(apt);
        if (apt != null) {
            APTSerializeUtils.writeTree(out, apt);
        }
    }

    public static APT readAPT(ObjectInputStream in) throws IOException, ClassNotFoundException {
        APT apt = (APT)in.readObject();
        if (apt != null) {
            APTSerializeUtils.readTree(in, apt);
        }
        return apt;
    }

    private static void writeTree(ObjectOutputStream out, APT root) throws IOException {
        assert (root != null) : "there must be something to write";
        APT node = root;
        do {
            APT child;
            if ((child = node.getFirstChild()) != null) {
                out.writeInt(1);
                APTSerializeUtils.writeAPT(out, child);
            }
            if ((node = node.getNextSibling()) == null) continue;
            out.writeInt(2);
            out.writeObject(node);
        } while (node != null);
        out.writeInt(3);
    }

    private static void readTree(ObjectInputStream in, APT root) throws IOException, ClassNotFoundException {
        assert (root != null) : "there must be something to read";
        APT node = root;
        do {
            int kind = in.readInt();
            switch (kind) {
                case 3: {
                    return;
                }
                case 1: {
                    node.setFirstChild(APTSerializeUtils.readAPT(in));
                    break;
                }
                case 2: {
                    APT sibling = (APT)in.readObject();
                    node.setNextSibling(sibling);
                    node = sibling;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (node != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV"})
    public static APT testAPTSerialization(APTFileBuffer buffer, APT apt) {
        FileObject file = CndFileUtils.toFileObject((FileSystem)buffer.getFileSystem(), (CharSequence)buffer.getAbsolutePath());
        APT aptRead = null;
        String prefix = "cnd_apt_" + fileIndex++;
        String suffix = file.getNameExt();
        try {
            File out = File.createTempFile(prefix, suffix);
            System.out.println("...saving APT of file " + file.getPath() + " into tmp file " + out);
            long astTime = System.currentTimeMillis();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(out), APTTraceFlags.BUF_SIZE));
            try {
                APTSerializeUtils.writeAPT(oos, apt);
            }
            finally {
                oos.close();
            }
            long writeTime = System.currentTimeMillis() - astTime;
            System.out.println("saved APT of file " + file.getPath() + " withing " + writeTime + "ms");
            astTime = System.currentTimeMillis();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(out), APTTraceFlags.BUF_SIZE));
            try {
                aptRead = APTSerializeUtils.readAPT(ois);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            finally {
                ois.close();
            }
            long readTime = System.currentTimeMillis() - astTime;
            System.out.println("read APT of file " + file.getPath() + " withing " + readTime + "ms");
            out.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return aptRead;
    }

    public static void writeSystemMacroMap(APTMacroMap macroMap, DataOutput output) throws IOException {
    }

    public static APTMacroMap readSystemMacroMap(DataInput input) throws IOException {
        return null;
    }

    public static void writeMacroMapState(APTMacroMap.State state, DataOutput output) throws IOException {
        assert (state != null);
        if (state instanceof APTFileMacroMap.FileStateImpl) {
            output.writeInt(2);
            ((APTFileMacroMap.FileStateImpl)state).write(output);
        } else {
            assert (state instanceof APTBaseMacroMap.StateImpl);
            output.writeInt(1);
            ((APTBaseMacroMap.StateImpl)state).write(output);
        }
    }

    public static APTMacroMap.State readMacroMapState(DataInput input) throws IOException {
        APTBaseMacroMap.StateImpl state;
        int handler = input.readInt();
        if (handler == 2) {
            state = new APTFileMacroMap.FileStateImpl(input);
        } else {
            assert (handler == 1);
            state = new APTBaseMacroMap.StateImpl(input);
        }
        return state;
    }

    public static void writeIncludeState(APTIncludeHandler.State state, DataOutput output) throws IOException {
        assert (state != null);
        assert (state instanceof APTIncludeHandlerImpl.StateImpl);
        ((APTIncludeHandlerImpl.StateImpl)state).write(output);
    }

    public static APTIncludeHandler.State readIncludeState(FileSystem fs, DataInput input) throws IOException {
        APTIncludeHandlerImpl.StateImpl state = new APTIncludeHandlerImpl.StateImpl(fs, input);
        return state;
    }

    public static void writePreprocState(APTPreprocHandler.State state, DataOutput output) throws IOException {
        assert (state != null);
        if (!(state instanceof APTPreprocHandlerImpl.StateImpl)) {
            throw new IllegalArgumentException("unknown preprocessor state" + state);
        }
        output.writeInt(3);
        ((APTPreprocHandlerImpl.StateImpl)state).write(output);
    }

    public static APTPreprocHandler.State readPreprocState(FileSystem fs, DataInput input) throws IOException {
        APTPreprocHandlerImpl.StateImpl out;
        int handler = input.readInt();
        switch (handler) {
            case 3: {
                out = new APTPreprocHandlerImpl.StateImpl(fs, input);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown preprocessor state handler" + handler);
            }
        }
        return out;
    }

    public static void writeSnapshot(APTMacroMapSnapshot snap, DataOutput output) throws IOException {
        output.writeInt(-1);
    }

    public static APTMacroMapSnapshot readSnapshot(DataInput input) throws IOException {
        int handler = input.readInt();
        APTMacroMapSnapshot snap = null;
        if (handler != -1) {
            assert (handler == 4);
            snap = new APTMacroMapSnapshot(input);
        }
        return snap;
    }

    public static void writeStringToMacroMap(Map<CharSequence, APTMacro> macros, DataOutput output) throws IOException {
        assert (macros != null);
        output.writeInt(macros.size());
        for (Map.Entry<CharSequence, APTMacro> entry : macros.entrySet()) {
            assert (entry != null);
            assert (CharSequences.isCompact((CharSequence)entry.getKey()));
            String key = ((Object)entry.getKey()).toString();
            output.writeUTF(key);
            APTMacro macro = entry.getValue();
            assert (macro != null);
            APTSerializeUtils.writeMacro(macro, output);
        }
    }

    public static void readStringToMacroMap(int collSize, Map<CharSequence, APTMacro> macros, DataInput input) throws IOException {
        for (int i = 0; i < collSize; ++i) {
            CharSequence key = CharSequences.create((CharSequence)input.readUTF());
            assert (key != null);
            APTMacro macro = APTSerializeUtils.readMacro(input);
            assert (macro != null);
            macros.put(key, macro);
        }
    }

    private static void writeMacro(APTMacro macro, DataOutput output) throws IOException {
        assert (macro != null);
        if (macro == APTMacroMapSnapshot.UNDEFINED_MACRO) {
            output.writeInt(5);
        } else if (macro instanceof APTMacroImpl) {
            output.writeInt(6);
            ((APTMacroImpl)macro).write(output);
        }
    }

    private static APTMacro readMacro(DataInput input) throws IOException {
        APTMacro macro;
        int handler = input.readInt();
        if (handler == 5) {
            macro = APTMacroMapSnapshot.UNDEFINED_MACRO;
        } else {
            assert (handler == 6);
            macro = new APTMacroImpl(input);
        }
        return macro;
    }
}

