/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.actions.PersistInstanceAction;
import org.netbeans.modules.hudson.ui.actions.SynchronizeAction;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobNode;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.actions.DeleteAction;
import org.openide.actions.PropertiesAction;
import org.openide.awt.DynamicMenuContent;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class HudsonInstanceNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/hudson/ui/resources/instance.png";
    private HudsonInstanceImpl instance;
    private InstanceNodeChildren children;
    private boolean warn = false;
    private boolean run = false;
    private boolean alive = false;
    private boolean version = false;
    private static final String SELECTED_VIEW = "view";

    public HudsonInstanceNode(HudsonInstanceImpl instance) {
        super((Children)new Children.Array(), Lookups.singleton((Object)instance));
        this.children = new InstanceNodeChildren(instance);
        this.setName(instance.getUrl());
        this.setDisplayName(instance.getName());
        this.setShortDescription(instance.getUrl());
        this.setIconBaseWithExtension(ICON_BASE);
        this.setValue("customDelete", true);
        this.instance = instance;
        instance.addHudsonChangeListener(new HudsonChangeListener(){

            @Override
            public void stateChanged() {
                HudsonInstanceNode.this.refreshState();
            }

            @Override
            public void contentChanged() {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        this.refreshState();
        this.refreshContent();
    }

    public String getHtmlDisplayName() {
        boolean pers = this.instance.isPersisted();
        String selectedView = this.instance.prefs().get(SELECTED_VIEW, null);
        return (this.run ? "<b>" : "") + (this.warn ? "<font color=\"#A40000\">" : "") + this.instance.getName() + (this.warn ? "</font>" : "") + (this.run ? "</b>" : "") + (selectedView != null ? " <font color='!controlShadow'>[" + selectedView + "]</font>" : "") + (this.alive ? (this.version ? "" : " <font color=\"#A40000\">" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"MSG_WrongVersion", (Object)HudsonVersion.SUPPORTED_VERSION) + "</font>") : " <font color=\"#A40000\">" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"MSG_Disconnected") + "</font>") + (!pers ? " <font color='!controlShadow'>" + NbBundle.getMessage(HudsonInstanceNode.class, (String)"HudsonInstanceNode.from_open_project") + "</font>" : "");
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.instance.getViews().size() > 1) {
            actions.add(new ViewSwitcher());
            actions.add(null);
        }
        actions.add(UI.createJobAction(this.instance));
        actions.add(null);
        actions.add((Action)SystemAction.get(SynchronizeAction.class));
        actions.add((Action)SystemAction.get(OpenUrlAction.class));
        if (!this.instance.isPersisted()) {
            actions.add((Action)SystemAction.get(PersistInstanceAction.class));
        } else {
            actions.add((Action)SystemAction.get(DeleteAction.class));
        }
        actions.add(null);
        actions.add((Action)SystemAction.get(PropertiesAction.class));
        return actions.toArray(new Action[0]);
    }

    public boolean canDestroy() {
        return this.instance.isPersisted();
    }

    public void destroy() throws IOException {
        HudsonManagerImpl.getDefault().removeInstance(this.instance);
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[]{this.instance.getProperties().getSheetSet()};
    }

    private synchronized void refreshState() {
        String oldHtmlName = "";
        this.alive = this.instance.isConnected();
        this.version = Utilities.isSupportedVersion(this.instance.getVersion());
        if (!this.alive || !this.version) {
            this.setChildren((Children)new Children.Array());
        } else if (this.getChildren().getNodesCount() == 0) {
            this.setChildren((Children)this.children);
        }
        this.fireDisplayNameChange(oldHtmlName, this.getHtmlDisplayName());
    }

    private synchronized void refreshContent() {
        String oldHtmlName = null;
        this.warn = false;
        this.run = false;
        for (HudsonJob job : this.instance.getJobs()) {
            if (job.getColor().equals((Object)HudsonJob.Color.red) || job.getColor().equals((Object)HudsonJob.Color.red_anime)) {
                this.warn = true;
            }
            if (job.getColor().equals((Object)HudsonJob.Color.blue_anime) || job.getColor().equals((Object)HudsonJob.Color.grey_anime) || job.getColor().equals((Object)HudsonJob.Color.red_anime) || job.getColor().equals((Object)HudsonJob.Color.yellow_anime)) {
                this.run = true;
            }
            if (!this.warn || !this.run) continue;
            break;
        }
        this.fireDisplayNameChange(oldHtmlName, this.getHtmlDisplayName());
    }

    private class ViewSwitcher
    extends AbstractAction
    implements Presenter.Popup {
        private ViewSwitcher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public JMenuItem getPopupPresenter() {
            class Menu
            extends JMenu
            implements DynamicMenuContent {
                Menu() {
                    this.setText(NbBundle.getMessage(HudsonInstanceNode.class, (String)"HudsonInstanceNode.view"));
                }

                public JComponent[] getMenuPresenters() {
                    this.removeAll();
                    String selectedView = HudsonInstanceNode.this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
                    String primaryViewName = HudsonInstanceNode.this.instance.getPrimaryView().getName();
                    JRadioButtonMenuItem item = new JRadioButtonMenuItem(primaryViewName);
                    item.setSelected(selectedView == null || selectedView.equals(primaryViewName));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            HudsonInstanceNode.this.instance.prefs().remove(HudsonInstanceNode.SELECTED_VIEW);
                        }
                    });
                    this.add(item);
                    this.addSeparator();
                    for (HudsonView view : HudsonInstanceNode.this.instance.getViews()) {
                        final String name = view.getName();
                        if (name.equals(primaryViewName)) continue;
                        item = new JRadioButtonMenuItem(name);
                        item.setSelected(name.equals(selectedView));
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                HudsonInstanceNode.this.instance.prefs().put(HudsonInstanceNode.SELECTED_VIEW, name);
                            }
                        });
                        this.add(item);
                    }
                    return new JComponent[]{this};
                }

                public JComponent[] synchMenuPresenters(JComponent[] items) {
                    return this.getMenuPresenters();
                }
            }
            return new Menu();
        }
    }

    private static class InstanceNodeChildren
    extends Children.Keys<HudsonJob>
    implements HudsonChangeListener {
        private final HudsonInstance instance;

        public InstanceNodeChildren(HudsonInstance instance) {
            this.instance = instance;
            instance.addHudsonChangeListener(this);
            instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    InstanceNodeChildren.this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(HudsonJob job) {
            return new Node[]{new HudsonJobNode(job)};
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            ArrayList<HudsonJob> jobs = new ArrayList<HudsonJob>();
            HudsonView view = this.instance.getPrimaryView();
            String selectedView = this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
            if (selectedView != null) {
                for (HudsonView v : this.instance.getViews()) {
                    if (!v.getName().equals(selectedView)) continue;
                    view = v;
                    break;
                }
            }
            for (HudsonJob job : this.instance.getJobs()) {
                if (!job.getViews().contains(view)) continue;
                jobs.add(job);
            }
            this.setKeys(jobs);
        }

        @Override
        public void stateChanged() {
        }

        @Override
        public void contentChanged() {
            this.refreshKeys();
        }
    }
}

