/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.CreateJobPanel;
import org.netbeans.modules.hudson.util.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class CreateJob
extends AbstractAction {
    private final HudsonInstance instance;

    public CreateJob() {
        super(Bundle.CTL_CreateJob());
        this.instance = null;
    }

    public CreateJob(HudsonInstance instance) {
        super(Bundle.CreateJob_new_build());
        this.instance = instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<HudsonInstanceImpl> instances;
        final CreateJobPanel panel = new CreateJobPanel();
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.CreateJob_title());
        final AtomicReference<Dialog> dialog = new AtomicReference<Dialog>();
        final JButton createButton = new JButton(Bundle.CreateJob_create());
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        CreateJob.this.finalizeJob(panel.instance, panel.creator, panel.name(), panel.selectedProject());
                    }
                });
                ((Dialog)dialog.get()).dispose();
            }
        });
        dd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("valid".equals(evt.getPropertyName())) {
                    createButton.setEnabled(dd.isValid());
                }
            }
        });
        HudsonInstance _instance = this.instance != null ? this.instance : ((instances = HudsonManagerImpl.getDefault().getInstances()).isEmpty() ? null : (HudsonInstance)instances.iterator().next());
        panel.init(dd, _instance);
        dd.setOptions(new Object[]{createButton, NotifyDescriptor.CANCEL_OPTION});
        dd.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        dialog.set(DialogDisplayer.getDefault().createDialog(dd));
        ((Dialog)dialog.get()).setVisible(true);
    }

    private void finalizeJob(HudsonInstance instance, ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator creator, String name, Project project) {
        try {
            Document doc = creator.configure();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            String createItemURL = instance.getUrl() + "createItem?name=" + Utilities.uriEncode(name);
            new ConnectionBuilder().instance(instance).url(createItemURL).header("Content-Type", "text/xml").postData(baos.toByteArray()).httpConnection().disconnect();
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(instance.getUrl() + "job/" + Utilities.uriEncode(name) + "/"));
            ((HudsonInstanceImpl)instance).synchronize();
            ProjectHudsonProvider.getDefault().recordAssociation(project, new ProjectHudsonProvider.Association(instance.getUrl(), name));
            OpenProjects.getDefault().open(new Project[]{project}, false);
            UI.selectNode(instance.getUrl(), name);
        }
        catch (IOException x) {
            Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.CreateJob_failure());
            Logger.getLogger(CreateJob.class.getName()).log(Level.WARNING, null, x);
        }
    }
}

