/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ViewUpdates
implements DocumentListener,
EditorViewFactoryListener {
    private static final Logger LOG = Logger.getLogger(ViewUpdates.class.getName());
    private static final int REBUILD_DELAY = 0;
    private static final int MAX_LOCAL_VIEWS_REBUILD_LENGTH = 200;
    private static final int LAZY_CHILDREN_MIN_BATCH_LINES = 5;
    private static final RequestProcessor rebuildRegionRP = new RequestProcessor("ViewHierarchy-Region-Rebuilding", 1, false, false);
    private final DocumentView documentView;
    private EditorViewFactory[] viewFactories;
    private DocumentListener incomingModificationListener;
    private OffsetRegion rebuildRegion;
    private Object rebuildRegionLock = new String("rebuild-region-lock");
    private boolean buildingViews;
    private DocumentEvent incomingEvent;
    private final RequestProcessor.Task rebuildRegionTask = rebuildRegionRP.create(new Runnable(){
        private boolean insideDocumentRender = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.insideDocumentRender) {
                ViewUpdates.this.documentView.syncViewsRebuild();
            } else {
                this.insideDocumentRender = true;
                try {
                    ViewUpdates.this.documentView.getDocument().render(this);
                }
                finally {
                    this.insideDocumentRender = false;
                }
            }
        }
    });

    public ViewUpdates(DocumentView documentView) {
        this.documentView = documentView;
        this.incomingModificationListener = new IncomingModificationListener();
        Document doc = documentView.getDocument();
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this.incomingModificationListener, null)), (DocumentListenerPriority)DocumentListenerPriority.FIRST);
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc)), (DocumentListenerPriority)DocumentListenerPriority.VIEW);
    }

    private void initFactories() {
        assert (this.viewFactories == null);
        JTextComponent component = this.documentView.getTextComponent();
        assert (component != null) : "Null component; doc=" + this.documentView.getDocument();
        List<EditorViewFactory.Factory> factoryFactories = EditorViewFactory.factories();
        this.viewFactories = new EditorViewFactory[factoryFactories.size()];
        for (int i = 0; i < factoryFactories.size(); ++i) {
            this.viewFactories[i] = factoryFactories.get(i).createEditorViewFactory(component);
            this.viewFactories[i].addEditorViewFactoryListener((EditorViewFactoryListener)WeakListeners.create(EditorViewFactoryListener.class, (EventListener)this, (Object)this.viewFactories[i]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildViews(ParagraphView paragraphView, int paragraphViewIndex, int startOffset, int endOffset, int modOffset, int modLength, boolean createLocalViews) {
        assert (this.documentView.isMutexAcquired()) : "View hierarchy mutex not acquired";
        assert (!this.buildingViews) : "Already building views";
        ViewBuilder viewBuilder = new ViewBuilder(paragraphView, this.documentView, paragraphViewIndex, this.viewFactories, startOffset, endOffset, modOffset, modLength, createLocalViews);
        this.setBuildingViews(true);
        try {
            this.documentView.checkMutexAcquiredIfLogging();
            viewBuilder.createViews();
            viewBuilder.replaceAndRepaintViews();
        }
        finally {
            this.setBuildingViews(false);
            viewBuilder.finish();
        }
        this.documentView.viewHierarchy.fireViewHierarchyEvent(new ViewHierarchyEvent(this.documentView.viewHierarchy(), startOffset));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finer("ViewUpdates.buildViews(): UPDATED-DOC-VIEW:\n" + this.documentView);
        }
    }

    private boolean isBuildingViews() {
        return this.buildingViews;
    }

    private void setBuildingViews(boolean buildingViews) {
        assert (buildingViews != this.buildingViews) : "buildingViews=" + buildingViews + " == this.buildingViews=" + this.buildingViews;
        this.buildingViews = buildingViews;
    }

    void reinitViews() {
        this.checkFactoriesComponentInited();
        int startOffset = this.documentView.getStartOffset();
        int endOffset = this.documentView.getEndOffset();
        this.buildViews(null, 0, startOffset, endOffset, endOffset, 0, this.documentView.isAccurateSpan());
    }

    void initChildren(int startIndex, int endIndex) {
        if (endIndex - startIndex < 5) {
            startIndex -= 2;
            endIndex += 2;
        }
        startIndex = Math.max(startIndex, 0);
        endIndex = Math.min(endIndex, this.documentView.getViewCount());
        assert (startIndex >= 0) : "startIndex=" + startIndex;
        assert (endIndex >= startIndex) : "endIndex=" + endIndex + " < startIndex=" + startIndex;
        ParagraphView startChild = (ParagraphView)this.documentView.getEditorView(startIndex);
        while (startChild.children != null && startIndex < endIndex - 1) {
            startChild = (ParagraphView)this.documentView.getEditorView(++startIndex);
        }
        ParagraphView lastChild = null;
        while (endIndex > startIndex) {
            lastChild = (ParagraphView)this.documentView.getEditorView(endIndex - 1);
            if (lastChild.children == null) break;
            --endIndex;
        }
        if (endIndex > startIndex) {
            int docTextLength = this.documentView.getDocument().getLength() + 1;
            int startOffset = startChild.getStartOffset();
            int endOffset = lastChild.getEndOffset();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Lazy-children init: [" + startIndex + "," + endIndex + "]\n");
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.INFO, "Lazy creation cause", new Exception());
                }
            }
            assert (startOffset <= endOffset) : "startOffset=" + startOffset + " > endOffset=" + endOffset + "\n" + this.documentView.toStringDetail();
            assert (endOffset <= docTextLength) : "endOffset=" + endOffset + " > docTextLength=" + docTextLength + "\n" + this.documentView.toStringDetail();
            this.buildViews(null, startIndex, startOffset, endOffset, endOffset, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLockedIfLogging();
            try {
                boolean createLocalViews;
                int paragraphViewLength;
                ParagraphView paragraphView;
                int paragraphViewIndex;
                int docViewEndOffset;
                int docViewStartOffset;
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                if (this.documentView.getViewCount() == 0) {
                    return;
                }
                Document doc = this.documentView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.insertUpdate(evt);
                }
                OffsetRegion rRegion = this.fetchRebuildRegion();
                int insertOffset = evt.getOffset();
                int insertLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-INSERT-evt: offset=" + insertOffset + ", length=" + insertLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                rRegion = OffsetRegion.union(rRegion, doc, insertOffset, insertOffset + insertLength, false);
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                if (lineElementChange != null) {
                    Element[] addedLines;
                    Element[] removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        assert (insertOffset >= firstRemovedLineStartOffset && insertOffset <= lastRemovedLineEndOffset);
                        rRegion = rRegion.union(doc, firstRemovedLineStartOffset, lastRemovedLineEndOffset, false);
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(doc, firstAddedLineStartOffset, lastAddedLineEndOffset, false);
                    }
                }
                if (this.documentView.hasExtraBounds() && (rRegion = rRegion.intersection(doc, docViewStartOffset = this.documentView.getStartOffset(), docViewEndOffset = this.documentView.getEndOffset(), true)) == null) {
                    return;
                }
                if (insertOffset == 0) {
                    paragraphViewIndex = 0;
                    paragraphView = null;
                    paragraphViewLength = 0;
                } else {
                    paragraphViewIndex = this.documentView.getViewIndex(rRegion.startOffset());
                    assert (paragraphViewIndex >= 0) : "paragraphViewIndex=" + paragraphViewIndex + ", docLen=" + evt.getDocument().getLength();
                    paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                    paragraphViewLength = paragraphView.getLength();
                }
                boolean bl = createLocalViews = rRegion.length() <= 200 + paragraphViewLength;
                if (paragraphView != null && paragraphView.children == null) {
                    int paragraphStartOffset = paragraphView.getStartOffset();
                    assert (paragraphStartOffset <= rRegion.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rRegion.startOffset();
                    rRegion = rRegion.union(doc, paragraphStartOffset, paragraphStartOffset + paragraphView.getLength(), false);
                    paragraphView = null;
                    createLocalViews = false;
                }
                createLocalViews |= this.documentView.isAccurateSpan();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ViewUpdates.insertUpdate-buildViews(): " + rRegion + " createLocalViews=" + createLocalViews + "\n");
                }
                this.buildViews(paragraphView, paragraphViewIndex, rRegion.startOffset(), rRegion.endOffset(), insertOffset, insertLength, createLocalViews);
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLockedIfLogging();
            try {
                boolean createLocalViews;
                int docViewEndOffset;
                int docViewStartOffset;
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                if (this.documentView.getViewCount() == 0) {
                    return;
                }
                Document doc = this.documentView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.removeUpdate(evt);
                }
                OffsetRegion rRegion = this.fetchRebuildRegion();
                int removeOffset = evt.getOffset();
                int removeLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-REMOVE-evt: offset=" + removeOffset + ", length=" + removeLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                rRegion = OffsetRegion.union(rRegion, doc, removeOffset, removeOffset, false);
                if (this.documentView.hasExtraBounds() && (rRegion = rRegion.intersection(doc, docViewStartOffset = this.documentView.getStartOffset(), docViewEndOffset = this.documentView.getEndOffset(), true)) == null) {
                    return;
                }
                DocumentEvent.ElementChange lineElementChange = evt.getChange(doc.getDefaultRootElement());
                Element[] removedLines = null;
                if (lineElementChange != null) {
                    Element[] addedLines;
                    removedLines = lineElementChange.getChildrenRemoved();
                    if (removedLines.length > 0) {
                        int firstRemovedLineStartOffset = removedLines[0].getStartOffset();
                        int lastRemovedLineEndOffset = removedLines[removedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(doc, firstRemovedLineStartOffset, lastRemovedLineEndOffset, false);
                    }
                    if ((addedLines = lineElementChange.getChildrenAdded()).length > 0) {
                        int firstAddedLineStartOffset = addedLines[0].getStartOffset();
                        int lastAddedLineEndOffset = addedLines[addedLines.length - 1].getEndOffset();
                        rRegion = rRegion.union(doc, firstAddedLineStartOffset, lastAddedLineEndOffset, false);
                    }
                }
                int paragraphViewIndex = this.documentView.getViewIndexFirst(rRegion.startOffset());
                assert (paragraphViewIndex >= 0) : "Line view index is " + paragraphViewIndex;
                ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
                boolean bl = createLocalViews = rRegion.length() <= 200 + paragraphView.getLength();
                if (paragraphView.children == null) {
                    int paragraphStartOffset = paragraphView.getStartOffset();
                    assert (paragraphStartOffset <= rRegion.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rStartOffset=" + rRegion.startOffset();
                    int parEndOffset = paragraphStartOffset + paragraphView.getLength();
                    if (parEndOffset > removeOffset) {
                        parEndOffset = Math.max(parEndOffset - removeLength, removeOffset);
                    }
                    rRegion = rRegion.union(doc, paragraphStartOffset, parEndOffset, false);
                    paragraphView = null;
                    createLocalViews = false;
                }
                createLocalViews |= this.documentView.isAccurateSpan();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("ViewUpdates.removeUpdate-buildViews(): " + rRegion + " createLocalViews=" + createLocalViews + "\n");
                }
                this.buildViews(paragraphView, paragraphViewIndex, rRegion.startOffset(), rRegion.endOffset(), removeOffset, -removeLength, createLocalViews);
            }
            finally {
                this.documentView.setIncomingModification(false);
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        PriorityMutex mutex = this.documentView.getMutex();
        if (mutex != null) {
            mutex.lock();
            this.documentView.checkDocumentLockedIfLogging();
            try {
                if (!this.documentView.isUpdatable()) {
                    return;
                }
                this.checkFactoriesComponentInited();
                for (int i = 0; i < this.viewFactories.length; ++i) {
                    EditorViewFactory editorViewFactory = this.viewFactories[i];
                    editorViewFactory.changedUpdate(evt);
                }
                this.documentView.checkIntegrity();
            }
            finally {
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewFactoryChanged(EditorViewFactoryEvent evt) {
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            this.documentView.checkDocumentLockedIfLogging();
            boolean postRebuildTask = this.rebuildRegion == null;
            List<EditorViewFactory.Change> changes = evt.getChanges();
            for (EditorViewFactory.Change change : changes) {
                int startOffset = change.getStartOffset();
                int endOffset = change.getEndOffset();
                this.rebuildRegion = OffsetRegion.union(this.rebuildRegion, this.documentView.getDocument(), startOffset, endOffset, false);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("ViewUpdates.viewFactoryChanged: <" + startOffset + "," + endOffset + ">\n");
            }
            if (postRebuildTask) {
                this.rebuildRegionTask.schedule(0);
            }
        }
    }

    private void checkFactoriesComponentInited() {
        if (this.viewFactories == null) {
            this.initFactories();
        }
    }

    void syncViewsRebuild() {
        OffsetRegion region = this.fetchRebuildRegion();
        if (region != null) {
            this.checkRebuild(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffsetRegion fetchRebuildRegion() {
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            OffsetRegion region = this.rebuildRegion;
            this.rebuildRegion = null;
            return region;
        }
    }

    private void checkRebuild(OffsetRegion region) {
        assert (region != null);
        this.documentView.checkDocumentLockedIfLogging();
        assert (!this.isBuildingViews()) : "Already building views";
        if (this.documentView.isActive()) {
            boolean createLocalViews;
            int docViewEndOffset;
            int docViewStartOffset;
            Document doc = this.documentView.getDocument();
            if (this.documentView.hasExtraBounds() && (region = region.intersection(doc, docViewStartOffset = this.documentView.getStartOffset(), docViewEndOffset = this.documentView.getEndOffset(), true)) == null) {
                return;
            }
            this.documentView.checkIntegrity();
            int paragraphViewIndex = this.documentView.getViewIndexFirst(region.startOffset());
            assert (paragraphViewIndex >= 0) : "Paragraph view index is " + paragraphViewIndex + " for " + region;
            ParagraphView paragraphView = (ParagraphView)this.documentView.getEditorView(paragraphViewIndex);
            boolean bl = createLocalViews = region.length() <= 200 + paragraphView.getLength();
            if (paragraphView.children == null) {
                int paragraphStartOffset = paragraphView.getStartOffset();
                assert (paragraphStartOffset <= region.startOffset()) : "paragraphStartOffset=" + paragraphStartOffset + " > rRegion.startOffset=" + region.startOffset();
                region = region.union(doc, paragraphStartOffset, paragraphStartOffset + paragraphView.getLength(), false);
                paragraphView = null;
                createLocalViews = false;
            }
            createLocalViews |= this.documentView.isAccurateSpan();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("ViewUpdates.checkRebuild-buildViews(): " + region + " createLocalViews=" + createLocalViews + "\n");
            }
            this.buildViews(paragraphView, paragraphViewIndex, region.startOffset(), region.endOffset(), region.endOffset(), 0, createLocalViews);
        }
    }

    void incomingEvent(DocumentEvent evt) {
        if (this.incomingEvent != null) {
            throw new IllegalStateException("Pending incoming event: " + this.incomingEvent);
        }
        this.incomingEvent = evt;
    }

    private void clearIncomingEvent(DocumentEvent evt) {
        if (this.incomingEvent == null) {
            throw new IllegalStateException("Incoming event already cleared");
        }
        if (this.incomingEvent != evt) {
            throw new IllegalStateException("Invalid incomingEvent=" + this.incomingEvent + " != evt=" + evt);
        }
        this.incomingEvent = null;
    }

    private final class IncomingModificationListener
    implements DocumentListener {
        private IncomingModificationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ViewUpdates.this.documentView.setIncomingModification(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
        }
    }
}

