/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewReplace;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;

final class ViewBuilder {
    private static final Logger LOG = Logger.getLogger(ViewBuilder.class.getName());
    private int prevViewEndOffset;
    private final int modLength;
    private final Element lineRoot;
    private int lineIndex;
    private int lineEndOffset;
    private int paragraphViewEndOffset = Integer.MIN_VALUE;
    private int matchOffset = Integer.MIN_VALUE;
    private final FactoryState[] factoryStates;
    private final ViewReplace<DocumentView, ParagraphView> dReplace;
    private ViewReplace<ParagraphView, EditorView> fReplace;
    private ViewReplace<ParagraphView, EditorView> pReplace;
    private boolean viewRemovalFinished;
    private List<ViewReplace<ParagraphView, EditorView>> pReplaceList;
    private int docViewEndOffset;
    private boolean createLocalViews;

    ViewBuilder(ParagraphView paragraphView, DocumentView documentView, int paragraphViewIndex, EditorViewFactory[] viewFactories, int startOffset, int endOffset, int modOffset, int modLength, boolean createLocalViews) {
        Document doc = documentView.getDocument();
        this.docViewEndOffset = documentView.getEndOffset();
        this.modLength = modLength;
        assert (startOffset >= 0) : "startOffset=" + startOffset + " < 0";
        assert (endOffset >= startOffset) : "endOffset=" + endOffset + " < startOffset=" + startOffset;
        if (endOffset > this.docViewEndOffset) {
            endOffset = this.docViewEndOffset;
        }
        this.createLocalViews = createLocalViews;
        if (!createLocalViews && paragraphView != null) {
            int pOffset;
            startOffset = pOffset = paragraphView.getStartOffset();
            paragraphView = null;
        }
        assert (paragraphView == null || createLocalViews) : "createLocalViews=" + createLocalViews + ", paragraphView=" + paragraphView;
        if (paragraphView != null) {
            this.fReplace = new ViewReplace(paragraphView, paragraphView.getViewIndex(startOffset));
            this.pReplace = this.fReplace;
            ++paragraphViewIndex;
        }
        this.dReplace = new ViewReplace(documentView, paragraphViewIndex);
        int beforeModEndOffset = endOffset - modLength;
        if (this.fReplace != null) {
            int childStartOffset;
            int paragraphViewStartOffset = paragraphView.getStartOffset();
            EditorView childView = this.fReplace.childViewAtIndex();
            startOffset = childStartOffset = childView.getStartOffset();
            this.paragraphViewEndOffset = paragraphViewStartOffset + paragraphView.getLength();
            if (beforeModEndOffset < this.paragraphViewEndOffset) {
                this.matchOffset = startOffset;
                while (this.matchOffset < beforeModEndOffset) {
                    this.matchOffset += childView.getLength();
                    ++this.fReplace.removeCount;
                    if (this.fReplace.removeEndIndex() == paragraphView.getViewCount()) {
                        assert (this.matchOffset == this.paragraphViewEndOffset) : "matchOffset=" + this.matchOffset + " != paragraphViewEndOffset=" + this.paragraphViewEndOffset;
                        break;
                    }
                    childView = paragraphView.getEditorView(this.fReplace.removeEndIndex());
                }
                assert (this.matchOffset >= beforeModEndOffset);
            } else {
                this.fReplace.removeTillEnd();
                this.matchOffset = this.paragraphViewEndOffset;
            }
        }
        if (this.matchOffset < beforeModEndOffset) {
            int paragraphCount = documentView.getViewCount();
            if (this.dReplace.index < paragraphCount) {
                Object pView = documentView.getEditorView(this.dReplace.index);
                if (this.paragraphViewEndOffset == Integer.MIN_VALUE) {
                    if (modOffset == endOffset && modLength == 0 && endOffset == this.docViewEndOffset && this.dReplace.index == 0) {
                        assert (paragraphView == null) : "paragraphView=" + paragraphView + " != null";
                        this.dReplace.removeCount = paragraphCount;
                        this.viewRemovalFinished = true;
                        this.matchOffset = this.paragraphViewEndOffset = this.docViewEndOffset;
                    } else {
                        this.paragraphViewEndOffset = modOffset == 0 && modLength > 0 && documentView.getStartOffset() == 0 ? 0 : ((View)pView).getStartOffset();
                    }
                }
                if (!this.viewRemovalFinished) {
                    this.paragraphViewEndOffset += ((EditorView)pView).getLength();
                    this.matchOffset = this.paragraphViewEndOffset;
                    ++this.dReplace.removeCount;
                    this.checkRemoveParagraphs(beforeModEndOffset, false);
                }
            } else {
                this.matchOffset = this.paragraphViewEndOffset = this.docViewEndOffset - modLength;
                this.viewRemovalFinished = true;
            }
        }
        assert (this.matchOffset >= 0) : "matchOffset=" + this.matchOffset;
        assert (this.paragraphViewEndOffset >= 0) : "paragraphViewEndOffset=" + this.paragraphViewEndOffset;
        if (modLength != 0) {
            this.matchOffset += modLength;
            this.paragraphViewEndOffset += modLength;
        }
        assert (this.matchOffset >= 0) : "matchOffset=" + this.matchOffset;
        assert (this.paragraphViewEndOffset >= 0) : "paragraphViewEndOffset=" + this.paragraphViewEndOffset;
        assert (this.matchOffset <= this.docViewEndOffset) : "matchOffset=" + this.matchOffset + " > docViewEndOffset=" + this.docViewEndOffset;
        this.prevViewEndOffset = startOffset;
        this.lineRoot = doc.getDefaultRootElement();
        this.lineIndex = this.lineRoot.getElementIndex(startOffset);
        Element line = this.lineRoot.getElement(this.lineIndex);
        this.lineEndOffset = line.getEndOffset();
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder: <").append(startOffset).append(",").append(endOffset);
            if (this.matchOffset != endOffset) {
                sb.append("=>").append(this.matchOffset);
            }
            sb.append(">, modOffset=").append(modOffset);
            sb.append(", docTextLength=").append(this.docViewEndOffset).append("\nfReplace=");
            if (this.fReplace != null) {
                sb.append(this.fReplace);
            } else {
                sb.append("<NULL>\n");
            }
            sb.append("dReplace=").append(this.dReplace);
            sb.append("lineIndex=").append(this.lineIndex);
            sb.append(", createLocalViews=").append(createLocalViews);
            sb.append('\n');
            LOG.fine(sb.toString());
        }
        this.factoryStates = new FactoryState[viewFactories.length];
        for (int i = 0; i < viewFactories.length; ++i) {
            FactoryState state = new FactoryState(viewFactories[i], startOffset);
            state.init(startOffset, this.matchOffset);
            state.updateNextViewStartOffset(startOffset);
            this.factoryStates[i] = state;
        }
        this.pReplaceList = new ArrayList<ViewReplace<ParagraphView, EditorView>>(2);
    }

    void createViews() {
        boolean doCreateViews;
        if (this.prevViewEndOffset > this.matchOffset) {
            throw new IllegalStateException("prevViewEndOffset=" + this.prevViewEndOffset + " > matchOffset=" + this.matchOffset);
        }
        boolean bl = doCreateViews = this.prevViewEndOffset < this.matchOffset;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("ViewBuilder.createViews(): doCreateViews=" + doCreateViews + "ViewBuilder:\n" + this);
        }
        if (this.prevViewEndOffset == this.matchOffset && this.fReplace != null) {
            assert (this.fReplace == this.pReplace);
            if (this.fReplace.added == null && this.fReplace.removeCount == ((ParagraphView)this.fReplace.view).getViewCount()) {
                assert (this.fReplace.index == 0) : "Invalid full-remove fReplace: " + this.fReplace;
                this.fReplace = null;
                this.pReplace = null;
                --this.dReplace.index;
                ++this.dReplace.removeCount;
            } else {
                boolean newlineViewRetained = this.fReplace.removeEndIndex() < ((ParagraphView)this.fReplace.view).getViewCount();
                this.checkRemoveParagraphs(this.prevViewEndOffset, newlineViewRetained);
            }
        }
        if (doCreateViews) {
            try {
                while (this.createNextView()) {
                }
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("ViewBuilder: Error in view creation: " + this.toString(), ex);
            }
        }
        if (this.pReplace != null && this.pReplace != this.fReplace) {
            throw new IllegalStateException("Unfinished non-first replace - error during view replacement: view:\n" + ((DocumentView)this.dReplace.view).toStringDetail() + "\n\npReplace:\n" + this.pReplace + "\nfReplace:\n" + this.fReplace);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ViewBuilder-creationEndOffset=" + this.prevViewEndOffset + "\n");
        }
        if (LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finer("ViewBuilder-Original:\n" + ((DocumentView)this.dReplace.view).toStringDetail() + '\n');
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder.createViews():\n");
            Document doc = ((DocumentView)this.dReplace.view).getDocument();
            sb.append("Creation for document: ").append(doc).append('\n');
            if (this.fReplace != null) {
                sb.append("fReplace:").append(this.fReplace);
            }
            sb.append("dReplace:").append(this.dReplace);
            sb.append("pReplaceList:\n");
            int digitCount = ArrayUtilities.digitCount((int)this.pReplaceList.size());
            for (int i = 0; i < this.pReplaceList.size(); ++i) {
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append(this.pReplaceList.get(i));
            }
            LOG.fine(sb.toString());
        }
    }

    boolean createNextView() {
        int limitOffset = this.matchOffset;
        if (limitOffset > this.docViewEndOffset) {
            throw new IllegalStateException("matchOffset=" + this.matchOffset + " > docViewEndOffset=" + this.docViewEndOffset + "\ndocView:\n" + ((DocumentView)this.dReplace.view).toStringDetail());
        }
        for (int i = this.factoryStates.length - 1; i >= 0; --i) {
            FactoryState state = this.factoryStates[i];
            int cmp = state.nextViewStartOffset - this.prevViewEndOffset;
            if (cmp < 0) {
                state.updateNextViewStartOffset(this.prevViewEndOffset);
                cmp = state.nextViewStartOffset - this.prevViewEndOffset;
            }
            if (cmp == 0) {
                boolean eolView;
                int createdViewEndOffset;
                if (this.prevViewEndOffset < 0) {
                    throw new IllegalStateException("prevViewEndOffset=" + this.prevViewEndOffset + " < 0");
                }
                if (this.prevViewEndOffset >= limitOffset) {
                    throw new IllegalStateException("prevViewEndOffset=" + this.prevViewEndOffset + " >= limitOffset=" + limitOffset + ", docTextLength=" + this.docViewEndOffset);
                }
                if (limitOffset > this.docViewEndOffset) {
                    throw new IllegalStateException("limitOffset=" + limitOffset + " > docTextLength=" + this.docViewEndOffset);
                }
                EditorView view = null;
                if (this.createLocalViews) {
                    view = state.factory.createView(this.prevViewEndOffset, limitOffset);
                    if (view == null) continue;
                    createdViewEndOffset = this.prevViewEndOffset + view.getLength();
                } else {
                    createdViewEndOffset = state.factory.viewEndOffset(this.prevViewEndOffset, limitOffset);
                    if (createdViewEndOffset == -1) continue;
                }
                if (createdViewEndOffset > this.docViewEndOffset) {
                    throw new IllegalStateException("View " + view + " produced by factory " + state.factory + " has endOffset=" + createdViewEndOffset + " but docTextLength=" + this.docViewEndOffset);
                }
                this.updateLine(createdViewEndOffset);
                boolean bl = eolView = createdViewEndOffset == this.lineEndOffset;
                if (!this.viewRemovalFinished) {
                    if (this.fReplace != null && this.fReplace == this.pReplace) {
                        if (createdViewEndOffset > this.paragraphViewEndOffset || eolView) {
                            this.fReplace.removeTillEnd();
                            if (this.paragraphViewEndOffset > this.docViewEndOffset) {
                                throw new IllegalStateException("paragraphViewEndOffset=" + this.paragraphViewEndOffset + " > docViewEndOffset=" + this.docViewEndOffset + "\ndocView:\n" + ((DocumentView)this.dReplace.view).toStringDetail());
                            }
                            this.matchOffset = this.paragraphViewEndOffset;
                            this.checkRemoveParagraphs(createdViewEndOffset, eolView);
                        } else if (createdViewEndOffset > this.matchOffset) {
                            int index;
                            int viewCount = ((ParagraphView)this.fReplace.view).getViewCount();
                            while ((index = this.fReplace.removeEndIndex()) < viewCount) {
                                this.matchOffset += ((EditorView)((ParagraphView)this.pReplace.view).getEditorView(index)).getLength();
                                if (this.matchOffset > this.docViewEndOffset) {
                                    throw new IllegalStateException("matchOffset=" + this.matchOffset + " > docViewEndOffset=" + this.docViewEndOffset + ", pReplace-view-length=" + ((EditorView)((ParagraphView)this.pReplace.view).getEditorView(index)).getLength() + "\ndocView:\n" + ((DocumentView)this.dReplace.view).toStringDetail());
                                }
                                ++this.pReplace.removeCount;
                                if (createdViewEndOffset > this.matchOffset) continue;
                            }
                            assert (index < viewCount) : "Replace includes last local view; viewCount=" + viewCount + ", matchOffset=" + this.matchOffset + ", paragraphViewEndOffset=" + this.paragraphViewEndOffset + ", docTextLength=" + this.docViewEndOffset;
                        }
                    } else {
                        this.checkRemoveParagraphs(createdViewEndOffset, eolView);
                    }
                }
                assert (this.viewRemovalFinished || createdViewEndOffset <= this.matchOffset) : "createdViewEndOffset=" + createdViewEndOffset + " > matchOffset=" + this.matchOffset + ", docTextLength=" + this.docViewEndOffset;
                if (this.pReplace == null) {
                    Position startPos;
                    try {
                        startPos = ((DocumentView)this.dReplace.view).getDocument().createPosition(this.prevViewEndOffset);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException("Cannot create position at offset=" + this.prevViewEndOffset);
                    }
                    ParagraphView paragraphView = new ParagraphView(startPos);
                    this.dReplace.add(paragraphView);
                    this.pReplace = new ViewReplace(paragraphView, 0);
                    if (this.createLocalViews) {
                        this.pReplaceList.add(this.pReplace);
                    }
                }
                if (this.createLocalViews) {
                    this.pReplace.add(view);
                }
                if (eolView) {
                    if (this.fReplace != this.pReplace) {
                        int length = createdViewEndOffset - ((ParagraphView)this.pReplace.view).getStartOffset();
                        ((ParagraphView)this.pReplace.view).setLength(length);
                    }
                    this.pReplace = null;
                }
                this.prevViewEndOffset = createdViewEndOffset;
                return this.prevViewEndOffset < this.matchOffset;
            }
            if (state.nextViewStartOffset >= this.docViewEndOffset || (limitOffset = state.nextViewStartOffset) <= this.docViewEndOffset) continue;
            throw new IllegalStateException("state: limitOffset=" + limitOffset + " > docViewEndOffset=" + this.docViewEndOffset + "\ndocView:\n" + ((DocumentView)this.dReplace.view).toStringDetail());
        }
        throw new IllegalStateException("No factory returned view for offset=" + this.prevViewEndOffset);
    }

    private void checkRemoveParagraphs(int createdViewEndOffset, boolean newlineViewCreated) {
        while (createdViewEndOffset > this.matchOffset || !newlineViewCreated && createdViewEndOffset == this.matchOffset) {
            int index = this.dReplace.removeEndIndex();
            if (index < ((DocumentView)this.dReplace.view).getViewCount()) {
                ParagraphView removeView = (ParagraphView)((DocumentView)this.dReplace.view).getEditorView(index);
                ++this.dReplace.removeCount;
                this.paragraphViewEndOffset += removeView.getLength();
                this.matchOffset = this.paragraphViewEndOffset;
                continue;
            }
            this.viewRemovalFinished = true;
            break;
        }
    }

    void replaceAndRepaintViews() {
        DocumentView docView = (DocumentView)this.dReplace.view;
        final JTextComponent textComponent = docView.getTextComponent();
        final Rectangle repaintBounds = new Rectangle(0, 0, -1, -1);
        assert (textComponent != null) : "Null textComponent";
        boolean docViewHeightChanged = false;
        boolean docViewWidthChanged = false;
        Rectangle2D.Double docViewBounds = docView.getAllocation();
        TextLayoutCache textLayoutCache = docView.getTextLayoutCache();
        VisualUpdate fUpdate = null;
        if (this.fReplace != null && (fUpdate = this.fReplace.replaceViews(this.modLength)) != null) {
            Shape childAlloc = docView.getChildAllocation(this.dReplace.index - 1, docViewBounds);
            fUpdate.updateSpansAndLayout(childAlloc);
            if (fUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= fUpdate.isWidthChanged();
                docViewHeightChanged |= fUpdate.isHeightChanged();
            }
            if (!fUpdate.getRepaintBounds().isEmpty()) {
                repaintBounds.add(fUpdate.getRepaintBounds());
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("fReplace:REPAINT:" + ViewUtils.toString(fUpdate.getRepaintBounds()) + '\n');
                }
            }
        }
        for (int i = 0; i < this.dReplace.removeCount; ++i) {
            ParagraphView paragraphView = (ParagraphView)docView.getEditorView(this.dReplace.index + i);
            if (paragraphView.children == null) continue;
            textLayoutCache.remove(paragraphView);
        }
        this.dReplace.retainSpans();
        VisualUpdate dUpdate = this.dReplace.replaceViews(0);
        for (int i = 0; i < this.pReplaceList.size(); ++i) {
            ViewReplace<ParagraphView, EditorView> replace = this.pReplaceList.get(i);
            VisualUpdate pUpdate = replace.replaceViews(0);
            if (pUpdate == null) continue;
            Shape childAlloc = docView.getChildAllocation(this.dReplace.index + i, docViewBounds);
            pUpdate.updateSpansAndLayout(childAlloc);
            if (pUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= pUpdate.isWidthChanged();
                docViewHeightChanged |= pUpdate.isHeightChanged();
            }
            if (pUpdate.getRepaintBounds().isEmpty()) continue;
            repaintBounds.add(pUpdate.getRepaintBounds());
            if (!LOG.isLoggable(Level.FINEST)) continue;
            LOG.fine("pReplaceList[" + i + "]:REPAINT:" + ViewUtils.toString(pUpdate.getRepaintBounds()) + '\n');
        }
        if (dUpdate != null) {
            dUpdate.updateSpansAndLayout(docViewBounds);
            if (dUpdate.isPreferenceChanged()) {
                docViewWidthChanged |= dUpdate.isWidthChanged();
                docViewHeightChanged |= dUpdate.isHeightChanged();
            }
            if (!dUpdate.getRepaintBounds().isEmpty()) {
                repaintBounds.add(dUpdate.getRepaintBounds());
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("dReplace:REPAINT:" + ViewUtils.toString(dUpdate.getRepaintBounds()) + '\n');
                }
            }
        }
        if (fUpdate != null && fUpdate.isPreferenceChanged()) {
            docView.preferenceChanged(this.dReplace.index - 1, fUpdate.isWidthChanged(), fUpdate.isHeightChanged(), false);
        }
        if (!repaintBounds.isEmpty()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.fine("REPAINT-bounds:" + ViewUtils.toString(repaintBounds) + '\n');
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewUtils.repaint(textComponent, repaintBounds);
                }
            });
        }
        if (docViewWidthChanged || docViewHeightChanged) {
            docView.preferenceChanged(null, docViewWidthChanged, docViewHeightChanged);
        }
    }

    void finish() {
        for (FactoryState factoryState : this.factoryStates) {
            factoryState.factory.finish();
        }
        ((DocumentView)this.dReplace.view).checkIntegrity();
    }

    void updateLine(int offset) {
        while (offset > this.lineEndOffset) {
            ++this.lineIndex;
            Element line = this.lineRoot.getElement(this.lineIndex);
            this.lineEndOffset = line.getEndOffset();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("-------- ViewBuilder dump -------\n");
        sb.append("prevViewEndOffset=").append(this.prevViewEndOffset).append('\n');
        sb.append("modLength=").append(this.modLength).append('\n');
        sb.append("docViewEndOffset=").append(this.docViewEndOffset).append('\n');
        sb.append("lineIndex=").append(this.lineIndex).append('\n');
        sb.append("lineEndOffset=").append(this.lineEndOffset).append('\n');
        sb.append("paragraphViewEndOffset=").append(this.paragraphViewEndOffset).append('\n');
        sb.append("matchOffset=").append(this.matchOffset).append('\n');
        sb.append("fReplace=").append(this.fReplace).append('\n');
        sb.append("dReplace=").append(this.dReplace).append('\n');
        sb.append("pReplace=").append(this.pReplace).append('\n');
        sb.append("pReplaceList=").append(this.pReplaceList).append('\n');
        sb.append("viewRemovalFinished=").append(this.viewRemovalFinished).append('\n');
        sb.append("-------- End of ViewBuilder dump -------\n");
        return sb.toString();
    }

    private static final class FactoryState {
        final EditorViewFactory factory;
        int nextViewStartOffset;

        FactoryState(EditorViewFactory factory, int startOffset) {
            this.factory = factory;
        }

        void init(int startOffset, int matchOffset) {
            this.factory.restart(startOffset, matchOffset);
        }

        void updateNextViewStartOffset(int offset) {
            this.nextViewStartOffset = this.factory.nextViewStartOffset(offset);
            if (this.nextViewStartOffset < offset) {
                throw new IllegalStateException("Editor view factory " + this.factory + " returned nextViewStartOffset=" + this.nextViewStartOffset + " < offset=" + offset);
            }
        }
    }
}

