/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Shape;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorBoxViewChildren;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.ParagraphViewChildren;
import org.netbeans.modules.editor.lib2.view.ViewStats;

public class ParagraphView
extends EditorBoxView<EditorView> {
    private static final Logger LOG = Logger.getLogger(ParagraphView.class.getName());
    private Position startPos;
    private int length;

    public ParagraphView(Position startPos) {
        super(null);
        this.startPos = startPos;
    }

    @Override
    public int getMajorAxis() {
        return 0;
    }

    @Override
    public int getStartOffset() {
        return this.startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getRawOffset() {
        return -1;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        throw new IllegalStateException("setRawOffset() must not be called on ParagraphView.");
    }

    @Override
    protected EditorBoxViewChildren<EditorView> createChildren(int capacity) {
        return new ParagraphViewChildren(capacity);
    }

    DocumentView getDocumentView() {
        return (DocumentView)this.getParent();
    }

    @Override
    public void setParent(View parent) {
        DocumentView documentView;
        super.setParent(parent);
        if (parent instanceof EditorBoxView && (documentView = this.getDocumentView()) != null && this.getMinorAxisSpan() == 0.0f) {
            this.setMinorAxisSpan(documentView.getDefaultLineHeight());
        }
    }

    int getNextVisualPositionY(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet, double x) {
        return ((ParagraphViewChildren)this.children).getNextVisualPositionY(this, offset, bias, alloc, direction, biasRet, x);
    }

    int getNextVisualPositionX(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        switch (direction) {
            case 3: 
            case 7: {
                int viewCount = this.getViewCount();
                int increment = direction == 3 ? 1 : -1;
                int retOffset = -1;
                for (int index = this.getViewIndex(offset); retOffset == -1 && index >= 0 && index < viewCount; index += increment) {
                    Shape viewAlloc;
                    Object view = this.getEditorViewChildrenValid(index);
                    retOffset = ((EditorView)view).getNextVisualPositionFromChecked(offset, bias, viewAlloc = this.getChildAllocation(index, alloc), direction, biasRet);
                    if (retOffset != -1) continue;
                    offset = -1;
                }
                return retOffset;
            }
            case 1: 
            case 5: {
                throw new IllegalStateException("Not intended to handle EAST and WEST directions");
            }
        }
        throw new IllegalArgumentException("Bad direction: " + direction);
    }

    @Override
    protected void releaseChildren() {
        this.releaseTextLayouts();
        super.releaseChildren();
    }

    void releaseTextLayouts() {
        DocumentView docView = this.getDocumentView();
        if (docView != null) {
            int viewCount = this.getViewCount();
            for (int i = 0; i < viewCount; ++i) {
                Object view = this.getEditorView(i);
                if (!(view instanceof HighlightsView)) continue;
                ((HighlightsView)view).setLayout(null);
            }
            docView.getTextLayoutCache().remove(this);
        }
    }

    void initTextLayouts() {
        assert (this.children != null) : "Null children";
        ViewStats.incrementInitTextLayouts();
        this.updateViews(0, this.getViewCount(), null);
    }

    void recomputeLayout() {
        if (this.children != null) {
            ((ParagraphViewChildren)this.children).recomputeLayout(this);
        }
    }

    @Override
    public String findIntegrityError() {
        String err = super.findIntegrityError();
        if (err != null) {
            return err;
        }
        if (this.children != null) {
            int childrenLength = this.children.getLength();
            if (this.getLength() != childrenLength) {
                return "length=" + this.getLength() + " != childrenLength=" + childrenLength;
            }
            err = HighlightsViewUtils.findLayoutIntegrityError(this);
        }
        return err;
    }

    @Override
    protected String getDumpName() {
        return "PV";
    }
}

