/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewUtils;
import org.netbeans.modules.editor.lib2.view.PaintState;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public final class NewlineView
extends EditorView {
    private int rawOffset;
    private final AttributeSet attributes;

    public NewlineView(int offset, AttributeSet attributes) {
        super(null);
        this.rawOffset = offset;
        this.attributes = attributes;
    }

    @Override
    public int getRawOffset() {
        return this.rawOffset;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    @Override
    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)((Object)this.getParent());
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attributes;
    }

    @Override
    public float getPreferredSpan(int axis) {
        DocumentView documentView = this.getDocumentView();
        if (axis == 0) {
            return documentView != null ? (documentView.isShowNonprintingCharacters() ? documentView.getDefaultLineHeight() : documentView.getDefaultCharWidth()) : 1.0f;
        }
        return documentView != null ? documentView.getDefaultLineHeight() : 1.0f;
    }

    ParagraphView getParagraphView() {
        return (ParagraphView)this.getParent();
    }

    DocumentView getDocumentView() {
        ParagraphView paragraphView = this.getParagraphView();
        return paragraphView != null ? paragraphView.getDocumentView() : null;
    }

    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        mutableBounds.width = this.getPreferredSpan(0);
        return mutableBounds;
    }

    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        return this.getStartOffset();
    }

    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        DocumentView docView = this.getDocumentView();
        if (docView != null) {
            Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
            mutableBounds.width = (double)docView.getWidth() - mutableBounds.x;
            if (mutableBounds.intersects(clipBounds)) {
                PaintState paintState = PaintState.save(g);
                try {
                    TextLayout textLayout;
                    int lineX;
                    JTextComponent textComponent = docView.getTextComponent();
                    Color componentBackground = textComponent.getBackground();
                    ViewUtils.applyBackgroundAttributes(this.attributes, componentBackground, g);
                    if (!componentBackground.equals(g.getColor())) {
                        ViewUtils.fillRect(g, mutableBounds);
                    }
                    int xInt = (int)mutableBounds.getX();
                    int yInt = (int)mutableBounds.getY();
                    int endXInt = (int)(mutableBounds.getX() + mutableBounds.getWidth() - 1.0);
                    int endYInt = (int)(mutableBounds.getY() + mutableBounds.getHeight() - 1.0);
                    Color textLimitLineColor = docView.getTextLimitLineColor();
                    boolean drawTextLimitLine = docView.isTextLimitLineDrawn();
                    int textLimitWidth = docView.getTextLimitWidth();
                    float defaultCharWidth = docView.getDefaultCharWidth();
                    if (drawTextLimitLine && textLimitWidth > 0 && (lineX = (int)((float)textLimitWidth * defaultCharWidth)) >= xInt && lineX <= endXInt) {
                        g.setColor(textLimitLineColor);
                        g.drawLine(lineX, yInt, lineX, endYInt);
                    }
                    if (docView.isShowNonprintingCharacters() && (textLayout = docView.getNewlineCharTextLayout()) != null) {
                        HighlightsViewUtils.paintForeground(g, mutableBounds, textLayout, this.getAttributes(), docView);
                    }
                }
                finally {
                    paintState.restore();
                }
            }
        }
    }

    @Override
    protected String getDumpName() {
        return "NV";
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

