/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.PriorityMutex;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DebugRepaintManager;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorTabExpander;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewStats;
import org.netbeans.modules.editor.lib2.view.ViewUpdates;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class DocumentView
extends EditorBoxView<ParagraphView>
implements PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(DocumentView.class.getName());
    private static final Logger REPAINT_LOG = Logger.getLogger(DebugRepaintManager.class.getName());
    private static final Logger LOG_QUERY_IN_MODIFICATION = Logger.getLogger(DocumentView.class.getName() + "-QueryInModification");
    private static final Logger LOG_MODEL_VIEW = Logger.getLogger(DocumentView.class.getName() + "-ModelView");
    private static final Logger LOG_PAINT = Logger.getLogger(DocumentView.class.getName() + "-Paint");
    static final boolean LOG_SOURCE_TEXT = Boolean.getBoolean("org.netbeans.editor.log.source.text");
    static final char PRINTING_SPACE = '\u00b7';
    static final char PRINTING_TAB = '\u00bb';
    static final char PRINTING_NEWLINE = '\u00b6';
    static final char LINE_CONTINUATION = '\u21a9';
    static final char LINE_CONTINUATION_ALTERNATE = '\u2190';
    private static final String MUTEX_CLIENT_PROPERTY = "foldHierarchyMutex";
    private static final String START_POSITION_PROPERTY = "document-view-start-position";
    private static final String END_POSITION_PROPERTY = "document-view-end-position";
    private static final String ACCURATE_SPAN_PROPERTY = "document-view-accurate-span";
    private PriorityMutex pMutex;
    private JTextComponent textComponent;
    private ViewUpdates viewUpdates;
    private TextLayoutCache textLayoutCache;
    private boolean incomingModification;
    private boolean childrenValid;
    private Position startPos;
    private Position endPos;
    private float width;
    private float height;
    private boolean accurateSpan;
    private int visibleWidth;
    private int visibleHeight;
    private FontRenderContext fontRenderContext;
    private Font defaultFont;
    private boolean customFont;
    private float defaultLineHeight;
    private float defaultAscent;
    private float defaultDescent;
    private float defaultLeading;
    private float defaultCharWidth;
    private Color defaultForeground;
    private boolean customForeground;
    private Color defaultBackground;
    private boolean customBackground;
    private Color defaultLimitLine;
    private int defaultLimitLineWidth;
    private LineWrapType lineWrapType;
    private TextLayout newlineTextLayout;
    private TextLayout tabTextLayout;
    private TextLayout singleCharTabTextLayout;
    private TextLayout lineContinuationTextLayout;
    private TabExpander tabExpander;
    private LookupListener lookupListener;
    private JViewport listeningOnViewport;
    private Preferences prefs;
    private PreferenceChangeListener prefsListener;
    private Map<?, ?> renderingHints;
    private int lengthyAtomicEdit;
    ViewHierarchy viewHierarchy;
    private Map<Font, FontInfo> fontInfos = new HashMap<Font, FontInfo>(4);

    public static DocumentView get(JTextComponent component) {
        View view;
        View rootView;
        TextUI textUI = component.getUI();
        if (textUI != null && (rootView = textUI.getRootView(component)) != null && rootView.getViewCount() > 0 && (view = rootView.getView(0)) instanceof DocumentView) {
            return (DocumentView)view;
        }
        return null;
    }

    static DocumentView get(View view) {
        while (view != null && !(view instanceof DocumentView)) {
            view = view.getParent();
        }
        return (DocumentView)view;
    }

    public DocumentView(Element elem) {
        super(elem);
        assert (elem != null) : "Expecting non-null element";
        this.tabExpander = new EditorTabExpander(this);
    }

    public ViewHierarchy viewHierarchy() {
        return this.viewHierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(Runnable r) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                r.run();
            }
            finally {
                mutex.unlock();
            }
        } else {
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncViewsRebuild() {
        this.checkDocumentLockedIfLogging();
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                if (this.viewUpdates != null) {
                    this.viewUpdates.syncViewsRebuild();
                }
            }
            finally {
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getPreferredSpan(int axis) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                Container parent;
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (!this.childrenValid) {
                    float f = 0.0f;
                    return f;
                }
                float span = super.getPreferredSpan(axis);
                if (axis == 1 && this.textComponent != null && (parent = this.textComponent.getParent()) instanceof JViewport) {
                    JViewport viewport = (JViewport)parent;
                    int viewportHeight = viewport.getExtentSize().height;
                    span += (float)(viewportHeight / 3);
                }
                float f = span;
                return f;
            }
            finally {
                mutex.unlock();
            }
        }
        return 1.0f;
    }

    @Override
    protected void setMajorAxisSpan(double majorAxisSpan) {
        super.setMajorAxisSpan(majorAxisSpan);
    }

    @Override
    protected void setMinorAxisSpan(float minorAxisSpan) {
        super.setMinorAxisSpan(minorAxisSpan);
    }

    public PriorityMutex getMutex() {
        return this.pMutex;
    }

    @Override
    public Document getDocument() {
        return this.getElement().getDocument();
    }

    @Override
    public int getStartOffset() {
        return this.startPos != null ? this.startPos.getOffset() : super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.endPos != null ? this.endPos.getOffset() : super.getEndOffset();
    }

    boolean hasExtraBounds() {
        return this.endPos != null;
    }

    @Override
    public void setLength(int length) {
    }

    @Override
    public int getMajorAxis() {
        return 1;
    }

    @Override
    protected TabExpander getTabExpander() {
        return this.tabExpander;
    }

    @Override
    public int getRawOffset() {
        return 0;
    }

    @Override
    public void setRawOffset(int rawOffset) {
        throw new IllegalStateException("Unexpected");
    }

    @Override
    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public Rectangle2D.Double getAllocation() {
        return new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
    }

    public float getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParent(View parent) {
        if (parent != null) {
            PriorityMutex mutex;
            Container container = parent.getContainer();
            assert (container != null) : "Container is null";
            assert (container instanceof JTextComponent) : "Container not JTextComponent";
            JTextComponent tc = (JTextComponent)container;
            this.pMutex = (PriorityMutex)tc.getClientProperty(MUTEX_CLIENT_PROPERTY);
            if (this.pMutex == null) {
                this.pMutex = new PriorityMutex();
                tc.putClientProperty(MUTEX_CLIENT_PROPERTY, this.pMutex);
            }
            if ((mutex = this.getMutex()) == null) return;
            mutex.lock();
            try {
                super.setParent(parent);
                this.textLayoutCache = new TextLayoutCache();
                this.textComponent = tc;
                this.viewHierarchy = ViewHierarchy.get(this.textComponent);
                this.startPos = (Position)this.textComponent.getClientProperty(START_POSITION_PROPERTY);
                this.endPos = (Position)this.textComponent.getClientProperty(END_POSITION_PROPERTY);
                if (this.startPos != null) {
                    if (this.endPos == null) {
                        this.endPos = this.getDocument().getEndPosition();
                        assert (this.endPos != null) : "Null position from doc.getEndPosition()";
                    }
                } else if (this.endPos != null) {
                    this.startPos = this.getDocument().getStartPosition();
                    assert (this.startPos != null) : "Null position from doc.getStartPosition()";
                }
                this.accurateSpan = Boolean.TRUE.equals(this.textComponent.getClientProperty(ACCURATE_SPAN_PROPERTY));
                this.viewUpdates = new ViewUpdates(this);
                this.textComponent.addPropertyChangeListener(this);
                if (!REPAINT_LOG.isLoggable(Level.FINE)) return;
                DebugRepaintManager.register(this.textComponent);
                return;
            }
            finally {
                mutex.unlock();
            }
        } else {
            this.getDocument().render(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PriorityMutex mutex = DocumentView.this.getMutex();
                    if (mutex != null) {
                        mutex.lock();
                        try {
                            if (DocumentView.this.textComponent != null) {
                                if (DocumentView.this.listeningOnViewport != null) {
                                    DocumentView.this.listeningOnViewport.removeChangeListener(DocumentView.this);
                                }
                                DocumentView.this.textComponent.removePropertyChangeListener(DocumentView.this);
                                DocumentView.this.textLayoutCache = null;
                                DocumentView.this.viewUpdates = null;
                                DocumentView.this.textComponent = null;
                            }
                            DocumentView.super.setParent(null);
                        }
                        finally {
                            mutex.unlock();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void preferenceChanged(View childView, boolean width, boolean height) {
        super.preferenceChanged(childView, width, height);
        if (childView == null && LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.INFO, "Cause of DocumentView.preferenceChanged()", new Exception());
            }
            float prefWidth = this.getPreferredSpan(0);
            float prefHeight = this.getPreferredSpan(1);
            String changed = (width ? "T" : "F") + "x" + (height ? "T" : "F");
            LOG.finer("DocumentView-preferenceChanged: WxH[" + changed + "]:" + prefWidth + "x" + prefHeight + '\n');
        }
    }

    void checkViewsInited() {
        if (!this.childrenValid && this.textComponent != null) {
            this.updateVisibleDimension();
            this.checkSettingsInfo();
            this.checkFontRenderContext();
            ((EditorTabExpander)this.tabExpander).updateTabSize();
            if (this.isBuildable()) {
                LOG.fine("viewUpdates.reinitViews()\n");
                this.childrenValid = true;
                this.viewUpdates.reinitViews();
                if (!this.childrenValid) {
                    this.childrenValid = true;
                    this.viewUpdates.reinitViews();
                }
            }
        }
    }

    private void checkFontRenderContext() {
        Graphics graphics;
        if (this.fontRenderContext == null && (graphics = this.textComponent.getGraphics()) != null) {
            assert (graphics instanceof Graphics2D) : "Not Graphics2D";
            if (this.renderingHints != null) {
                ((Graphics2D)graphics).setRenderingHints(this.renderingHints);
            }
            this.fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            if (this.fontRenderContext != null) {
                this.updateCharMetrics();
            }
        }
    }

    @Override
    protected void releaseChildren() {
        this.childrenValid = false;
    }

    public void releaseChildrenLocked(final boolean updateFonts) {
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        if (updateFonts) {
                            DocumentView.this.updateDefaultFontAndColors(null);
                        } else {
                            DocumentView.this.releaseChildren();
                        }
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
    }

    @Override
    protected void initChildren(int startIndex, int endIndex) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("DocumentView.initChildren(): <" + startIndex + "," + endIndex + ">\n");
        }
        this.viewUpdates.initChildren(startIndex, endIndex);
    }

    void recomputeLayout() {
        boolean widthChange;
        this.checkDocumentLockedIfLogging();
        int viewCount = this.getViewCount();
        boolean heightChange = false;
        float origWidth = this.getMinorAxisSpan();
        float newWidth = 0.0f;
        for (int i = 0; i < viewCount; ++i) {
            boolean childWidthChange;
            ParagraphView paragraphView = (ParagraphView)this.getEditorView(i);
            double origChildWidth = paragraphView.getMajorAxisSpan();
            float origChildHeight = paragraphView.getMinorAxisSpan();
            paragraphView.recomputeLayout();
            double childWidth = paragraphView.getMajorAxisSpan();
            boolean bl = childWidthChange = origChildWidth != childWidth;
            if (childWidth > (double)newWidth) {
                newWidth = (float)childWidth;
            }
            boolean childHeightChange = origChildHeight != paragraphView.getMinorAxisSpan();
            heightChange |= childHeightChange;
            this.preferenceChanged(i, childWidthChange, childHeightChange, false);
        }
        boolean bl = widthChange = origWidth != newWidth;
        if (widthChange) {
            this.setMinorAxisSpan(newWidth);
        }
        if (widthChange || heightChange) {
            this.preferenceChanged(null, widthChange, heightChange);
        }
        this.viewHierarchy.fireViewHierarchyEvent(new ViewHierarchyEvent(this.viewHierarchy, this.getStartOffset()));
    }

    boolean isAccurateSpan() {
        return this.accurateSpan;
    }

    private void updateVisibleDimension() {
        boolean heightDiffers;
        Dimension newSize;
        Container parent = this.textComponent.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            if (this.listeningOnViewport != viewport) {
                if (this.listeningOnViewport != null) {
                    this.listeningOnViewport.removeChangeListener(this);
                }
                viewport.addChangeListener(this);
                this.listeningOnViewport = viewport;
            }
            newSize = viewport.getExtentSize();
        } else {
            newSize = this.textComponent.getSize();
        }
        boolean widthDiffers = newSize.width != this.visibleWidth;
        boolean bl = heightDiffers = newSize.height != this.visibleHeight;
        if (widthDiffers) {
            this.visibleWidth = newSize.width;
        }
        if (heightDiffers) {
            this.visibleHeight = newSize.height;
        }
        if (widthDiffers) {
            this.recomputeLayout();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Document doc = this.getDocument();
        doc.render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        if (DocumentView.this.textComponent != null) {
                            DocumentView.this.updateVisibleDimension();
                        }
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
    }

    private void checkSettingsInfo() {
        String mimeType;
        JTextComponent tc = this.textComponent;
        if (tc == null) {
            return;
        }
        if (this.lookupListener == null) {
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    final Lookup.Result result = (Lookup.Result)ev.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DocumentView.this.getDocument().render(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    PriorityMutex mutex = DocumentView.this.getMutex();
                                    if (mutex != null) {
                                        mutex.lock();
                                        try {
                                            if (DocumentView.this.textComponent != null) {
                                                DocumentView.this.updateDefaultFontAndColors((Lookup.Result<FontColorSettings>)result);
                                            }
                                        }
                                        finally {
                                            mutex.unlock();
                                        }
                                    }
                                }
                            });
                        }
                    });
                }
            };
            mimeType = DocumentUtilities.getMimeType((JTextComponent)tc);
            Lookup lookup = MimeLookup.getLookup((String)mimeType);
            Lookup.Result result = lookup.lookupResult(FontColorSettings.class);
            this.updateDefaultFontAndColors((Lookup.Result<FontColorSettings>)result);
            result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)result));
        }
        if (this.prefs == null) {
            mimeType = DocumentUtilities.getMimeType((JTextComponent)tc);
            this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
            this.prefsListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    String key = evt.getKey();
                    if (key == null || key.equals("non-printable-characters-visible")) {
                        DocumentView.this.releaseChildrenLocked(false);
                    }
                }
            };
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        }
        if (this.lineWrapType == null) {
            this.updateLineWrapType();
            Document doc = this.getDocument();
            Integer dllw = (Integer)doc.getProperty("text-limit-width");
            this.defaultLimitLineWidth = dllw != null ? dllw : 80;
            DocumentUtilities.addPropertyChangeListener((Document)doc, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)doc));
        }
    }

    private void updateLineWrapType() {
        String lwt = null;
        if (this.textComponent != null) {
            lwt = (String)this.textComponent.getClientProperty("text-line-wrap");
        }
        if (lwt == null) {
            Document doc = this.getDocument();
            lwt = (String)doc.getProperty("text-line-wrap");
        }
        if (lwt != null) {
            this.lineWrapType = LineWrapType.fromSettingValue(lwt);
            if (this.lineWrapType == null) {
                this.lineWrapType = LineWrapType.NONE;
            }
        }
    }

    void updateDefaultFontAndColors(Lookup.Result<FontColorSettings> result) {
        Font font = this.textComponent.getFont();
        Color foreColor = this.textComponent.getForeground();
        Color backColor = this.textComponent.getBackground();
        Color limitLineColor = Color.PINK;
        if (result != null) {
            Color c;
            FontColorSettings fcs = (FontColorSettings)result.allInstances().iterator().next();
            AttributeSet attributes = fcs.getFontColors("default");
            if (attributes != null) {
                font = ViewUtils.getFont(attributes, new Font(font.getFamily(), 0, font.getSize()));
                c = (Color)attributes.getAttribute(StyleConstants.Foreground);
                if (c != null) {
                    foreColor = c;
                }
                if ((c = (Color)attributes.getAttribute(StyleConstants.Background)) != null) {
                    backColor = c;
                }
                this.renderingHints = (Map)attributes.getAttribute(EditorStyleConstants.RenderingHints);
            }
            if ((attributes = fcs.getFontColors("text-limit-line-color")) != null && (c = (Color)attributes.getAttribute(StyleConstants.Foreground)) != null) {
                limitLineColor = c;
            }
        }
        this.defaultFont = font;
        this.defaultForeground = foreColor;
        this.defaultBackground = backColor;
        this.defaultLimitLine = limitLineColor;
        if (!this.customFont && this.textComponent != null) {
            this.textComponent.setFont(this.defaultFont);
        }
        if (!this.customForeground && this.textComponent != null) {
            this.textComponent.setForeground(this.defaultForeground);
        }
        if (!this.customBackground && this.textComponent != null) {
            this.textComponent.setBackground(this.defaultBackground);
        }
        if (this.textComponent != null) {
            this.updateCharMetrics();
            this.releaseChildren();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.getDumpId() + ": Updated DEFAULTS: font=" + this.defaultFont + ", fg=" + ViewUtils.toString(this.defaultForeground) + ", bg=" + ViewUtils.toString(this.defaultBackground) + '\n');
        }
    }

    private void updateCharMetrics() {
        FontRenderContext frc = this.getFontRenderContext();
        assert (this.defaultFont != null) : "Null defaultFont";
        if (frc != null) {
            this.fontInfos.clear();
            FontInfo defaultFontInfo = new FontInfo(this.defaultFont, this, frc);
            this.fontInfos.put(this.defaultFont, defaultFontInfo);
            this.defaultAscent = defaultFontInfo.ascent;
            this.defaultDescent = defaultFontInfo.descent;
            this.defaultLeading = defaultFontInfo.leading;
            this.updateLineHeight();
            this.defaultCharWidth = defaultFontInfo.charWidth;
            this.tabTextLayout = null;
            this.singleCharTabTextLayout = null;
            this.lineContinuationTextLayout = null;
            LOG.fine("updateCharMetrics(): FontRenderContext: AA=" + frc.isAntiAliased() + ", AATransformed=" + frc.isTransformed() + ", AAFractMetrics=" + frc.usesFractionalMetrics() + ", AAHint=" + frc.getAntiAliasingHint() + "\n");
        }
    }

    private void updateLineHeight() {
        this.defaultLineHeight = (float)Math.ceil(this.defaultAscent + this.defaultDescent + this.defaultLeading);
    }

    void notifyFontUse(Font font) {
        if (font == this.defaultFont || this.fontInfos.containsKey(font)) {
            return;
        }
        FontInfo fontInfo = new FontInfo(font, this, this.getFontRenderContext());
        this.fontInfos.put(font, fontInfo);
        boolean change = false;
        if (fontInfo.ascent > this.defaultAscent) {
            this.defaultAscent = fontInfo.ascent;
            change = true;
        }
        if (fontInfo.descent > this.defaultDescent) {
            this.defaultDescent = fontInfo.descent;
            change = true;
        }
        if (fontInfo.leading > this.defaultLeading) {
            this.defaultLeading = fontInfo.leading;
            change = true;
        }
        if (change) {
            this.updateLineHeight();
            this.releaseChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipTextChecked(double x, double y, Shape allocation) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (this.isActive()) {
                    String string = this.children.getToolTipTextChecked(this, x, y, allocation);
                    return string;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getToolTip(double x, double y, Shape allocation) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (this.isActive()) {
                    JComponent jComponent = this.children.getToolTip(this, x, y, allocation);
                    return jComponent;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                if (LOG_PAINT.isLoggable(Level.FINE)) {
                    LOG_PAINT.log(Level.FINE, "ViewHierarchy paint: clip=" + clipBounds + "\n", new Exception());
                }
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (this.isActive()) {
                    if (g != null && this.renderingHints != null) {
                        g.setRenderingHints(this.renderingHints);
                    }
                    super.paint(g, alloc, clipBounds);
                }
            }
            finally {
                mutex.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        Rectangle2D.Double rect = ViewUtils.shape2Bounds(alloc);
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                int index;
                Object msg;
                if (LOG_MODEL_VIEW.isLoggable(Level.FINE)) {
                    LOG_MODEL_VIEW.log(Level.FINE, "ViewHierarchy modelToView: offset=" + offset + "\n", new Exception());
                }
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (LOG.isLoggable(Level.FINER)) {
                    msg = "DocumentView.modelToViewChecked(): offset=" + offset + "\n";
                    LOG.finer((String)msg);
                }
                if (this.isActive()) {
                    msg = super.modelToViewChecked(offset, alloc, bias);
                    return msg;
                }
                if (this.children != null && (index = this.getViewIndexFirst(offset)) >= 0) {
                    rect.y = this.getViewVisualOffset(index);
                }
            }
            finally {
                mutex.unlock();
            }
        }
        if (this.defaultLineHeight > 0.0f) {
            rect.height = this.defaultLineHeight;
        }
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double modelToY(int offset, Shape alloc) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                int index;
                if (LOG_MODEL_VIEW.isLoggable(Level.FINE)) {
                    LOG_MODEL_VIEW.log(Level.FINE, "ViewHierarchy modelToY: offset=" + offset + "\n", new Exception());
                }
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (this.isActive() && (index = this.getViewIndexFirst(offset)) >= 0) {
                    double d = this.getViewVisualOffset(index);
                    return d;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                if (LOG_MODEL_VIEW.isLoggable(Level.FINE)) {
                    LOG_MODEL_VIEW.log(Level.FINE, "ViewHierarchy viewToModel: [x,y]=" + x + "," + y + "\n", new Exception());
                }
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (LOG.isLoggable(Level.FINER)) {
                    String msg = "DocumentView.viewToModelChecked(): x=" + x + ", y=" + y + "\n";
                    LOG.finer(msg);
                }
                if (this.isActive()) {
                    int n = super.viewToModelChecked(x, y, alloc, biasReturn);
                    return n;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        PriorityMutex mutex = this.getMutex();
        if (mutex != null) {
            mutex.lock();
            try {
                if (LOG_MODEL_VIEW.isLoggable(Level.FINE)) {
                    LOG_MODEL_VIEW.log(Level.FINE, "ViewHierarchy nextVisualPosition: offset=" + offset + "\n", new Exception());
                }
                this.checkDocumentLockedIfLogging();
                this.checkViewsInited();
                if (this.isActive()) {
                    int retOffset;
                    switch (direction) {
                        case 3: 
                        case 7: {
                            retOffset = this.getNextVisualPositionX(offset, bias, alloc, direction, biasRet);
                            break;
                        }
                        case 1: 
                        case 5: {
                            retOffset = this.getNextVisualPositionY(offset, bias, alloc, direction, biasRet);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad direction " + direction);
                        }
                    }
                    if (retOffset > 0 && biasRet[0] == Position.Bias.Backward) {
                        --retOffset;
                        biasRet[0] = Position.Bias.Forward;
                    }
                    if (retOffset == -1) {
                        retOffset = offset;
                    }
                    offset = retOffset;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        return offset;
    }

    private int getNextVisualPositionY(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        Shape offsetBounds;
        Point magicCaretPoint;
        assert (direction == 1 || direction == 5) : "Invalid direction " + direction;
        if (this.textComponent == null) {
            return -1;
        }
        Caret caret = this.textComponent.getCaret();
        Point point = magicCaretPoint = caret != null ? caret.getMagicCaretPosition() : null;
        double x = magicCaretPoint == null ? ((offsetBounds = this.modelToViewChecked(offset, alloc, bias)) == null ? 0.0 : offsetBounds.getBounds2D().getX()) : (double)magicCaretPoint.x;
        int viewCount = this.getViewCount();
        int increment = direction == 5 ? 1 : -1;
        int retOffset = -1;
        for (int pIndex = this.getViewIndex(offset, bias); retOffset == -1 && pIndex >= 0 && pIndex < viewCount; pIndex += increment) {
            Shape pAlloc;
            ParagraphView pView = (ParagraphView)this.getEditorViewChildrenValid(pIndex);
            retOffset = pView.getNextVisualPositionY(offset, bias, pAlloc = this.getChildAllocation(pIndex, alloc), direction, biasRet, x);
            if (retOffset != -1) continue;
            offset = -1;
        }
        return retOffset;
    }

    private int getNextVisualPositionX(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        assert (direction == 3 || direction == 7) : "Invalid direction " + direction;
        int viewCount = this.getViewCount();
        int increment = direction == 3 ? 1 : -1;
        int retOffset = -1;
        for (int pIndex = this.getViewIndex(offset); retOffset == -1 && pIndex >= 0 && pIndex < viewCount; pIndex += increment) {
            Shape pAlloc;
            ParagraphView pView = (ParagraphView)this.getEditorViewChildrenValid(pIndex);
            retOffset = pView.getNextVisualPositionFromChecked(offset, bias, pAlloc = this.getChildAllocation(pIndex, alloc), direction, biasRet);
            if (retOffset != -1) continue;
            offset = -1;
        }
        return retOffset;
    }

    @Override
    public View getView(int index) {
        if (LOG.isLoggable(Level.FINE)) {
            this.checkDocumentLockedIfLogging();
            this.checkMutexAcquiredIfLogging();
        }
        return super.getView(index);
    }

    void setIncomingModification(boolean incomingModification) {
        this.incomingModification = incomingModification;
    }

    boolean isActive() {
        if (this.incomingModification) {
            if (LOG_QUERY_IN_MODIFICATION.isLoggable(Level.FINE)) {
                LOG_QUERY_IN_MODIFICATION.log(Level.INFO, "View Hierarchy Query during Incoming Modification\n", new Exception());
            }
            return false;
        }
        return this.isUpdatable();
    }

    boolean isUpdatable() {
        return this.textComponent != null && this.childrenValid && this.lengthyAtomicEdit <= 0;
    }

    boolean isBuildable() {
        return this.textComponent != null && this.fontRenderContext != null && this.lengthyAtomicEdit <= 0 && !this.incomingModification;
    }

    public void updateLengthyAtomicEdit(int delta) {
        this.lengthyAtomicEdit += delta;
        LOG.log(Level.FINE, "updateLengthyAtomicEdit: delta={0} lengthyAtomicEdit={1}\n", new Object[]{delta, this.lengthyAtomicEdit});
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.INFO, "updateLengthyAtomicEdit() stack", new Exception("updateLengthyAtomicEdit()"));
        }
        if (this.lengthyAtomicEdit == 0) {
            this.releaseChildrenLocked(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void removeUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    @Override
    public void changedUpdate(DocumentEvent evt, Shape alloc, ViewFactory viewFactory) {
    }

    float getVisibleWidth() {
        return this.visibleWidth;
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.textLayoutCache;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public float getDefaultLineHeight() {
        this.checkSettingsInfo();
        return this.defaultLineHeight;
    }

    public float getDefaultAscent() {
        this.checkSettingsInfo();
        return this.defaultAscent;
    }

    public float[] getUnderlineAndStrike(Font font) {
        this.checkSettingsInfo();
        FontInfo fontInfo = this.fontInfos.get(font);
        if (fontInfo == null) {
            fontInfo = this.fontInfos.get(this.defaultFont);
        }
        return fontInfo.underlineAndStrike;
    }

    public float getDefaultCharWidth() {
        this.checkSettingsInfo();
        return this.defaultCharWidth;
    }

    public boolean isShowNonprintingCharacters() {
        this.checkSettingsInfo();
        return this.prefs.getBoolean("non-printable-characters-visible", false);
    }

    LineWrapType getLineWrapType() {
        this.checkSettingsInfo();
        return this.lineWrapType;
    }

    Color getTextLimitLineColor() {
        this.checkSettingsInfo();
        return this.defaultLimitLine;
    }

    boolean isTextLimitLineDrawn() {
        this.checkSettingsInfo();
        return this.prefs.getBoolean("text-limit-line-visible", true);
    }

    int getTextLimitWidth() {
        this.checkSettingsInfo();
        if (this.defaultLimitLineWidth > 0) {
            return this.defaultLimitLineWidth;
        }
        return this.prefs.getInt("text-limit-width", 80);
    }

    TextLayout getNewlineCharTextLayout() {
        if (this.newlineTextLayout == null) {
            this.newlineTextLayout = this.createTextLayout(String.valueOf('\u00b6'), this.defaultFont);
        }
        return this.newlineTextLayout;
    }

    TextLayout getTabCharTextLayout(double availableWidth) {
        if (this.tabTextLayout == null) {
            this.tabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), this.defaultFont);
        }
        TextLayout ret = this.tabTextLayout;
        if (this.tabTextLayout != null && availableWidth > 0.0 && (double)this.tabTextLayout.getAdvance() > availableWidth) {
            if (this.singleCharTabTextLayout == null) {
                for (int i = this.defaultFont.getSize() - 1; i >= 0; --i) {
                    Font font = new Font(this.defaultFont.getName(), this.defaultFont.getStyle(), i);
                    this.singleCharTabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), font);
                    if (this.singleCharTabTextLayout == null) break;
                    if (!(this.singleCharTabTextLayout.getAdvance() <= this.getDefaultCharWidth())) continue;
                    LOG.log(Level.FINE, "singleChar font size={0}\n", i);
                    break;
                }
            }
            ret = this.singleCharTabTextLayout;
        }
        return ret;
    }

    TextLayout getLineContinuationCharTextLayout() {
        if (this.lineContinuationTextLayout == null) {
            char lineContinuationChar = '\u21a9';
            if (!this.defaultFont.canDisplay(lineContinuationChar)) {
                lineContinuationChar = '\u2190';
            }
            this.lineContinuationTextLayout = this.createTextLayout(String.valueOf(lineContinuationChar), this.defaultFont);
        }
        return this.lineContinuationTextLayout;
    }

    TextLayout createTextLayout(String text, Font font) {
        this.checkSettingsInfo();
        if (this.fontRenderContext != null && font != null) {
            ViewStats.incrementTextLayoutCreated(text.length());
            return new TextLayout(text, font, this.fontRenderContext);
        }
        return null;
    }

    TextLayout createTextLayout(String text, AttributeSet attrs) {
        Font font = ViewUtils.getFont(attrs, this.defaultFont);
        return this.createTextLayout(text, font);
    }

    void checkDocumentLockedIfLogging() {
        if (LOG.isLoggable(Level.FINE)) {
            this.checkDocumentLocked();
        }
    }

    void checkDocumentLocked() {
        if (!DocumentUtilities.isReadLocked((Document)this.getDocument())) {
            LOG.log(Level.INFO, "Document not locked", new Exception("Document not locked"));
        }
    }

    void checkMutexAcquiredIfLogging() {
        if (LOG.isLoggable(Level.FINE)) {
            this.checkMutexAcquired();
        }
    }

    void checkMutexAcquired() {
        Thread mutexThread;
        PriorityMutex mutex = this.getMutex();
        if (mutex != null && (mutexThread = mutex.getLockThread()) != Thread.currentThread()) {
            String msg = mutexThread == null ? "Mutex not acquired" : "Mutex already acquired for different thread: " + mutexThread;
            LOG.log(Level.INFO, msg + " for textComponent=" + this.textComponent, new Exception());
        }
    }

    boolean isMutexAcquired() {
        PriorityMutex mutex = this.getMutex();
        return mutex != null && mutex.getLockThread() == Thread.currentThread();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean releaseChildren = false;
        boolean updateFonts = false;
        if (evt.getSource() instanceof Document) {
            int llw;
            String propName = evt.getPropertyName();
            if (propName == null || "text-line-wrap".equals(propName)) {
                LineWrapType origLineWrapType = this.lineWrapType;
                this.updateLineWrapType();
                if (origLineWrapType != this.lineWrapType) {
                    LOG.log(Level.FINE, "Changing lineWrapType from {0} to {1}", new Object[]{origLineWrapType, this.lineWrapType});
                    releaseChildren = true;
                }
            }
            if (propName == null || "tab-size".equals(propName)) {
                releaseChildren = true;
            }
            if ((propName == null || "text-limit-width".equals(propName)) && (llw = ((Integer)this.getDocument().getProperty("text-limit-width")).intValue()) != this.defaultLimitLineWidth) {
                LOG.log(Level.FINE, "Changing defaultLimitLineWidth from {0} to {1}", new Object[]{this.defaultLimitLineWidth, llw});
                this.defaultLimitLineWidth = llw;
                releaseChildren = true;
            }
        } else {
            String propName = evt.getPropertyName();
            if (!"ancestor".equals(propName) && !"document".equals(propName)) {
                if ("font".equals(propName)) {
                    if (!this.customFont && this.defaultFont != null) {
                        boolean bl = this.customFont = this.textComponent != null && !this.defaultFont.equals(this.textComponent.getFont());
                    }
                    if (this.customFont) {
                        updateFonts = true;
                    }
                    releaseChildren = true;
                } else if ("foreground".equals(propName)) {
                    if (!this.customForeground && this.defaultForeground != null) {
                        this.customForeground = this.textComponent != null && !this.defaultForeground.equals(this.textComponent.getForeground());
                    }
                    releaseChildren = true;
                } else if ("background".equals(propName)) {
                    if (!this.customBackground && this.defaultBackground != null) {
                        this.customBackground = this.textComponent != null && !this.defaultBackground.equals(this.textComponent.getBackground());
                    }
                    releaseChildren = true;
                } else if ("text-line-wrap".equals(propName)) {
                    this.updateLineWrapType();
                    releaseChildren = true;
                }
            }
        }
        if (releaseChildren) {
            this.releaseChildrenLocked(updateFonts);
        }
    }

    @Override
    protected String getDumpName() {
        return "DV";
    }

    @Override
    public String findIntegrityError() {
        String err = super.findIntegrityError();
        if (err != null) {
            return err;
        }
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        int viewCount = this.getViewCount();
        if (viewCount > 0) {
            Object firstView = this.getEditorView(0);
            if (((View)firstView).getStartOffset() != startOffset) {
                return "firstView.getStartOffset()=" + ((View)firstView).getStartOffset() + " != startOffset=" + startOffset;
            }
            Object lastView = this.getEditorView(viewCount - 1);
            if (((View)lastView).getEndOffset() != endOffset) {
                return "lastView.endOffset=" + ((View)lastView).getEndOffset() + " != endOffset=" + endOffset;
            }
        }
        return null;
    }

    @Override
    public String findTreeIntegrityError() {
        final String[] ret = new String[1];
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        ret[0] = DocumentView.super.findTreeIntegrityError();
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
        return ret[0];
    }

    @Override
    protected StringBuilder appendViewInfoCore(StringBuilder sb, int indent, int importantChildIndex) {
        super.appendViewInfoCore(sb, indent, importantChildIndex);
        sb.append("; incomingMod=").append(this.incomingModification);
        sb.append("; lengthyAtomicEdit=").append(this.lengthyAtomicEdit);
        if (this.startPos != null) {
            sb.append("; startPos:").append(this.startPos.getOffset());
        } else {
            sb.append("; startPos is null");
        }
        if (this.endPos != null) {
            sb.append("; endPos:").append(this.endPos.getOffset());
        } else {
            sb.append("; endPos is null");
        }
        if (LOG_SOURCE_TEXT) {
            Document doc = this.getDocument();
            sb.append("\nDoc: ").append(ViewUtils.toString(doc));
        }
        return sb;
    }

    @Override
    protected StringBuilder appendViewInfo(final StringBuilder sb, final int indent, final int importantChildIndex) {
        this.getDocument().render(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PriorityMutex mutex = DocumentView.this.getMutex();
                if (mutex != null) {
                    mutex.lock();
                    try {
                        DocumentView.super.appendViewInfo(sb, indent, importantChildIndex);
                    }
                    finally {
                        mutex.unlock();
                    }
                }
            }
        });
        return sb;
    }

    private static class FontInfo {
        final float ascent;
        final float descent;
        final float leading;
        final float charWidth;
        final float[] underlineAndStrike = new float[4];

        FontInfo(Font font, DocumentView docView, FontRenderContext frc) {
            char defaultChar = 'A';
            String defaultCharText = String.valueOf(defaultChar);
            TextLayout defaultCharTextLayout = new TextLayout(defaultCharText, font, frc);
            TextLayout lineHeightTextLayout = new TextLayout("A_|B", font, frc);
            this.ascent = lineHeightTextLayout.getAscent();
            this.descent = lineHeightTextLayout.getDescent();
            this.leading = lineHeightTextLayout.getLeading();
            this.charWidth = (float)Math.ceil(defaultCharTextLayout.getAdvance());
            LineMetrics lineMetrics = font.getLineMetrics(defaultCharText, frc);
            this.underlineAndStrike[0] = ViewUtils.floorFractions(lineMetrics.getUnderlineOffset());
            this.underlineAndStrike[1] = lineMetrics.getUnderlineThickness();
            this.underlineAndStrike[2] = ViewUtils.floorFractions(lineMetrics.getStrikethroughOffset());
            this.underlineAndStrike[3] = lineMetrics.getStrikethroughThickness();
            if (LOG.isLoggable(Level.FINE)) {
                FontMetrics fm = docView.getTextComponent().getFontMetrics(font);
                LOG.fine("Font: " + font + "\nSize2D: " + font.getSize2D() + ", ascent=" + this.ascent + ", descent=" + this.descent + ", leading=" + this.leading + "\nChar-width=" + this.charWidth + ", underlineO/T=" + this.underlineAndStrike[0] + "/" + this.underlineAndStrike[1] + ", strikethroughO/T=" + this.underlineAndStrike[2] + "/" + this.underlineAndStrike[3] + "\nFontMetrics (for comparison): fm-line-height=" + fm.getHeight() + ", fm-ascent=" + fm.getAscent() + ", fm-descent=" + fm.getDescent() + "\n");
            }
        }
    }

    static enum LineWrapType {
        NONE("none"),
        CHARACTER_BOUND("chars"),
        WORD_BOUND("words");

        private final String settingValue;

        private LineWrapType(String settingValue) {
            this.settingValue = settingValue;
        }

        public static LineWrapType fromSettingValue(String settingValue) {
            if (settingValue != null) {
                for (LineWrapType lwt : LineWrapType.values()) {
                    if (!lwt.settingValue.equals(settingValue)) continue;
                    return lwt;
                }
            }
            return null;
        }
    }
}

