/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.tools.RunScript;
import org.h2.tools.Script;
import org.h2.util.FileUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.Tool;

public class CreateCluster
extends Tool {
    private void showUsage() {
        this.out.println("Creates a cluster from a standalone database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " -urlSource <url>    The database URL of the source database (jdbc:h2:...)\n" + " -urlTarget <url>    The database URL of the target database (jdbc:h2:...)\n" + " -user <user>        The user name\n" + " [-password <pwd>]   The password\n" + " -serverlist <list>  The comma separated list of host names or IP addresses");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] stringArray) throws SQLException {
        new CreateCluster().run(stringArray);
    }

    public void run(String[] stringArray) throws SQLException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string6 = stringArray[i];
            if (string6.equals("-urlSource")) {
                string = stringArray[++i];
                continue;
            }
            if (string6.equals("-urlTarget")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string6.equals("-user")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string6.equals("-password")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string6.equals("-serverlist")) {
                string5 = stringArray[++i];
                continue;
            }
            if (string6.equals("-help") || string6.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + string6);
            this.showUsage();
            return;
        }
        if (string == null || string2 == null || string3 == null || string5 == null) {
            this.showUsage();
            return;
        }
        this.process(string, string2, string3, string4, string5);
    }

    public void execute(String string, String string2, String string3, String string4, String string5) throws SQLException {
        new CreateCluster().process(string, string2, string3, string4, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            boolean bl;
            Driver.load();
            connection = DriverManager.getConnection(string + ";CLUSTER=''", string3, string4);
            connection.close();
            try {
                connection = DriverManager.getConnection(string2 + ";IFEXISTS=TRUE", string3, string4);
                connection.close();
                bl = true;
            }
            catch (SQLException sQLException) {
                bl = false;
            }
            if (bl) {
                throw new SQLException("Target database must not yet exist. Please delete it first");
            }
            String string6 = "backup.sql";
            Script script = new Script();
            script.setOut(this.out);
            script.process(string, string3, string4, string6);
            RunScript runScript = new RunScript();
            runScript.setOut(this.out);
            runScript.process(string2, string3, string4, string6, null, false);
            FileUtils.delete(string6);
            connection = DriverManager.getConnection(string, string3, string4);
            statement = connection.createStatement();
            statement.executeUpdate("SET CLUSTER '" + string5 + "'");
            connection.close();
            connection = DriverManager.getConnection(string2, string3, string4);
            statement = connection.createStatement();
            statement.executeUpdate("SET CLUSTER '" + string5 + "'");
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(connection);
            JdbcUtils.closeSilently(statement);
            throw throwable;
        }
        JdbcUtils.closeSilently(connection);
        JdbcUtils.closeSilently(statement);
    }
}

