/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.spi.GoToSourceProvider;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GoToSourceHelper {
    public static boolean openSource(Project project, JavaSourceLocation location) {
        ProfilerLogger.debug((String)("Open Source: Project: " + (project == null ? "null" : ProjectUtilities.getProjectName((Project)project))));
        ProfilerLogger.debug((String)("Open Source: Class name: " + location.className));
        ProfilerLogger.debug((String)("Open Source: Method name: " + location.methodName));
        ProfilerLogger.debug((String)("Open Source: Method sig: " + location.signature));
        Collection implementations = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String st = MessageFormat.format(NbBundle.getMessage(GoToSourceHelper.class, (String)"OpeningSourceMsg"), location.className);
        String finalStatusText = st + " ...";
        StatusDisplayer.getDefault().setStatusText(finalStatusText);
        for (GoToSourceProvider impl : implementations) {
            try {
                if (!impl.openSource(project, location.className, location.methodName, location.signature, location.line)) continue;
                return true;
            }
            catch (Exception e) {
                ProfilerLogger.log((Exception)e);
            }
        }
        Profiler.getDefault().displayError(MessageFormat.format(NbBundle.getMessage(GoToSourceHelper.class, (String)"NoSourceFoundMessage"), location.className));
        return false;
    }
}

