/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.actions.ProfilingAwareAction;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class HeapDumpAction
extends ProfilingAwareAction {
    private static final String ACTION_NAME = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_ActionName");
    private static final String REQUIRED_JDK_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_RequiredJdkMsg");
    private static final String REMOTE_UNSUPPORTED_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_RemoteUnsupportedMsg");
    private static final String WRONG_DESTINATION_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_WrongDestinationMsg");
    private static final String DUMPING_HEAP_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DumpingHeapText");
    private static final String SAVED_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_SavedDialogCaption");
    private static final String SAVED_DIALOG_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_SavedDialogText");
    private static final String DUMPING_FAILED_MSG = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DumpingFailedMsg");
    private static final String DESTINATION_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DestinationDialogCaption");
    private static final String LOCATION_PROJECT_STRING = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_LocationProjectString");
    private static final String LOCATION_GLOBAL_STRING = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_LocationGlobalString");
    private static final String DIRECTORY_DIALOG_CAPTION = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DirectoryDialogCaption");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_OkButtonText");
    private static final String DESTINATION_LABEL_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DestinationLabelText");
    private static final String DEFAULT_LOCATION_RADIO_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_DefaultLocationRadioText");
    private static final String CUSTOM_LOCATION_RADIO_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_CustomLocationRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(HeapDumpAction.class, (String)"HeapDumpAction_BrowseButtonText");
    public static final String TAKEN_HEAPDUMP_PREFIX = "heapdump-";
    private static final String SELECTING_TARGET_CANCELLED = "&*$?CANCELLED?$*&";
    private static final int[] ENABLED_STATES = new int[]{4};
    private static JFileChooser snapshotDirectoryChooser;
    private ChooseHeapdumpTargetPanel heapdumpTargetSelector;

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return ACTION_NAME;
    }

    public void dumpToProject() {
        this.takeHeapDump(false);
    }

    public void performAction() {
        this.takeHeapDump(true);
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    protected String iconResource() {
        return "org/netbeans/modules/profiler/actions/resources/dumpHeap.png";
    }

    private String getCurrentHeapDumpFilename(String targetFolder) {
        try {
            String fileName = TAKEN_HEAPDUMP_PREFIX + System.currentTimeMillis();
            FileObject folder = targetFolder == null ? IDEUtils.getProjectSettingsFolder(NetBeansProfiler.getDefaultNB().getProfiledProject(), true) : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(targetFolder)));
            return FileUtil.toFile((FileObject)folder).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)"hprof") + "." + "hprof";
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isHeapDumpSupported() {
        String fullJDKString;
        int minorNumber;
        TargetAppRunner targetApp = Profiler.getDefault().getTargetAppRunner();
        String jdkVersion = targetApp.getProfilerEngineSettings().getTargetJDKVersionString();
        if ("jdk16".equals(jdkVersion) || "jdk17".equals(jdkVersion)) {
            return true;
        }
        return "jdk15".equals(jdkVersion) && (minorNumber = Platform.getJDKMinorNumber((String)(fullJDKString = targetApp.getProfilingSessionStatus().fullTargetJDKVersionString))) >= 12;
    }

    private static JFileChooser getSnapshotDirectoryChooser() {
        if (snapshotDirectoryChooser == null) {
            snapshotDirectoryChooser = new JFileChooser();
            snapshotDirectoryChooser.setFileSelectionMode(1);
            snapshotDirectoryChooser.setMultiSelectionEnabled(false);
            snapshotDirectoryChooser.setDialogType(0);
            snapshotDirectoryChooser.setDialogTitle(DIRECTORY_DIALOG_CAPTION);
        }
        return snapshotDirectoryChooser;
    }

    private ChooseHeapdumpTargetPanel getHeapdumpTargetSelector() {
        if (this.heapdumpTargetSelector == null) {
            this.heapdumpTargetSelector = new ChooseHeapdumpTargetPanel();
        }
        return this.heapdumpTargetSelector;
    }

    private String selectTargetDirectory() {
        ChooseHeapdumpTargetPanel targetSelector = this.getHeapdumpTargetSelector();
        targetSelector.updateDefaultLocation(NetBeansProfiler.getDefaultNB().getProfiledProject() != null ? LOCATION_PROJECT_STRING : LOCATION_GLOBAL_STRING);
        DialogDescriptor desc = new DialogDescriptor((Object)targetSelector, DESTINATION_DIALOG_CAPTION, true, new Object[]{targetSelector.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object res = ProfilerDialogs.notify((NotifyDescriptor)desc);
        if (!res.equals(targetSelector.getOKButton())) {
            return SELECTING_TARGET_CANCELLED;
        }
        int destinationType = targetSelector.getDestinationType();
        if (destinationType == 0) {
            return this.getCurrentHeapDumpFilename(null);
        }
        if (destinationType == 1) {
            return this.getCurrentHeapDumpFilename(targetSelector.getCustomDirectory());
        }
        return null;
    }

    private void takeHeapDump(final boolean askForDestination) {
        IDEUtils.runInProfilerRequestProcessor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NetBeansProfiler nbProfiler = NetBeansProfiler.getDefaultNB();
                TargetAppRunner targetApp = nbProfiler.getTargetAppRunner();
                if (!targetApp.hasSupportedJDKForHeapDump()) {
                    nbProfiler.displayWarning(REQUIRED_JDK_MSG);
                    return;
                }
                if (targetApp.getProfilingSessionStatus().remoteProfiling) {
                    nbProfiler.displayWarning(REMOTE_UNSUPPORTED_MSG);
                    return;
                }
                try {
                    String dumpFileName;
                    String string = dumpFileName = askForDestination ? HeapDumpAction.this.selectTargetDirectory() : HeapDumpAction.this.getCurrentHeapDumpFilename(null);
                    if (dumpFileName == HeapDumpAction.SELECTING_TARGET_CANCELLED) {
                        return;
                    }
                    if (dumpFileName == null) {
                        nbProfiler.displayError(WRONG_DESTINATION_MSG);
                        return;
                    }
                    boolean heapdumpTaken = false;
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandleFactory.createHandle((String)DUMPING_HEAP_TEXT);
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        heapdumpTaken = targetApp.getProfilerClient().takeHeapDump(dumpFileName);
                    }
                    finally {
                        if (pHandle != null) {
                            pHandle.finish();
                        }
                    }
                    if (heapdumpTaken) {
                        ProfilerControlPanel2.getDefault().refreshSnapshotsList();
                        if (askForDestination) {
                            ProfilerDialogs.DNSAConfirmation dnsa = new ProfilerDialogs.DNSAConfirmation("HeapDumpAction.heapdumpSaved", (Object)SAVED_DIALOG_TEXT, SAVED_DIALOG_CAPTION, 0);
                            dnsa.setDNSADefault(false);
                            if (ProfilerDialogs.notify((NotifyDescriptor)dnsa).equals(ProfilerDialogs.DNSAConfirmation.YES_OPTION)) {
                                HeapWalkerManager.getDefault().openHeapWalker(new File(dumpFileName));
                            }
                        } else if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                            HeapWalkerManager.getDefault().openHeapWalker(new File(dumpFileName));
                        }
                    } else {
                        nbProfiler.displayError(DUMPING_FAILED_MSG);
                    }
                }
                catch (Exception e) {
                    nbProfiler.displayError(e.getMessage());
                    ProfilerLogger.log((Exception)e);
                }
            }
        });
    }

    private static class ChooseHeapdumpTargetPanel
    extends JPanel {
        public static final int DESTINATION_DEFAULT = 0;
        public static final int DESTINATION_CUSTOM = 1;
        private JButton customLocationButton;
        private JButton okButton;
        private JLabel chooseDestinationLabel;
        private JRadioButton customLocationRadio;
        private JRadioButton defaultLocationRadio;
        private JTextField customLocationField;

        public ChooseHeapdumpTargetPanel() {
            this.initComponents();
        }

        public String getCustomDirectory() {
            return this.customLocationField.getText();
        }

        public int getDestinationType() {
            if (this.defaultLocationRadio.isSelected()) {
                return 0;
            }
            return 1;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public void updateDefaultLocation(String location) {
            this.defaultLocationRadio.setText(location);
        }

        private void initComponents() {
            this.okButton = new JButton(OK_BUTTON_TEXT);
            this.setLayout(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            this.chooseDestinationLabel = new JLabel(DESTINATION_LABEL_TEXT);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 10, 8, 5);
            this.add((Component)this.chooseDestinationLabel, c);
            this.defaultLocationRadio = new JRadioButton(DEFAULT_LOCATION_RADIO_TEXT);
            group.add(this.defaultLocationRadio);
            this.defaultLocationRadio.setSelected(true);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.defaultLocationRadio, c);
            this.customLocationRadio = new JRadioButton(CUSTOM_LOCATION_RADIO_TEXT);
            group.add(this.customLocationRadio);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.customLocationRadio, c);
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir.endsWith(File.separator)) {
                tempDir = tempDir.substring(0, tempDir.length() - File.separator.length());
            }
            this.customLocationField = new JTextField();
            this.customLocationField.setText(tempDir);
            this.customLocationField.setPreferredSize(new Dimension(210, this.customLocationField.getPreferredSize().height));
            this.customLocationField.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.customLocationField, c);
            this.customLocationButton = new JButton(BROWSE_BUTTON_TEXT);
            this.customLocationButton.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.customLocationButton, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), c);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            };
            this.customLocationField.getDocument().addDocumentListener(documentListener);
            this.defaultLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ChooseHeapdumpTargetPanel.this.customLocationField.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.customLocationButton.setEnabled(ChooseHeapdumpTargetPanel.this.customLocationRadio.isSelected());
                    ChooseHeapdumpTargetPanel.this.updateOKButton();
                }
            });
            this.customLocationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser directoryChooser = HeapDumpAction.getSnapshotDirectoryChooser();
                    directoryChooser.setCurrentDirectory(new File(ChooseHeapdumpTargetPanel.this.getCustomDirectory()));
                    if (directoryChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0 && (file = directoryChooser.getSelectedFile()) != null) {
                        ChooseHeapdumpTargetPanel.this.customLocationField.setText(directoryChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.defaultLocationRadio.isSelected()) {
                this.okButton.setEnabled(true);
            } else if (this.customLocationRadio.isSelected()) {
                File file = new File(this.getCustomDirectory());
                this.okButton.setEnabled(file.exists() && file.isDirectory());
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }
}

