/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class DiffTreeTable
extends OutlineView
implements MouseListener,
MouseMotionListener {
    private RevisionsRootNode rootNode;
    private List results;
    private static final Icon NO_ICON = new NoIcon();

    public DiffTreeTable() {
        this.getOutline().setShowHorizontalLines(true);
        this.getOutline().setShowVerticalLines(false);
        this.getOutline().setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
        this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
        this.getOutline().addMouseListener((MouseListener)this);
        this.getOutline().addMouseMotionListener((MouseMotionListener)this);
    }

    private SearchHistoryPanel.DispRevision getRevisionWithTagsAt(Point p) {
        SearchHistoryPanel.DispRevision drev = this.getRevisionWithPropertyAt(p, "tagsRevision");
        if (drev != null && drev.getBranches() != null && drev.getBranches().size() + drev.getTags().size() > 1) {
            return drev;
        }
        return null;
    }

    private SearchHistoryPanel.DispRevision getRevisionWithPropertyAt(Point p, String property) {
        int row = this.getOutline().rowAtPoint(p);
        int column = this.getOutline().columnAtPoint(p);
        if (row == -1 || column == -1) {
            return null;
        }
        Object o = this.getOutline().getValueAt(row, column);
        if (o instanceof Node.Property) {
            Node.Property tags = (Node.Property)o;
            return (SearchHistoryPanel.DispRevision)tags.getValue(property);
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Window w;
        Point p = new Point(e.getPoint());
        SearchHistoryPanel.DispRevision drev = this.getRevisionWithTagsAt(p);
        if (drev != null) {
            w = SwingUtilities.windowForComponent((Component)this.getOutline());
            SwingUtilities.convertPointToScreen(p, (Component)this.getOutline());
            p.x += 10;
            p.y += 10;
            SummaryView.showAllTags(w, p, drev);
        }
        if ((drev = this.getRevisionWithPropertyAt(p = new Point(e.getPoint()), "messageRevision")) != null) {
            w = SwingUtilities.windowForComponent((Component)this.getOutline());
            SwingUtilities.convertPointToScreen(p, (Component)this.getOutline());
            if ((p.x -= 150) < 0) {
                p.x = 10;
            }
            p.y += this.getOutline().getRowHeight() * 3 / 2;
            this.showMessage(w, p, drev);
        }
    }

    private void showMessage(Window w, Point p, SearchHistoryPanel.DispRevision drev) {
        final JTextPane tp = new JTextPane();
        tp.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        tp.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        tp.setEditable(false);
        Style headerStyle = tp.addStyle("headerStyle", null);
        StyleConstants.setBold(headerStyle, true);
        Document doc = tp.getDocument();
        try {
            doc.insertString(doc.getLength(), NbBundle.getMessage(DiffTreeTable.class, (String)"CTL_MessageWindow_Title") + "\n\n", headerStyle);
            doc.insertString(doc.getLength(), drev.getRevision().getMessage() + "\n", null);
        }
        catch (BadLocationException e) {
            Logger.getLogger(DiffTreeTable.class.getName()).log(Level.WARNING, "Internal error creating commit message popup", e);
        }
        Dimension dim = tp.getPreferredSize();
        tp.setPreferredSize(new Dimension(dim.width * 7 / 6, dim.height));
        JScrollPane jsp = new JScrollPane(tp);
        jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow ttw = new TooltipWindow(w, jsp);
        ttw.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                tp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        ttw.show(p);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getRevisionWithTagsAt(e.getPoint()) != null || this.getRevisionWithPropertyAt(e.getPoint(), "messageRevision") != null) {
            this.getOutline().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.getOutline().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setupColumns() {
        Node.Property[] columns;
        ResourceBundle loc = NbBundle.getBundle(DiffTreeTable.class);
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
            columns = new Node.Property[5];
            columns[3] = new ColumnDescriptor("tags", List.class, loc.getString("LBL_DiffTree_Column_Tags"), loc.getString("LBL_DiffTree_Column_Tags_Desc"));
            columns[4] = new ColumnDescriptor("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        } else {
            columns = new Node.Property[4];
            columns[3] = new ColumnDescriptor("message", String.class, loc.getString("LBL_DiffTree_Column_Message"), loc.getString("LBL_DiffTree_Column_Message_Desc"));
        }
        columns[0] = new ColumnDescriptor("location", String.class, loc.getString("LBL_DiffTree_Column_Location"), loc.getString("LBL_DiffTree_Column_Location_Desc"));
        columns[1] = new ColumnDescriptor("date", String.class, loc.getString("LBL_DiffTree_Column_Time"), loc.getString("LBL_DiffTree_Column_Time_Desc"));
        columns[2] = new ColumnDescriptor("username", String.class, loc.getString("LBL_DiffTree_Column_Username"), loc.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setProperties(columns);
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffTreeTable.this.getWidth();
                if (CvsModuleConfig.getDefault().getPreferences().getBoolean("searchHistory.fetchTags", true)) {
                    if (DiffTreeTable.this.getOutline().getColumnModel().getColumnCount() != 6) {
                        return;
                    }
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 15 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 15 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(4).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(5).setPreferredWidth(width * 40 / 100);
                } else {
                    if (DiffTreeTable.this.getOutline().getColumnModel().getColumnCount() != 5) {
                        return;
                    }
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width * 20 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width * 20 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(width * 10 / 100);
                    DiffTreeTable.this.getOutline().getColumnModel().getColumn(4).setPreferredWidth(width * 40 / 100);
                }
            }
        });
    }

    void setSelection(int idx) {
        this.getOutline().getSelectionModel().setValueIsAdjusting(false);
        this.getOutline().scrollRectToVisible(this.getOutline().getCellRect(idx, 1, true));
        this.getOutline().getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(SearchHistoryPanel.ResultsContainer container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(SearchHistoryPanel.DispRevision revision) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, revision);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.getOutline().getSelectedRows();
    }

    public int getRowCount() {
        return this.getOutline().getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
        this.setDefaultColumnSizes();
    }

    public void setResults(List results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private class NoLeafIconRenderDataProvider
    implements RenderDataProvider {
        private RenderDataProvider delegate;

        public NoLeafIconRenderDataProvider(RenderDataProvider delegate) {
            this.delegate = delegate;
        }

        public String getDisplayName(Object o) {
            return this.delegate.getDisplayName(o);
        }

        public boolean isHtmlDisplayName(Object o) {
            return this.delegate.isHtmlDisplayName(o);
        }

        public Color getBackground(Object o) {
            return this.delegate.getBackground(o);
        }

        public Color getForeground(Object o) {
            return this.delegate.getForeground(o);
        }

        public String getTooltipText(Object o) {
            return this.delegate.getTooltipText(o);
        }

        public Icon getIcon(Object o) {
            if (DiffTreeTable.this.getOutline().getOutlineModel().isLeaf(o)) {
                return NO_ICON;
            }
            return null;
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys {
        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
        }

        protected Node[] createNodes(Object key) {
            RevisionNode node = key instanceof SearchHistoryPanel.ResultsContainer ? new RevisionNode((SearchHistoryPanel.ResultsContainer)key) : new RevisionNode((SearchHistoryPanel.DispRevision)key);
            return new Node[]{node};
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren(), Lookups.singleton((Object)DiffTreeTable.this.results));
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

