/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCache<K, V> {
    private final ConcurrentMap<K, Ref<K, V>> map = new ConcurrentHashMap<K, Ref<K, V>>();
    private final ReferenceQueue<V> referenceQueue = new ReferenceQueue();
    private final Lock lock = new ReentrantLock();

    public Collection<V> values() {
        ArrayList result = new ArrayList(this.map.size());
        for (Ref ref : this.map.values()) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    public V putIfAbsent(K key, V value) {
        Ref newRef = new Ref(key, value, this.referenceQueue);
        Ref oldRef = this.map.putIfAbsent(key, newRef);
        if (oldRef == null) {
            return value;
        }
        Object oldValue = oldRef.get();
        if (oldValue == null || oldValue.getClass() != value.getClass()) {
            this.map.put(key, newRef);
            return value;
        }
        return (V)oldValue;
    }

    public void put(K key, V value) {
        Ref ref = new Ref(key, value, this.referenceQueue);
        this.map.put(key, ref);
    }

    public V get(K key) {
        Ref ref = (Ref)this.map.get(key);
        V result = ref == null ? null : (V)ref.get();
        return result;
    }

    public V remove(K key) {
        Ref removed = (Ref)this.map.remove(key);
        return removed == null ? null : (V)removed.get();
    }

    public int size() {
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDeadEntries() {
        if (this.lock.tryLock()) {
            try {
                Ref ref;
                while ((ref = (Ref)this.referenceQueue.poll()) != null) {
                    if (ref.key == null) continue;
                    this.map.remove(ref.key);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ref<K, V>
    extends SoftReference<V> {
        private final K key;

        private Ref(K key, V value, ReferenceQueue<V> referenceQueue) {
            super(value, referenceQueue);
            this.key = key;
        }
    }
}

