/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.fs.CachedRemoteInputStream;
import org.netbeans.modules.remote.impl.fs.DirEntry;
import org.netbeans.modules.remote.impl.fs.DirectoryStorage;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RemoteDirectory
extends RemoteFileObjectBase {
    private static final boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
    private static boolean LS_VIA_SFTP = !Boolean.getBoolean("remote.parse.ls");
    private Reference<DirectoryStorage> storageRef;
    private final Object refLock = new RefLock();

    public RemoteDirectory(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, RemoteFileObjectBase parent, String remotePath, File cache) {
        super(fileSystem, execEnv, parent, remotePath, cache);
    }

    public boolean isFolder() {
        return true;
    }

    public boolean isData() {
        return false;
    }

    public RemoteFileObjectBase getFileObject(String name, String ext) {
        return this.getFileObject(name + '.' + ext);
    }

    boolean canWrite(String childNameExt) throws IOException, ConnectException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage();
            DirEntry entry = storage.getEntry(childNameExt);
            return entry != null && entry.canWrite(this.getExecutionEnvironment());
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (CancellationException ex) {
            return false;
        }
    }

    boolean canRead(String childNameExt) throws IOException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage();
            DirEntry entry = storage.getEntry(childNameExt);
            return entry != null && entry.canRead(this.getExecutionEnvironment());
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (CancellationException ex) {
            return false;
        }
    }

    public FileObject createData(String name) throws IOException {
        return this.create(name, false);
    }

    public FileObject createData(String name, String ext) throws IOException {
        if (ext == null || ext.length() == 0) {
            return this.create(name, false);
        }
        return this.create(name + '.' + ext, false);
    }

    public FileObject createFolder(String name) throws IOException {
        return this.create(name, true);
    }

    protected void postDeleteChild(FileObject child) {
        try {
            DirectoryStorage ds = this.refreshDirectoryStorage();
        }
        catch (ConnectException ex) {
            RemoteLogger.getInstance().log(Level.INFO, "Error post removing child " + child, ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.getExecutionEnvironment(), this.getPath(), true);
    }

    private FileObject create(String name, boolean directory) throws IOException {
        ProcessUtils.ExitStatus res;
        String path = this.getPath() + '/' + name;
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            throw new ConnectException("Can not create " + this.getUrlToReport(path) + ": connection required");
        }
        if (directory) {
            res = ProcessUtils.execute((ExecutionEnvironment)this.getExecutionEnvironment(), (String)"mkdir", (String[])new String[]{path});
        } else {
            String script = String.format("ls \"%s\" || touch \"%s\"", name, name);
            res = ProcessUtils.executeInDir((String)this.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)"sh", (String[])new String[]{"-c", script});
            if (res.isOK() && res.error.length() == 0) {
                throw new IOException("Already exists: " + this.getUrlToReport(path));
            }
        }
        if (res.isOK()) {
            try {
                this.refreshImpl();
                RemoteFileObjectBase fo = this.getFileObject(name);
                if (fo == null) {
                    throw new FileNotFoundException("Can not create FileObject " + this.getUrlToReport(path));
                }
                if (directory) {
                    this.fireFileFolderCreatedEvent(this.getListeners(), new FileEvent((FileObject)fo));
                } else {
                    this.fireFileDataCreatedEvent(this.getListeners(), new FileEvent((FileObject)fo));
                }
                return fo;
            }
            catch (ConnectException ex) {
                throw new IOException("Can not create " + path + ": not connected", ex);
            }
            catch (InterruptedIOException ex) {
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (ExecutionException ex) {
                throw new IOException("Can not create " + path + ": exception occurred", ex);
            }
            catch (InterruptedException ex) {
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (CancellationException ex) {
                throw new IOException("Can not create " + path + ": cancelled", ex);
            }
        }
        throw new IOException("Can not create " + this.getUrlToReport(path) + ": " + res.error);
    }

    private String getUrlToReport(String path) {
        return this.getExecutionEnvironment().getDisplayName() + ':' + path;
    }

    public RemoteFileObjectBase getFileObject(String relativePath) {
        int slashPos;
        if ("".equals(relativePath = PathUtilities.normalizeUnixPath((String)relativePath))) {
            return this;
        }
        if (relativePath.startsWith("..")) {
            String absPath = this.getPath() + '/' + relativePath;
            absPath = PathUtilities.normalizeUnixPath((String)absPath);
            return this.getFileSystem().findResource(absPath);
        }
        if (relativePath != null && relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if ((slashPos = relativePath.lastIndexOf(47)) > 0) {
            String parentRemotePath = this.getPath() + '/' + relativePath.substring(0, slashPos);
            String childNameExt = relativePath.substring(slashPos + 1);
            RemoteFileObjectBase parentFileObject = this.getFileSystem().findResource(parentRemotePath);
            if (parentFileObject != null && parentFileObject.isFolder()) {
                return parentFileObject.getFileObject(childNameExt);
            }
            return null;
        }
        RemoteLogger.assertTrue(slashPos == -1);
        try {
            DirectoryStorage storage = this.getDirectoryStorage();
            DirEntry entry = storage.getEntry(relativePath);
            if (entry == null) {
                return null;
            }
            return this.createFileObject(entry);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void fireRemoteFileObjectCreated(RemoteFileObjectBase fo) {
        FileEvent e = new FileEvent((FileObject)fo);
        if (fo instanceof RemoteDirectory) {
            this.fireFileFolderCreatedEvent(this.getListeners(), e);
        } else if (fo instanceof RemotePlainFile) {
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        } else {
            RemoteLogger.getInstance().warning("firing fireFileDataCreatedEvent for a link");
            this.fireFileDataCreatedEvent(this.getListeners(), e);
        }
    }

    private RemoteFileObjectBase createFileObject(DirEntry entry) {
        File childCache = new File(this.getCache(), entry.getCache());
        String childPath = this.getPath() + '/' + entry.getName();
        RemoteFileObjectBase fo = entry.isDirectory() ? this.getFileSystem().getFactory().createRemoteDirectory(this, childPath, childCache) : (entry.isLink() ? this.getFileSystem().getFactory().createRemoteLink(this, childPath, entry.getLinkTarget()) : this.getFileSystem().getFactory().createRemotePlainFile(this, childPath, childCache, FileType.File));
        return fo;
    }

    private RemoteFileObjectBase[] getExistentChildren() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage storage = this.getDirectoryStorage();
        List<DirEntry> entries = storage.list();
        ArrayList<RemoteFileObjectBase> result = new ArrayList<RemoteFileObjectBase>(entries.size());
        for (DirEntry entry : entries) {
            String path = this.getPath() + '/' + entry.getName();
            RemoteFileObjectBase fo = this.getFileSystem().getFactory().getCachedFileObject(path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result.toArray(new RemoteFileObjectBase[result.size()]);
    }

    public RemoteFileObjectBase[] getChildren() {
        try {
            DirectoryStorage storage = this.getDirectoryStorage();
            List<DirEntry> entries = storage.list();
            RemoteFileObjectBase[] childrenFO = new RemoteFileObjectBase[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                DirEntry entry = entries.get(i);
                childrenFO[i] = this.createFileObject(entry);
            }
            return childrenFO;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
        }
        return new RemoteFileObjectBase[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage getDirectoryStorage() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(false);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("getDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage refreshDirectoryStorage() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(true);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("refreshDirectoryStorage for {1} took {0} ms", this, System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    /*
     * Exception decompiling
     */
    private DirectoryStorage getDirectoryStorageImpl(boolean force) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream _getInputStream(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        Lock lock = RemoteFileSystem.getLock(child.getCache()).readLock();
        lock.lock();
        try {
            if (child.getCache().exists()) {
                FileInputStream fileInputStream = new FileInputStream(child.getCache());
                return fileInputStream;
            }
        }
        finally {
            lock.unlock();
        }
        this.checkConnection(child, true);
        DirectoryStorage storage = this.getDirectoryStorage();
        return new CachedRemoteInputStream(child, this.getExecutionEnvironment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureChildSync(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        block16: {
            Lock lock = RemoteFileSystem.getLock(child.getCache()).readLock();
            lock.lock();
            try {
                if (child.getCache().exists()) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            this.checkConnection(child, true);
            DirectoryStorage storage = this.getDirectoryStorage();
            lock = RemoteFileSystem.getLock(child.getCache()).writeLock();
            lock.lock();
            try {
                Future task;
                int rc;
                if (child.getCache().exists()) {
                    return;
                }
                File cacheParentFile = child.getCache().getParentFile();
                if (!cacheParentFile.exists()) {
                    cacheParentFile.mkdirs();
                    if (!cacheParentFile.exists()) {
                        throw new IOException("Unable to create parent firectory " + cacheParentFile.getAbsolutePath());
                    }
                }
                if ((rc = ((Integer)(task = CommonTasksSupport.downloadFile((String)child.getPath(), (ExecutionEnvironment)this.getExecutionEnvironment(), (String)child.getCache().getAbsolutePath(), null)).get()).intValue()) == 0) {
                    this.getFileSystem().incrementFileCopyCount();
                    break block16;
                }
                throw new IOException("Can't copy file " + child.getCache().getAbsolutePath() + " from " + this.getExecutionEnvironment() + ':' + this.getPath() + ": rc=" + rc);
            }
            catch (InterruptedException ex) {
                child.getCache().delete();
                throw ex;
            }
            catch (ExecutionException ex) {
                child.getCache().delete();
                throw ex;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void checkConnection(RemoteFileObjectBase fo, boolean throwConnectException) throws ConnectException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.getExecutionEnvironment())) {
            this.getFileSystem().getRemoteFileSupport().addPendingFile(fo);
            if (throwConnectException) {
                throw new ConnectException();
            }
        }
    }

    public FileType getType() {
        return FileType.Directory;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException(this.getPath());
    }

    private void invalidate(DirEntry oldEntry) {
        RemoteFileObjectBase fo = this.getFileSystem().getFactory().invalidate(this.getPath() + '/' + oldEntry.getName());
        File oldEntryCache = new File(this.getCache(), oldEntry.getCache());
        this.removeFile(oldEntryCache);
        if (fo != null) {
            this.fireFileDeletedEvent(this.getListeners(), new FileEvent((FileObject)fo));
        }
    }

    private void removeFile(File cache) {
        if (cache.isDirectory()) {
            for (File child : cache.listFiles()) {
                this.removeFile(child);
            }
        }
        cache.delete();
    }

    private static void setStorageTimestamp(File cache, final long timestamp, boolean recursive) {
        cache.setLastModified(timestamp);
        if (recursive && cache.exists()) {
            cache.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        File childCache = new File(pathname, ".rfs_cache");
                        RemoteDirectory.setStorageTimestamp(childCache, timestamp, true);
                    }
                    return false;
                }
            });
        }
    }

    protected void refreshImpl() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        this.refreshDirectoryStorage();
        for (RemoteFileObjectBase child : this.getExistentChildren()) {
            child.refreshImpl();
        }
    }

    private void trace(String message, Object ... args) {
        if (trace) {
            message = "SYNC [" + this.getPath() + "][" + System.identityHashCode(this) + "][" + Thread.currentThread().getId() + "]: " + message;
            RemoteLogger.getInstance().log(Level.FINEST, message, args);
        }
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private DirEntry getChildEntry(RemoteFileObjectBase child) {
        try {
            DirectoryStorage directoryStorage = this.getDirectoryStorage();
            if (directoryStorage != null) {
                DirEntry entry = directoryStorage.getEntry(child.getNameExt());
                if (entry != null) {
                    return entry;
                }
                RemoteLogger.getInstance().log(Level.INFO, "Not found entry for file {0}", child);
            }
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (ExecutionException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
        }
        return null;
    }

    long getSize(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getSize();
        }
        return 0L;
    }

    Date lastModified(RemoteFileObjectBase child) {
        DirEntry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getLastModified();
        }
        return new Date(0L);
    }

    static boolean getLsViaSftp() {
        return LS_VIA_SFTP;
    }

    static void testSetLsViaSftp(boolean value) {
        LS_VIA_SFTP = value;
    }

    private static final class RefLock {
        private RefLock() {
        }
    }
}

