/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.spi.FileSystemProviderImplementation;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalFileSystemProvider
implements FileSystemProviderImplementation {
    private FileSystem rootFileSystem = null;
    private Map<String, LocalFileSystem> nonRootFileSystems = new HashMap<String, LocalFileSystem>();
    private final boolean isWindows = Utilities.isWindows();
    private static RequestProcessor RP = new RequestProcessor(LocalFileSystemProvider.class.getSimpleName());

    public String normalizeAbsolutePath(String absPath, ExecutionEnvironment env) {
        return FileUtil.normalizePath((String)absPath);
    }

    public String normalizeAbsolutePath(String absPath, FileSystem fileSystem) {
        return FileUtil.normalizePath((String)absPath);
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public FileObject getFileObject(FileObject baseFileObject, String relativeOrAbsolutePath) {
        String absPath = FileSystemProvider.isAbsolute((String)relativeOrAbsolutePath) ? relativeOrAbsolutePath : baseFileObject.getPath() + File.separatorChar + relativeOrAbsolutePath.toString();
        return FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)absPath)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getRootFileSystem() {
        if (this.rootFileSystem == null) {
            File tmpFile = null;
            try {
                tmpFile = File.createTempFile("NetBeans", ".tmp");
                tmpFile = FileUtil.normalizeFile((File)tmpFile);
                FileObject fo = FileUtil.toFileObject((File)tmpFile);
                this.rootFileSystem = fo.getFileSystem();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return this.rootFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem(ExecutionEnvironment env, String root) {
        if (env.isLocal()) {
            LocalFileSystemProvider localFileSystemProvider = this;
            synchronized (localFileSystemProvider) {
                if ("/".equals(root) || "".equals(root)) {
                    return this.getRootFileSystem();
                }
                LocalFileSystem fs = this.nonRootFileSystems.get(root);
                if (fs == null) {
                    fs = new LocalFileSystem();
                    try {
                        fs.setRootDirectory(new File(root));
                        this.nonRootFileSystems.put(root, fs);
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return fs;
            }
        }
        return null;
    }

    public FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        File file = FileUtil.toFile((FileObject)fileObject);
        RemoteLogger.assertTrue(file != null, "null file");
        if (file == null) {
            return fileObject;
        }
        File canonicalFile = file.getCanonicalFile();
        if (canonicalFile.equals(file)) {
            return fileObject;
        }
        FileObject canonicalFileObject = FileUtil.toFileObject((File)canonicalFile);
        RemoteLogger.assertTrue(canonicalFileObject != null, "null canonical file");
        return canonicalFileObject == null ? fileObject : canonicalFileObject;
    }

    public String getCanonicalPath(FileObject fileObject) throws IOException {
        return this.getCanonicalFileObject(fileObject).getPath();
    }

    public String getCanonicalPath(FileSystem fs, String absPath) throws IOException {
        return new File(absPath).getCanonicalPath();
    }

    public String getCanonicalPath(ExecutionEnvironment env, String absPath) throws IOException {
        RemoteLogger.assertTrueInConsole(env.isLocal(), this.getClass().getSimpleName() + ".getCanonicalPath is called for REMOTE env: " + env);
        return new File(absPath).getCanonicalPath();
    }

    public boolean isMine(ExecutionEnvironment env) {
        return env.isLocal();
    }

    public ExecutionEnvironment getExecutionEnvironment(FileSystem fileSystem) {
        return ExecutionEnvironmentFactory.getLocal();
    }

    public boolean isMine(FileObject fileObject) {
        try {
            return this.isMine(fileObject.getFileSystem());
        }
        catch (FileStateInvalidException ex) {
            RemoteLogger.getInstance().log(Level.WARNING, ex.getLocalizedMessage(), ex);
            return false;
        }
    }

    public boolean isMine(FileSystem fileSystem) {
        if (fileSystem instanceof LocalFileSystem) {
            return true;
        }
        FileSystem rootFS = this.getRootFileSystem();
        return rootFS != null && rootFS.getClass() == fileSystem.getClass();
    }

    public boolean isMine(String absoluteURL) {
        if (this.isWindows) {
            return absoluteURL.length() > 1 && absoluteURL.charAt(1) == ':';
        }
        return absoluteURL.startsWith("/");
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    public boolean waitWrites(ExecutionEnvironment env, Collection<FileObject> filesToWait, Collection<String> failedFiles) throws InterruptedException {
        return true;
    }

    public FileObject urlToFileObject(String absoluteURL) {
        File file = new File(absoluteURL);
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
    }

    public String toURL(FileObject fileObject) {
        return fileObject.getPath();
    }

    public String toURL(FileSystem fileSystem, String absPath) {
        return absPath;
    }

    public FileObject fileToFileObject(File file) {
        return FileUtil.toFileObject((File)file);
    }

    public boolean isMine(File file) {
        return file.getClass() == File.class;
    }

    public void addDownloadListener(FileSystemProvider.DownloadListener listener) {
    }

    public void removeDownloadListener(FileSystemProvider.DownloadListener listener) {
    }

    public void scheduleRefresh(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        this.scheduleRefresh(file);
    }

    public void scheduleRefresh(ExecutionEnvironment env, Collection<String> paths) {
        RemoteLogger.assertTrue(env.isLocal());
        File[] files = new File[paths.size()];
        int pos = 0;
        for (String path : paths) {
            files[pos++] = new File(path);
        }
        this.scheduleRefresh(files);
    }

    private void scheduleRefresh(final File ... files) {
        RP.post(new Runnable(){

            public void run() {
                FileUtil.refreshFor((File[])files);
            }
        });
    }
}

