/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MarkOccurrencesHighlighter
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(MarkOccurrencesHighlighter.class.getName());
    private final Language language;
    private final Snapshot snapshot;
    static ColoringAttributes.Coloring MO = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.MARK_OCCURRENCES);
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;

    MarkOccurrencesHighlighter(Language language, Snapshot snapshot) {
        this.language = language;
        this.snapshot = snapshot;
    }

    public void run(ParserResult info, SchedulerEvent event) {
        this.resume();
        Document doc = this.snapshot.getSource().getDocument(false);
        if (doc == null) {
            LOG.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        long start = System.currentTimeMillis();
        int caretPosition = ((CursorMovedSchedulerEvent)event).getCaretOffset();
        if (this.isCancelled()) {
            return;
        }
        List<OffsetRange> bag = this.processImpl(info, doc, caretPosition);
        if (bag == null) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        if (bag.size() > 0) {
            Collections.sort(bag);
        }
        OffsetsBag obag = new OffsetsBag(doc);
        obag.clear();
        if (bag.size() > 0) {
            AttributeSet attributes = this.language.getColoringManager().getColoringImpl(MO);
            for (OffsetRange range : bag) {
                if (range == OffsetRange.NONE) continue;
                obag.addHighlight(range.getStart(), range.getEnd(), attributes);
            }
        }
        MarkOccurrencesHighlighter.getHighlightsBag(doc).setHighlights(obag);
        OccurrencesMarkProvider.get(doc).setOccurrences(OccurrencesMarkProvider.createMarks(doc, bag, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    @NonNull
    List<OffsetRange> processImpl(ParserResult info, Document doc, int caretPosition) {
        Map<OffsetRange, ColoringAttributes> highlights;
        OccurrencesFinder finder = this.language.getOccurrencesFinder();
        assert (finder != null);
        finder.setCaretPosition(caretPosition);
        try {
            finder.run(info, null);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        if (this.isCancelled()) {
            finder.cancel();
        }
        return (highlights = finder.getOccurrences()) == null ? null : new ArrayList<OffsetRange>(highlights.keySet());
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    public static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrencesHighlighter.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrencesHighlighter.class, bag);
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
            FileObject stream = DataLoadersBridge.getDefault().getFileObject(doc);
            if (stream instanceof FileObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{stream, bag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{stream, l});
            }
        }
        return bag;
    }
}

