/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.SelectHostWizardProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.makeproject.actions.ShadowProjectSynchronizer;
import org.netbeans.modules.cnd.makeproject.ui.wizards.RemoteProjectImportWizard;
import org.netbeans.modules.cnd.makeproject.ui.wizards.RemoteProjectImportWizardPanel;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public final class RemoteProjectImportWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private final List<RemoteProjectImportWizard.ImportedProject> projects = new ArrayList<RemoteProjectImportWizard.ImportedProject>();
    private WizardDescriptor wizard;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.panels == null) {
            SelectHostWizardProvider hostPanelProvider = SelectHostWizardProvider.createInstance((boolean)false, (boolean)true, (ChangeListener)new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    RemoteProjectImportWizardIterator.this.fireChangeEvent();
                }
            });
            WizardDescriptor.Panel[] wizardPanels = new WizardDescriptor.Panel[]{hostPanelProvider.getSelectHostPanel(), new RemoteProjectImportWizardPanel()};
            this.panels = wizardPanels;
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return NbBundle.getMessage(RemoteProjectImportWizardIterator.class, (String)"RemoteProjectImportWizardIterator.indexOf", (Object)(this.index + 1), (Object)this.getPanels().length);
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    Object getErrorMessage() {
        return null;
    }

    public Set<RemoteProjectImportWizard.ImportedProject> instantiate() throws IOException {
        return this.instantiate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RemoteProjectImportWizard.ImportedProject> instantiate(ProgressHandle handle) throws IOException {
        try {
            if (handle != null) {
                handle.start();
            }
            try {
                this.projects.clear();
                Collection remoteProjects = (Collection)this.wizard.getProperty("RemoteImportedProjects");
                this.projects.addAll(remoteProjects);
                for (RemoteProjectImportWizard.ImportedProject importedProject : remoteProjects) {
                    ServerRecord record;
                    boolean needsInitialization;
                    ExecutionEnvironment remoteEnvironment = importedProject.getRemoteEnvironment();
                    if (handle != null) {
                        handle.progress(NbBundle.getMessage(RemoteProjectImportWizardIterator.class, (String)"RemoteProjectImportWizardIterator.setupRecord", (Object)remoteEnvironment.getDisplayName()));
                    }
                    boolean newHost = true;
                    for (ExecutionEnvironment Env2 : ServerList.getEnvironments()) {
                        if (!remoteEnvironment.equals(Env2)) continue;
                        newHost = false;
                        break;
                    }
                    if (!(needsInitialization = (record = newHost ? ServerList.addServer((ExecutionEnvironment)remoteEnvironment, (String)remoteEnvironment.getDisplayName(), (RemoteSyncFactory)RemoteSyncFactory.getDefault(), (boolean)false, (boolean)true) : ServerList.get((ExecutionEnvironment)remoteEnvironment)).isOffline())) {
                        needsInitialization = CompilerSetManager.get((ExecutionEnvironment)remoteEnvironment).getCompilerSets().isEmpty();
                    }
                    if (needsInitialization) {
                        record.validate(true);
                        if (record.isOnline()) {
                            RequestProcessor.Task task = ToolsPanelSupport.restoreCompilerSets((ExecutionEnvironment)remoteEnvironment);
                            task.waitFinished();
                        }
                    }
                    if (!record.isOnline()) continue;
                    String remoteProjectFolder = importedProject.getRemoteProjectFolder();
                    if (handle != null) {
                        handle.progress(NbBundle.getMessage(RemoteProjectImportWizardIterator.class, (String)"RemoteProjectImportWizardIterator.import", (Object)CndPathUtilitities.getDirName((String)remoteProjectFolder)));
                    }
                    ShadowProjectSynchronizer synchronizer = new ShadowProjectSynchronizer(remoteProjectFolder, importedProject.getLocalProjectDestinationFolder(), remoteEnvironment);
                    FileObject localProject = synchronizer.createShadowProject();
                    assert (localProject != null);
                    Project findProject = ProjectManager.getDefault().findProject(localProject);
                    if (findProject != null) {
                        OpenProjects.getDefault().open(new Project[]{findProject}, false);
                        continue;
                    }
                    throw new IOException(NbBundle.getMessage(RemoteProjectImportWizardIterator.class, (String)"RemoteProjectImportWizardIterator.canNotOpenProject"));
                }
            }
            catch (SAXException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Set<RemoteProjectImportWizard.ImportedProject> set = Collections.emptySet();
            return set;
        }
        finally {
            if (handle != null) {
                handle.finish();
            }
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.getPanels();
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    List<RemoteProjectImportWizard.ImportedProject> getProjects() {
        return this.projects;
    }
}

