/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.remote.SelectHostWizardProvider;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.MakeProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.spi.DatabaseProjectProvider;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakefileOrConfigureDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ParserConfigurationDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectBinaryPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModeDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFoldersDescriptorPanel;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NewMakeProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 1L;
    public static final String APPLICATION_PROJECT_NAME = "CppApplication";
    public static final String DYNAMICLIBRARY_PROJECT_NAME = "CppDynamicLibrary";
    public static final String STATICLIBRARY_PROJECT_NAME = "CppStaticLibrary";
    public static final String MAKEFILEPROJECT_PROJECT_NAME = "MakefileProject";
    public static final String BINARY_PROJECT_NAME = "BinaryProject";
    public static final String FULL_REMOTE_PROJECT_NAME = "FullRemoteProject";
    public static final String QTAPPLICATION_PROJECT_NAME = "QtApplication";
    public static final String QTDYNAMICLIBRARY_PROJECT_NAME = "QtDynamicLibrary";
    public static final String QTSTATICLIBRARY_PROJECT_NAME = "QtStaticLibrary";
    public static final String DBAPPLICATION_PROJECT_NAME = "DbApplication";
    static final String PROP_NAME_INDEX = "nameIndex";
    public static final int TYPE_MAKEFILE = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_DYNAMIC_LIB = 2;
    public static final int TYPE_STATIC_LIB = 3;
    public static final int TYPE_QT_APPLICATION = 4;
    public static final int TYPE_QT_DYNAMIC_LIB = 5;
    public static final int TYPE_QT_STATIC_LIB = 6;
    public static final int TYPE_BINARY = 7;
    public static final int TYPE_DB_APPLICATION = 8;
    private final int wizardtype;
    private final boolean fullRemote;
    private Boolean lastSimpleMode = null;
    private String lastHostUid = null;
    private Boolean lastSetupHost = null;
    private SelectHostWizardProvider selectHostWizardProvider;
    private WizardDescriptor.Panel<WizardDescriptor> selectHostPanel;
    private WizardDescriptor.Panel<WizardDescriptor> selectBinaryPanel;
    private int lastNewHostPanel = -1;
    private SelectModeDescriptorPanel selectModePanel;
    private final PanelConfigureProject panelConfigureProjectTrue;
    private final List<WizardDescriptor.Panel<WizardDescriptor>> advancedPanels;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private transient int index;
    private transient List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private transient WizardDescriptor wiz;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    private static ResourceBundle bundle;

    private NewMakeProjectWizardIterator(int wizardtype, String name, String wizardTitle, String wizardACSD) {
        this(wizardtype, name, wizardTitle, wizardACSD, false);
    }

    private NewMakeProjectWizardIterator(int wizardtype, String name, String wizardTitle, String wizardACSD, boolean fullRemote) {
        this.wizardtype = wizardtype;
        name = name.replaceAll(" ", "");
        this.fullRemote = fullRemote;
        this.panelConfigureProjectTrue = new PanelConfigureProject(name, wizardtype, wizardTitle, wizardACSD, true);
        this.advancedPanels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
        this.advancedPanels.add(new MakefileOrConfigureDescriptorPanel());
        this.advancedPanels.add(new BuildActionsDescriptorPanel());
        this.advancedPanels.add(new SourceFoldersDescriptorPanel());
        this.advancedPanels.add(new ParserConfigurationDescriptorPanel());
        this.advancedPanels.add(new PanelConfigureProject(name, wizardtype, wizardTitle, wizardACSD, false));
    }

    private synchronized SelectModeDescriptorPanel getSelectModePanel() {
        if (this.selectModePanel == null) {
            this.selectModePanel = new SelectModeDescriptorPanel(this.fullRemote);
            this.selectModePanel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NewMakeProjectWizardIterator.this.setupPanelsAndStepsIfNeed();
                }
            });
        }
        return this.selectModePanel;
    }

    public static NewMakeProjectWizardIterator newApplication() {
        String name = APPLICATION_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newApplication.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewLibraryACSD");
        return new NewMakeProjectWizardIterator(1, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newDynamicLibrary() {
        String name = DYNAMICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newDynamicLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewDynamicLibraryACSD");
        return new NewMakeProjectWizardIterator(2, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newStaticLibrary() {
        String name = STATICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newStaticLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewStaticLibraryACSD");
        return new NewMakeProjectWizardIterator(3, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtApplication() {
        String name = QTAPPLICATION_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtApplication.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtApplicationACSD");
        return new NewMakeProjectWizardIterator(4, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtDynamicLibrary() {
        String name = QTDYNAMICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtDynamicLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtDynamicLibraryACSD");
        return new NewMakeProjectWizardIterator(5, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newQtStaticLibrary() {
        String name = QTSTATICLIBRARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newQtStaticLibrary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewQtStaticLibraryACSD");
        return new NewMakeProjectWizardIterator(6, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newDBApplication() {
        String name = DBAPPLICATION_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newDBApplication.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeNewDBApplicationACSD");
        return new NewMakeProjectWizardIterator(8, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator makefile() {
        String name = MAKEFILEPROJECT_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/makefile.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeMakefileNameACSD");
        return new NewMakeProjectWizardIterator(0, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator binary() {
        String name = BINARY_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/binary.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeBinaryNameACSD");
        return new NewMakeProjectWizardIterator(7, name, wizardTitle, wizardACSD);
    }

    public static NewMakeProjectWizardIterator newFullRemote() {
        String name = FULL_REMOTE_PROJECT_NAME;
        String wizardTitle = NewMakeProjectWizardIterator.getString("Templates/Project/Native/newFullRemote.xml");
        String wizardACSD = NewMakeProjectWizardIterator.getString("NativeFullRemoteNameACSD");
        return new NewMakeProjectWizardIterator(0, name, wizardTitle, wizardACSD, true);
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    private SelectHostWizardProvider getSelectHostWizardProvider() {
        if (this.selectHostWizardProvider == null) {
            this.selectHostWizardProvider = SelectHostWizardProvider.createInstance((boolean)false, (boolean)false, (ChangeListener)new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NewMakeProjectWizardIterator.this.fireStateChanged();
                }
            });
        }
        return this.selectHostWizardProvider;
    }

    private synchronized void setupPanelsAndStepsIfNeed() {
        if (this.wizardtype == 1 || this.wizardtype == 2 || this.wizardtype == 3 || this.wizardtype == 4 || this.wizardtype == 5 || this.wizardtype == 6) {
            if (this.panels == null) {
                this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
                this.panels.add(this.panelConfigureProjectTrue);
                String[] steps = this.createSteps(this.panels);
            }
        } else if (this.wizardtype == 0) {
            Boolean setupHost;
            String hostUID = this.wiz == null ? null : (String)this.wiz.getProperty("hostUID");
            Boolean bl = setupHost = this.fullRemote ? Boolean.valueOf(this.getSelectHostWizardProvider().isNewHost()) : null;
            if (this.panels != null && NewMakeProjectWizardIterator.equals(this.lastSimpleMode, this.isSimple())) {
                if (this.fullRemote) {
                    if (NewMakeProjectWizardIterator.equals(this.lastHostUid, hostUID) && NewMakeProjectWizardIterator.equals(this.lastSetupHost, setupHost)) {
                        return;
                    }
                } else {
                    return;
                }
            }
            this.lastHostUid = hostUID;
            this.lastSimpleMode = this.isSimple();
            this.lastSetupHost = setupHost;
            this.lastNewHostPanel = -1;
            LOGGER.log(Level.FINE, "refreshing panels and steps");
            ArrayList<WizardDescriptor.Panel<WizardDescriptor>> panelsList = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
            SelectModeDescriptorPanel modeSelectionPanel = this.getSelectModePanel();
            if (this.fullRemote) {
                if (this.selectHostPanel == null) {
                    this.selectHostPanel = this.getSelectHostWizardProvider().getSelectHostPanel();
                }
                panelsList.add(this.selectHostPanel);
                if (this.getSelectHostWizardProvider().isNewHost()) {
                    panelsList.addAll(this.getSelectHostWizardProvider().getAdditionalPanels());
                    this.lastNewHostPanel = panelsList.size() - 1;
                    panelsList.add((WizardDescriptor.Panel<WizardDescriptor>)modeSelectionPanel);
                    if (!this.isSimple()) {
                        panelsList.addAll(this.advancedPanels);
                    }
                } else {
                    panelsList.add((WizardDescriptor.Panel<WizardDescriptor>)modeSelectionPanel);
                    if (!this.isSimple()) {
                        panelsList.addAll(this.advancedPanels);
                    }
                }
            } else {
                panelsList.add((WizardDescriptor.Panel<WizardDescriptor>)modeSelectionPanel);
                if (!this.isSimple()) {
                    panelsList.addAll(this.advancedPanels);
                }
            }
            this.panels = panelsList;
            this.setupSteps();
        } else if (this.wizardtype == 7) {
            if (this.selectBinaryPanel == null) {
                this.selectBinaryPanel = new SelectBinaryPanel();
            }
            if (this.panels == null) {
                this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
                this.panels.add(this.selectBinaryPanel);
                this.panels.add(this.advancedPanels.get(4));
                String[] steps = this.createSteps(this.panels);
            }
        } else if (this.wizardtype == 8) {
            if (this.panels == null) {
                this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
                this.panelConfigureProjectTrue.setFinishPanel(false);
                this.panels.add(this.panelConfigureProjectTrue);
                DatabaseProjectProvider provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class);
                if (provider != null) {
                    provider.setupAdditionalWizardPanels(this.panels);
                }
                String[] stringArray = this.createSteps(this.panels);
            }
        } else {
            throw new IllegalStateException("Illegal wizard type: " + this.wizardtype);
        }
    }

    private void setupSteps() {
        String[] steps = this.createSteps(this.panels);
        String[] advanced = this.fullRemote ? new String[]{steps[0], steps[1], "..."} : new String[]{steps[0], "..."};
        Component c = this.panels.get(0).getComponent();
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentData", advanced);
        }
    }

    private String[] createSteps(List<WizardDescriptor.Panel<WizardDescriptor>> panels) {
        int i;
        String[] steps = new String[panels.size()];
        for (i = 0; i < panels.size(); ++i) {
            steps[i] = panels.get(i) instanceof Name ? ((Name)panels.get(i)).getName() : panels.get(i).getComponent().getName();
        }
        for (i = 0; i < panels.size(); ++i) {
            Component c = panels.get(i).getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        return steps;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set<FileObject> set = this.instantiate();
            return set;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            handle.finish();
        }
    }

    public Set<FileObject> instantiate() throws IOException {
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        String hostUID = (String)this.wiz.getProperty("hostUID");
        CompilerSet toolchain = (CompilerSet)this.wiz.getProperty("toolchain");
        boolean defaultToolchain = Boolean.TRUE.equals(this.wiz.getProperty("toolchainDefault"));
        if (dirF != null) {
            dirF = CndFileUtils.normalizeFile((File)dirF);
        }
        String projectName = (String)this.wiz.getProperty("name");
        String makefileName = (String)this.wiz.getProperty("generatedMakefileName");
        if (this.fullRemote) {
            this.getSelectHostWizardProvider().apply();
        }
        if (this.isSimple()) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                resultSet.addAll(extension.createProject(new SelectModeDescriptorPanel.WizardDescriptorAdapter(this.getSelectModePanel().getWizardStorage())));
            }
        } else if (this.wizardtype == 0) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                resultSet.addAll(extension.createProject(this.wiz));
            }
        } else if (this.wizardtype == 7) {
            IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension != null) {
                IteratorExtension.ProjectKind kind = (IteratorExtension.ProjectKind)((Object)this.wiz.getProperty("dependencyKind"));
                if (kind == null) {
                    kind = IteratorExtension.ProjectKind.IncludeDependencies;
                }
                extension.discoverProject(this.wiz.getProperties(), null, kind);
            }
        } else if (this.wizardtype == 1 || this.wizardtype == 2 || this.wizardtype == 3 || this.wizardtype == 4 || this.wizardtype == 5 || this.wizardtype == 6 || this.wizardtype == 8) {
            Object connection;
            DatabaseProjectProvider provider;
            DatabaseProjectProvider provider2;
            int conftype = -1;
            if (this.wizardtype == 1) {
                conftype = 1;
            } else if (this.wizardtype == 2) {
                conftype = 2;
            } else if (this.wizardtype == 3) {
                conftype = 3;
            } else if (this.wizardtype == 4) {
                conftype = 4;
            } else if (this.wizardtype == 5) {
                conftype = 5;
            } else if (this.wizardtype == 6) {
                conftype = 6;
            } else if (this.wizardtype == 8) {
                conftype = 7;
            }
            String mainFile = null;
            if (((Boolean)this.wiz.getProperty("createMainFile")).booleanValue()) {
                String fname = (String)this.wiz.getProperty("mainFileName");
                String template = (String)this.wiz.getProperty("mainFileTemplate");
                mainFile = fname + "|" + template;
            }
            MakeConfiguration debug = new MakeConfiguration(dirF.getPath(), "Debug", conftype, hostUID, toolchain, defaultToolchain);
            debug.getCCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getCCCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getFortranCompilerConfiguration().getDevelopmentMode().setValue(1);
            debug.getAssemblerConfiguration().getDevelopmentMode().setValue(1);
            debug.getQmakeConfiguration().getBuildMode().setValue(0);
            if (this.wizardtype == 8 && (provider2 = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class)) != null) {
                provider2.setupReleaseConfiguration(debug);
            }
            MakeConfiguration release = new MakeConfiguration(dirF.getPath(), "Release", conftype, hostUID, toolchain, defaultToolchain);
            release.getCCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getCCCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getFortranCompilerConfiguration().getDevelopmentMode().setValue(5);
            release.getAssemblerConfiguration().getDevelopmentMode().setValue(5);
            release.getQmakeConfiguration().getBuildMode().setValue(1);
            if (this.wizardtype == 8 && (provider = (DatabaseProjectProvider)Lookup.getDefault().lookup(DatabaseProjectProvider.class)) != null) {
                provider.setupReleaseConfiguration(release);
            }
            MakeConfiguration[] confs = new MakeConfiguration[]{debug, release};
            ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(projectName, dirF);
            prjParams.setMakefileName(makefileName);
            prjParams.setConfigurations(confs);
            prjParams.setMainFile(mainFile);
            prjParams.setFullRemote(this.fullRemote);
            prjParams.setHostUID(hostUID);
            if (this.wizardtype == 8 && (connection = this.wiz.getProperties().get("connectionName")) instanceof String) {
                prjParams.setDatabaseConnection((String)connection);
            }
            prjParams.setTemplateParams(new HashMap<String, Object>(this.wiz.getProperties()));
            MakeProjectGenerator.createProject(prjParams);
            ConfigurationDescriptorProvider.recordCreatedProjectMetrics(confs);
            FileObject dir = CndFileUtils.toFileObject((File)dirF);
            resultSet.add(dir);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        wiz.putProperty("fullRemote", (Object)this.fullRemote);
        this.index = 0;
        this.setupPanelsAndStepsIfNeed();
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz.putProperty("mainClass", null);
        if (this.wizardtype == 0) {
            this.wiz.putProperty("sourceRoot", null);
        }
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewMakeProjectWizardIterator.class, (String)"LAB_IteratorName"), this.index + 1, this.panels.size());
    }

    private boolean isSimple() {
        return this.wizardtype == 0 && this.wiz != null && Boolean.TRUE.equals(this.wiz.getProperty("simpleMode"));
    }

    public boolean hasNext() {
        this.setupPanelsAndStepsIfNeed();
        boolean result = this.index < this.panels.size() - 1;
        LOGGER.log(Level.FINE, "hasNext()=={0} (index=={1}, panels.length=={2})", new Object[]{result, this.index, this.panels.size()});
        return result;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.index == this.lastNewHostPanel && this.fullRemote) {
            this.getSelectHostWizardProvider().apply();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.setupPanelsAndStepsIfNeed();
        return this.panels.get(this.index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        ChangeListener[] listenersCopy;
        ChangeEvent event = new ChangeEvent(this);
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            listenersCopy = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        for (ChangeListener listener : listenersCopy) {
            listener.stateChanged(event);
        }
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NewMakeProjectWizardIterator.class);
        }
        return bundle.getString(s);
    }

    static interface Name {
        public String getName();
    }
}

