/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

class RemoteSyncActions {
    private static UploadAction uploadAction;
    private static DownloadAction downloadAction;
    private static final AtomicReference<Node[]> activatedNodesCache;
    private static final RequestProcessor.Task clearCacheTask;

    private RemoteSyncActions() {
    }

    public static Action createUploadAction() {
        if (uploadAction == null) {
            uploadAction = new UploadAction();
        }
        return uploadAction;
    }

    public static Action createDownloadAction() {
        if (downloadAction == null) {
            downloadAction = new DownloadAction();
        }
        return downloadAction;
    }

    private static void cacheActiveNodes(Node[] activatedNodes) {
        activatedNodesCache.set(activatedNodes);
        clearCacheTask.schedule(5000);
    }

    private static ExecutionEnvironment getEnv(Node[] activatedNodes) {
        ExecutionEnvironment result = null;
        for (Node node : activatedNodes) {
            Project project = RemoteSyncActions.getNodeProject(node);
            ExecutionEnvironment env = RemoteSyncActions.getEnv(project);
            if (env == null) continue;
            if (result == null) {
                result = env;
                continue;
            }
            if (result.equals(env)) continue;
            return null;
        }
        return result;
    }

    private static ExecutionEnvironment getEnv(Project project) {
        ExecutionEnvironment dh;
        RemoteProject info;
        ExecutionEnvironment developmentHost = ServerList.getDefaultRecord().getExecutionEnvironment();
        if (project != null && (info = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (dh = info.getDevelopmentHost()) != null) {
            developmentHost = dh;
        }
        return developmentHost;
    }

    private static Project getNodeProject(Node node) {
        if (node == null) {
            return null;
        }
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            return project;
        }
        return RemoteSyncActions.getNodeProject(node.getParentNode());
    }

    private static InputOutput getTab(String name, boolean reuse) {
        InputOutput tab;
        if (reuse) {
            tab = IOProvider.getDefault().getIO(name, false);
            tab.closeInputOutput();
        }
        tab = IOProvider.getDefault().getIO(name, true);
        try {
            tab.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tab.select();
        return tab;
    }

    private static void upload(ExecutionEnvironment execEnv, Node[] nodes) {
        InputOutput tab = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadTab_Name", (Object)execEnv), true);
        Uploader worker = new Uploader(execEnv, nodes, tab);
        worker.work();
    }

    private static void download(ExecutionEnvironment execEnv, Node[] nodes) {
        InputOutput tab = RemoteSyncActions.getTab(NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadTab_Name", (Object)execEnv), true);
        Downloader worker = new Downloader(execEnv, nodes, tab);
        worker.work();
    }

    private static Map<Project, Collection<File>> gatherFiles(Node[] nodes) {
        HashMap<Project, Collection<File>> result = new HashMap<Project, Collection<File>>();
        for (Node node : nodes) {
            Project project = RemoteSyncActions.getNodeProject(node);
            ArrayList files = (ArrayList)result.get(project);
            if (files == null) {
                files = new ArrayList();
                result.put(project, files);
            }
            RemoteSyncActions.gatherFiles((Collection<File>)files, node);
        }
        return result;
    }

    private static void gatherFiles(Collection<File> files, Node node) {
        Folder folder;
        File file;
        FileObject fo;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null && (fo = dataObject.getPrimaryFile()) != null && !(file = FileUtil.toFile((FileObject)fo)).isDirectory()) {
            files.add(file);
        }
        if ((folder = (Folder)node.getLookup().lookup(Folder.class)) != null) {
            RemoteSyncActions.gatherFiles(files, folder);
        }
    }

    private static void gatherFiles(Collection<File> files, Folder folder) {
        for (Item item : folder.getItemsAsArray()) {
            FileObject fo = item.getFileObject();
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null || file.isDirectory()) continue;
            files.add(file);
        }
        for (Folder subfolder : folder.getFolders()) {
            RemoteSyncActions.gatherFiles(files, subfolder);
        }
    }

    static {
        activatedNodesCache = new AtomicReference();
        clearCacheTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                activatedNodesCache.set(null);
            }
        });
    }

    private static class DownloadAction
    extends BaseAction {
        private DownloadAction() {
        }

        @Override
        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_0");
        }

        @Override
        protected String getItemText(String hostName) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_DownloadAction_Name_1", (Object)hostName);
        }

        @Override
        protected void performAction(final ExecutionEnvironment execEnv, final Node[] activatedNodes) {
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)execEnv).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.download(execEnv, activatedNodes);
                }
            });
        }
    }

    private static class UploadAction
    extends BaseAction {
        private UploadAction() {
        }

        @Override
        protected String getDummyItemText() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_0");
        }

        @Override
        protected String getItemText(String hostName) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"LBL_UploadAction_Name_1", (Object)hostName);
        }

        @Override
        protected void performAction(final ExecutionEnvironment execEnv, final Node[] activatedNodes) {
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable("Uploading to " + ServerList.get((ExecutionEnvironment)execEnv).getDisplayName()){

                protected void runImpl() {
                    RemoteSyncActions.upload(execEnv, activatedNodes);
                }
            });
        }
    }

    private static abstract class BaseAction
    extends NodeAction {
        private boolean enabled;

        private BaseAction() {
        }

        protected abstract void performAction(ExecutionEnvironment var1, Node[] var2);

        protected abstract String getDummyItemText();

        protected abstract String getItemText(String var1);

        protected boolean enable(Node[] activatedNodes) {
            RemoteSyncActions.cacheActiveNodes(activatedNodes);
            ExecutionEnvironment execEnv = RemoteSyncActions.getEnv(activatedNodes);
            this.enabled = execEnv != null && execEnv.isRemote();
            return this.enabled;
        }

        protected boolean wasEnabled() {
            return this.enabled;
        }

        protected void performAction(Node[] activatedNodes) {
            ExecutionEnvironment execEnv = RemoteSyncActions.getEnv(activatedNodes);
            if (execEnv != null && execEnv.isRemote()) {
                this.performAction(execEnv, activatedNodes);
            }
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public String getName() {
            if (!this.wasEnabled()) {
                return this.getDummyItemText();
            }
            Node[] activatedNodes = (Node[])activatedNodesCache.get();
            if (activatedNodes == null || activatedNodes.length == 0) {
                return this.getDummyItemText();
            }
            ExecutionEnvironment execEnv = RemoteSyncActions.getEnv(activatedNodes);
            if (execEnv == null || execEnv.isLocal()) {
                return this.getDummyItemText();
            }
            String hostName = ServerList.get((ExecutionEnvironment)execEnv).getDisplayName();
            return this.getItemText(hostName);
        }
    }

    private static class Downloader
    extends UpDownLoader {
        public Downloader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            super(execEnv, nodes, tab);
        }

        @Override
        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_DOWNLOAD_FILE", (Object)file.getAbsolutePath());
        }

        @Override
        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_DOWNLOAD", (Object)this.envName);
        }

        @Override
        protected RemoteSyncSupport.Worker createWorker(final Project project, final ExecutionEnvironment execEnv) {
            return new RemoteSyncSupport.Worker(){
                private final PathMap pathMap;
                {
                    this.pathMap = RemoteSyncSupport.getPathMap((ExecutionEnvironment)execEnv, (Project)project);
                }

                public void process(File file, Writer err) throws RemoteSyncSupport.PathMapperException, InterruptedException, ExecutionException, IOException {
                    String remotePath = this.pathMap.getRemotePath(file.getAbsolutePath(), false);
                    if (remotePath == null) {
                        throw new RemoteSyncSupport.PathMapperException(file);
                    }
                    Future task = CommonTasksSupport.downloadFile((String)remotePath, (ExecutionEnvironment)execEnv, (String)file.getAbsolutePath(), (Writer)err);
                    int rc = (Integer)task.get();
                    if (rc != 0) {
                        throw new IOException(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_RC", (Object)rc));
                    }
                }

                public void close() {
                }
            };
        }
    }

    private static class Uploader
    extends UpDownLoader {
        public Uploader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            super(execEnv, nodes, tab);
        }

        @Override
        protected String getFileProgressMessage(File file) {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"MSG_UPLOAD_FILE", (Object)file.getAbsolutePath());
        }

        @Override
        protected String getProgressTitle() {
            return NbBundle.getMessage(RemoteSyncActions.class, (String)"PROGRESS_TITLE_UPLOAD", (Object)this.envName);
        }

        @Override
        protected RemoteSyncSupport.Worker createWorker(Project project, ExecutionEnvironment execEnv) {
            return RemoteSyncSupport.createUploader((Project)project, (ExecutionEnvironment)execEnv);
        }
    }

    private static abstract class UpDownLoader
    implements Cancellable {
        protected final ExecutionEnvironment execEnv;
        protected final String envName;
        protected final InputOutput tab;
        private boolean cancelled = false;
        private final Node[] nodes;
        private volatile Thread workingThread;

        public UpDownLoader(ExecutionEnvironment execEnv, Node[] nodes, InputOutput tab) {
            this.execEnv = execEnv;
            this.nodes = nodes;
            this.tab = tab;
            this.envName = ServerList.get((ExecutionEnvironment)execEnv).getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work() {
            this.workingThread = Thread.currentThread();
            String title = this.getProgressTitle();
            this.tab.getOut().println(title);
            long time = System.currentTimeMillis();
            int errCnt = 0;
            int okCnt = 0;
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)title, (Cancellable)this);
            progressHandle.start();
            try {
                if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    ConnectionManager.getInstance().connectTo(this.execEnv);
                }
                Map filesMap = RemoteSyncActions.gatherFiles(this.nodes);
                int cnt = 0;
                int total = 0;
                for (Collection collection : filesMap.values()) {
                    total += collection.size();
                }
                progressHandle.switchToDeterminate(total);
                block19: for (Map.Entry entry : filesMap.entrySet()) {
                    RemoteSyncSupport.Worker worker = this.createWorker((Project)entry.getKey(), this.execEnv);
                    try {
                        for (File file : (Collection)entry.getValue()) {
                            if (this.cancelled) continue block19;
                            String progressMessage = this.getFileProgressMessage(file);
                            this.tab.getOut().println(progressMessage);
                            try {
                                worker.process(file, (Writer)this.tab.getErr());
                                ++okCnt;
                            }
                            catch (InterruptedException ex) {
                                continue block19;
                            }
                            catch (ExecutionException ex) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)ex.getMessage()));
                                ++errCnt;
                            }
                            catch (IOException ex) {
                                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_FILE", (Object)file.getAbsolutePath(), (Object)ex.getMessage()));
                                ++errCnt;
                            }
                            progressHandle.progress(progressMessage, cnt++);
                        }
                    }
                    finally {
                        worker.close();
                    }
                }
            }
            catch (RemoteSyncSupport.PathMapperException ex) {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"ERR_MAPPING", (Object)ex.getFile().getAbsolutePath()));
            }
            catch (CancellationException ex) {
                this.cancelled = true;
            }
            catch (InterruptedIOException ex) {
                this.cancelled = true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                progressHandle.finish();
            }
            this.workingThread = null;
            time = System.currentTimeMillis() - time;
            if (errCnt == 0) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_SUCCESS", (Object)okCnt));
            } else if (this.cancelled) {
                this.tab.getOut().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_CANCELLED", (Object)okCnt));
            } else {
                this.tab.getErr().println(NbBundle.getMessage(RemoteSyncActions.class, (String)"SUMMARY_ERROR", (Object)okCnt));
            }
        }

        public boolean cancel() {
            this.cancelled = true;
            Thread thread = this.workingThread;
            if (thread != null) {
                thread.interrupt();
            }
            return true;
        }

        protected abstract String getProgressTitle();

        protected abstract String getFileProgressMessage(File var1);

        protected abstract RemoteSyncSupport.Worker createWorker(Project var1, ExecutionEnvironment var2);
    }
}

