/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingFolderItemsAction;
import org.netbeans.modules.cnd.makeproject.actions.AddExistingItemAction;
import org.netbeans.modules.cnd.makeproject.actions.DebugTestAction;
import org.netbeans.modules.cnd.makeproject.actions.NewFolderAction;
import org.netbeans.modules.cnd.makeproject.actions.NewTestActionFactory;
import org.netbeans.modules.cnd.makeproject.actions.RunTestAction;
import org.netbeans.modules.cnd.makeproject.actions.StepIntoTestAction;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.AnnotatedNode;
import org.netbeans.modules.cnd.makeproject.ui.FolderSearchInfo;
import org.netbeans.modules.cnd.makeproject.ui.LogicalViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.NodeActionFactory;
import org.netbeans.modules.cnd.makeproject.ui.PropertiesFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.RemoveFolderAction;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemPasteType;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class LogicalFolderNode
extends AnnotatedNode
implements ChangeListener {
    private final Folder folder;
    private final MakeLogicalViewProvider provider;
    private final String pathPostfix;

    public LogicalFolderNode(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
        super((Children)new LogicalViewChildren(folder, provider), LogicalFolderNode.createLFNLookup(folderNode, folder, provider), MakeLogicalViewProvider.ANNOTATION_RP);
        this.folder = folder;
        this.provider = provider;
        String postfix = "";
        if (folder != null && folder.getRoot() != null) {
            String AbsRootPath = CndPathUtilitities.toAbsolutePath((String)provider.getMakeConfigurationDescriptor().getBaseDir(), (String)folder.getRoot());
            FileObject folderFile = RemoteFileUtil.getFileObject((String)(AbsRootPath = RemoteFileUtil.normalizeAbsolutePath((String)AbsRootPath, (Project)provider.getProject())), (Project)provider.getProject());
            if (folderFile != null) {
                postfix = " - " + folderFile.getPath();
            }
        }
        this.pathPostfix = postfix;
        this.setForceAnnotation(true);
        this.updateAnnotationFiles();
    }

    private static Lookup createLFNLookup(Node folderNode, Folder folder, MakeLogicalViewProvider provider) {
        MakeConfigurationDescriptor conf;
        ArrayList<Object> elems = new ArrayList<Object>(3);
        elems.add(folder);
        elems.add(provider.getProject());
        elems.add(new FolderSearchInfo(folder));
        if (folder.isDiskFolder() && (conf = folder.getConfigurationDescriptor()) != null) {
            DataFolder dataFolder;
            String rootPath = folder.getRootPath();
            FileObject fo = RemoteFileUtil.getFileObject((FileObject)conf.getBaseDirFileObject(), (String)rootPath);
            if (fo != null && fo.isValid() && fo.isFolder() && (dataFolder = DataFolder.findFolder((FileObject)fo)) != null) {
                elems.add(dataFolder);
            }
        }
        return Lookups.fixed((Object[])elems.toArray());
    }

    private void updateAnnotationFiles() {
        MakeLogicalViewProvider.ANNOTATION_RP.post((Runnable)new FileAnnotationUpdater(this));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateAnnotationFiles();
        EventQueue.invokeLater(new VisualUpdater());
    }

    public Folder getFolder() {
        return this.folder;
    }

    public Object getValue(String valstring) {
        if (valstring == null) {
            return super.getValue(null);
        }
        if (valstring.equals("Folder")) {
            return this.folder;
        }
        if (valstring.equals("Project")) {
            return this.provider.getProject();
        }
        if (valstring.equals("This")) {
            return this;
        }
        return super.getValue(valstring);
    }

    public Image getIcon(int type) {
        if (this.folder.isTest()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif"), type);
        }
        if (this.folder.isTestRootFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
        }
        if (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
        }
        if (this.folder.isDiskFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), type);
        }
        return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolder.gif"), type);
    }

    public Image getOpenedIcon(int type) {
        if (this.folder.isTest()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testContainer.gif"), type);
        }
        if (this.folder.isTestRootFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolderOpened.gif"), type);
        }
        if (this.folder.isDiskFolder() && this.folder.isTestLogicalFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/testFolder.gif"), type);
        }
        if (this.folder.isDiskFolder()) {
            return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/tree_folder.gif"), type);
        }
        return this.annotateIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/logicalFilesFolderOpened.gif"), type);
    }

    public String getName() {
        return this.folder.getDisplayName();
    }

    public String getDisplayName() {
        return this.annotateName(this.folder.getDisplayName() + this.pathPostfix);
    }

    public void setName(String newName) {
        String oldName = this.folder.getDisplayName();
        if (this.folder.isDiskFolder()) {
            String rootPath = this.folder.getRootPath();
            String AbsRootPath = CndPathUtilitities.toAbsolutePath((String)this.folder.getConfigurationDescriptor().getBaseDir(), (String)rootPath);
            FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)AbsRootPath));
            if (fo == null || !fo.isValid() || !fo.isFolder()) {
                return;
            }
            try {
                fo.rename(fo.lock(), newName, null);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        if (this.folder.getParent() != null && this.folder.getParent().findFolderByDisplayName(newName) != null) {
            String msg = NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"CANNOT_RENAME", (Object)oldName, (Object)newName);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            return;
        }
        this.folder.setDisplayName(newName);
        this.fireDisplayNameChange(oldName, newName);
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return this.getFolder().isDiskFolder();
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public void destroy() throws IOException {
        if (!this.getFolder().isDiskFolder()) {
            return;
        }
        String absPath = CndPathUtilitities.toAbsolutePath((String)this.getFolder().getConfigurationDescriptor().getBaseDir(), (String)this.getFolder().getRootPath());
        FileObject folderFileObject = CndFileUtils.toFileObject((CharSequence)CndFileUtils.normalizeAbsolutePath((String)absPath));
        if (folderFileObject == null || !folderFileObject.isValid() || !folderFileObject.isFolder()) {
            return;
        }
        folderFileObject.delete();
        super.destroy();
    }

    public PasteType getDropType(Transferable transferable, int action, int index) {
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            return super.getDropType(transferable, action, index);
        }
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        if (this.folder.isTestLogicalFolder()) {
            return;
        }
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].getSubType().equals("x-org-netbeans-modules-cnd-makeproject-uidnd")) continue;
            try {
                ViewItemNode viewItemNode = (ViewItemNode)transferable.getTransferData(flavors[i]);
                int type = new Integer(flavors[i].getParameter("mask"));
                list.add(new ViewItemPasteType(this.getFolder(), viewItemNode, type, this.provider));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.createPasteTypes(transferable, list);
    }

    public void newLogicalFolder() {
    }

    public Action[] getActions(boolean context) {
        Action[] result;
        ResourceBundle bundle = NbBundle.getBundle(MakeLogicalViewProvider.class);
        if (this.folder.isTestRootFolder()) {
            result = new Action[]{null, ProjectSensitiveActions.projectCommandAction((String)"test", (String)bundle.getString("LBL_TestAction_Name"), null), null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(PropertiesFolderAction.class)};
            result = NodeActionFactory.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
        } else if (this.folder.isTestLogicalFolder() && !this.folder.isDiskFolder()) {
            result = new Action[]{null, NewTestActionFactory.emptyTestFolderAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)};
            result = NodeActionFactory.insertAfter(NewTestActionFactory.getTestCreationActions(this.folder.getProject()), result);
        } else {
            result = this.folder.isTest() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(AddExistingItemAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(RunTestAction.class), SystemAction.get(DebugTestAction.class), SystemAction.get(StepIntoTestAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : (this.folder.isDiskFolder() ? new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)} : new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(NewFolderAction.class), SystemAction.get(AddExistingItemAction.class), SystemAction.get(AddExistingFolderItemsAction.class), SystemAction.get(FindAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(RemoveFolderAction.class), NodeActionFactory.createRenameAction(), null, SystemAction.get(PropertiesFolderAction.class)});
        }
        MakeProjectType projectKind = (MakeProjectType)this.provider.getProject().getLookup().lookup(MakeProjectType.class);
        List actionsForMakeProject = Utilities.actionsForPath((String)projectKind.folderActionsPath());
        result = NodeActionFactory.insertAfter(result, actionsForMakeProject.toArray(new Action[actionsForMakeProject.size()]), NodeActionFactory.RenameNodeAction.class);
        result = NodeActionFactory.insertSyncActions(result, NodeActionFactory.RenameNodeAction.class);
        return result;
    }

    private final class VisualUpdater
    implements Runnable {
        private VisualUpdater() {
        }

        @Override
        public void run() {
            LogicalFolderNode.this.fireIconChange();
            LogicalFolderNode.this.fireOpenedIconChange();
        }
    }

    private final class FileAnnotationUpdater
    implements Runnable {
        private LogicalFolderNode logicalFolderNode;

        FileAnnotationUpdater(LogicalFolderNode logicalFolderNode2) {
            this.logicalFolderNode = logicalFolderNode2;
        }

        @Override
        public void run() {
            LogicalFolderNode.this.setFiles(new HashSet<FileObject>());
            ArrayList<Folder> allFolders = new ArrayList<Folder>();
            allFolders.add(LogicalFolderNode.this.folder);
            allFolders.addAll(LogicalFolderNode.this.folder.getAllFolders(true));
            Iterator iter = allFolders.iterator();
            while (iter.hasNext()) {
                ((Folder)iter.next()).addChangeListener(this.logicalFolderNode);
            }
        }
    }
}

