/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ShadowProjectSynchronizer {
    public static final String DEFAULT = "default";
    private static final String PROJECT_CONFIGURATION_FILE = "nbproject/configurations.xml";
    private static final String PROJECT_PRIVATE_CONFIGURATION_FILE = "nbproject/private/configurations.xml";
    private static final String TMP_NBPROJECT_SUBFOLDER_NAME = "full_remote_tmp";
    private static final String TMP_NBPROJECT_SUBFOLDER_PATH = "private/full_remote_tmp";
    private final ExecutionEnvironment env;
    private final String remoteProjectPath;
    private final String localProjectPath;
    private FileObject remoteProject;
    private FileObject localProject;
    private static final Logger LOGGER = Logger.getLogger("cnd.remote.logger");

    public ShadowProjectSynchronizer(String remoteProjectPath, String localProjectPath, ExecutionEnvironment env) {
        this.remoteProjectPath = remoteProjectPath;
        this.localProjectPath = localProjectPath;
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createShadowProject() throws IOException, SAXException {
        File localProjectFile = new File(this.localProjectPath);
        if (localProjectFile.exists()) {
            throw new IOException(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_DirAlreadyExists", (Object)localProjectFile.getAbsolutePath()));
        }
        this.localProject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)localProjectFile));
        boolean success = false;
        try {
            this.remoteProject = CndFileUtils.toFileObject((FileSystem)FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env), (CharSequence)this.remoteProjectPath);
            if (this.remoteProject == null || !this.remoteProject.isValid()) {
                throw new IOException(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_DirDoesNotExist", (Object)this.remoteProjectPath));
            }
            FileObject remoteNbprojectFO = ShadowProjectSynchronizer.getFileObject(this.remoteProject, "nbproject");
            remoteNbprojectFO.refresh();
            this.copy(remoteNbprojectFO, this.localProject, "nbproject", null);
            this.updateLocalProjectXml();
            this.updateLocalConfiguration();
            this.updateLocalPrivateConfiguration();
            success = true;
        }
        finally {
            if (!success) {
                this.remove(this.localProject);
            }
        }
        return this.localProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteProject() throws IOException, SAXException, InterruptedException {
        File localProjectFile = new File(this.localProjectPath);
        if (!localProjectFile.exists()) {
            throw new FileNotFoundException(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_DirDoesNotExist", (Object)this.localProjectPath));
        }
        this.localProject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)localProjectFile));
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync", (Object)this.localProject.getNameExt(), (Object)this.env.getDisplayName()));
        progress.setInitialDelay(4000);
        progress.start();
        try {
            this.updateRemoteProjectImpl(progress);
        }
        finally {
            progress.finish();
        }
    }

    private FileObject[] filterChildren(FileObject[] children) {
        for (int i = 0; i < children.length; ++i) {
            if (!TMP_NBPROJECT_SUBFOLDER_NAME.equals(children[i].getName())) continue;
            FileObject[] result = new FileObject[children.length - 1];
            if (i == 0) {
                System.arraycopy(children, 1, result, 0, children.length - 1);
            } else {
                System.arraycopy(children, 0, result, 0, i);
                System.arraycopy(children, i + 1, result, i, children.length - i - 1);
            }
            return result;
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean differ(FileObject fo1, FileObject fo2) {
        Parameters.notNull((CharSequence)"file object 1", (Object)fo1);
        Parameters.notNull((CharSequence)"file object 2", (Object)fo2);
        if (fo1.isValid() != fo2.isValid()) {
            LOGGER.log(Level.FINEST, "PrjDiff: validity differ for {0} and {1}", new Object[]{fo1, fo2});
            return true;
        }
        if (fo1.isFolder()) {
            FileObject[] children2;
            if (!fo2.isFolder()) {
                LOGGER.log(Level.FINEST, "PrjDiff: {0} is not a folder", fo2);
                return true;
            }
            FileObject[] children1 = this.filterChildren(fo1.getChildren());
            if (children1.length != (children2 = this.filterChildren(fo2.getChildren())).length) {
                LOGGER.log(Level.FINEST, "PrjDiff: child count differ for {0} and {1}: {2} vs {3}", new Object[]{fo1, fo2, children1.length, children2.length});
                return true;
            }
            Comparator<FileObject> comparator = new Comparator<FileObject>(){

                @Override
                public int compare(FileObject o1, FileObject o2) {
                    return o1.getNameExt().compareTo(o2.getNameExt());
                }
            };
            Arrays.sort(children1, comparator);
            Arrays.sort(children2, comparator);
            for (int i = 0; i < children1.length; ++i) {
                if (!this.differ(children1[i], children2[i])) continue;
                return true;
            }
        } else {
            long size2;
            if (fo2.isFolder()) {
                LOGGER.log(Level.FINEST, "PrjDiff: {0} is folder\n", fo2);
                return true;
            }
            long size1 = fo1.getSize();
            if (size1 != (size2 = fo2.getSize())) {
                LOGGER.log(Level.FINEST, "PrjDiff: size differ for {0} and {1}: {2} vs {3}", new Object[]{fo1, fo2, size1, size2});
                return true;
            }
            BufferedReader reader1 = null;
            BufferedReader reader2 = null;
            try {
                reader1 = new BufferedReader(new InputStreamReader(fo1.getInputStream()));
                reader2 = new BufferedReader(new InputStreamReader(fo2.getInputStream()));
                while (true) {
                    int c1;
                    if ((c1 = reader1.read()) >= 0) {
                        int c2 = reader2.read();
                        if (c1 == c2) continue;
                        LOGGER.log(Level.FINEST, "PrjDiff: {0} and {1} differ in content\n", new Object[]{fo1, fo2});
                        boolean bl = true;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINEST, "PrjDiff: exception: {0} when reading {1} or {2}\n", new Object[]{e.getMessage(), fo1, fo2});
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    if (reader1 != null) {
                        reader1.close();
                    }
                    if (reader2 != null) {
                        reader1.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteProjectImpl(ProgressHandle progress) throws IOException, SAXException, InterruptedException {
        FileObject localNbprojectFO = ShadowProjectSynchronizer.getFileObject(this.localProject, "nbproject");
        this.remoteProject = CndFileUtils.toFileObject((FileSystem)FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env), (CharSequence)this.remoteProjectPath);
        if (this.remoteProject == null || !this.remoteProject.isValid()) {
            return;
        }
        FileObject remoteNbprojectFO = ShadowProjectSynchronizer.getFileObject(this.remoteProject, "nbproject");
        progress.switchToDeterminate(7);
        AtomicReference<FileObject> remoteTmpFoRef = new AtomicReference<FileObject>();
        AtomicReference<Boolean> remoteTmpFOCreationSuccess = new AtomicReference<Boolean>(false);
        AtomicReference<String> remoteTmpFOErrMsg = new AtomicReference<String>();
        FileObject tmpFO = ShadowProjectSynchronizer.createTempDir(this.localProject.getName(), ".tmp");
        try {
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_local_tmp"));
            FileObject tmpNbProjFO = this.copy(localNbprojectFO, tmpFO, "nbproject", null);
            progress.progress(1);
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_local_merge"));
            ShadowProjectSynchronizer.updateRemoteProjectXml(tmpFO);
            this.updateRemoteConfiguration(tmpFO);
            this.updateRemotePrivateConfiguration(tmpFO);
            progress.progress(2);
            if (!this.differ(tmpNbProjFO, remoteNbprojectFO)) {
                LOGGER.fine("PrjDiff: Project has not change - no synchronization to remote host is needed");
                return;
            }
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_remote_temp"));
            RequestProcessor.Task remoteTmpFOTask = this.prepareRemoteNbProject(remoteNbprojectFO, remoteTmpFoRef, remoteTmpFOCreationSuccess, remoteTmpFOErrMsg);
            remoteTmpFOTask.waitFinished();
            if (!remoteTmpFOCreationSuccess.get().booleanValue()) {
                throw new IOException(remoteTmpFOErrMsg.get());
            }
            FileObject remoteTmpFo = remoteTmpFoRef.get();
            CndUtils.assertNotNull((Object)remoteTmpFo, (String)"Null remote temp file object");
            progress.progress(3);
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_copy_to_remote"));
            ArrayList<FileObject> objectsToTrack = new ArrayList<FileObject>();
            this.copy(tmpNbProjFO, remoteTmpFo, objectsToTrack);
            ArrayList failed = new ArrayList();
            FileSystemProvider.waitWrites((ExecutionEnvironment)this.env, objectsToTrack, failed);
            progress.progress(4);
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_update_project"));
            ProcessUtils.ExitStatus moveStatus = ProcessUtils.executeInDir((String)remoteNbprojectFO.getPath(), (ExecutionEnvironment)this.env, (String)"/bin/sh", (String[])new String[]{"-c", "mv private/full_remote_tmp/private/* private/; rmdir private/full_remote_tmp/private; mv private/full_remote_tmp/* ."});
            progress.progress(5);
            if (!moveStatus.isOK()) {
                throw new IOException(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_MovingRemoteTmpToProject", (Object)moveStatus.error));
            }
            progress.progress(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"Progress_sync_cleanup"));
            Future rmTask = CommonTasksSupport.rmDir((ExecutionEnvironment)this.env, (String)(remoteNbprojectFO.getPath() + '/' + TMP_NBPROJECT_SUBFOLDER_PATH), (boolean)true, (Writer)new PrintWriter(System.err));
            progress.progress(6);
            try {
                int rc = (Integer)rmTask.get();
                if (rc != 0) {
                    LOGGER.info("Error cleaning up remote temporary directory");
                }
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, "Exception when cleaning up remote temporary directory", ex);
            }
            remoteNbprojectFO.refresh();
        }
        finally {
            this.remove(tmpFO);
            progress.progress(7);
        }
    }

    private RequestProcessor.Task prepareRemoteNbProject(final FileObject remoteNbprojectFO, final AtomicReference<FileObject> createdFO, final AtomicReference<Boolean> success, final AtomicReference<String> errMsg) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)remoteNbprojectFO.getPath(), (ExecutionEnvironment)ShadowProjectSynchronizer.this.env, (String)"/bin/sh", (String[])new String[]{"-c", "mkdir -p private/full_remote_tmp && rm -rf private/full_remote_tmp/*; "});
                if (status.isOK()) {
                    remoteNbprojectFO.refresh();
                    FileObject fo = remoteNbprojectFO.getFileObject(ShadowProjectSynchronizer.TMP_NBPROJECT_SUBFOLDER_PATH);
                    if (fo == null) {
                        success.set(false);
                        errMsg.set(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_RemoteTmpDirNotFound"));
                    } else {
                        createdFO.set(fo);
                        success.set(true);
                    }
                } else {
                    errMsg.set(status.error);
                    success.set(false);
                }
            }
        };
        return new RequestProcessor("Preparing to sync back project " + this.remoteProjectPath, 1).post(r);
    }

    private static FileObject createTempDir(String prefix, String suffix) throws IOException {
        File tmpFile = FileUtil.normalizeFile((File)File.createTempFile(prefix, suffix));
        if (!tmpFile.delete()) {
            throw new IOException("Can not delete temporary file " + tmpFile.getAbsolutePath());
        }
        if (!tmpFile.mkdirs()) {
            throw new IOException("Can create temporary directory " + tmpFile.getAbsolutePath());
        }
        FileObject tmpFO = FileUtil.toFileObject((File)tmpFile);
        return tmpFO;
    }

    private boolean remove(FileObject fo) {
        if (fo.isFolder()) {
            boolean success = true;
            for (FileObject child : fo.getChildren()) {
                if (this.remove(child)) continue;
                success = false;
            }
            if (success) {
                try {
                    fo.delete();
                }
                catch (IOException ex) {
                    success = false;
                    LOGGER.log(Level.INFO, "Exception when performing cleanup in " + fo.getPath(), ex);
                }
            }
            return success;
        }
        try {
            fo.delete();
            return true;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Exception when performing cleanup in " + fo.getPath(), ex);
            return false;
        }
    }

    private static FileObject updateRemoteProjectXml(FileObject remoteProjectCopy) throws IOException, SAXException {
        FileObject projectXmlFO = ShadowProjectSynchronizer.getFileObject(remoteProjectCopy, "nbproject/project.xml");
        Document doc = XMLUtil.parse((InputSource)new InputSource(projectXmlFO.getInputStream()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null) {
            String[] tagsToRemove;
            for (String tag : tagsToRemove = new String[]{"remote-sources-mode", "remote-filesystem-host", "remote-filesystem-base-dir"}) {
                NodeList nodeList = root.getElementsByTagName(tag);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    node.getParentNode().removeChild(node);
                }
            }
        }
        return ShadowProjectSynchronizer.saveXml(doc, remoteProjectCopy, "nbproject/project.xml");
    }

    private static String getOrigCompilerSet(FileObject remoteProjectOrig) throws IOException, SAXException {
        FileObject origPublicConfigurationsFO = ShadowProjectSynchronizer.getFileObject(remoteProjectOrig, PROJECT_CONFIGURATION_FILE);
        Document origDoc = XMLUtil.parse((InputSource)new InputSource(origPublicConfigurationsFO.getInputStream()), (boolean)false, (boolean)true, null, null);
        Element origRoot = origDoc.getDocumentElement();
        return ShadowProjectSynchronizer.getOrigCompilerSet(origRoot);
    }

    private static String getOrigCompilerSet(Element origRoot) throws IOException, SAXException {
        Node origCsNode;
        String origCsName = DEFAULT;
        NodeList origCSList = origRoot.getElementsByTagName("compilerSet");
        if (origCSList.getLength() > 0 && (origCsNode = origCSList.item(0)).getChildNodes().getLength() > 0) {
            origCsName = ShadowProjectSynchronizer.getSimpleNodeValue(origCsNode);
        }
        return origCsName;
    }

    private static String getSimpleNodeValue(Node node) {
        NodeList childNodes;
        if (node != null && (childNodes = node.getChildNodes()).getLength() > 0) {
            return childNodes.item(0).getNodeValue();
        }
        return null;
    }

    private static FileObject getFileObject(FileObject base, String relPath) throws FileNotFoundException {
        FileObject fo = base.getFileObject(relPath);
        if (fo == null || !fo.isValid()) {
            String text;
            try {
                text = base.getURL().toString();
                text = text + (text.endsWith("/") ? "" : "/") + relPath;
            }
            catch (FileStateInvalidException ex) {
                text = base.getPath() + '/' + relPath;
            }
            throw new FileNotFoundException(NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_DirDoesNotExist", (Object)text));
        }
        return fo;
    }

    private FileObject updateRemoteConfiguration(FileObject remoteProjectCopy) throws IOException, SAXException {
        String origCsName = ShadowProjectSynchronizer.getOrigCompilerSet(this.remoteProject);
        FileObject fo = ShadowProjectSynchronizer.getFileObject(remoteProjectCopy, PROJECT_CONFIGURATION_FILE);
        Document doc = XMLUtil.parse((InputSource)new InputSource(fo.getInputStream()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null) {
            NodeList toolSetList = root.getElementsByTagName("toolsSet");
            for (int i = 0; i < toolSetList.getLength(); ++i) {
                Node node = toolSetList.item(i);
                ShadowProjectSynchronizer.removeChildren(node);
                Element el = doc.createElement("remote-sources-mode");
                el.setTextContent(RemoteProject.Mode.LOCAL_SOURCES.name());
                node.appendChild(el);
                el = doc.createElement("compilerSet");
                el.setTextContent(origCsName);
                node.appendChild(el);
            }
        }
        return ShadowProjectSynchronizer.saveXml(doc, remoteProjectCopy, PROJECT_CONFIGURATION_FILE);
    }

    private Map<String, ServerAndPlatform> getOrigPlatforms() throws IOException, SAXException {
        HashMap<String, ServerAndPlatform> compilerSets = new HashMap<String, ServerAndPlatform>();
        FileObject origPublicConfigurationsFO = ShadowProjectSynchronizer.getFileObject(this.remoteProject, PROJECT_PRIVATE_CONFIGURATION_FILE);
        Document doc = XMLUtil.parse((InputSource)new InputSource(origPublicConfigurationsFO.getInputStream()), (boolean)false, (boolean)true, null, null);
        for (Node conf : ShadowProjectSynchronizer.getIterableByTagName(doc.getDocumentElement(), "conf")) {
            NamedNodeMap attrs = conf.getAttributes();
            String confName = attrs.getNamedItem("name").getNodeValue();
            for (Node toolSetNode : ShadowProjectSynchronizer.getIterableByTagName(conf, "toolsSet")) {
                Node serverNode = ShadowProjectSynchronizer.getNodeByTagName(toolSetNode, "developmentServer");
                Node platformNode = ShadowProjectSynchronizer.getNodeByTagName(toolSetNode, "platform");
                ServerAndPlatform sp = new ServerAndPlatform(ShadowProjectSynchronizer.getSimpleNodeValue(serverNode), ShadowProjectSynchronizer.getSimpleNodeValue(platformNode));
                compilerSets.put(confName, sp);
            }
        }
        return compilerSets;
    }

    private FileObject updateRemotePrivateConfiguration(FileObject remoteProjectCopy) throws IOException, SAXException {
        Map<String, ServerAndPlatform> origPlatforms = this.getOrigPlatforms();
        FileObject fo = ShadowProjectSynchronizer.getFileObject(remoteProjectCopy, PROJECT_PRIVATE_CONFIGURATION_FILE);
        Document doc = XMLUtil.parse((InputSource)new InputSource(fo.getInputStream()), (boolean)false, (boolean)true, null, null);
        for (Node conf : ShadowProjectSynchronizer.getIterableByTagName(doc.getDocumentElement(), "conf")) {
            NamedNodeMap attrs = conf.getAttributes();
            String confName = attrs.getNamedItem("name").getNodeValue();
            ServerAndPlatform sp = origPlatforms.get(confName);
            if (sp == null) {
                sp = new ServerAndPlatform(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()), Integer.toString(ShadowProjectSynchronizer.getPlatform(this.env)));
            }
            for (Node node : ShadowProjectSynchronizer.getIterableByTagName(conf, "toolsSet")) {
                ShadowProjectSynchronizer.removeChildren(node);
                Element remoteMode = doc.createElement("developmentServer");
                remoteMode.setTextContent(sp.server);
                node.appendChild(remoteMode);
                remoteMode = doc.createElement("platform");
                remoteMode.setTextContent(sp.platform);
                node.appendChild(remoteMode);
            }
        }
        return ShadowProjectSynchronizer.saveXml(doc, remoteProjectCopy, PROJECT_PRIVATE_CONFIGURATION_FILE);
    }

    private FileObject updateLocalProjectXml() throws IOException, SAXException {
        NodeList dataList;
        FileObject fo = ShadowProjectSynchronizer.getFileObject(this.localProject, "nbproject/project.xml");
        File projXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null && (dataList = root.getElementsByTagName("data")).getLength() > 0) {
            Node masterConfs = dataList.item(0);
            Element remoteMode = doc.createElement("remote-sources-mode");
            remoteMode.setTextContent(RemoteProject.Mode.REMOTE_SOURCES.name());
            masterConfs.appendChild(remoteMode);
            Element remoteHost = doc.createElement("remote-filesystem-host");
            remoteHost.setTextContent(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env));
            masterConfs.appendChild(remoteHost);
            Element remoteBaseDir = doc.createElement("remote-filesystem-base-dir");
            remoteBaseDir.setTextContent(this.remoteProject.getPath());
            masterConfs.appendChild(remoteBaseDir);
        }
        return ShadowProjectSynchronizer.saveXml(doc, this.localProject, "nbproject/project.xml");
    }

    private FileObject updateLocalConfiguration() throws IOException, SAXException {
        FileObject fo = ShadowProjectSynchronizer.getFileObject(this.localProject, PROJECT_CONFIGURATION_FILE);
        File confXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(confXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null) {
            String csNameAndFlavor;
            String origCsNameAndFlavor = ShadowProjectSynchronizer.getOrigCompilerSet(root);
            if (DEFAULT.equals(origCsNameAndFlavor)) {
                csNameAndFlavor = DEFAULT;
            } else {
                int pos;
                String origCsName;
                CompilerSetManager csManager = CompilerSetManager.get((ExecutionEnvironment)this.env);
                CompilerSet existentCompilerSet = csManager.getCompilerSet(origCsName = (pos = origCsNameAndFlavor.indexOf(124)) > 0 ? origCsNameAndFlavor.substring(0, pos) : origCsNameAndFlavor);
                if (existentCompilerSet == null) {
                    csNameAndFlavor = DEFAULT;
                    this.reportNotFoundCompilerSet(origCsName);
                } else {
                    csNameAndFlavor = origCsNameAndFlavor;
                }
            }
            NodeList toolSetList = root.getElementsByTagName("toolsSet");
            if (toolSetList.getLength() > 0) {
                for (int i = 0; i < toolSetList.getLength(); ++i) {
                    Node node = toolSetList.item(i);
                    ShadowProjectSynchronizer.removeChildren(node);
                    Element remoteMode = doc.createElement("remoteSyncFactory");
                    remoteMode.setTextContent("full");
                    node.appendChild(remoteMode);
                    remoteMode = doc.createElement("remote-sources-mode");
                    remoteMode.setTextContent(RemoteProject.Mode.REMOTE_SOURCES.name());
                    node.appendChild(remoteMode);
                    remoteMode = doc.createElement("compilerSet");
                    remoteMode.setTextContent(csNameAndFlavor);
                    node.appendChild(remoteMode);
                }
            }
        }
        return ShadowProjectSynchronizer.saveXml(doc, this.localProject, PROJECT_CONFIGURATION_FILE);
    }

    private void reportNotFoundCompilerSet(String origCsName) {
        String title = NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_CS_Title", (Object)this.remoteProject.getName());
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/exclamation.gif", (boolean)false);
        String details = NbBundle.getMessage(ShadowProjectSynchronizer.class, (String)"ERR_CS_Details", (Object)origCsName);
        Notification n = NotificationDisplayer.getDefault().notify(title, (Icon)icon, details, null, NotificationDisplayer.Priority.HIGH);
    }

    private FileObject updateLocalPrivateConfiguration() throws IOException, SAXException {
        NodeList toolSetList;
        FileObject fo = ShadowProjectSynchronizer.getFileObject(this.localProject, PROJECT_PRIVATE_CONFIGURATION_FILE);
        File confXml = FileUtil.toFile((FileObject)fo);
        Document doc = XMLUtil.parse((InputSource)new InputSource(confXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
        Element root = doc.getDocumentElement();
        if (root != null && (toolSetList = root.getElementsByTagName("toolsSet")).getLength() > 0) {
            for (int i = 0; i < toolSetList.getLength(); ++i) {
                Node node = toolSetList.item(i);
                ShadowProjectSynchronizer.removeChildren(node);
                Element remoteMode = doc.createElement("developmentServer");
                remoteMode.setTextContent(ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env));
                node.appendChild(remoteMode);
                Element platformElement = doc.createElement("platform");
                platformElement.setTextContent(Integer.toString(ShadowProjectSynchronizer.getPlatform(this.env)));
                node.appendChild(platformElement);
            }
        }
        return ShadowProjectSynchronizer.saveXml(doc, this.localProject, PROJECT_PRIVATE_CONFIGURATION_FILE);
    }

    private static int getPlatform(ExecutionEnvironment env) {
        return CompilerSetManager.get((ExecutionEnvironment)env).getPlatform();
    }

    private static FileObject getOrCreateFileObject(FileObject dstParent, String name, boolean folder) throws IOException {
        FileObject fo;
        block5: {
            fo = dstParent.getFileObject(name);
            if (fo != null && fo.isValid() && fo.isFolder() != folder) {
                fo.delete();
                fo = null;
            }
            if (fo == null || !fo.isValid()) {
                try {
                    fo = folder ? dstParent.createFolder(name) : dstParent.createData(name);
                }
                catch (IOException ex) {
                    dstParent.refresh();
                    fo = dstParent.getFileObject(name);
                    if (fo != null && (fo.isValid() || fo.isFolder() == folder)) break block5;
                    throw ex;
                }
            }
        }
        if (fo == null || !fo.isValid()) {
            throw new IOException("Can not create " + (folder ? "folder " : "file ") + name + " in " + dstParent);
        }
        return fo;
    }

    private FileObject copy(FileObject src, FileObject dst, Collection<FileObject> createdFileObjects) throws IOException {
        return this.copy(src, dst.getParent(), dst.getNameExt(), createdFileObjects);
    }

    private FileObject copy(FileObject src, FileObject dstParent, String name, Collection<FileObject> createdFileObjects) throws IOException {
        if (src.isFolder()) {
            FileObject dst = ShadowProjectSynchronizer.getOrCreateFileObject(dstParent, name, true);
            FileUtil.copyAttributes((FileObject)src, (FileObject)dst);
            if (createdFileObjects != null && dst != null) {
                createdFileObjects.add(dst);
            }
            for (FileObject fo : src.getChildren()) {
                if (TMP_NBPROJECT_SUBFOLDER_NAME.equals(fo.getNameExt())) continue;
                FileObject copiedFO = this.copy(fo, dst, fo.getNameExt(), createdFileObjects);
                if (createdFileObjects == null || copiedFO == null) continue;
                createdFileObjects.add(copiedFO);
            }
            return dst;
        }
        FileObject dest = this.copyImpl(src, dstParent, name);
        if (createdFileObjects != null && dest != null) {
            createdFileObjects.add(dest);
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyImpl(FileObject source, FileObject destFolder, String newName) throws IOException {
        FileObject dest = ShadowProjectSynchronizer.getOrCreateFileObject(destFolder, newName, false);
        FileLock lock = null;
        InputStream bufIn = null;
        OutputStream bufOut = null;
        try {
            lock = dest.lock();
            bufIn = source.getInputStream();
            bufOut = dest.getOutputStream(lock);
            FileUtil.copy((InputStream)bufIn, (OutputStream)bufOut);
            FileUtil.copyAttributes((FileObject)source, (FileObject)dest);
        }
        finally {
            if (bufIn != null) {
                bufIn.close();
            }
            if (bufOut != null) {
                bufOut.close();
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = ShadowProjectSynchronizer.getOrCreateFileObject(dir, path, false);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
        return xml;
    }

    private static void removeChildren(Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> list = new ArrayList<Node>();
        for (int j = 0; j < childNodes.getLength(); ++j) {
            list.add(childNodes.item(j));
        }
        for (Node n : list) {
            node.removeChild(n);
        }
    }

    private static Node getNodeByTagName(Node node, String tagName) {
        Iterator<Node> it = ShadowProjectSynchronizer.getIteratorByTagName(node, tagName);
        if (it.hasNext()) {
            Node result = it.next();
            if (it.hasNext()) {
                LOGGER.log(Level.WARNING, "More than one node of type {0}", tagName);
            }
            return result;
        }
        return null;
    }

    private static Iterator<Node> getIteratorByTagName(Node node, String tagName) {
        if (node != null && node.getNodeType() == 1) {
            return new NodeListIterator(((Element)node).getElementsByTagName(tagName));
        }
        return new EmptyIterator<Node>();
    }

    private static NodeListIterable getIterableByTagName(Node node, String tagName) {
        if (node != null && node.getNodeType() == 1) {
            return new NodeListIterable(((Element)node).getElementsByTagName(tagName));
        }
        return new NodeListIterable(null);
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class NodeListIterator
    implements Iterator<Node> {
        private final NodeList nodeList;
        private int curr = 0;

        public NodeListIterator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.nodeList.getLength();
        }

        @Override
        public Node next() {
            return this.nodeList.item(this.curr++);
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class ServerAndPlatform {
        public final String server;
        public final String platform;

        public ServerAndPlatform(String server, String platform) {
            this.server = server;
            this.platform = platform;
        }

        public String toString() {
            return this.server + ',' + this.platform;
        }
    }

    private static class NodeListIterable
    implements Iterable<Node> {
        private final NodeList nodeList;

        public NodeListIterable(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public Iterator<Node> iterator() {
            return this.nodeList == null ? new EmptyIterator() : new NodeListIterator(this.nodeList);
        }
    }
}

